/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.GDSLayers;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GDSTab
extends PreferencePanel {
    private JList gdsLayersList;
    private DefaultListModel gdsLayersModel;
    private boolean changingGDS = false;
    private Setting gdsOutMergesBoxesSetting = IOTool.getGDSOutMergesBoxesSetting();
    private Setting gdsOutWritesExportPinsSetting = IOTool.getGDSOutWritesExportPinsSetting();
    private Setting gdsOutUpperCaseSetting = IOTool.getGDSOutUpperCaseSetting();
    private Setting gdsOutDefaultTextLayerSetting = IOTool.getGDSDefaultTextLayerSetting();
    private Setting gdsOutputConvertsBracketsInExportsSetting = IOTool.getGDSOutputConvertsBracketsInExportsSetting();
    private Setting gdsOutCollapseVddGndPinNamesSetting = IOTool.getGDSOutColapseVddGndPinNamesSetting();
    private Setting gdsOutWriteExportCharacteristicsSetting = IOTool.getGDSOutWriteExportCharacteristicsSetting();
    private Setting gdsCellNameLenMaxSetting = IOTool.getGDSCellNameLenMaxSetting();
    private Setting gdsInputScaleSetting = IOTool.getGDSInputScaleSetting();
    private Setting gdsOutputScaleSetting = IOTool.getGDSOutputScaleSetting();
    private JPanel Export;
    private JPanel Import;
    private JPanel exportImport;
    private JComboBox foundrySelection;
    private JComboBox gdsArraySimplification;
    private JCheckBox gdsCadenceCompatibility;
    private JTextField gdsCellNameLenMax;
    private JCheckBox gdsConvertNCCExportsConnectedByParentPins;
    private JTextField gdsDefaultTextLayer;
    private JCheckBox gdsExportAllCells;
    private JCheckBox gdsExportFlatDesign;
    private JLabel gdsFoundryName;
    private JTextField gdsHighVLayer;
    private JTextField gdsHighVType;
    private JCheckBox gdsIncludesText;
    private JCheckBox gdsInputExpandsCells;
    private JCheckBox gdsInputInstantiatesArrays;
    private JCheckBox gdsInputMergesBoxes;
    private JTextField gdsInputScale;
    private JScrollPane gdsLayerList;
    private JTextField gdsLayerNumber;
    private JTextField gdsLayerType;
    private JCheckBox gdsOutputColapseNames;
    private JCheckBox gdsOutputConvertsBracketsInExports;
    private JCheckBox gdsOutputMergesBoxes;
    private JTextField gdsOutputScale;
    private JCheckBox gdsOutputUpperCase;
    private JCheckBox gdsOutputWritesCharacteristics;
    private JCheckBox gdsOutputWritesExportPins;
    private JTextField gdsPinLayer;
    private JTextField gdsPinType;
    private JCheckBox gdsSimplifyCells;
    private JTextField gdsTextLayer;
    private JTextField gdsTextType;
    private JComboBox gdsUnknownLayers;
    private JCheckBox gdsVisibility;
    private JPanel inputPanel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel layerPanel;
    private JPanel outputPanel;
    private JPanel preferences;
    private JPanel projectSettings;
    private JComboBox technologySelection;

    public GDSTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.gdsLayerNumber);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsLayerType);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsPinLayer);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsPinType);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsTextLayer);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsTextType);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsHighVLayer);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsHighVType);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsCellNameLenMax);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsDefaultTextLayer);
        EDialog.makeTextFieldSelectAllOnTab(this.gdsInputScale);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.preferences;
    }

    @Override
    public JPanel getProjectPreferencesPanel() {
        return this.projectSettings;
    }

    @Override
    public String getName() {
        return "GDS";
    }

    @Override
    public void init() {
        this.gdsInputMergesBoxes.setSelected(IOTool.isGDSInMergesBoxes());
        this.gdsIncludesText.setSelected(IOTool.isGDSIncludesText());
        this.gdsInputExpandsCells.setSelected(IOTool.isGDSInExpandsCells());
        this.gdsSimplifyCells.setSelected(IOTool.isGDSInSimplifyCells());
        this.gdsInputInstantiatesArrays.setSelected(IOTool.isGDSInInstantiatesArrays());
        this.gdsArraySimplification.addItem("None");
        this.gdsArraySimplification.addItem("Merge individual arrays");
        this.gdsArraySimplification.addItem("Merge all arrays");
        this.gdsArraySimplification.setSelectedIndex(IOTool.getGDSArraySimplification());
        this.gdsUnknownLayers.addItem("Ignore");
        this.gdsUnknownLayers.addItem("Convert to DRC Exclusion layer");
        this.gdsUnknownLayers.addItem("Convert to random layer");
        this.gdsUnknownLayers.setSelectedIndex(IOTool.getGDSInUnknownLayerHandling());
        this.gdsCadenceCompatibility.setSelected(IOTool.isGDSCadenceCompatibility());
        this.gdsExportAllCells.setSelected(IOTool.isGDSWritesEntireLibrary());
        this.gdsExportFlatDesign.setSelected(IOTool.isGDSFlatDesign());
        this.gdsConvertNCCExportsConnectedByParentPins.setSelected(IOTool.getGDSConvertNCCExportsConnectedByParentPins());
        this.gdsVisibility.setSelected(IOTool.isGDSOnlyInvisibleLayers());
        this.gdsOutputMergesBoxes.setSelected(this.getBoolean(this.gdsOutMergesBoxesSetting));
        this.gdsOutputWritesExportPins.setSelected(this.getBoolean(this.gdsOutWritesExportPinsSetting));
        this.gdsOutputUpperCase.setSelected(this.getBoolean(this.gdsOutUpperCaseSetting));
        this.gdsOutputColapseNames.setSelected(this.getBoolean(this.gdsOutCollapseVddGndPinNamesSetting));
        this.gdsOutputWritesCharacteristics.setSelected(this.getBoolean(this.gdsOutWriteExportCharacteristicsSetting));
        this.gdsDefaultTextLayer.setText(Integer.toString(this.getInt(this.gdsOutDefaultTextLayerSetting)));
        this.gdsOutputConvertsBracketsInExports.setSelected(this.getBoolean(this.gdsOutputConvertsBracketsInExportsSetting));
        this.gdsCellNameLenMax.setText(Integer.toString(this.getInt(this.gdsCellNameLenMaxSetting)));
        this.gdsInputScale.setText(TextUtils.formatDouble(this.getDouble(this.gdsInputScaleSetting), 0));
        this.gdsOutputScale.setText(TextUtils.formatDouble(this.getDouble(this.gdsOutputScaleSetting), 0));
        this.gdsLayersModel = new DefaultListModel();
        this.gdsLayersList = new JList(this.gdsLayersModel);
        this.gdsLayersList.setSelectionMode(0);
        this.gdsLayerList.setViewportView(this.gdsLayersList);
        this.gdsLayersList.clearSelection();
        this.gdsLayersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                GDSTab.this.gdsClickLayer();
            }
        });
        TechGDSTab currentTech = null;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            TechGDSTab t = new TechGDSTab(tech);
            if (tech == Technology.getCurrent()) {
                assert (currentTech == null);
                currentTech = t;
            }
            this.technologySelection.addItem(t);
        }
        this.technologySelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GDSTab.this.techChanged();
            }
        });
        this.technologySelection.setSelectedItem(currentTech);
        this.foundrySelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GDSTab.this.foundryChanged();
            }
        });
        this.techChanged();
        GDSDocumentListener myDocumentListener = new GDSDocumentListener(this);
        this.gdsLayerNumber.getDocument().addDocumentListener(myDocumentListener);
        this.gdsLayerType.getDocument().addDocumentListener(myDocumentListener);
        this.gdsPinLayer.getDocument().addDocumentListener(myDocumentListener);
        this.gdsPinType.getDocument().addDocumentListener(myDocumentListener);
        this.gdsTextLayer.getDocument().addDocumentListener(myDocumentListener);
        this.gdsTextType.getDocument().addDocumentListener(myDocumentListener);
        this.gdsHighVLayer.getDocument().addDocumentListener(myDocumentListener);
        this.gdsHighVType.getDocument().addDocumentListener(myDocumentListener);
    }

    @Override
    public void term() {
        int currentI;
        boolean currentValue = this.gdsInputMergesBoxes.isSelected();
        if (currentValue != IOTool.isGDSInMergesBoxes()) {
            IOTool.setGDSInMergesBoxes(currentValue);
        }
        if ((currentValue = this.gdsIncludesText.isSelected()) != IOTool.isGDSIncludesText()) {
            IOTool.setGDSIncludesText(currentValue);
        }
        if ((currentValue = this.gdsInputExpandsCells.isSelected()) != IOTool.isGDSInExpandsCells()) {
            IOTool.setGDSInExpandsCells(currentValue);
        }
        if ((currentValue = this.gdsSimplifyCells.isSelected()) != IOTool.isGDSInSimplifyCells()) {
            IOTool.setGDSInSimplifyCells(currentValue);
        }
        if ((currentValue = this.gdsInputInstantiatesArrays.isSelected()) != IOTool.isGDSInInstantiatesArrays()) {
            IOTool.setGDSInInstantiatesArrays(currentValue);
        }
        if ((currentI = this.gdsArraySimplification.getSelectedIndex()) != IOTool.getGDSArraySimplification()) {
            IOTool.setGDSArraySimplification(currentI);
        }
        if ((currentI = this.gdsUnknownLayers.getSelectedIndex()) != IOTool.getGDSInUnknownLayerHandling()) {
            IOTool.setGDSInUnknownLayerHandling(currentI);
        }
        if ((currentValue = this.gdsCadenceCompatibility.isSelected()) != IOTool.isGDSCadenceCompatibility()) {
            IOTool.setGDSCadenceCompatibility(currentValue);
        }
        if ((currentValue = this.gdsExportAllCells.isSelected()) != IOTool.isGDSWritesEntireLibrary()) {
            IOTool.setGDSWritesEntireLibrary(currentValue);
        }
        if ((currentValue = this.gdsExportFlatDesign.isSelected()) != IOTool.isGDSFlatDesign()) {
            IOTool.setGDSFlatDesign(currentValue);
        }
        if ((currentValue = this.gdsConvertNCCExportsConnectedByParentPins.isSelected()) != IOTool.getGDSConvertNCCExportsConnectedByParentPins()) {
            IOTool.setGDSConvertNCCExportsConnectedByParentPins(currentValue);
        }
        if ((currentValue = this.gdsVisibility.isSelected()) != IOTool.isGDSOnlyInvisibleLayers()) {
            IOTool.setGDSOnlyInvisibleLayers(currentValue);
        }
        this.setBoolean(this.gdsOutMergesBoxesSetting, this.gdsOutputMergesBoxes.isSelected());
        this.setBoolean(this.gdsOutWritesExportPinsSetting, this.gdsOutputWritesExportPins.isSelected());
        this.setBoolean(this.gdsOutUpperCaseSetting, this.gdsOutputUpperCase.isSelected());
        this.setInt(this.gdsOutDefaultTextLayerSetting, TextUtils.atoi(this.gdsDefaultTextLayer.getText()));
        this.setBoolean(this.gdsOutputConvertsBracketsInExportsSetting, this.gdsOutputConvertsBracketsInExports.isSelected());
        this.setBoolean(this.gdsOutCollapseVddGndPinNamesSetting, this.gdsOutputColapseNames.isSelected());
        this.setBoolean(this.gdsOutWriteExportCharacteristicsSetting, this.gdsOutputWritesCharacteristics.isSelected());
        this.setInt(this.gdsCellNameLenMaxSetting, TextUtils.atoi(this.gdsCellNameLenMax.getText()));
        this.setDouble(this.gdsInputScaleSetting, TextUtils.atof(this.gdsInputScale.getText()));
        this.setDouble(this.gdsOutputScaleSetting, TextUtils.atof(this.gdsOutputScale.getText()));
    }

    @Override
    public void refresh() {
        this.foundryChanged();
    }

    @Override
    public void reset() {
        Foundry foundry;
        if (IOTool.isFactoryGDSInMergesBoxes() != IOTool.isGDSInMergesBoxes()) {
            IOTool.setGDSInMergesBoxes(IOTool.isFactoryGDSInMergesBoxes());
        }
        if (IOTool.isFactoryGDSIncludesText() != IOTool.isGDSIncludesText()) {
            IOTool.setGDSIncludesText(IOTool.isFactoryGDSIncludesText());
        }
        if (IOTool.isFactoryGDSInExpandsCells() != IOTool.isGDSInExpandsCells()) {
            IOTool.setGDSInExpandsCells(IOTool.isFactoryGDSInExpandsCells());
        }
        if (IOTool.isFactoryGDSInSimplifyCells() != IOTool.isGDSInSimplifyCells()) {
            IOTool.setGDSInSimplifyCells(IOTool.isFactoryGDSInSimplifyCells());
        }
        if (IOTool.isFactoryGDSInInstantiatesArrays() != IOTool.isGDSInInstantiatesArrays()) {
            IOTool.setGDSInInstantiatesArrays(IOTool.isFactoryGDSInInstantiatesArrays());
        }
        if (IOTool.getFactoryGDSArraySimplification() != IOTool.getGDSArraySimplification()) {
            IOTool.setGDSArraySimplification(IOTool.getFactoryGDSArraySimplification());
        }
        if (IOTool.getFactoryGDSInUnknownLayerHandling() != IOTool.getGDSInUnknownLayerHandling()) {
            IOTool.setGDSInUnknownLayerHandling(IOTool.getFactoryGDSInUnknownLayerHandling());
        }
        if (IOTool.isFactoryGDSCadenceCompatibility() != IOTool.isGDSCadenceCompatibility()) {
            IOTool.setGDSCadenceCompatibility(IOTool.isFactoryGDSCadenceCompatibility());
        }
        if (IOTool.isFactoryGDSWritesEntireLibrary() != IOTool.isGDSWritesEntireLibrary()) {
            IOTool.setGDSWritesEntireLibrary(IOTool.isFactoryGDSWritesEntireLibrary());
        }
        if (IOTool.isFactoryGDSFlatDesign() != IOTool.isGDSFlatDesign()) {
            IOTool.setGDSFlatDesign(IOTool.isFactoryGDSFlatDesign());
        }
        if (IOTool.getFactoryGDSConvertNCCExportsConnectedByParentPins() != IOTool.getGDSConvertNCCExportsConnectedByParentPins()) {
            IOTool.setGDSConvertNCCExportsConnectedByParentPins(IOTool.getFactoryGDSConvertNCCExportsConnectedByParentPins());
        }
        if ((foundry = (Foundry)this.foundrySelection.getSelectedItem()) == null) {
            return;
        }
        Technology tech = ((TechGDSTab)this.technologySelection.getSelectedItem()).tech;
        Iterator<Layer> it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            Setting set = foundry.getGDSLayerSetting(layer);
            Object factoryObj = set.getFactoryValue();
            if (!(factoryObj instanceof String)) continue;
            this.setString(set, (String)factoryObj);
        }
        this.setDouble(this.gdsInputScaleSetting, (Double)this.gdsInputScaleSetting.getFactoryValue());
        this.setBoolean(this.gdsOutMergesBoxesSetting, (Boolean)this.gdsOutMergesBoxesSetting.getFactoryValue());
        this.setBoolean(this.gdsOutWritesExportPinsSetting, (Boolean)this.gdsOutWritesExportPinsSetting.getFactoryValue());
        this.setBoolean(this.gdsOutUpperCaseSetting, (Boolean)this.gdsOutUpperCaseSetting.getFactoryValue());
        this.setBoolean(this.gdsOutputConvertsBracketsInExportsSetting, (Boolean)this.gdsOutputConvertsBracketsInExportsSetting.getFactoryValue());
        this.setBoolean(this.gdsOutCollapseVddGndPinNamesSetting, (Boolean)this.gdsOutCollapseVddGndPinNamesSetting.getFactoryValue());
        this.setBoolean(this.gdsOutWriteExportCharacteristicsSetting, (Boolean)this.gdsOutWriteExportCharacteristicsSetting.getFactoryValue());
        this.setInt(this.gdsCellNameLenMaxSetting, (Integer)this.gdsCellNameLenMaxSetting.getFactoryValue());
        this.setInt(this.gdsOutDefaultTextLayerSetting, (Integer)this.gdsOutDefaultTextLayerSetting.getFactoryValue());
        this.setDouble(this.gdsOutputScaleSetting, (Double)this.gdsOutputScaleSetting.getFactoryValue());
    }

    private void foundryChanged() {
        Foundry foundry = (Foundry)this.foundrySelection.getSelectedItem();
        if (foundry == null) {
            return;
        }
        Technology tech = ((TechGDSTab)this.technologySelection.getSelectedItem()).tech;
        this.gdsLayersModel.clear();
        for (Layer layer : tech.getLayersSortedByUserPreference()) {
            String str = layer.getName();
            String gdsLayer = this.getString(foundry.getGDSLayerSetting(layer));
            if (gdsLayer != null && gdsLayer.length() > 0) {
                str = str + " (" + gdsLayer + ")";
            }
            this.gdsLayersModel.addElement(str);
        }
        this.gdsLayersList.setSelectedIndex(0);
        this.gdsClickLayer();
    }

    private void setFoundries(Technology tech) {
        this.foundrySelection.removeAllItems();
        Iterator<Foundry> itF = tech.getFoundries();
        while (itF.hasNext()) {
            this.foundrySelection.addItem(itF.next());
        }
        this.foundrySelection.setSelectedItem(tech.getSelectedFoundry());
        this.foundryChanged();
    }

    private void techChanged() {
        Technology tech = ((TechGDSTab)this.technologySelection.getSelectedItem()).tech;
        if (tech == null) {
            return;
        }
        this.setFoundries(tech);
    }

    private void gdsClickLayer() {
        this.changingGDS = true;
        String str = (String)this.gdsLayersList.getSelectedValue();
        GDSLayers numbers = this.gdsGetNumbers(str);
        if (numbers == null) {
            numbers = GDSLayers.EMPTY;
        }
        if (!numbers.hasLayerType(GDSLayers.GDSLayerType.DRAWING)) {
            this.gdsLayerNumber.setText("");
            this.gdsLayerType.setText("");
        } else {
            int layerNum = numbers.getLayerNumber(GDSLayers.GDSLayerType.DRAWING);
            int layerType = numbers.getLayerType(GDSLayers.GDSLayerType.DRAWING);
            this.gdsLayerNumber.setText(Integer.toString(layerNum));
            this.gdsLayerType.setText(Integer.toString(layerType));
        }
        if (!numbers.hasLayerType(GDSLayers.GDSLayerType.PIN)) {
            this.gdsPinLayer.setText("");
            this.gdsPinType.setText("");
        } else {
            this.gdsPinLayer.setText(Integer.toString(numbers.getLayerNumber(GDSLayers.GDSLayerType.PIN)));
            this.gdsPinType.setText(Integer.toString(numbers.getLayerType(GDSLayers.GDSLayerType.PIN)));
        }
        if (!numbers.hasLayerType(GDSLayers.GDSLayerType.TEXT)) {
            this.gdsTextLayer.setText("");
            this.gdsTextType.setText("");
        } else {
            this.gdsTextLayer.setText(Integer.toString(numbers.getLayerNumber(GDSLayers.GDSLayerType.TEXT)));
            this.gdsTextType.setText(Integer.toString(numbers.getLayerType(GDSLayers.GDSLayerType.TEXT)));
        }
        if (!numbers.hasLayerType(GDSLayers.GDSLayerType.HIGHVOLTAGE)) {
            this.gdsHighVLayer.setText("");
            this.gdsHighVType.setText("");
        } else {
            this.gdsHighVLayer.setText(Integer.toString(numbers.getLayerNumber(GDSLayers.GDSLayerType.HIGHVOLTAGE)));
            this.gdsHighVType.setText(Integer.toString(numbers.getLayerType(GDSLayers.GDSLayerType.HIGHVOLTAGE)));
        }
        this.changingGDS = false;
    }

    private GDSLayers gdsGetNumbers(String str) {
        if (str == null) {
            return null;
        }
        int openParen = str.indexOf(40);
        if (openParen < 0) {
            return null;
        }
        int closeParen = str.lastIndexOf(41);
        if (closeParen < 0) {
            return null;
        }
        String gdsNumbers = str.substring(openParen + 1, closeParen);
        GDSLayers numbers = GDSLayers.parseLayerString(gdsNumbers);
        return numbers;
    }

    private Layer gdsGetLayer(String str) {
        int openParen = str.indexOf(40);
        String layerName = openParen >= 0 ? str.substring(0, openParen - 1) : str;
        Technology tech = ((TechGDSTab)this.technologySelection.getSelectedItem()).tech;
        if (tech == null) {
            return null;
        }
        Layer layer = tech.findLayer(layerName);
        return layer;
    }

    private boolean isValidGDSValue(String s2) {
        try {
            int v = Integer.parseInt(s2);
            return v > -1;
        }
        catch (NumberFormatException e) {
            if (!s2.equals("")) {
                System.out.println("'" + s2 + "' is an invalid gds value. Correct text field");
            }
            return false;
        }
    }

    private void gdsNumbersChanged() {
        if (this.changingGDS) {
            return;
        }
        String str = (String)this.gdsLayersList.getSelectedValue();
        Layer layer = this.gdsGetLayer(str);
        if (layer == null) {
            return;
        }
        String newLine = "";
        String val = this.gdsLayerNumber.getText().trim();
        if (this.isValidGDSValue(val)) {
            int layerType;
            newLine = newLine + val;
            val = this.gdsLayerType.getText().trim();
            if (this.isValidGDSValue(val) && (layerType = TextUtils.atoi(val)) != 0) {
                newLine = newLine + "/" + layerType;
            }
            newLine = newLine + GDSLayers.GDSLayerType.DRAWING.getExtension();
        }
        if (this.isValidGDSValue(val = this.gdsPinLayer.getText().trim())) {
            int pinType;
            newLine = newLine + "," + val;
            val = this.gdsPinType.getText().trim();
            if (this.isValidGDSValue(val) && (pinType = TextUtils.atoi(val)) != 0) {
                newLine = newLine + "/" + pinType;
            }
            newLine = newLine + GDSLayers.GDSLayerType.PIN.getExtension();
        }
        if (this.isValidGDSValue(val = this.gdsTextLayer.getText().trim())) {
            int textType;
            newLine = newLine + "," + val;
            val = this.gdsTextType.getText().trim();
            if (this.isValidGDSValue(val) && (textType = TextUtils.atoi(val)) != 0) {
                newLine = newLine + "/" + textType;
            }
            newLine = newLine + GDSLayers.GDSLayerType.TEXT.getExtension();
        }
        if (this.isValidGDSValue(val = this.gdsHighVLayer.getText().trim())) {
            int highVType;
            newLine = newLine + "," + val;
            val = this.gdsHighVType.getText().trim();
            if (this.isValidGDSValue(val) && (highVType = TextUtils.atoi(val)) != 0) {
                newLine = newLine + "/" + highVType;
            }
            newLine = newLine + GDSLayers.GDSLayerType.HIGHVOLTAGE.getExtension();
        }
        String wholeLine = layer.getName();
        if (newLine.length() > 0) {
            wholeLine = wholeLine + " (" + newLine + ")";
        }
        int index = this.gdsLayersList.getSelectedIndex();
        this.gdsLayersModel.set(index, wholeLine);
        Foundry foundry = (Foundry)this.foundrySelection.getSelectedItem();
        this.setString(foundry.getGDSLayerSetting(layer), newLine);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.preferences = new JPanel();
        this.Import = new JPanel();
        this.gdsInputMergesBoxes = new JCheckBox();
        this.gdsInputExpandsCells = new JCheckBox();
        this.gdsInputInstantiatesArrays = new JCheckBox();
        this.gdsSimplifyCells = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.gdsArraySimplification = new JComboBox();
        this.jLabel1 = new JLabel();
        this.gdsUnknownLayers = new JComboBox();
        this.gdsCadenceCompatibility = new JCheckBox();
        this.Export = new JPanel();
        this.gdsExportAllCells = new JCheckBox();
        this.gdsExportFlatDesign = new JCheckBox();
        this.gdsConvertNCCExportsConnectedByParentPins = new JCheckBox();
        this.gdsVisibility = new JCheckBox();
        this.gdsIncludesText = new JCheckBox();
        this.projectSettings = new JPanel();
        this.gdsLayerList = new JScrollPane();
        this.technologySelection = new JComboBox();
        this.jLabel10 = new JLabel();
        this.gdsFoundryName = new JLabel();
        this.foundrySelection = new JComboBox();
        this.outputPanel = new JPanel();
        this.gdsOutputMergesBoxes = new JCheckBox();
        this.gdsOutputWritesExportPins = new JCheckBox();
        this.gdsOutputUpperCase = new JCheckBox();
        this.gdsOutputConvertsBracketsInExports = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.gdsCellNameLenMax = new JTextField();
        this.jLabel12 = new JLabel();
        this.gdsOutputScale = new JTextField();
        this.gdsOutputColapseNames = new JCheckBox();
        this.gdsOutputWritesCharacteristics = new JCheckBox();
        this.inputPanel = new JPanel();
        this.jLabel11 = new JLabel();
        this.gdsInputScale = new JTextField();
        this.layerPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.gdsLayerNumber = new JTextField();
        this.gdsPinLayer = new JTextField();
        this.gdsTextLayer = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel6 = new JLabel();
        this.gdsLayerType = new JTextField();
        this.jLabel4 = new JLabel();
        this.gdsPinType = new JTextField();
        this.gdsTextType = new JTextField();
        this.jLabel13 = new JLabel();
        this.gdsHighVLayer = new JTextField();
        this.jLabel14 = new JLabel();
        this.gdsHighVType = new JTextField();
        this.exportImport = new JPanel();
        this.jLabel9 = new JLabel();
        this.gdsDefaultTextLayer = new JTextField();
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GDSTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.preferences.setLayout(new GridBagLayout());
        this.Import.setBorder(BorderFactory.createTitledBorder("Import"));
        this.Import.setLayout(new GridBagLayout());
        this.gdsInputMergesBoxes.setText("Merge boxes (slow)");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.Import.add((Component)this.gdsInputMergesBoxes, gridBagConstraints);
        this.gdsInputExpandsCells.setText("Expand cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.Import.add((Component)this.gdsInputExpandsCells, gridBagConstraints);
        this.gdsInputInstantiatesArrays.setText("Instantiate arrays");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.Import.add((Component)this.gdsInputInstantiatesArrays, gridBagConstraints);
        this.gdsSimplifyCells.setText("Simplify contact vias");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.Import.add((Component)this.gdsSimplifyCells, gridBagConstraints);
        this.jLabel3.setText("Array simplification:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.Import.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        this.Import.add((Component)this.gdsArraySimplification, gridBagConstraints);
        this.jLabel1.setText("Unknown layers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.Import.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        this.Import.add((Component)this.gdsUnknownLayers, gridBagConstraints);
        this.gdsCadenceCompatibility.setText("Cadence compatibility");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.Import.add((Component)this.gdsCadenceCompatibility, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.preferences.add((Component)this.Import, gridBagConstraints);
        this.Export.setBorder(BorderFactory.createTitledBorder("Export"));
        this.Export.setLayout(new GridBagLayout());
        this.gdsExportAllCells.setText("Export all cells in Library");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.Export.add((Component)this.gdsExportAllCells, gridBagConstraints);
        this.gdsExportFlatDesign.setText("Flat design");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.Export.add((Component)this.gdsExportFlatDesign, gridBagConstraints);
        this.gdsConvertNCCExportsConnectedByParentPins.setText("Use NCC annotations for exports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.Export.add((Component)this.gdsConvertNCCExportsConnectedByParentPins, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.preferences.add((Component)this.Export, gridBagConstraints);
        this.gdsVisibility.setText("Use visibility as filter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.preferences.add((Component)this.gdsVisibility, gridBagConstraints);
        this.gdsIncludesText.setText("Include text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.preferences.add((Component)this.gdsIncludesText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.preferences, gridBagConstraints);
        this.projectSettings.setLayout(new GridBagLayout());
        this.gdsLayerList.setMinimumSize(new Dimension(200, 200));
        this.gdsLayerList.setOpaque(false);
        this.gdsLayerList.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.projectSettings.add((Component)this.gdsLayerList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.projectSettings.add((Component)this.technologySelection, gridBagConstraints);
        this.jLabel10.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.projectSettings.add((Component)this.jLabel10, gridBagConstraints);
        this.gdsFoundryName.setText("Foundry:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.projectSettings.add((Component)this.gdsFoundryName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.projectSettings.add((Component)this.foundrySelection, gridBagConstraints);
        this.outputPanel.setBorder(BorderFactory.createTitledBorder("Export"));
        this.outputPanel.setLayout(new GridBagLayout());
        this.gdsOutputMergesBoxes.setText("Output merges Boxes (slow)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 2, 4);
        this.outputPanel.add((Component)this.gdsOutputMergesBoxes, gridBagConstraints);
        this.gdsOutputWritesExportPins.setText("Output writes export Pins");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.gdsOutputWritesExportPins, gridBagConstraints);
        this.gdsOutputUpperCase.setText("Output all upper-case");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.gdsOutputUpperCase, gridBagConstraints);
        this.gdsOutputConvertsBracketsInExports.setText("Output converts brackets in exports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.gdsOutputConvertsBracketsInExports, gridBagConstraints);
        this.jLabel5.setText("Max chars in output cell name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.gdsCellNameLenMax, gridBagConstraints);
        this.jLabel12.setText("Scale by:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.jLabel12, gridBagConstraints);
        this.gdsOutputScale.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.gdsOutputScale, gridBagConstraints);
        this.gdsOutputColapseNames.setText("Output collapses VDD/GND pin names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.gdsOutputColapseNames, gridBagConstraints);
        this.gdsOutputWritesCharacteristics.setText("Output writes export chacteristics");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.outputPanel.add((Component)this.gdsOutputWritesCharacteristics, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.projectSettings.add((Component)this.outputPanel, gridBagConstraints);
        this.inputPanel.setBorder(BorderFactory.createTitledBorder("Import"));
        this.inputPanel.setLayout(new GridBagLayout());
        this.jLabel11.setText("Scale by:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.inputPanel.add((Component)this.jLabel11, gridBagConstraints);
        this.gdsInputScale.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.inputPanel.add((Component)this.gdsInputScale, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.projectSettings.add((Component)this.inputPanel, gridBagConstraints);
        this.layerPanel.setLayout(new GridBagLayout());
        this.jLabel2.setText("Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.layerPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.gdsLayerNumber.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.gdsLayerNumber, gridBagConstraints);
        this.gdsPinLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.gdsPinLayer, gridBagConstraints);
        this.gdsTextLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.gdsTextLayer, gridBagConstraints);
        this.jLabel8.setText("Text:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel7.setText("Pin:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel6.setText("Normal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.gdsLayerType, gridBagConstraints);
        this.jLabel4.setText("Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.layerPanel.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.gdsPinType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.gdsTextType, gridBagConstraints);
        this.jLabel13.setText("Clear these field to ignore the layer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.layerPanel.add((Component)this.jLabel13, gridBagConstraints);
        this.gdsHighVLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.gdsHighVLayer, gridBagConstraints);
        this.jLabel14.setText("High V:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.jLabel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.gdsHighVType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        this.projectSettings.add((Component)this.layerPanel, gridBagConstraints);
        this.exportImport.setBorder(BorderFactory.createTitledBorder("Export/Import"));
        this.exportImport.setName("Import/Export");
        this.exportImport.setLayout(new GridBagLayout());
        this.jLabel9.setText("Default text layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.exportImport.add((Component)this.jLabel9, gridBagConstraints);
        this.gdsDefaultTextLayer.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.exportImport.add((Component)this.gdsDefaultTextLayer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.projectSettings.add((Component)this.exportImport, gridBagConstraints);
        this.exportImport.getAccessibleContext().setAccessibleDescription("Export/Import");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.projectSettings, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class TechGDSTab {
        public Technology tech;

        TechGDSTab(Technology t) {
            this.tech = t;
        }

        public String toString() {
            return this.tech.getTechName();
        }
    }

    private static class GDSDocumentListener
    implements DocumentListener {
        GDSTab dialog;

        GDSDocumentListener(GDSTab dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.dialog.gdsNumbersChanged();
        }
    }
}

