/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.metrics.WireQualityMetric;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import java.net.UnknownHostException;

public class SoGWireQualityMetric
extends WireQualityMetric {
    public SoGWireQualityMetric(String s2) {
        super(s2, null);
    }

    public WireQualityMetric.QualityResults calculate(SeaOfGatesEngine.RouteBatch batch) {
        WireQualityMetric.QualityResults result2 = null;
        boolean atLeastOneSegment = false;
        ++this.numberOfTotalNets;
        try {
            result2 = this.startLogging(batch.netName);
            result2.wireLength = new Double(0.0);
            result2.vias = new Integer(0);
            double minX = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            double minY = Double.MAX_VALUE;
            double maxY = -1.7976931348623157E308;
            for (SeaOfGatesEngine.NeededRoute nr : batch.routesInBatch) {
                if (nr.getRoutedSucess()) {
                    ++this.numRoutedSegments;
                    SeaOfGatesEngine.Wavefront winningWF = nr.getWavefront();
                    if (winningWF.vertices.size() < 2) {
                        System.out.println("WARNING: Review net '" + batch.netName + "' - it has less than 2 vertices");
                        continue;
                    }
                    SeaOfGatesEngine.SearchVertex theFirst = winningWF.vertices.get(0);
                    SeaOfGatesEngine.SearchVertex theLast = winningWF.vertices.get(winningWF.vertices.size() - 1);
                    double theSegMinX = Math.min(theFirst.getX(), theLast.getX());
                    double theSegMaxX = Math.max(theFirst.getX(), theLast.getX());
                    double theSegMinY = Math.min(theFirst.getY(), theLast.getY());
                    double theSegMaxY = Math.max(theFirst.getY(), theLast.getY());
                    result2.addSegmentHPWL(theSegMaxX - theSegMinX + (theSegMaxY - theSegMinY), false);
                    int startZ = theFirst.getZ();
                    int endZ = theLast.getZ();
                    int maxZ = Math.max(startZ, endZ);
                    int countVias = 0;
                    for (int i = 1; i < winningWF.vertices.size(); ++i) {
                        SeaOfGatesEngine.SearchVertex svLast = winningWF.vertices.get(i - 1);
                        if (i == 1) {
                            minX = Math.min(minX, svLast.getX());
                            minY = Math.min(minY, svLast.getY());
                            maxX = Math.max(maxX, svLast.getX());
                            maxY = Math.max(maxY, svLast.getY());
                        }
                        SeaOfGatesEngine.SearchVertex sv = winningWF.vertices.get(i);
                        if (svLast.getZ() != sv.getZ()) {
                            ++countVias;
                            maxZ = Math.max(maxZ, sv.getZ());
                            continue;
                        }
                        minX = Math.min(minX, sv.getX());
                        minY = Math.min(minY, sv.getY());
                        maxX = Math.max(maxX, sv.getX());
                        maxY = Math.max(maxY, sv.getY());
                        double dX = Math.abs(svLast.getX() - sv.getX());
                        double dY = Math.abs(svLast.getY() - sv.getY());
                        WireQualityMetric.QualityResults qualityResults = result2;
                        Double.valueOf(qualityResults.wireLength + Math.sqrt(dY * dY + dX * dX));
                        qualityResults.wireLength = qualityResults.wireLength;
                    }
                    WireQualityMetric.QualityResults qualityResults = result2;
                    Integer.valueOf(qualityResults.vias + countVias);
                    qualityResults.vias = qualityResults.vias;
                    result2.addSegmentViaValues(countVias, maxZ - startZ + (maxZ - endZ));
                    atLeastOneSegment = true;
                    continue;
                }
                if (nr.getErrorMessage() == null) continue;
                ++this.numFailedSegments;
            }
            double avgWLHPWLReal = 0.0;
            double avgWLHPWLIdeal = 0.0;
            if (atLeastOneSegment) {
                result2.addSegmentHPWL(maxX - minX + (maxY - minY), true);
                this.avgHpwlReal += result2.getSegmentHPWL(false, true);
                this.avgHpwlIdeal += result2.getSegmentHPWL(false, false);
                this.totalWL += result2.wireLength.doubleValue();
                this.avgVias += result2.vias.intValue();
                avgWLHPWLReal = result2.getWLDivHPWL(true);
                avgWLHPWLIdeal = result2.getWLDivHPWL(false);
                this.addWLLengthToBucket(avgWLHPWLReal, result2.resultName, true);
                this.addWLLengthToBucket(avgWLHPWLIdeal, result2.resultName, false);
                this.addViaZeroBucket(result2.getSegmentViaValue(), result2.resultName);
                this.avgWlDivHpwlReal += avgWLHPWLReal;
                this.avgWlDivHpwlIdeal += avgWLHPWLIdeal;
                ++this.numberOfRoutedNets;
            } else {
                ++this.numFailedBatches;
            }
            this.info("wire length metric for net '" + batch.netName + "': " + result2.wireLength);
            this.info("via amount metric for net '" + batch.netName + "': " + result2.vias);
            this.info("routed segment metric for net '" + batch.netName + "': " + result2.numOfSegments(true));
            this.info("via++ metric for net '" + batch.netName + "': " + result2.getSegmentViaValue());
            this.info("Real HPWL amount metric for net '" + batch.netName + "': " + result2.getSegmentHPWL(true, true));
            this.info("Ideal HPWL amount metric for net '" + batch.netName + "': " + result2.getSegmentHPWL(true, false));
            this.info("Real WL v/s HPWL for net '" + batch.netName + "': " + avgWLHPWLReal);
            this.info("Ideal WL v/s HPWL for net '" + batch.netName + "': " + avgWLHPWLIdeal);
            this.info("============================");
        }
        catch (UnknownHostException e) {
            if (Job.getDebug()) {
                e.printStackTrace();
            }
            System.out.println("No name or service not known");
        }
        return result2;
    }
}

