/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.extract.LayerCoverageTool;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CoverageTab
extends PreferencePanel {
    private boolean layerDataChanging = false;
    private LayerCoverageTool.LayerCoveragePreferences lcp;
    private DefaultListModel layerListModel;
    private JList layerJList;
    private JPanel boundingSelection;
    private JTextField deltaXField;
    private JLabel deltaXLabel;
    private JTextField deltaYField;
    private JLabel deltaYLabel;
    private JTextField heightField;
    private JLabel heightLabel;
    private JLabel jLabel1;
    private JTextField layerAreaField;
    private JLabel layerAreaLabel;
    private JPanel layerCoverage;
    private JPanel layerPanel;
    private JScrollPane listScrollList;
    private JComboBox technologySelection;
    private JTextField widthField;
    private JLabel widthLabel;

    public CoverageTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.layerAreaField);
        EDialog.makeTextFieldSelectAllOnTab(this.widthField);
        EDialog.makeTextFieldSelectAllOnTab(this.heightField);
        EDialog.makeTextFieldSelectAllOnTab(this.deltaXField);
        EDialog.makeTextFieldSelectAllOnTab(this.deltaYField);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.layerCoverage;
    }

    @Override
    public String getName() {
        return "Coverage";
    }

    @Override
    public void init() {
        this.lcp = new LayerCoverageTool.LayerCoveragePreferences(false);
        this.layerListModel = new DefaultListModel();
        this.layerJList = new JList(this.layerListModel);
        this.layerJList.setSelectionMode(0);
        this.listScrollList.setViewportView(this.layerJList);
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = tIt.next();
            this.technologySelection.addItem(tech.getTechName());
        }
        this.layerDataChanging = false;
        this.layerAreaField.getDocument().addDocumentListener(new CoverageDocumentListener(this));
        this.technologySelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CoverageTab.this.newTechSelected();
            }
        });
        this.layerJList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CoverageTab.this.layerValueChanged(false);
            }
        });
        this.technologySelection.setSelectedItem(Technology.getCurrent().getTechName());
    }

    private void newTechSelected() {
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        this.layerDataChanging = true;
        this.layerListModel.clear();
        List<Layer> list2 = tech.getLayersSortedByUserPreference();
        for (Layer layer : list2) {
            this.layerListModel.addElement(CoverageTab.getLineString(layer, this.lcp.getAreaCoverage(layer)));
        }
        this.layerJList.setSelectedIndex(0);
        double techScale = tech.getScale();
        this.widthField.setText(TextUtils.formatDistance(this.lcp.widthInMicrons / techScale));
        this.heightField.setText(TextUtils.formatDistance(this.lcp.heightInMicrons / techScale));
        this.deltaXField.setText(TextUtils.formatDistance(this.lcp.deltaXInMicrons / techScale));
        this.deltaYField.setText(TextUtils.formatDistance(this.lcp.deltaYInMicrons / techScale));
        this.layerDataChanging = false;
        this.layerValueChanged(false);
    }

    @Override
    public void refresh() {
        this.newTechSelected();
    }

    private static String getLineString(Layer layer, double value2) {
        return layer.getName() + " (" + value2 + ")";
    }

    private void layerValueChanged(boolean set) {
        if (this.layerDataChanging) {
            return;
        }
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        String primName = (String)this.layerJList.getSelectedValue();
        int spacePos = primName.indexOf(32);
        if (spacePos >= 0) {
            primName = primName.substring(0, spacePos);
        }
        Layer layer = tech.findLayer(primName);
        double origValue = this.lcp.getAreaCoverage(layer);
        if (set) {
            double val = 0.0;
            boolean foundError = false;
            String text2 = this.layerAreaField.getText();
            try {
                if (text2.equals("")) {
                    return;
                }
                val = Double.parseDouble(text2);
                foundError = val < 0.0 || val > 100.0;
            }
            catch (NumberFormatException e) {
                foundError = true;
            }
            if (foundError) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), text2 + " is out of range area value xfor layer '" + layer.getName() + "' (valid range 0 -> 100).");
                SwingUtilities.invokeLater(new SetOriginalValue(this.layerAreaField, origValue));
                return;
            }
            this.lcp.setAreaCoverageInfo(layer, val);
            int lineNo = this.layerJList.getSelectedIndex();
            this.layerListModel.setElementAt(CoverageTab.getLineString(layer, val), lineNo);
        } else {
            this.layerAreaField.setText(TextUtils.formatDouble(origValue));
        }
    }

    @Override
    public void term() {
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech != null) {
            double techScale = tech.getScale();
            this.lcp.widthInMicrons = TextUtils.atofDistance(this.widthField.getText()) * techScale;
            this.lcp.heightInMicrons = TextUtils.atofDistance(this.heightField.getText()) * techScale;
            this.lcp.deltaXInMicrons = TextUtils.atofDistance(this.deltaXField.getText()) * techScale;
            this.lcp.deltaYInMicrons = TextUtils.atofDistance(this.deltaYField.getText()) * techScale;
        }
        this.putPrefs(this.lcp);
    }

    @Override
    public void reset() {
        if (this.lcp == null) {
            return;
        }
        this.lcp.reset();
        this.putPrefs(this.lcp);
    }

    private void initComponents() {
        this.layerCoverage = new JPanel();
        this.layerPanel = new JPanel();
        this.layerAreaLabel = new JLabel();
        this.layerAreaField = new JTextField();
        this.listScrollList = new JScrollPane();
        this.boundingSelection = new JPanel();
        this.widthLabel = new JLabel();
        this.widthField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightField = new JTextField();
        this.deltaXLabel = new JLabel();
        this.deltaXField = new JTextField();
        this.deltaYLabel = new JLabel();
        this.deltaYField = new JTextField();
        this.jLabel1 = new JLabel();
        this.technologySelection = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CoverageTab.this.closeDialog(evt);
            }
        });
        this.layerCoverage.setLayout(new GridBagLayout());
        this.layerPanel.setLayout(new GridBagLayout());
        this.layerPanel.setBorder(new TitledBorder("Layers:"));
        this.layerPanel.setDoubleBuffered(false);
        this.layerAreaLabel.setText("Coverage Area (%):");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.layerAreaLabel, gridBagConstraints);
        this.layerAreaField.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerPanel.add((Component)this.layerAreaField, gridBagConstraints);
        this.listScrollList.setPreferredSize(new Dimension(200, 300));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.layerPanel.add((Component)this.listScrollList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.layerCoverage.add((Component)this.layerPanel, gridBagConstraints);
        this.boundingSelection.setLayout(new GridBagLayout());
        this.boundingSelection.setBorder(new TitledBorder("Bounding Selection"));
        this.boundingSelection.setDoubleBuffered(false);
        this.widthLabel.setText("Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.widthLabel, gridBagConstraints);
        this.widthField.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.widthField, gridBagConstraints);
        this.heightLabel.setText("Height:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.heightLabel, gridBagConstraints);
        this.heightField.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.heightField, gridBagConstraints);
        this.deltaXLabel.setText("DeltaX:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.deltaXLabel, gridBagConstraints);
        this.deltaXField.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.deltaXField, gridBagConstraints);
        this.deltaYLabel.setText("DeltaY:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.deltaYLabel, gridBagConstraints);
        this.deltaYField.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.boundingSelection.add((Component)this.deltaYField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.layerCoverage.add((Component)this.boundingSelection, gridBagConstraints);
        this.jLabel1.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerCoverage.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.layerCoverage.add((Component)this.technologySelection, gridBagConstraints);
        this.getContentPane().add((Component)this.layerCoverage, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class SetOriginalValue
    implements Runnable {
        JTextField field;
        double origValue;

        public SetOriginalValue(JTextField field2, double value2) {
            this.field = field2;
            this.origValue = value2;
        }

        @Override
        public void run() {
            this.field.setText(TextUtils.formatDouble(this.origValue));
        }
    }

    private static class CoverageDocumentListener
    implements DocumentListener {
        CoverageTab dialog;

        CoverageDocumentListener(CoverageTab dialog) {
            this.dialog = dialog;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.dialog.layerValueChanged(true);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.dialog.layerValueChanged(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.dialog.layerValueChanged(true);
        }
    }
}

