/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.Pref;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FindText
extends EModelessDialog {
    private static FindText theDialog = null;
    private static Pref.Group prefs = Pref.groupForPackage(FindText.class);
    private static Pref prefCaseSensitive = Pref.makeBooleanPref("FindText_caseSensitive", prefs, false);
    private static Pref prefFindTextMessage = Pref.makeStringPref("FindText_findTextMessage", prefs, "");
    private static Pref prefReplaceTextMessage = Pref.makeStringPref("FindText_ReplaceTextMessage", prefs, "");
    private static Pref prefFindReverse = Pref.makeBooleanPref("FindText_findReverse", prefs, false);
    private static Pref prefRegExp = Pref.makeBooleanPref("FindText_regExp", prefs, false);
    private static Pref prefSearchNodeNames = Pref.makeBooleanPref("FindText_searchNodeNames", prefs, true);
    private static Pref prefSearchNodeVars = Pref.makeBooleanPref("FindText_searchNodeVars", prefs, true);
    private static Pref prefSearchArcNames = Pref.makeBooleanPref("FindText_searchArcNames", prefs, true);
    private static Pref prefSearchArcVars = Pref.makeBooleanPref("FindText_searchArcVars", prefs, true);
    private static Pref prefSearchExportNames = Pref.makeBooleanPref("FindText_searchExportNames", prefs, true);
    private static Pref prefSearchExportVars = Pref.makeBooleanPref("FindText_searchExportVars", prefs, true);
    private static Pref prefSearchCellVars = Pref.makeBooleanPref("FindText_searchCellVars", prefs, true);
    private static Pref prefSearchTempNames = Pref.makeBooleanPref("FindText_searchTempNames", prefs, false);
    private static Pref prefSearchHighlighted = Pref.makeBooleanPref("FindText_searchHighlighted", prefs, false);
    private static Pref prefCodeRestriction = Pref.makeIntPref("FindText_searchCodeRestriction", prefs, 0);
    private static Pref prefUnitRestriction = Pref.makeIntPref("FindText_searchUnitRestriction", prefs, 0);
    private String lastSearch = null;
    private CodeExpression.Code[] codeRestrictions;
    private AbstractTextDescriptor.Unit[] unitRestrictions;
    private JButton Done;
    private JCheckBox caseSensitive;
    private JButton find;
    private JCheckBox findReverse;
    private JTextField findString;
    private JButton goToLine;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField lineNumber;
    private JCheckBox regExp;
    private JButton replace;
    private JButton replaceAll;
    private JButton replaceAndFind;
    private JTextField replaceString;
    private JCheckBox searchArcNames;
    private JCheckBox searchArcVars;
    private JCheckBox searchCellVars;
    private JComboBox searchCodeRestriction;
    private JCheckBox searchExportNames;
    private JCheckBox searchExportVars;
    private JCheckBox searchHighlighted;
    private JCheckBox searchNodeNames;
    private JCheckBox searchNodeVars;
    private JCheckBox searchTempNames;
    private JComboBox searchUnitsRestriction;
    private JPanel whatToSearch;

    public static void findTextDialog() {
        if (Client.getOperatingSystem() == Client.OS.UNIX) {
            if (theDialog != null) {
                theDialog.dispose();
            }
            theDialog = null;
        }
        if (theDialog == null) {
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new FindText(jf);
        }
        theDialog.setVisible(true);
        theDialog.toFront();
    }

    private FindText(Frame parent) {
        super(parent);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.findString);
        EDialog.makeTextFieldSelectAllOnTab(this.replaceString);
        EDialog.makeTextFieldSelectAllOnTab(this.lineNumber);
        int numCodeRestrs = 1;
        Iterator<CodeExpression.Code> it = CodeExpression.Code.getCodes();
        while (it.hasNext()) {
            it.next();
            ++numCodeRestrs;
        }
        this.codeRestrictions = new CodeExpression.Code[numCodeRestrs];
        numCodeRestrs = 0;
        this.codeRestrictions[numCodeRestrs++] = null;
        this.searchCodeRestriction.addItem("All Code Values");
        this.codeRestrictions[numCodeRestrs++] = CodeExpression.Code.NONE;
        this.searchCodeRestriction.addItem("Only NO Code");
        it = CodeExpression.Code.getCodes();
        while (it.hasNext()) {
            CodeExpression.Code cec = it.next();
            if (cec == CodeExpression.Code.NONE) continue;
            this.searchCodeRestriction.addItem("Only " + cec.name() + " Code");
            this.codeRestrictions[numCodeRestrs++] = cec;
        }
        int numUnitRestrs = 1;
        Iterator<AbstractTextDescriptor.Unit> it2 = AbstractTextDescriptor.Unit.getUnits();
        while (it2.hasNext()) {
            it2.next();
            ++numUnitRestrs;
        }
        this.unitRestrictions = new AbstractTextDescriptor.Unit[numUnitRestrs];
        numUnitRestrs = 0;
        this.unitRestrictions[numUnitRestrs++] = null;
        this.searchUnitsRestriction.addItem("All Units Values");
        this.unitRestrictions[numUnitRestrs++] = AbstractTextDescriptor.Unit.NONE;
        this.searchUnitsRestriction.addItem("Only NO Units");
        it2 = AbstractTextDescriptor.Unit.getUnits();
        while (it2.hasNext()) {
            AbstractTextDescriptor.Unit un = it2.next();
            if (un == AbstractTextDescriptor.Unit.NONE) continue;
            String camelCase = un.getDescription().toUpperCase().substring(0, 1) + un.getDescription().substring(1);
            this.searchUnitsRestriction.addItem("Only " + camelCase + " Units");
            this.unitRestrictions[numUnitRestrs++] = un;
        }
        this.findString.setText(prefFindTextMessage.getString());
        this.replaceString.setText(prefReplaceTextMessage.getString());
        this.caseSensitive.setSelected(prefCaseSensitive.getBoolean());
        this.findReverse.setSelected(prefFindReverse.getBoolean());
        this.regExp.setSelected(prefRegExp.getBoolean());
        this.searchNodeNames.setSelected(prefSearchNodeNames.getBoolean());
        this.searchNodeVars.setSelected(prefSearchNodeVars.getBoolean());
        this.searchArcNames.setSelected(prefSearchArcNames.getBoolean());
        this.searchArcVars.setSelected(prefSearchArcVars.getBoolean());
        this.searchExportNames.setSelected(prefSearchExportNames.getBoolean());
        this.searchExportVars.setSelected(prefSearchExportVars.getBoolean());
        this.searchCellVars.setSelected(prefSearchCellVars.getBoolean());
        this.searchTempNames.setSelected(prefSearchTempNames.getBoolean());
        this.searchHighlighted.setSelected(prefSearchHighlighted.getBoolean());
        this.searchCodeRestriction.setSelectedIndex(prefCodeRestriction.getInt());
        this.searchUnitsRestriction.setSelectedIndex(prefUnitRestriction.getInt());
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindText.this.lastSearch = null;
            }
        };
        this.searchNodeNames.addActionListener(action);
        this.searchNodeVars.addActionListener(action);
        this.searchArcNames.addActionListener(action);
        this.searchArcVars.addActionListener(action);
        this.searchExportNames.addActionListener(action);
        this.searchExportVars.addActionListener(action);
        this.searchCellVars.addActionListener(action);
        this.searchTempNames.addActionListener(action);
        this.searchHighlighted.addActionListener(action);
        this.searchCodeRestriction.addActionListener(action);
        this.searchUnitsRestriction.addActionListener(action);
        this.getRootPane().setDefaultButton(this.find);
        this.finishInitialization();
        this.pack();
    }

    private boolean badRegExpSyntax() {
        if (!this.regExp.isSelected()) {
            return false;
        }
        try {
            Pattern.compile(this.findString.getText());
            return false;
        }
        catch (Exception e) {
            System.out.println("Regular Expression error in Find string. Operation aborted.");
            return true;
        }
    }

    private Set<TextUtils.WhatToSearch> getWhatToSearch() {
        HashSet<TextUtils.WhatToSearch> whatToSearch = new HashSet<TextUtils.WhatToSearch>();
        if (this.searchNodeNames.isSelected()) {
            whatToSearch.add(TextUtils.WhatToSearch.NODE_NAME);
        }
        if (this.searchNodeVars.isSelected()) {
            whatToSearch.add(TextUtils.WhatToSearch.NODE_VAR);
        }
        if (this.searchArcNames.isSelected()) {
            whatToSearch.add(TextUtils.WhatToSearch.ARC_NAME);
        }
        if (this.searchArcVars.isSelected()) {
            whatToSearch.add(TextUtils.WhatToSearch.ARC_VAR);
        }
        if (this.searchExportNames.isSelected()) {
            whatToSearch.add(TextUtils.WhatToSearch.EXPORT_NAME);
        }
        if (this.searchExportVars.isSelected()) {
            whatToSearch.add(TextUtils.WhatToSearch.EXPORT_VAR);
        }
        if (this.searchCellVars.isSelected()) {
            whatToSearch.add(TextUtils.WhatToSearch.CELL_VAR);
        }
        if (this.searchTempNames.isSelected()) {
            whatToSearch.add(TextUtils.WhatToSearch.TEMP_NAMES);
        }
        return whatToSearch;
    }

    @Override
    protected void escapePressed() {
        this.doneActionPerformed(null);
    }

    private void initComponents() {
        this.jLabel4 = new JLabel();
        this.Done = new JButton();
        this.findString = new JTextField();
        this.jLabel1 = new JLabel();
        this.replaceString = new JTextField();
        this.caseSensitive = new JCheckBox();
        this.findReverse = new JCheckBox();
        this.replace = new JButton();
        this.replaceAndFind = new JButton();
        this.replaceAll = new JButton();
        this.jLabel2 = new JLabel();
        this.lineNumber = new JTextField();
        this.find = new JButton();
        this.goToLine = new JButton();
        this.regExp = new JCheckBox();
        this.whatToSearch = new JPanel();
        this.searchNodeNames = new JCheckBox();
        this.searchNodeVars = new JCheckBox();
        this.searchArcNames = new JCheckBox();
        this.searchArcVars = new JCheckBox();
        this.searchExportNames = new JCheckBox();
        this.searchExportVars = new JCheckBox();
        this.searchCellVars = new JCheckBox();
        this.searchTempNames = new JCheckBox();
        this.searchHighlighted = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.searchCodeRestriction = new JComboBox();
        this.searchUnitsRestriction = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Search and Replace");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FindText.this.closeDialog(evt);
            }
        });
        this.jLabel4.setText("Find:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.Done.setMnemonic('d');
        this.Done.setText("Done");
        this.Done.setActionCommand("done");
        this.Done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindText.this.doneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.Done, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.findString, gridBagConstraints);
        this.jLabel1.setText("Line Number:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replaceString, gridBagConstraints);
        this.caseSensitive.setMnemonic('c');
        this.caseSensitive.setText("Case Sensitive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.caseSensitive, gridBagConstraints);
        this.findReverse.setMnemonic('v');
        this.findReverse.setText("Find Reverse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.findReverse, gridBagConstraints);
        this.replace.setMnemonic('r');
        this.replace.setText("Replace");
        this.replace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindText.this.replaceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replace, gridBagConstraints);
        this.replaceAndFind.setMnemonic('n');
        this.replaceAndFind.setText("Replace and Find");
        this.replaceAndFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindText.this.replaceAndFindActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replaceAndFind, gridBagConstraints);
        this.replaceAll.setMnemonic('a');
        this.replaceAll.setText("Replace All");
        this.replaceAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindText.this.replaceAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replaceAll, gridBagConstraints);
        this.jLabel2.setText("Replace:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.lineNumber.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.lineNumber, gridBagConstraints);
        this.find.setMnemonic('f');
        this.find.setText("Find");
        this.find.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindText.this.findActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.find, gridBagConstraints);
        this.goToLine.setMnemonic('g');
        this.goToLine.setText("Go To Line");
        this.goToLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindText.this.goToLineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.goToLine, gridBagConstraints);
        this.regExp.setMnemonic('e');
        this.regExp.setText("Regular Expressions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.regExp, gridBagConstraints);
        this.whatToSearch.setLayout(new GridBagLayout());
        this.whatToSearch.setBorder(BorderFactory.createTitledBorder("Objects to Search"));
        this.searchNodeNames.setText("Node Names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchNodeNames, gridBagConstraints);
        this.searchNodeVars.setText("Node Variables");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchNodeVars, gridBagConstraints);
        this.searchArcNames.setText("Arc Names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchArcNames, gridBagConstraints);
        this.searchArcVars.setText("Arc Variables");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchArcVars, gridBagConstraints);
        this.searchExportNames.setText("Export Names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchExportNames, gridBagConstraints);
        this.searchExportVars.setText("Export Variables");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchExportVars, gridBagConstraints);
        this.searchCellVars.setText("Cell Variables");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchCellVars, gridBagConstraints);
        this.searchTempNames.setText("Automatically Generated Node and Arc Names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        this.whatToSearch.add((Component)this.searchTempNames, gridBagConstraints);
        this.searchHighlighted.setText("Limit Search to the Highlighted Area");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchHighlighted, gridBagConstraints);
        this.jLabel3.setText("Restrictions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.whatToSearch.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 4);
        this.whatToSearch.add((Component)this.searchCodeRestriction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 4);
        this.whatToSearch.add((Component)this.searchUnitsRestriction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        this.getContentPane().add((Component)this.whatToSearch, gridBagConstraints);
        this.pack();
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void goToLineActionPerformed(ActionEvent evt) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        WindowContent content = wf.getContent();
        if (content instanceof TextWindow) {
            TextWindow tw = (TextWindow)content;
            int i = TextUtils.atoi(this.lineNumber.getText());
            tw.goToLineNumber(i);
            return;
        }
        System.out.println("Cannot access this window by line numbers");
    }

    private void replaceAllActionPerformed(ActionEvent evt) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        String search = this.findString.getText();
        String replace = this.replaceString.getText();
        WindowContent content = wf.getContent();
        CodeExpression.Code codeRestr = this.codeRestrictions[this.searchCodeRestriction.getSelectedIndex()];
        AbstractTextDescriptor.Unit unitRestr = this.unitRestrictions[this.searchUnitsRestriction.getSelectedIndex()];
        content.initTextSearch(search, this.caseSensitive.isSelected(), this.regExp.isSelected(), this.getWhatToSearch(), codeRestr, unitRestr, this.searchHighlighted.isSelected());
        content.replaceAllText(replace);
    }

    private void replaceAndFindActionPerformed(ActionEvent evt) {
        if (this.badRegExpSyntax()) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (this.lastSearch == null) {
            return;
        }
        WindowContent content = wf.getContent();
        content.replaceText(this.replaceString.getText());
        if (!content.findNextText(this.findReverse.isSelected())) {
            this.lastSearch = null;
        }
    }

    private void replaceActionPerformed(ActionEvent evt) {
        if (this.badRegExpSyntax()) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (this.lastSearch == null) {
            return;
        }
        WindowContent content = wf.getContent();
        content.replaceText(this.replaceString.getText());
        this.replace.setEnabled(false);
    }

    private void findActionPerformed(ActionEvent evt) {
        if (this.badRegExpSyntax()) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        String search = this.findString.getText();
        WindowContent content = wf.getContent();
        if (this.lastSearch != null && !this.lastSearch.equals(search)) {
            this.lastSearch = null;
        }
        if (this.lastSearch == null) {
            CodeExpression.Code codeRestr = this.codeRestrictions[this.searchCodeRestriction.getSelectedIndex()];
            AbstractTextDescriptor.Unit unitRestr = this.unitRestrictions[this.searchUnitsRestriction.getSelectedIndex()];
            content.initTextSearch(search, this.caseSensitive.isSelected(), this.regExp.isSelected(), this.getWhatToSearch(), codeRestr, unitRestr, this.searchHighlighted.isSelected());
        }
        this.lastSearch = search;
        if (!content.findNextText(this.findReverse.isSelected())) {
            this.lastSearch = null;
        }
        this.replace.setEnabled(true);
    }

    private void closeDialog(WindowEvent evt) {
        prefFindTextMessage.setString(this.findString.getText());
        prefReplaceTextMessage.setString(this.replaceString.getText());
        prefCaseSensitive.setBoolean(this.caseSensitive.isSelected());
        prefFindReverse.setBoolean(this.findReverse.isSelected());
        prefRegExp.setBoolean(this.regExp.isSelected());
        prefSearchNodeNames.setBoolean(this.searchNodeNames.isSelected());
        prefSearchNodeVars.setBoolean(this.searchNodeVars.isSelected());
        prefSearchArcNames.setBoolean(this.searchArcNames.isSelected());
        prefSearchArcVars.setBoolean(this.searchArcVars.isSelected());
        prefSearchExportNames.setBoolean(this.searchExportNames.isSelected());
        prefSearchExportVars.setBoolean(this.searchExportVars.isSelected());
        prefSearchCellVars.setBoolean(this.searchCellVars.isSelected());
        prefSearchTempNames.setBoolean(this.searchTempNames.isSelected());
        prefSearchHighlighted.setBoolean(this.searchHighlighted.isSelected());
        prefCodeRestriction.setInt(this.searchCodeRestriction.getSelectedIndex());
        prefUnitRestriction.setInt(this.searchUnitsRestriction.getSelectedIndex());
        this.setVisible(false);
        this.dispose();
    }
}

