/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.hornFunnel2;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.flag.hornFunnel2.Node;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTree {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private final boolean SLANTED_EDGES = true;
    private static final Technology SCHEM_TECH = Technology.findTechnology("schematic");
    private static final PrimitiveNode SCH_ICON_PROTO = SCHEM_TECH.findNodeProto("Buffer");
    private static final PrimitiveNode DOT_ICON_PROTO = SCHEM_TECH.findNodeProto("Wire_Pin");
    private static final ArcProto LINE_PROTO = SCHEM_TECH.findArcProto("Wire");
    private final int SLOT_WID = 6;
    private final int SLOT_HEI = 24;
    private List<Node> slots;
    private final int height;
    private final int numSlots;
    private final Node root;

    private void prln(String s) {
        System.out.println(s);
    }

    private void pr(String s) {
        System.out.print(s);
    }

    private List<Node> makeSlots(int nbSlots) {
        ArrayList<Node> slots = new ArrayList<Node>();
        for (int i = 0; i < nbSlots; ++i) {
            slots.add(null);
        }
        return slots;
    }

    private void drawExternalArc(Cell c, Map<Node, NodeInst> nodeToInst) {
        int dotX = -6;
        int dotY = (this.height + 1) * 24;
        NodeInst dot = LayoutLib.newNodeInst(DOT_ICON_PROTO, dotX, dotY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, c);
        PortInst dotPi = dot.getOnlyPortInst();
        PortInst inPi = nodeToInst.get(this.root).findPortInst("a");
        this.drawArc(dotPi, inPi);
    }

    private void drawArc(PortInst p1, PortInst p2) {
        ArcInst aL = ArcInst.makeInstance(LINE_PROTO, p1, p2);
        aL.setFixedAngle(false);
    }

    private void drawArcs(Node n, Map<Node, NodeInst> nodeToInst) {
        if (n.isLeaf()) {
            return;
        }
        PortInst cur = nodeToInst.get(n).findPortInst("y");
        PortInst left = nodeToInst.get(n.getLeftChild()).findPortInst("a");
        PortInst right = nodeToInst.get(n.getRightChild()).findPortInst("a");
        this.drawArc(cur, left);
        this.drawArc(cur, right);
        this.drawArcs(n.getLeftChild(), nodeToInst);
        this.drawArcs(n.getRightChild(), nodeToInst);
    }

    private void setSlot(int slot, Node n) {
        this.slots.set(slot, n);
        n.setSlot(slot);
    }

    public BinaryTree(int height) {
        this.height = height;
        this.numSlots = (int)Math.pow(2.0, height) - 1;
        this.slots = this.makeSlots(this.numSlots);
        int halfNbSlots = (this.numSlots + 1) / 2;
        Node.resetIds();
        this.root = new Node(null, height, -1 + halfNbSlots, this.slots);
    }

    public int getHeight() {
        return this.height;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    public void checkSlots() {
        HashMap<Node, Integer> nodeToNdx = new HashMap<Node, Integer>();
        for (int i = 0; i < this.slots.size(); ++i) {
            Node n = this.slots.get(i);
            Job.error(n.getSlot() != i, "wrong slot. actual=" + i + " incorrect=" + n.getSlot());
            Integer index2 = (Integer)nodeToNdx.get(n);
            Job.error(index2 != null, "already at: " + index2);
            nodeToNdx.put(n, i);
        }
    }

    private boolean isLocked(Node n, int movableHeight) {
        int h = n.getHeight();
        return h > movableHeight;
    }

    public void moveTo(Node n, int dst, int moveableHeight) {
        this.checkSlots();
        int src = n.getSlot();
        Job.error(this.isLocked(this.slots.get(dst), moveableHeight), "moveTo fails because destination is locked. \n    src: " + this.slots.get(src).toString() + "\n" + "    dest: " + this.slots.get(dst).toString());
        int incr = dst >= src ? 1 : -1;
        Node movee = this.slots.get(src);
        int wr = src;
        while (wr != dst) {
            int rd = wr + incr;
            while (this.isLocked(this.slots.get(rd), moveableHeight)) {
                rd += incr;
            }
            this.setSlot(wr, this.slots.get(rd));
            wr = rd;
        }
        this.setSlot(dst, movee);
        this.checkSlots();
    }

    public void addId(NodeInst ni, int id) {
        ni.setName("" + id);
    }

    public void draw(Cell c) {
        HashMap<Node, NodeInst> nodeToInst = new HashMap<Node, NodeInst>();
        for (Node n : this.slots) {
            int h = n.getHeight();
            int s = n.getSlot();
            double x = s * 6;
            double y = h * 24;
            NodeInst ni = LayoutLib.newNodeInst(SCH_ICON_PROTO, x, y, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 270.0, c);
            this.addId(ni, n.getId());
            Job.error(nodeToInst.containsKey(n), "duplicate entry");
            nodeToInst.put(n, ni);
        }
        this.drawExternalArc(c, nodeToInst);
        this.drawArcs(this.root, nodeToInst);
        this.printStats();
    }

    public int calcWireLength() {
        int wireLen = this.getRoot().getSlot() + 1;
        for (Node n : this.slots) {
            wireLen += n.getChildWireLength();
        }
        return wireLen;
    }

    public int maxWireLength() {
        int maxLen = this.getRoot().getSlot() + 1;
        for (Node n : this.slots) {
            maxLen = Math.max(maxLen, n.getChildWireLength());
        }
        return maxLen;
    }

    public int[] countTracks() {
        int[] counts = new int[this.numSlots];
        for (Node n : this.slots) {
            if (n.isLeaf()) continue;
            int minSlot = n.getMinChildWireSlot();
            int maxSlot = n.getMaxChildWireSlot();
            int i = minSlot;
            while (i <= maxSlot) {
                int n2 = i++;
                counts[n2] = counts[n2] + 1;
            }
        }
        int i = 0;
        while (i <= this.getRoot().getSlot()) {
            int n = i++;
            counts[n] = counts[n] + 1;
        }
        return counts;
    }

    public List<Node> getNodesSortedByChildWireLength() {
        ArrayList<Node> sorted2 = new ArrayList<Node>();
        sorted2.addAll(this.slots);
        Collections.sort(sorted2, new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                return n1.getChildWireLength() - n2.getChildWireLength();
            }
        });
        return sorted2;
    }

    public Node getNodeWithLongestChildWire() {
        List<Node> sorted2 = this.getNodesSortedByChildWireLength();
        return sorted2.get(sorted2.size() - 1);
    }

    public int getLowBoundWireLen() {
        return (int)Math.ceil((double)this.getNumSlots() / (double)this.height);
    }

    public void printStats() {
        this.pr("Track counts: ");
        int[] counts = this.countTracks();
        int maxNbTracks = -1;
        for (int count2 : counts) {
            this.pr(count2 + " ");
            maxNbTracks = Math.max(maxNbTracks, count2);
        }
        this.prln("");
        this.prln("Max numb tracks: " + maxNbTracks);
        this.prln("Total wire length: " + this.calcWireLength());
        this.prln("Maximum wire length: " + this.maxWireLength());
        int lowBoundWireLen = this.getLowBoundWireLen();
        this.prln("Lower bound on wire length: " + lowBoundWireLen);
        this.prln("Nodes with child wire length exceeding lower bound: ");
        for (Node n : this.getNodesSortedByChildWireLength()) {
            if (n.isLeaf() || n.getChildWireLength() <= lowBoundWireLen) continue;
            this.prln(n.toString());
        }
    }

    public List<Node> getNodesAtHeight(int h) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node n : this.slots) {
            if (n.getHeight() != h) continue;
            nodes.add(n);
        }
        return nodes;
    }

    public Node getNodeInSlot(int i) {
        return this.slots.get(i);
    }
}

