/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.Environment;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.LayerId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechPool
extends AbstractMap<TechId, Technology> {
    public final IdManager idManager;
    private final Technology[] techs;
    private final Technology.State[] states;
    private final EntrySet entrySet;
    private ArcProto[] univList;
    private Generic generic;
    private Artwork artwork;
    private Schematics schematics;

    public TechPool(IdManager idManager) {
        this.idManager = idManager;
        this.techs = new Technology[0];
        this.states = new Technology.State[0];
        this.entrySet = new EntrySet();
        assert (this.size() == 0);
        this.univList = new ArcProto[0];
    }

    private TechPool(Collection<Technology.State> techStates) {
        Iterator<Technology.State> it = techStates.iterator();
        TechId techId = it.next().getTechnology().getId();
        this.idManager = techId.idManager;
        int maxTechIndex = techId.techIndex;
        while (it.hasNext()) {
            techId = it.next().getTechnology().getId();
            if (techId.idManager != this.idManager) {
                throw new IllegalArgumentException();
            }
            maxTechIndex = Math.max(maxTechIndex, techId.techIndex);
        }
        this.techs = new Technology[maxTechIndex + 1];
        this.states = new Technology.State[maxTechIndex + 1];
        for (Technology.State state : techStates) {
            Technology tech = state.getTechnology();
            techId = tech.getId();
            int techIndex = techId.techIndex;
            if (this.techs[techIndex] != null) {
                throw new IllegalArgumentException();
            }
            this.techs[techIndex] = tech;
            this.states[techIndex] = state;
            if (tech instanceof Generic) {
                this.generic = (Generic)tech;
                continue;
            }
            if (tech instanceof Artwork) {
                this.artwork = (Artwork)tech;
                continue;
            }
            if (!(tech instanceof Schematics)) continue;
            this.schematics = (Schematics)tech;
        }
        this.entrySet = new EntrySet();
        assert (this.size() == techStates.size());
    }

    public Map<TechFactory.Param, Object> getTechParams() {
        LinkedHashMap<TechFactory.Param, Object> techParams = new LinkedHashMap<TechFactory.Param, Object>();
        for (int techIndex = 0; techIndex < this.states.length; ++techIndex) {
            Technology.State state = this.states[techIndex];
            if (state == null) continue;
            techParams.putAll(state.paramValues);
        }
        return techParams;
    }

    public TechPool withTechParams(Map<TechFactory.Param, Object> paramValues) {
        assert (this.isActive());
        ArrayList<Technology.State> newTechStates = new ArrayList<Technology.State>();
        boolean changed = false;
        for (int techIndex = 0; techIndex < this.techs.length; ++techIndex) {
            Technology tech = this.techs[techIndex];
            if (tech == null) continue;
            Technology.State state = this.states[techIndex];
            Technology.State newTechState = tech.withState(paramValues);
            if (newTechState != state) {
                changed = true;
            }
            newTechStates.add(newTechState);
        }
        return changed ? new TechPool(newTechStates) : this;
    }

    public void activate() {
        for (int techIndex = 0; techIndex < this.states.length; ++techIndex) {
            Technology.State techState = this.states[techIndex];
            if (techState == null) continue;
            techState.activate();
        }
    }

    public boolean isActive() {
        for (int techIndex = 0; techIndex < this.states.length; ++techIndex) {
            Technology.State techState = this.states[techIndex];
            if (techState == null || techState == techState.getTechnology().getCurrentState()) continue;
            return false;
        }
        return true;
    }

    public TechPool deepClone() {
        ArrayList<Technology.State> newTechStates = new ArrayList<Technology.State>();
        Generic newGeneric = Generic.newInstance(this.idManager);
        newTechStates.add(newGeneric.getCurrentState());
        for (int techIndex = 0; techIndex < this.states.length; ++techIndex) {
            Technology tech = this.techs[techIndex];
            if (tech == null || tech == this.generic) continue;
            Technology newTech = tech.techFactory.newInstance(this.generic, this.states[techIndex].paramValues);
            newTechStates.add(newTech.getCurrentState());
        }
        return new TechPool(newTechStates);
    }

    public TechPool restrict(BitSet techUsed, TechPool candidatePool) {
        if (candidatePool != null && candidatePool.isRestriction(this, techUsed)) {
            return candidatePool;
        }
        return this.restrict(techUsed);
    }

    public TechPool restrict(BitSet techUsed) {
        ArrayList<Technology.State> techStates = new ArrayList<Technology.State>();
        for (int techIndex = 0; techIndex < this.techs.length; ++techIndex) {
            if (!techUsed.get(techIndex)) continue;
            techStates.add(this.states[techIndex]);
        }
        if (techStates.size() != techUsed.cardinality()) {
            throw new IllegalArgumentException();
        }
        return techStates.isEmpty() ? new TechPool(this.idManager) : new TechPool(techStates);
    }

    public boolean isRestriction(TechPool superPool) {
        return this.isRestriction(superPool, this.getTechUsages());
    }

    private boolean isRestriction(TechPool superPool, BitSet techUsed) {
        if (techUsed.length() != this.techs.length) {
            return false;
        }
        if (this.techs.length > superPool.techs.length) {
            return false;
        }
        if (this.idManager != superPool.idManager) {
            return false;
        }
        for (int techIndex = 0; techIndex < this.techs.length; ++techIndex) {
            Technology tech = superPool.techs[techIndex];
            Technology.State state = superPool.states[techIndex];
            if (techUsed.get(techIndex)) {
                if (tech == null) {
                    return false;
                }
            } else {
                tech = null;
                state = null;
            }
            if (this.techs[techIndex] == tech && this.states[techIndex] == state) continue;
            return false;
        }
        return true;
    }

    public BitSet getTechUsages() {
        BitSet bs = new BitSet(this.techs.length);
        for (int techIndex = 0; techIndex < this.techs.length; ++techIndex) {
            if (this.techs[techIndex] == null) continue;
            bs.set(techIndex);
        }
        return bs;
    }

    public TechPool withTech(Technology tech) {
        TechId techId = tech.getId();
        int techIndex = techId.techIndex;
        if (techIndex < this.techs.length && this.techs[techIndex] == tech && this.states[techIndex] == tech.getCurrentState()) {
            return this;
        }
        if (techId.idManager != this.idManager) {
            throw new IllegalArgumentException();
        }
        ArrayList<Technology.State> newStates = new ArrayList<Technology.State>();
        for (int i = 0; i < this.states.length; ++i) {
            if (i == techIndex || this.states[i] == null) continue;
            newStates.add(this.states[i]);
        }
        newStates.add(tech.getCurrentState());
        return new TechPool(newStates);
    }

    public Technology getTech(TechId techId) {
        if (techId.idManager != this.idManager) {
            throw new IllegalArgumentException();
        }
        int techIndex = techId.techIndex;
        return techIndex < this.techs.length ? this.techs[techIndex] : null;
    }

    public Technology findTechnology(String techName) {
        for (Technology tech : this.values()) {
            if (!tech.getTechName().equals(techName)) continue;
            return tech;
        }
        return null;
    }

    public Technology.State getState(TechId techId) {
        if (techId.idManager != this.idManager) {
            throw new IllegalArgumentException();
        }
        int techIndex = techId.techIndex;
        return techIndex < this.states.length ? this.states[techIndex] : null;
    }

    public Layer getLayer(LayerId layerId) {
        Technology tech = this.getTech(layerId.techId);
        if (tech == null) {
            return null;
        }
        return tech.getLayerByChronIndex(layerId.chronIndex);
    }

    public ArcProto getArcProto(ArcProtoId arcProtoId) {
        Technology tech = this.getTech(arcProtoId.techId);
        if (tech == null) {
            return null;
        }
        return tech.getArcProtoByChronIndex(arcProtoId.chronIndex);
    }

    public PrimitiveNode getPrimitiveNode(PrimitiveNodeId primitiveNodeId) {
        Technology tech = this.getTech(primitiveNodeId.techId);
        if (tech == null) {
            return null;
        }
        return tech.getPrimitiveNodeByChronIndex(primitiveNodeId.chronIndex);
    }

    public PrimitivePort getPrimitivePort(PrimitivePortId primitivePortId) {
        PrimitiveNode pn = this.getPrimitiveNode(primitivePortId.getParentId());
        if (pn == null) {
            return null;
        }
        return pn.getPrimitivePortByChronIndex(primitivePortId.chronIndex);
    }

    public void correctSizesToDisk(List<CellRevision> cells, Version version, Map<Setting, Object> projectSettings, boolean isJelib, boolean keepExtendOverMin) {
        HashMap<TechId, Technology.SizeCorrector> sizeCorrectors = new HashMap<TechId, Technology.SizeCorrector>();
        for (int i = 0; i < cells.size(); ++i) {
            CellRevision cellRevision = cells.get(i);
            boolean needCorrection = false;
            for (TechId techId : cellRevision.getTechUsages()) {
                Technology.SizeCorrector sizeCorrector = (Technology.SizeCorrector)sizeCorrectors.get(techId);
                if (sizeCorrector == null && !sizeCorrectors.containsKey(techId)) {
                    Technology tech = this.getTech(techId);
                    sizeCorrector = tech.getSizeCorrector(version, projectSettings, isJelib, keepExtendOverMin);
                    if (sizeCorrector.isIdentity()) {
                        sizeCorrector = null;
                    }
                    sizeCorrectors.put(techId, sizeCorrector);
                }
                if (sizeCorrector == null) continue;
                needCorrection = true;
            }
            if (!needCorrection) continue;
            ImmutableNodeInst[] correctedNodes = new ImmutableNodeInst[cellRevision.nodes.size()];
            for (int nodeIndex = 0; nodeIndex < correctedNodes.length; ++nodeIndex) {
                ImmutableNodeInst n = (ImmutableNodeInst)cellRevision.nodes.get(nodeIndex);
                if (n.protoId instanceof PrimitiveNodeId) {
                    PrimitiveNodeId pnId = (PrimitiveNodeId)n.protoId;
                    Technology.SizeCorrector sizeCorrector = (Technology.SizeCorrector)sizeCorrectors.get(pnId.techId);
                    if (sizeCorrector != null) {
                        n = n.withSize(sizeCorrector.getSizeToDisk(n));
                    }
                }
                correctedNodes[nodeIndex] = n;
            }
            ImmutableArcInst[] correctedArcs = new ImmutableArcInst[cellRevision.arcs.size()];
            for (int arcIndex = 0; arcIndex < correctedArcs.length; ++arcIndex) {
                ImmutableArcInst a = (ImmutableArcInst)cellRevision.arcs.get(arcIndex);
                if (a == null) continue;
                ArcProtoId apId = a.protoId;
                Technology.SizeCorrector sizeCorrector = (Technology.SizeCorrector)sizeCorrectors.get(apId.techId);
                if (sizeCorrector != null) {
                    a = a.withGridExtendOverMin(sizeCorrector.getExtendToDisk(a));
                }
                correctedArcs[arcIndex] = a;
            }
            cellRevision = cellRevision.with(cellRevision.d, correctedNodes, correctedArcs, null);
            cells.set(i, cellRevision);
        }
    }

    public Artwork getArtwork() {
        return this.artwork;
    }

    public Generic getGeneric() {
        return this.generic;
    }

    public Schematics getSchematics() {
        return this.schematics;
    }

    public boolean equals(TechPool that) {
        if (this.idManager != that.idManager || this.techs.length != that.techs.length) {
            return false;
        }
        for (int techIndex = 0; techIndex < this.techs.length; ++techIndex) {
            if (this.techs[techIndex] == that.techs[techIndex]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        int techIndex = ((TechId)key).techIndex;
        if (techIndex >= this.techs.length) {
            return false;
        }
        Technology tech = this.techs[techIndex];
        return tech != null && tech.getId() == key;
    }

    @Override
    public boolean containsValue(Object value) {
        int techIndex = ((Technology)value).getId().techIndex;
        return techIndex < this.techs.length && this.techs[techIndex] == value;
    }

    @Override
    public Technology get(Object key) {
        int techIndex = ((TechId)key).techIndex;
        if (techIndex >= this.techs.length) {
            return null;
        }
        Technology tech = this.techs[techIndex];
        return tech != null && tech.getId() == key ? tech : null;
    }

    @Override
    public Set<Map.Entry<TechId, Technology>> entrySet() {
        return this.entrySet;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof TechPool ? this.equals((TechPool)o) : super.equals(o);
    }

    public void writeDiff(IdWriter writer, TechPool old) throws IOException {
        boolean isEmpty = this.isEmpty();
        writer.writeBoolean(isEmpty);
        if (isEmpty) {
            return;
        }
        writer.writeDiffs();
        Generic generic = this.getGeneric();
        assert (generic != null);
        boolean newGeneric = generic != old.getGeneric();
        writer.writeBoolean(newGeneric);
        for (Technology tech : this.values()) {
            if (tech == generic) continue;
            TechId techId = tech.getId();
            writer.writeInt(techId.techIndex);
            Technology.State techState = this.getState(techId);
            boolean sameState = techState == old.getState(techId);
            writer.writeBoolean(sameState);
            if (sameState) continue;
            boolean sameTech = tech == old.getTech(techId);
            writer.writeBoolean(sameTech);
            if (!sameTech) {
                tech.techFactory.write(writer);
            }
            for (TechFactory.Param techParam : tech.techFactory.getTechParams()) {
                Object value = techState.paramValues.get(techParam);
                writer.writeString(techParam.xmlPath);
                Variable.writeObject(writer, value);
            }
        }
        writer.writeInt(-1);
    }

    public static TechPool read(IdReader reader, TechPool old) throws IOException {
        int techIndex;
        boolean isEmpty = reader.readBoolean();
        if (isEmpty) {
            return new TechPool(reader.idManager);
        }
        reader.readDiffs();
        ArrayList<Technology.State> technologiesList = new ArrayList<Technology.State>();
        boolean newGeneric = reader.readBoolean();
        Generic generic = newGeneric ? Generic.newInstance(reader.idManager) : old.getGeneric();
        technologiesList.add(generic.getCurrentState());
        while ((techIndex = reader.readInt()) != -1) {
            Technology.State techState;
            TechId techId = reader.idManager.getTechId(techIndex);
            assert (techId != null);
            boolean sameState = reader.readBoolean();
            if (sameState) {
                technologiesList.add(old.getState(techId));
                continue;
            }
            boolean sameTech = reader.readBoolean();
            TechFactory techFactory = sameTech ? old.getTech((TechId)techId).techFactory : TechFactory.read(reader);
            HashMap<TechFactory.Param, Object> paramValues = new HashMap<TechFactory.Param, Object>();
            for (TechFactory.Param techParam : techFactory.getTechParams()) {
                String xmlPath = reader.readString();
                assert (xmlPath.equals(techParam.xmlPath));
                Object value = Variable.readObject(reader);
                paramValues.put(techParam, value);
            }
            if (sameTech) {
                Technology tech = old.getTech(techId);
                techState = tech.newState(paramValues);
            } else {
                techState = techFactory.newInstance(generic, paramValues).getCurrentState();
            }
            technologiesList.add(techState);
        }
        return new TechPool(technologiesList);
    }

    ArcProto[] getUnivList() {
        if (this.univList == null) {
            this.makeUnivList();
        }
        return this.univList;
    }

    private void makeUnivList() {
        int univListCount = 0;
        for (Technology tech : this.techs) {
            if (tech == null) continue;
            univListCount += tech.getNumArcs();
        }
        this.univList = new ArcProto[univListCount];
        univListCount = 0;
        for (Technology tech : this.techs) {
            if (tech == null) continue;
            Iterator<ArcProto> ait = tech.getArcs();
            while (ait.hasNext()) {
                this.univList[univListCount++] = ait.next();
            }
        }
        assert (univListCount == this.univList.length);
    }

    public void check() {
        int size = 0;
        int arcCount = 0;
        for (int techIndex = 0; techIndex < this.techs.length; ++techIndex) {
            Technology tech = this.techs[techIndex];
            if (tech == null) {
                assert (this.states[techIndex] == null);
                continue;
            }
            assert (this.states[techIndex].getTechnology() == tech);
            ++size;
            TechId techId = tech.getId();
            assert (techId.idManager == this.idManager);
            assert (techId.techIndex == techIndex);
            assert (this.idManager.getTechId(techIndex) == techId);
            assert (this.get(techId) == tech);
            assert (this.containsKey(techId));
            assert (this.containsValue(tech));
            if (this.univList == null) continue;
            Iterator<ArcProto> it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                assert (this.univList[arcCount++] == ap);
            }
        }
        assert (size == this.size());
        if (size != 0) assert (this.getGeneric() != null);
        assert (size == 0 || this.techs[this.techs.length - 1] != null);
        if (this.univList != null) assert (arcCount == this.univList.length);
        TechId prevTechId = null;
        for (Map.Entry<TechId, Technology> e : this.entrySet()) {
            assert (this.entrySet.contains(e));
            TechId techId = e.getKey();
            Technology tech = e.getValue();
            assert (techId == tech.getId());
            assert (this.techs[techId.techIndex] == tech);
            if (prevTechId != null) assert (TextUtils.STRING_NUMBER_ORDER.compare(prevTechId.techName, techId.techName) < 0);
            prevTechId = techId;
        }
    }

    public static TechPool getThreadTechPool() {
        return Environment.getThreadEnvironment().techPool;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TechEntry
    implements Map.Entry<TechId, Technology> {
        private final TechId key;
        private final Technology value;

        public TechEntry(TechId key, Technology value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            this.key = key;
            this.value = value;
        }

        @Override
        public TechId getKey() {
            return this.key;
        }

        @Override
        public Technology getValue() {
            return this.value;
        }

        @Override
        public Technology setValue(Technology value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<TechId, Technology>> {
        private final TechEntry[] entries;

        EntrySet() {
            TreeSet<Technology> sortedTechs = new TreeSet<Technology>();
            for (Technology tech : TechPool.this.techs) {
                if (tech == null) continue;
                sortedTechs.add(tech);
            }
            this.entries = new TechEntry[sortedTechs.size()];
            int i = 0;
            for (Technology tech : sortedTechs) {
                TechId techId = tech.getId();
                this.entries[i++] = new TechEntry(techId, tech);
            }
        }

        @Override
        public int size() {
            return this.entries.length;
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry e = (Map.Entry)o;
            Technology tech = (Technology)e.getValue();
            return TechPool.this.containsValue(tech) && e.getKey().equals(tech.getId());
        }

        @Override
        public Iterator<Map.Entry<TechId, Technology>> iterator() {
            return ArrayIterator.iterator(this.entries);
        }
    }
}

