/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.sc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.sc.Place;
import com.sun.electric.tool.sc.Route;
import com.sun.electric.tool.sc.SilComp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetNetlist {
    private static final int GND = 0;
    private static final int PWR = 1;
    public static final int PORTDIRMASK = 15;
    public static final int PORTDIRUP = 1;
    public static final int PORTDIRDOWN = 2;
    public static final int PORTDIRRIGHT = 4;
    public static final int PORTDIRLEFT = 8;
    public static final int PORTTYPE = 1008;
    public static final int GNDPORT = 16;
    public static final int PWRPORT = 32;
    public static final int BIDIRPORT = 64;
    public static final int OUTPORT = 128;
    public static final int INPORT = 256;
    public static final int UNPORT = 512;
    public static final int LEAFCELL = 0;
    public static final int COMPLEXCELL = 1;
    public static final int SPECIALCELL = 2;
    public static final int FEEDCELL = 3;
    public static final int STITCH = 4;
    public static final int LATERALFEED = 5;
    SCCell scCells;
    SCCell curSCCell;

    public boolean readNetCurCell(Cell cell) {
        String err;
        this.scCells = null;
        this.curSCCell = null;
        if (cell.getView() != View.NETLISTQUISC) {
            System.out.println("Current cell must have QUISC Netlist view");
            return true;
        }
        String[] strings = cell.getTextViewContents();
        if (strings == null) {
            System.out.println("Cell " + cell.describe(true) + " has no text in it");
            return true;
        }
        boolean errors = false;
        for (int i = 0; i < strings.length; ++i) {
            String err2;
            String inBuf = strings[i].trim();
            if (inBuf.length() == 0 || inBuf.charAt(0) == '!') continue;
            ArrayList<String> parameters = new ArrayList<String>();
            for (int sPtr = 0; sPtr < inBuf.length(); ++sPtr) {
                while (sPtr < inBuf.length() && (inBuf.charAt(sPtr) == ' ' || inBuf.charAt(sPtr) == '\t')) {
                    ++sPtr;
                }
                if (sPtr >= inBuf.length()) break;
                if (inBuf.charAt(sPtr) == '\"') {
                    int endQuote;
                    if ((endQuote = inBuf.indexOf(34, ++sPtr)) < 0) {
                        System.out.println("ERROR line " + (i + 1) + ": Unbalanced quotes ");
                        errors = true;
                        break;
                    }
                    parameters.add(inBuf.substring(sPtr, endQuote));
                    sPtr = endQuote;
                    continue;
                }
                int endSpace = inBuf.indexOf(32, sPtr);
                int endTab = inBuf.indexOf(9, sPtr);
                if (endSpace < 0) {
                    endSpace = endTab;
                }
                if (endSpace < 0) {
                    endSpace = inBuf.length();
                }
                if (endTab >= 0 && endTab < endSpace) {
                    endSpace = endTab;
                }
                parameters.add(inBuf.substring(sPtr, endSpace));
                sPtr = endSpace;
            }
            if ((err2 = this.parse(parameters)) == null) continue;
            System.out.println("ERROR line " + (i + 1) + ": " + err2);
            System.out.println("      Line: " + inBuf);
            errors = true;
            break;
        }
        if ((err = this.pull()) != null) {
            System.out.println(err);
            errors = true;
        }
        return errors;
    }

    private String parse(List<String> keywords) {
        if (keywords.size() == 0) {
            return null;
        }
        String mainKeyword = keywords.get(0);
        if (mainKeyword.equalsIgnoreCase("connect")) {
            return this.connect(keywords);
        }
        if (mainKeyword.equalsIgnoreCase("create")) {
            return this.create(keywords);
        }
        if (mainKeyword.equalsIgnoreCase("export")) {
            return this.export(keywords);
        }
        if (mainKeyword.equalsIgnoreCase("extract")) {
            return this.extract(keywords);
        }
        if (mainKeyword.equalsIgnoreCase("set")) {
            return this.xSet(keywords);
        }
        return "Unknown keyword: " + mainKeyword;
    }

    private String create(List<String> keywords) {
        if (keywords.size() <= 1) {
            return "No keyword for CREATE command";
        }
        String sPtr = keywords.get(1);
        if (sPtr.equalsIgnoreCase("cell")) {
            if (keywords.size() <= 2) {
                return "No name for CREATE CELL command";
            }
            sPtr = keywords.get(2);
            SCCell cell = this.scCells;
            while (cell != null) {
                if (sPtr.equalsIgnoreCase(cell.name)) {
                    return "Cell '" + sPtr + "' already exists in current library";
                }
                cell = cell.next;
            }
            if (this.findLeafCell(sPtr) != null) {
                System.out.println("WARNING - cell " + sPtr + " may be overridden by created cell");
            }
            SCCell newCell = new SCCell();
            newCell.name = sPtr;
            newCell.maxNodeNum = 0;
            newCell.niList = new ArrayList<SCNiTree>();
            newCell.exNodes = null;
            newCell.bits = 0;
            newCell.power = null;
            newCell.ground = null;
            newCell.ports = null;
            newCell.lastPort = null;
            newCell.placement = null;
            newCell.route = null;
            newCell.next = this.scCells;
            this.scCells = newCell;
            this.curSCCell = newCell;
            SCNiTree ntp = this.findNi(this.curSCCell, "ground");
            if (ntp != null) {
                return "Instance 'ground' already exists";
            }
            ntp = new SCNiTree("ground", 2);
            this.curSCCell.niList.add(ntp);
            new SCNiPort(ntp);
            ntp.number = this.curSCCell.maxNodeNum++;
            ntp = this.findNi(this.curSCCell, "power");
            if (ntp != null) {
                return "Instance 'power' already exists";
            }
            ntp = new SCNiTree("power", 2);
            this.curSCCell.niList.add(ntp);
            new SCNiPort(ntp);
            ntp.number = this.curSCCell.maxNodeNum++;
            return null;
        }
        if (sPtr.equalsIgnoreCase("instance")) {
            if (keywords.size() <= 2) {
                return "No instance name for CREATE INSTANCE command";
            }
            String noden = keywords.get(2);
            if (keywords.size() <= 3) {
                return "No type name for CREATE INSTANCE command";
            }
            String nodep = keywords.get(3);
            SCCell cell = null;
            SCCell c = this.scCells;
            while (c != null) {
                if (nodep.equalsIgnoreCase(c.name)) {
                    cell = c;
                    break;
                }
                c = c.next;
            }
            Object proto = cell;
            int type = 1;
            double size = 0.0;
            if (cell == null) {
                Cell bc = this.findLeafCell(nodep);
                if (bc == null) {
                    return "There is no '" + nodep + "' in the standard cell library";
                }
                proto = bc;
                type = 0;
                size = SilComp.leafCellXSize(bc);
            }
            if (this.curSCCell == null) {
                return "No cell selected";
            }
            SCNiTree ntp = this.findNi(this.curSCCell, noden);
            if (ntp != null) {
                return "Instance '" + noden + "' already exists";
            }
            ntp = new SCNiTree(noden, type);
            this.curSCCell.niList.add(ntp);
            ntp.number = this.curSCCell.maxNodeNum++;
            ntp.np = proto;
            ntp.size = size;
            if (type == 1) {
                SCNiPort oldNiPort = null;
                SCPort port = ((SCCell)proto).ports;
                while (port != null) {
                    SCNiPort niPort = new SCNiPort();
                    niPort.port = port;
                    niPort.extNode = null;
                    niPort.bits = 0;
                    niPort.xPos = 0.0;
                    switch (port.bits & 0x3F0) {
                        case 16: {
                            niPort.next = ntp.ground;
                            ntp.ground = niPort;
                            break;
                        }
                        case 32: {
                            niPort.next = ntp.power;
                            ntp.power = niPort;
                            break;
                        }
                        default: {
                            niPort.next = null;
                            if (oldNiPort == null) {
                                ntp.ports = niPort;
                            } else {
                                oldNiPort.next = niPort;
                            }
                            oldNiPort = niPort;
                        }
                    }
                    port = port.next;
                }
            } else {
                SCNiPort oldNiPort = null;
                Cell realCell = (Cell)proto;
                Iterator<PortProto> it = realCell.getPorts();
                block11: while (it.hasNext()) {
                    Export bp = (Export)it.next();
                    SCNiPort niPort = new SCNiPort();
                    niPort.port = bp;
                    niPort.extNode = null;
                    niPort.bits = 0;
                    niPort.xPos = SilComp.leafPortXPos(bp);
                    switch (GetNetlist.getLeafPortType(bp)) {
                        case 16: {
                            niPort.next = ntp.ground;
                            ntp.ground = niPort;
                            continue block11;
                        }
                        case 32: {
                            niPort.next = ntp.power;
                            ntp.power = niPort;
                            continue block11;
                        }
                    }
                    niPort.next = null;
                    if (oldNiPort == null) {
                        ntp.ports = niPort;
                    } else {
                        oldNiPort.next = niPort;
                    }
                    oldNiPort = niPort;
                }
            }
            return null;
        }
        return "Unknown CREATE command: " + sPtr;
    }

    private SCNiTree findNi(SCCell cell, String name) {
        for (SCNiTree nPtr : cell.niList) {
            if (!nPtr.name.equalsIgnoreCase(name)) continue;
            return nPtr;
        }
        return null;
    }

    private String connect(List<String> keywords) {
        if (keywords.size() < 4) {
            return "Not enough parameters for CONNECT command";
        }
        String node0Name = keywords.get(1);
        String port0Name = keywords.get(2);
        SCNiTree ntpA = this.findNi(this.curSCCell, node0Name);
        if (ntpA == null) {
            return "Cannot find instance '" + node0Name + "'";
        }
        SCNiPort portA = this.findPp(ntpA, port0Name);
        if (portA == null) {
            return "Cannot find port '" + port0Name + "' on instance '" + node0Name + "'";
        }
        String node1Name = keywords.get(3);
        SCNiTree ntpB = this.findNi(this.curSCCell, node1Name);
        if (ntpB == null) {
            return "Cannot find instance '" + node1Name + "'";
        }
        SCNiPort portB = ntpB.ports;
        if (ntpB.type != 2) {
            if (keywords.size() < 5) {
                return "Not enough parameters for CONNECT command";
            }
            String port1Name = keywords.get(4);
            portB = this.findPp(ntpB, port1Name);
            if (portB == null) {
                return "Cannot find port '" + port1Name + "' on instance '" + node1Name + "'";
            }
        }
        this.conList(ntpA, portA, ntpB, portB);
        return null;
    }

    private SCNiPort findPp(SCNiTree ntp, String name) {
        SCNiPort port = null;
        if (ntp == null) {
            return null;
        }
        switch (ntp.type) {
            case 2: {
                return ntp.ports;
            }
            case 1: {
                port = ntp.ports;
                while (port != null && !((SCPort)port.port).name.equalsIgnoreCase(name)) {
                    port = port.next;
                }
                break;
            }
            case 0: {
                Export pp;
                port = ntp.ports;
                while (port != null && !(pp = (Export)port.port).getName().equalsIgnoreCase(name)) {
                    port = port.next;
                }
                break;
            }
        }
        return port;
    }

    private void conList(SCNiTree ntpA, SCNiPort portA, SCNiTree ntpB, SCNiPort portB) {
        ConList cl = new ConList();
        cl.portA = portA;
        cl.nodeB = ntpB;
        cl.portB = portB;
        cl.extNode = null;
        cl.next = ntpA.connect;
        ntpA.connect = cl;
        cl = new ConList();
        cl.portA = portB;
        cl.nodeB = ntpA;
        cl.portB = portA;
        cl.extNode = null;
        cl.next = ntpB.connect;
        ntpB.connect = cl;
    }

    private String export(List<String> keywords) {
        SCNiTree searchNPtr;
        if (this.curSCCell == null) {
            return "No cell selected";
        }
        if (keywords.size() <= 1) {
            return "No instance specified for EXPORT command";
        }
        String instName = keywords.get(1);
        SCNiTree nPtr = this.findNi(this.curSCCell, instName);
        if (nPtr == null) {
            return "Cannot find instance '" + instName + "' for EXPORT command";
        }
        if (keywords.size() <= 2) {
            return "No port specified for EXPORT command";
        }
        String portName = keywords.get(2);
        SCNiPort port = this.findPp(nPtr, portName);
        if (port == null) {
            return "Cannot find port '" + portName + "' on instance '" + instName + "' for EXPORT command";
        }
        if (keywords.size() <= 3) {
            return "No export name specified for EXPORT command";
        }
        String exportName = keywords.get(3);
        int type = 512;
        if (keywords.size() >= 5) {
            String typeName = keywords.get(4);
            if (typeName.equalsIgnoreCase("input")) {
                type = 256;
            } else if (typeName.equalsIgnoreCase("output")) {
                type = 128;
            } else if (typeName.equalsIgnoreCase("bidirectional")) {
                type = 64;
            } else {
                return "Unknown port type '" + typeName + "' for EXPORT command";
            }
        }
        if ((searchNPtr = this.findNi(this.curSCCell, exportName)) != null) {
            return "Export name '" + exportName + "' is not unique";
        }
        SCNiTree newNPtr = new SCNiTree(exportName, 2);
        this.curSCCell.niList.add(newNPtr);
        newNPtr.number = this.curSCCell.maxNodeNum++;
        searchNPtr = newNPtr;
        SCNiPort niPort = new SCNiPort();
        niPort.port = null;
        niPort.extNode = null;
        niPort.next = null;
        newNPtr.ports = niPort;
        SCPort newPort = new SCPort();
        niPort.port = newPort;
        newPort.name = exportName;
        newPort.node = newNPtr;
        newPort.parent = this.curSCCell;
        newPort.bits = type;
        newPort.next = null;
        if (this.curSCCell.lastPort == null) {
            this.curSCCell.ports = this.curSCCell.lastPort = newPort;
        } else {
            this.curSCCell.lastPort.next = newPort;
            this.curSCCell.lastPort = newPort;
        }
        this.conList(nPtr, port, newNPtr, niPort);
        return null;
    }

    private String xSet(List<String> keywords) {
        if (keywords.size() <= 1) {
            return "No option for SET command";
        }
        String whatToSet = keywords.get(1);
        if (whatToSet.equalsIgnoreCase("leaf-cell-numbers")) {
            String cellName = keywords.get(2);
            Cell leafCell = this.findLeafCell(cellName);
            if (leafCell == null) {
                return "Cannot find cell '" + cellName + "'";
            }
            SCCellNums cNums = GetNetlist.getLeafCellNums(leafCell);
            int numPar = 3;
            while (numPar < keywords.size()) {
                String parName = keywords.get(numPar);
                if (parName.equalsIgnoreCase("top-active")) {
                    if (++numPar >= keywords.size()) continue;
                    cNums.topActive = TextUtils.atoi(keywords.get(numPar++));
                    continue;
                }
                if (parName.equalsIgnoreCase("bottom-active")) {
                    if (++numPar >= keywords.size()) continue;
                    cNums.bottomActive = TextUtils.atoi(keywords.get(numPar++));
                    continue;
                }
                if (parName.equalsIgnoreCase("left-active")) {
                    if (++numPar >= keywords.size()) continue;
                    cNums.leftActive = TextUtils.atoi(keywords.get(numPar++));
                    continue;
                }
                if (parName.equalsIgnoreCase("right-active")) {
                    if (++numPar >= keywords.size()) continue;
                    cNums.rightActive = TextUtils.atoi(keywords.get(numPar++));
                    continue;
                }
                return "Unknown option '" + parName + "' for SET LEAF-CELL-NUMBERS command";
            }
            GetNetlist.setLeafCellNums(leafCell, cNums);
            return null;
        }
        if (whatToSet.equalsIgnoreCase("node-name")) {
            if (keywords.size() <= 4) {
                return "Insufficent parameters for SET NODE-NAME command";
            }
            String instName = keywords.get(2);
            SCNiTree instPtr = this.findNi(this.curSCCell, instName);
            if (instPtr == null) {
                return "Cannot find instance '" + instName + "' in SET NODE-NAME command";
            }
            String portName = keywords.get(3);
            SCNiPort iPort = instPtr.ports;
            while (iPort != null) {
                if (instPtr.type == 0) {
                    Export e = (Export)iPort.port;
                    if (e.getName().equalsIgnoreCase(portName)) {
                        break;
                    }
                } else if (instPtr.type == 1) {
                    SCPort scp = (SCPort)iPort.port;
                    if (scp.name.equalsIgnoreCase(portName)) break;
                }
                iPort = iPort.next;
            }
            if (iPort == null) {
                return "Cannot find port '" + portName + "' on instance '" + instName + "' in SET NODE-NAME command";
            }
            if (iPort.extNode == null) {
                return "Cannot find extracted node to set name in SET NODE-NAME command";
            }
            iPort.extNode.name = keywords.get(4);
            return null;
        }
        if (whatToSet.equalsIgnoreCase("port-direction")) {
            String cellName = keywords.get(2);
            String portName = keywords.get(3);
            SCCell cell = this.scCells;
            while (cell != null && !cell.name.equalsIgnoreCase(cellName)) {
                cell = cell.next;
            }
            int bits = 0;
            if (cell == null) {
                Cell leafCell = this.findLeafCell(cellName);
                if (leafCell == null) {
                    return "Cannot find cell '" + cellName + "'";
                }
                Export leafPort = leafCell.findExport(portName);
                if (leafPort == null) {
                    return "Cannot find port '" + portName + "' on cell '" + cellName + "'";
                }
            } else {
                SCPort port = cell.ports;
                while (port != null && !port.name.equalsIgnoreCase(portName)) {
                    port = port.next;
                }
                if (port == null) {
                    return "Cannot find port '" + portName + "' on cell '" + cellName + "'";
                }
                bits = port.bits;
            }
            bits &= 0xFFFFFFF0;
            String dir = keywords.get(4);
            block10: for (int i = 0; i < dir.length(); ++i) {
                char dirCh = dir.charAt(i);
                switch (dirCh) {
                    case 'u': {
                        bits |= 1;
                        continue block10;
                    }
                    case 'd': {
                        bits |= 2;
                        continue block10;
                    }
                    case 'r': {
                        bits |= 4;
                        continue block10;
                    }
                    case 'l': {
                        bits |= 8;
                        continue block10;
                    }
                    default: {
                        return "Unknown port direction specifier '" + dir + "'";
                    }
                }
            }
            return null;
        }
        return "Unknown option '" + whatToSet + "' for SET command";
    }

    static SCCellNums getLeafCellNums(Cell leafCell) {
        SCCellNums sNums = new SCCellNums();
        return sNums;
    }

    static void setLeafCellNums(Cell leafCell, SCCellNums nums) {
    }

    private Cell findLeafCell(String name) {
        Cell layCell;
        NodeProto np = Cell.findNodeProto(name);
        if (!(np instanceof Cell)) {
            np = null;
        }
        Cell cell = (Cell)np;
        Library lib = Library.findLibrary("sclib");
        if (cell == null && lib != null && (cell = lib.findNodeProto(name)) == null) {
            return null;
        }
        if (cell != null && (layCell = cell.otherView(View.LAYOUT)) != null) {
            cell = layCell;
        }
        return cell;
    }

    private String extract(List keywords) {
        ExtPort pList;
        ExtPort oldPList;
        if (this.curSCCell == null) {
            return "No cell selected";
        }
        this.extractClearFlag(this.curSCCell);
        this.curSCCell.exNodes = null;
        this.extractFindNodes(this.curSCCell);
        this.curSCCell.ground = new ExtNode();
        this.curSCCell.ground.name = "ground";
        this.curSCCell.ground.flags = 0;
        this.curSCCell.ground.ptr = null;
        this.curSCCell.ground.firstPort = null;
        this.curSCCell.ground.next = null;
        ExtNode oldNList = this.curSCCell.exNodes;
        ExtNode nList = this.curSCCell.exNodes;
        while (nList != null) {
            oldPList = nList.firstPort;
            pList = nList.firstPort;
            while (pList != null) {
                if (pList.node.number == 0) {
                    this.curSCCell.ground.firstPort = nList.firstPort;
                    if (oldNList == nList) {
                        this.curSCCell.exNodes = nList.next;
                    } else {
                        oldNList.next = nList.next;
                    }
                    if (oldPList == pList) {
                        this.curSCCell.ground.firstPort = pList.next;
                        break;
                    }
                    oldPList.next = pList.next;
                    break;
                }
                oldPList = pList;
                pList = pList.next;
            }
            if (pList != null) break;
            oldNList = nList;
            nList = nList.next;
        }
        ExtPort pList2 = this.curSCCell.ground.firstPort;
        while (pList2 != null) {
            pList2.port.extNode = this.curSCCell.ground;
            pList2 = pList2.next;
        }
        this.curSCCell.power = new ExtNode();
        this.curSCCell.power.name = "power";
        this.curSCCell.power.flags = 0;
        this.curSCCell.power.ptr = null;
        this.curSCCell.power.firstPort = null;
        this.curSCCell.power.next = null;
        oldNList = this.curSCCell.exNodes;
        nList = this.curSCCell.exNodes;
        while (nList != null) {
            oldPList = nList.firstPort;
            pList = nList.firstPort;
            while (pList != null) {
                if (pList.node.number == 1) {
                    this.curSCCell.power.firstPort = nList.firstPort;
                    if (oldNList == nList) {
                        this.curSCCell.exNodes = nList.next;
                    } else {
                        oldNList.next = nList.next;
                    }
                    if (oldPList == pList) {
                        this.curSCCell.power.firstPort = pList.next;
                        break;
                    }
                    oldPList.next = pList.next;
                    break;
                }
                oldPList = pList;
                pList = pList.next;
            }
            if (pList != null) break;
            oldNList = nList;
            nList = nList.next;
        }
        pList2 = this.curSCCell.power.firstPort;
        while (pList2 != null) {
            pList2.port.extNode = this.curSCCell.power;
            pList2 = pList2.next;
        }
        this.extractFindPower(this.curSCCell, this.curSCCell);
        this.extractCollectUnconnected(this.curSCCell);
        SCPort port = this.curSCCell.ports;
        while (port != null) {
            switch (port.bits & 0x3F0) {
                case 16: 
                case 32: {
                    break;
                }
                default: {
                    port.node.ports.extNode.name = port.name;
                }
            }
            port = port.next;
        }
        int nodenum = 2;
        ExtNode ext = this.curSCCell.exNodes;
        while (ext != null) {
            if (ext.name == null) {
                ext.name = "n" + nodenum++;
            }
            ext = ext.next;
        }
        return null;
    }

    private void extractClearFlag(SCCell cell) {
        for (SCNiTree ntp : cell.niList) {
            ntp.flags &= 2;
            SCNiPort port = ntp.ports;
            while (port != null) {
                port.extNode = null;
                port = port.next;
            }
        }
    }

    private void extractFindNodes(SCCell cell) {
        for (SCNiTree niTree : cell.niList) {
            niTree.flags |= 2;
            ConList cl = niTree.connect;
            while (cl != null) {
                this.extractSnake(niTree, cl.portA, cl);
                cl = cl.next;
            }
        }
    }

    private void extractSnake(SCNiTree nodeA, SCNiPort portA, ConList cl) {
        while (cl != null) {
            if (cl.portA == portA) {
                if (portA != null && portA.extNode != null) {
                    if (cl.portB == null || cl.portB.extNode == null) {
                        this.extractAddNode(portA.extNode, cl.nodeB, cl.portB);
                        if ((cl.nodeB.flags & 2) == 0) {
                            cl.nodeB.flags |= 2;
                            this.extractSnake(cl.nodeB, cl.portB, cl.nodeB.connect);
                            cl.nodeB.flags ^= 2;
                        }
                    }
                } else if (cl.portB != null && cl.portB.extNode != null) {
                    this.extractAddNode(cl.portB.extNode, nodeA, portA);
                } else {
                    ExtNode common = this.extractAddNode(null, nodeA, portA);
                    common = this.extractAddNode(common, cl.nodeB, cl.portB);
                    if ((cl.nodeB.flags & 2) == 0) {
                        cl.nodeB.flags |= 2;
                        this.extractSnake(cl.nodeB, cl.portB, cl.nodeB.connect);
                        cl.nodeB.flags ^= 2;
                    }
                }
            }
            cl = cl.next;
        }
    }

    private ExtNode extractAddNode(ExtNode simNode, SCNiTree node, SCNiPort port) {
        ExtPort newPort = new ExtPort();
        if (simNode == null) {
            simNode = new ExtNode();
            simNode.firstPort = newPort;
            simNode.flags = 0;
            simNode.ptr = null;
            simNode.name = null;
            newPort.node = node;
            newPort.port = port;
            if (port != null) {
                port.extNode = simNode;
            }
            newPort.next = null;
            simNode.next = this.curSCCell.exNodes;
            this.curSCCell.exNodes = simNode;
        } else {
            newPort.node = node;
            newPort.port = port;
            if (port != null) {
                port.extNode = simNode;
            }
            newPort.next = simNode.firstPort;
            simNode.firstPort = newPort;
        }
        return simNode;
    }

    private void extractFindPower(SCCell cell, SCCell vars) {
        block5: for (SCNiTree ntp : cell.niList) {
            if (ntp.number <= 1) continue;
            switch (ntp.type) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    ExtPort pList;
                    SCNiPort port = ntp.ground;
                    while (port != null) {
                        pList = new ExtPort();
                        pList.node = ntp;
                        pList.port = port;
                        port.extNode = vars.ground;
                        pList.next = vars.ground.firstPort;
                        vars.ground.firstPort = pList;
                        port = port.next;
                    }
                    port = ntp.power;
                    while (port != null) {
                        pList = new ExtPort();
                        pList.node = ntp;
                        pList.port = port;
                        port.extNode = vars.power;
                        pList.next = vars.power.firstPort;
                        vars.power.firstPort = pList;
                        port = port.next;
                    }
                    continue block5;
                }
            }
        }
    }

    private String pull() {
        if (this.curSCCell == null) {
            return "No cell selected";
        }
        ArrayList<SCNiTree> cellList = new ArrayList<SCNiTree>();
        for (SCNiTree inst : this.curSCCell.niList) {
            if (inst.type != 1) continue;
            cellList.add(inst);
        }
        for (SCNiTree inst : cellList) {
            String err = this.pullInst(inst, this.curSCCell);
            if (err == null) continue;
            return err;
        }
        ArrayList<SCNiTree> deleteList = new ArrayList<SCNiTree>();
        for (SCNiTree inst : this.curSCCell.niList) {
            if (inst.type != 1) continue;
            deleteList.add(inst);
        }
        for (SCNiTree inst : deleteList) {
            this.curSCCell.niList.remove(inst);
        }
        return null;
    }

    private String pullInst(SCNiTree inst, SCCell cell) {
        ExtPort ePort;
        SCNiPort iPort;
        SCCell subCell = (SCCell)inst.np;
        for (SCNiTree subInst : subCell.niList) {
            String err;
            if (subInst.type == 2) continue;
            ArrayList<String> createPars = new ArrayList<String>();
            createPars.add("create");
            createPars.add("instance");
            createPars.add(inst.name + "." + subInst.name);
            if (subInst.type == 0) {
                createPars.add(((Cell)subInst.np).getName());
            } else {
                createPars.add(((SCCell)subInst.np).name);
            }
            if ((err = this.create(createPars)) == null) continue;
            return err;
        }
        ExtNode eNode = subCell.exNodes;
        while (eNode != null) {
            ExtNode bNode = null;
            iPort = inst.ports;
            while (iPort != null) {
                if (((SCPort)iPort.port).node.ports.extNode == eNode) {
                    bNode = iPort.extNode;
                    break;
                }
                iPort = iPort.next;
            }
            if (bNode == null) {
                bNode = new ExtNode();
                bNode.name = null;
                bNode.firstPort = null;
                bNode.ptr = null;
                bNode.flags = 0;
                bNode.next = cell.exNodes;
                cell.exNodes = bNode;
            }
            ePort = eNode.firstPort;
            while (ePort != null) {
                if (ePort.node.type != 2) {
                    ExtPort nport = new ExtPort();
                    nport.node = this.findNi(cell, inst.name + "." + ePort.node.name);
                    SCNiPort iPort2 = nport.node.ports;
                    while (iPort2 != null) {
                        if (iPort2.port == ePort.port.port) {
                            nport.port = iPort2;
                            iPort2.extNode = bNode;
                            nport.next = bNode.firstPort;
                            bNode.firstPort = nport;
                            break;
                        }
                        iPort2 = iPort2.next;
                    }
                }
                ePort = ePort.next;
            }
            eNode = eNode.next;
        }
        ExtPort ePort2 = subCell.power.firstPort;
        while (ePort2 != null) {
            if (ePort2.node.type != 2) {
                ExtPort nport = new ExtPort();
                nport.node = this.findNi(cell, inst.name + "." + ePort2.node.name);
                iPort = nport.node.ports;
                while (iPort != null) {
                    if (iPort.port == ePort2.port.port) {
                        nport.port = iPort;
                        iPort.extNode = cell.power;
                        break;
                    }
                    iPort = iPort.next;
                }
                if (iPort == null) {
                    iPort = nport.node.power;
                    while (iPort != null) {
                        if (iPort.port == ePort2.port.port) {
                            nport.port = iPort;
                            iPort.extNode = cell.power;
                            break;
                        }
                        iPort = iPort.next;
                    }
                }
                nport.next = cell.power.firstPort;
                cell.power.firstPort = nport;
            }
            ePort2 = ePort2.next;
        }
        ExtPort nPort = cell.power.firstPort;
        ExtPort ePort3 = cell.power.firstPort;
        while (ePort3 != null) {
            if (ePort3.node == inst) {
                if (ePort3 == nPort) {
                    cell.power.firstPort = ePort3.next;
                    nPort = ePort3.next;
                } else {
                    nPort.next = ePort3.next;
                }
            } else {
                nPort = ePort3;
            }
            ePort3 = ePort3.next;
        }
        ePort3 = subCell.ground.firstPort;
        while (ePort3 != null) {
            if (ePort3.node.type != 2) {
                nPort = new ExtPort();
                nPort.node = this.findNi(cell, inst.name + "." + ePort3.node.name);
                iPort = nPort.node.ports;
                while (iPort != null) {
                    if (iPort.port == ePort3.port.port) {
                        nPort.port = iPort;
                        iPort.extNode = cell.ground;
                        break;
                    }
                    iPort = iPort.next;
                }
                if (iPort == null) {
                    iPort = nPort.node.ground;
                    while (iPort != null) {
                        if (iPort.port == ePort3.port.port) {
                            nPort.port = iPort;
                            iPort.extNode = cell.ground;
                            break;
                        }
                        iPort = iPort.next;
                    }
                }
                nPort.next = cell.ground.firstPort;
                cell.ground.firstPort = nPort;
            }
            ePort3 = ePort3.next;
        }
        nPort = cell.ground.firstPort;
        ePort3 = cell.ground.firstPort;
        while (ePort3 != null) {
            if (ePort3.node == inst) {
                if (ePort3 == nPort) {
                    cell.ground.firstPort = ePort3.next;
                    nPort = ePort3.next;
                } else {
                    nPort.next = ePort3.next;
                }
            } else {
                nPort = ePort3;
            }
            ePort3 = ePort3.next;
        }
        ExtNode eNode2 = cell.exNodes;
        while (eNode2 != null) {
            nPort = eNode2.firstPort;
            ePort = eNode2.firstPort;
            while (ePort != null) {
                if (ePort.node == inst) {
                    if (ePort == nPort) {
                        eNode2.firstPort = ePort.next;
                        nPort = ePort.next;
                    } else {
                        nPort.next = ePort.next;
                    }
                } else {
                    nPort = ePort;
                }
                ePort = ePort.next;
            }
            eNode2 = eNode2.next;
        }
        int oldNum = 0;
        ExtNode eNode3 = cell.exNodes;
        while (eNode3 != null) {
            if (eNode3.name != null) {
                int sPtr = 0;
                char firstCh = eNode3.name.charAt(0);
                if (Character.toUpperCase(firstCh) == 'N') {
                    int newnum;
                    ++sPtr;
                    while (sPtr < eNode3.name.length() && Character.isDigit(eNode3.name.charAt(sPtr))) {
                        ++sPtr;
                    }
                    if (sPtr >= eNode3.name.length() && (newnum = TextUtils.atoi(eNode3.name.substring(1))) > oldNum) {
                        oldNum = newnum;
                    }
                }
            }
            eNode3 = eNode3.next;
        }
        eNode3 = cell.exNodes;
        while (eNode3 != null) {
            if (eNode3.name == null) {
                eNode3.name = "n" + ++oldNum;
            }
            eNode3 = eNode3.next;
        }
        for (SCNiTree subInst : subCell.niList) {
            SCNiTree ninst;
            String err;
            if (subInst.type != 1 || (err = this.pullInst(ninst = this.findNi(cell, inst.name + "." + subInst.name), cell)) == null) continue;
            return err;
        }
        return null;
    }

    private void extractCollectUnconnected(SCCell cell) {
        block3: for (SCNiTree nPtr : cell.niList) {
            switch (nPtr.type) {
                case 0: 
                case 1: {
                    SCNiPort port = nPtr.ports;
                    while (port != null) {
                        if (port.extNode == null) {
                            ExtNode ext = new ExtNode();
                            ext.name = null;
                            ExtPort ePort = new ExtPort();
                            ePort.node = nPtr;
                            ePort.port = port;
                            ePort.next = null;
                            ext.firstPort = ePort;
                            ext.flags = 0;
                            ext.ptr = null;
                            ext.next = cell.exNodes;
                            cell.exNodes = ext;
                            port.extNode = ext;
                        }
                        port = port.next;
                    }
                    continue block3;
                }
            }
        }
    }

    static int getLeafPortType(Export leafPort) {
        if (leafPort.isPower()) {
            return 32;
        }
        if (leafPort.isGround()) {
            return 16;
        }
        if (leafPort.getCharacteristic() == PortCharacteristic.BIDIR) {
            return 64;
        }
        if (leafPort.getCharacteristic() == PortCharacteristic.OUT) {
            return 128;
        }
        if (leafPort.getCharacteristic() == PortCharacteristic.IN) {
            return 256;
        }
        return 512;
    }

    static int getLeafPortDirection(PortProto port) {
        return 3;
    }

    public static class ExtNode {
        String name;
        ExtPort firstPort;
        int flags;
        Object ptr;
        ExtNode next;
    }

    private static class ExtPort {
        SCNiTree node;
        SCNiPort port;
        ExtPort next;

        private ExtPort() {
        }
    }

    private static class ConList {
        SCNiPort portA;
        SCNiTree nodeB;
        SCNiPort portB;
        ExtNode extNode;
        ConList next;

        private ConList() {
        }
    }

    static class SCNiPort {
        Object port;
        ExtNode extNode;
        int bits;
        double xPos;
        SCNiPort next;

        SCNiPort() {
        }

        SCNiPort(SCNiTree instance) {
            this.port = null;
            this.extNode = null;
            this.bits = 0;
            this.xPos = 0.0;
            this.next = instance.ports;
            instance.ports = this;
        }
    }

    static class SCNiTree {
        String name;
        int number;
        int type;
        Object np;
        double size;
        ConList connect;
        SCNiPort ports;
        SCNiPort power;
        SCNiPort ground;
        int flags;
        Object tp;

        SCNiTree(String name, int type) {
            this.name = name;
            this.type = type;
            this.number = 0;
            this.np = null;
            this.size = 0.0;
            this.connect = null;
            this.ports = null;
            this.power = null;
            this.ground = null;
            this.flags = 0;
            this.tp = null;
        }
    }

    static class SCCellNums {
        int topActive;
        int bottomActive;
        int leftActive;
        int rightActive;

        SCCellNums() {
        }
    }

    static class SCPort {
        String name;
        SCNiTree node;
        SCCell parent;
        int bits;
        SCPort next;

        SCPort() {
        }
    }

    static class SCCell {
        String name;
        int maxNodeNum;
        List<SCNiTree> niList;
        ExtNode exNodes;
        int bits;
        ExtNode power;
        ExtNode ground;
        SCPort ports;
        SCPort lastPort;
        Place.SCPlace placement;
        Route.SCRoute route;
        SCCell next;

        SCCell() {
        }
    }
}

