/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PartType;
import com.sun.electric.tool.ncc.netlist.PartTypeTable;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Resistor
extends Part {
    public static final PartTypeTable TYPES = new PartTypeTable(new String[][]{{"N-Poly-RPO-Resistor", "N-Poly-RPO-Resistor"}, {"P-Poly-RPO-Resistor", "P-Poly-RPO-Resistor"}});
    private static final Map<PartType, ResistorPinType> TYPE_TO_PINTYPE = new HashMap<PartType, ResistorPinType>();
    private static final int[] PIN_COEFFS;
    private final PartType type;
    private final double width;
    private final double length;

    public Resistor(PartType type, NccNameProxy.PartNameProxy name, double width, double length, Wire w1, Wire w2) {
        super(name, new Wire[]{w1, w2});
        this.type = type;
        this.width = width;
        this.length = length;
    }

    @Override
    public int[] getPinCoeffs() {
        return PIN_COEFFS;
    }

    @Override
    public String valueDescription() {
        String sz = "W= " + this.width + " L=" + this.length;
        return sz;
    }

    @Override
    public Integer hashCodeForParallelMerge() {
        int hc = this.pins[0].hashCode() + this.pins[1].hashCode() + this.getClass().hashCode();
        return new Integer(hc);
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    public void connect(Wire ss, Wire ee) {
        this.pins[0] = ss;
        this.pins[1] = ee;
        ss.add(this);
        ee.add(this);
    }

    @Override
    public boolean parallelMerge(Part p) {
        return false;
    }

    @Override
    public int typeCode() {
        int tw = 4;
        return 0 + (this.type.getOrdinal() << 4);
    }

    @Override
    public PinType getPinTypeOfNthPin(int n) {
        return TYPE_TO_PINTYPE.get(this.type);
    }

    @Override
    public String typeString() {
        return this.type.getName();
    }

    @Override
    public String connectionDescription(int n) {
        String s = this.pins[0].getName();
        String e = this.pins[1].getName();
        return "S= " + s + " E= " + e;
    }

    @Override
    public String connectionDescription(Wire w) {
        String s = "";
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (s.length() != 0) {
                s = s + ",";
            }
            s = s + (i == 0 ? "S" : "E");
        }
        return s;
    }

    static {
        Iterator<PartType> it = TYPES.iterator();
        while (it.hasNext()) {
            PartType t = it.next();
            TYPE_TO_PINTYPE.put(t, new ResistorPinType(t));
        }
        PIN_COEFFS = new int[]{Primes.get(1), Primes.get(1)};
    }

    private static class ResistorPinType
    implements PinType {
        private PartType type;

        public ResistorPinType(PartType t) {
            this.type = t;
        }

        @Override
        public String description() {
            return this.type.getName();
        }
    }
}

