/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.IdManager;
import com.sun.electric.database.LibId;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class SnapshotReader {
    private final DataInputStream in;
    private final IdManager idManager;
    private final ArrayList<Variable.Key> varKeys = new ArrayList();
    private final ArrayList<TextDescriptor> textDescriptors = new ArrayList();
    private final ArrayList<Tool> tools = new ArrayList();
    private final ArrayList<Technology> techs = new ArrayList();
    private final ArrayList<ArcProto> arcProtos = new ArrayList();
    private final ArrayList<PrimitiveNode> primNodes = new ArrayList();
    private final ArrayList<Orientation> orients = new ArrayList();

    public SnapshotReader(DataInputStream in, IdManager idManager) {
        if (in == null || idManager == null) {
            throw new NullPointerException();
        }
        this.in = in;
        this.idManager = idManager;
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public byte[] readBytes() throws IOException {
        int length = this.in.readInt();
        byte[] bytes = new byte[length];
        this.in.readFully(bytes);
        return bytes;
    }

    public String readString() throws IOException {
        return this.in.readUTF();
    }

    public Variable.Key readVariableKey() throws IOException {
        int i = this.in.readInt();
        if (i == this.varKeys.size()) {
            String s = this.in.readUTF();
            Variable.Key varKey = Variable.newKey(s);
            this.varKeys.add(varKey);
        }
        return this.varKeys.get(i);
    }

    public TextDescriptor readTextDescriptor() throws IOException {
        int i = this.in.readInt();
        if (i == -1) {
            return null;
        }
        if (i == this.textDescriptors.size()) {
            long bits = this.in.readLong();
            int colorIndex = this.in.readInt();
            boolean isDisplay = this.in.readBoolean();
            boolean isJava = this.in.readBoolean();
            String fontName = this.in.readUTF();
            AbstractTextDescriptor.Code code = isJava ? AbstractTextDescriptor.Code.JAVA : AbstractTextDescriptor.Code.NONE;
            MutableTextDescriptor mtd = new MutableTextDescriptor(bits, colorIndex, isDisplay, code);
            int face = 0;
            if (fontName.length() != 0) {
                AbstractTextDescriptor.ActiveFont af = AbstractTextDescriptor.ActiveFont.findActiveFont(fontName);
                face = af.getIndex();
            }
            mtd.setFace(face);
            TextDescriptor td = TextDescriptor.newTextDescriptor(mtd);
            this.textDescriptors.add(td);
        }
        return this.textDescriptors.get(i);
    }

    public Tool readTool() throws IOException {
        int i = this.in.readInt();
        if (i == this.tools.size()) {
            String toolName = this.in.readUTF();
            Tool tool = Tool.findTool(toolName);
            this.tools.add(tool);
        }
        return this.tools.get(i);
    }

    public Technology readTechnology() throws IOException {
        int i = this.in.readInt();
        if (i == this.techs.size()) {
            String techName = this.in.readUTF();
            Technology tech = Technology.findTechnology(techName);
            this.techs.add(tech);
        }
        return this.techs.get(i);
    }

    public ArcProto readArcProto() throws IOException {
        int i = this.in.readInt();
        if (i == this.arcProtos.size()) {
            Technology tech = this.readTechnology();
            String arcName = this.in.readUTF();
            ArcProto ap = tech.findArcProto(arcName);
            this.arcProtos.add(ap);
        }
        return this.arcProtos.get(i);
    }

    public LibId readLibId() throws IOException {
        int libIndex = this.in.readInt();
        return this.idManager.getLibId(libIndex);
    }

    public NodeProtoId readNodeProtoId() throws IOException {
        int i = this.in.readInt();
        if (i >= 0) {
            return this.idManager.getCellId(i);
        }
        if ((i ^= 0xFFFFFFFF) == this.primNodes.size()) {
            Technology tech = this.readTechnology();
            String primName = this.in.readUTF();
            PrimitiveNode pn = tech.findNodeProto(primName);
            this.primNodes.add(pn);
        }
        return this.primNodes.get(i);
    }

    public PortProtoId readPortProtoId() throws IOException {
        NodeProtoId nodeProtoId = this.readNodeProtoId();
        int chronIndex = this.in.readInt();
        return nodeProtoId.getPortId(chronIndex);
    }

    public int readNodeId() throws IOException {
        return this.in.readInt();
    }

    public int readArcId() throws IOException {
        return this.in.readInt();
    }

    public Name readNameKey() throws IOException {
        String name = this.in.readUTF();
        return Name.findName(name);
    }

    public Orientation readOrientation() throws IOException {
        int i = this.in.readInt();
        if (i == this.orients.size()) {
            short angle = this.in.readShort();
            boolean isXMirrored = this.in.readBoolean();
            boolean isYMirrored = this.in.readBoolean();
            Orientation orient = Orientation.fromJava(angle, isXMirrored, isYMirrored);
            this.orients.add(orient);
        }
        return this.orients.get(i);
    }

    public long readCoord() throws IOException {
        return this.in.readLong();
    }

    public EPoint readPoint() throws IOException {
        long x = this.readCoord();
        long y = this.readCoord();
        return EPoint.fromGrid(x, y);
    }

    public ERectangle readRectangle() throws IOException {
        long x = this.readCoord();
        long y = this.readCoord();
        long w = this.readCoord();
        long h = this.readCoord();
        return ERectangle.fromGrid(x, y, w, h);
    }
}

