/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;

public class Highlight {
    private Type type;
    private ElectricObject eobj;
    private Cell cell;
    private int point;
    private Variable.Key varKey;
    private Name name;
    private Rectangle2D bounds;
    private Point2D pt1;
    private Point2D pt2;
    private Point2D center;
    private String msg;
    private Poly polygon;
    private Object object;
    private Color color;
    private boolean highlightConnected;
    public static final BasicStroke solidLine = new BasicStroke(0.0f);
    public static final BasicStroke dottedLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f);
    public static final BasicStroke dashedLine = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
    public static final BasicStroke boldLine = new BasicStroke(3.0f);
    private static final int CROSSSIZE = 3;

    protected Highlight(Type type, ElectricObject eobj, Cell cell) {
        this.type = type;
        this.eobj = eobj;
        this.cell = cell;
        this.point = -1;
        this.varKey = null;
        this.name = null;
        this.bounds = null;
        this.pt1 = null;
        this.pt2 = null;
        this.msg = null;
        this.polygon = null;
        this.color = null;
        this.highlightConnected = true;
    }

    public Type getType() {
        return this.type;
    }

    public ElectricObject getElectricObject() {
        return this.eobj;
    }

    protected void setElectricObject(ElectricObject eobj) {
        this.eobj = eobj;
    }

    protected void setObject(Object obj) {
        this.object = obj;
    }

    public Object getObject() {
        return this.object;
    }

    public Geometric getGeometric() {
        if (this.getType() == Type.EOBJ) {
            ElectricObject eobj = this.getElectricObject();
            if (eobj instanceof PortInst) {
                eobj = ((PortInst)eobj).getNodeInst();
            }
            if (eobj instanceof Geometric) {
                return (Geometric)eobj;
            }
        } else if (this.getType() == Type.TEXT && this.nodeMovesWithText()) {
            ElectricObject eobj = this.getElectricObject();
            if (eobj instanceof Export) {
                eobj = ((Export)eobj).getOriginalPort().getNodeInst();
            }
            if (eobj instanceof Geometric) {
                return (Geometric)eobj;
            }
        }
        return null;
    }

    public Cell getCell() {
        return this.cell;
    }

    public int getPoint() {
        return this.point;
    }

    public void setPoint(int point) {
        this.point = point;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    protected void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    public Name getName() {
        return this.name;
    }

    protected void setName(Name name) {
        this.name = name;
    }

    public Variable.Key getVarKey() {
        return this.varKey;
    }

    public void setVar(Variable var) {
        if (var != null && !var.isLinked(this.eobj)) {
            System.out.println("Unlinked var " + var + " added to highlight");
        }
        this.varKey = var.getKey();
    }

    public Point2D getLineStart() {
        return this.pt1;
    }

    public void setLineStart(Point2D pt) {
        this.pt1 = new Point2D.Double(pt.getX(), pt.getY());
    }

    public Point2D getLineEnd() {
        return this.pt2;
    }

    public void setLineEnd(Point2D pt) {
        this.pt2 = new Point2D.Double(pt.getX(), pt.getY());
    }

    public String getMessage() {
        return this.msg;
    }

    protected void setMessage(String msg) {
        this.msg = msg;
    }

    public Point2D getLocation() {
        return this.pt1;
    }

    public void setLocation(Point2D pt) {
        this.pt1 = new Point2D.Double(pt.getX(), pt.getY());
    }

    protected void setCenter(Point2D pt) {
        this.center = new Point2D.Double(pt.getX(), pt.getY());
    }

    public Point2D getCenter() {
        return this.center;
    }

    public void setHighlightConnected(boolean b) {
        this.highlightConnected = b;
    }

    public void setPoly(Poly poly) {
        this.polygon = poly;
    }

    public Poly getPoly() {
        return this.polygon;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isValid() {
        if (this.cell != null && !this.cell.isLinked()) {
            return false;
        }
        if (this.type == Type.EOBJ) {
            if (this.eobj instanceof PortInst) {
                return ((PortInst)this.eobj).getNodeInst().isLinked();
            }
            return this.eobj.isLinked();
        }
        if (this.type == Type.BBOX || this.type == Type.LINE || this.type == Type.MESSAGE || this.type == Type.THICKLINE || this.type == Type.POLY) {
            return true;
        }
        if (this.type == Type.TEXT) {
            if (this.name != null) {
                if (this.eobj instanceof NodeInst) {
                    NodeInst ni = (NodeInst)this.eobj;
                    return ni.getNameKey() == this.name;
                }
                if (this.eobj instanceof ArcInst) {
                    ArcInst ai = (ArcInst)this.eobj;
                    return ai.getNameKey() == this.name;
                }
            }
            if (this.varKey != null) {
                return this.eobj != null && this.eobj.getVar(this.varKey) != null;
            }
            if (this.eobj != null) {
                return this.eobj.isLinked();
            }
            return false;
        }
        return false;
    }

    protected Object clone() {
        Highlight h = new Highlight(this.type, this.eobj, this.cell);
        h.point = this.point;
        h.varKey = this.varKey;
        h.name = this.name;
        h.bounds = this.bounds;
        h.pt1 = this.pt1;
        h.pt2 = this.pt2;
        h.msg = this.msg;
        h.polygon = this.polygon;
        h.color = this.color;
        h.highlightConnected = this.highlightConnected;
        return h;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Highlight)) {
            return false;
        }
        Highlight h = (Highlight)other;
        if (h.getType() != this.type) {
            return false;
        }
        if (this.cell != h.getCell()) {
            return false;
        }
        if (this.type == Type.EOBJ) {
            return this.eobj == h.getElectricObject();
        }
        if (this.type == Type.TEXT) {
            return this.eobj == h.getElectricObject() && this.varKey == h.getVarKey() && this.name == h.getName();
        }
        if (this.type == Type.MESSAGE) {
            return this.getLocation().equals(h.getLocation()) && this.getMessage().equals(h.getMessage());
        }
        if (this.type == Type.BBOX) {
            return this.getBounds().equals(h.getBounds());
        }
        if (this.type == Type.LINE) {
            return this.getLineEnd().equals(h.getLineEnd()) && this.getLineStart().equals(h.getLineStart());
        }
        if (this.type == Type.THICKLINE) {
            boolean centerEquals = false;
            if (this.getCenter() != null && h.getCenter() != null) {
                centerEquals = this.getCenter().equals(h.getCenter());
            }
            return this.getLineEnd().equals(h.getLineEnd()) && this.getLineStart().equals(h.getLineStart()) && centerEquals;
        }
        if (this.type == Type.POLY) {
            return this.getPoly() == h.getPoly() && this.getColor() == h.getColor();
        }
        return false;
    }

    public int hasCode() {
        throw new UnsupportedOperationException();
    }

    public boolean nodeMovesWithText() {
        if (this.type != Type.TEXT) {
            return false;
        }
        if (this.varKey != null) {
            if (!(this.eobj instanceof NodeInst)) {
                return false;
            }
            NodeInst ni = (NodeInst)this.eobj;
            if (ni.isInvisiblePinWithText()) {
                return true;
            }
        } else {
            if (!(this.eobj instanceof Export)) {
                return false;
            }
            Export pp = (Export)this.eobj;
            if (pp.getOriginalPort().getNodeInst().getProto() == Generic.tech.invisiblePinNode) {
                return true;
            }
            if (User.isMoveNodeWithExport()) {
                return true;
            }
        }
        return false;
    }

    public void showHighlight(EditWindow wnd, Graphics g, int highOffX, int highOffY, boolean onlyHighlight, Color mainColor, Stroke primaryStroke) {
        if (!this.isValid()) {
            return;
        }
        g.setColor(mainColor);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(primaryStroke);
        if (this.type == Type.BBOX) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(this.bounds.getMinX(), this.bounds.getMinY()), new Point2D.Double(this.bounds.getMinX(), this.bounds.getMaxY()), new Point2D.Double(this.bounds.getMaxX(), this.bounds.getMaxY()), new Point2D.Double(this.bounds.getMaxX(), this.bounds.getMinY()), new Point2D.Double(this.bounds.getMinX(), this.bounds.getMinY())};
            Highlight.drawOutlineFromPoints(wnd, g, points, highOffX, highOffY, false, null);
            return;
        }
        if (this.type == Type.LINE) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(this.pt1.getX(), this.pt1.getY()), new Point2D.Double(this.pt2.getX(), this.pt2.getY())};
            Highlight.drawOutlineFromPoints(wnd, g, points, highOffX, highOffY, false, null);
            return;
        }
        if (this.type == Type.THICKLINE) {
            Point2D[] points = new Point2D.Double[]{new Point2D.Double(this.pt1.getX(), this.pt1.getY()), new Point2D.Double(this.pt2.getX(), this.pt2.getY())};
            Highlight.drawOutlineFromPoints(wnd, g, points, highOffX, highOffY, false, this.center);
            return;
        }
        if (this.type == Type.TEXT) {
            Geometric geom;
            ElectricObject eObj = this.getElectricObject();
            Point2D[] points = Highlighter.describeHighlightText(wnd, eObj, this.getVarKey());
            if (points == null) {
                return;
            }
            Point2D[] linePoints = new Point2D[2];
            for (int i = 0; i < points.length; i += 2) {
                linePoints[0] = points[i];
                linePoints[1] = points[i + 1];
                Highlight.drawOutlineFromPoints(wnd, g, linePoints, highOffX, highOffY, false, null);
            }
            if (onlyHighlight && eObj != null && eObj instanceof Geometric && ((geom = (Geometric)eObj) instanceof ArcInst || !((NodeInst)geom).isInvisiblePinWithText())) {
                Point c = wnd.databaseToScreen(geom.getTrueCenter());
                int lowX = Integer.MAX_VALUE;
                int highX = Integer.MIN_VALUE;
                int lowY = Integer.MAX_VALUE;
                int highY = Integer.MIN_VALUE;
                for (int i = 0; i < points.length; ++i) {
                    Point a = wnd.databaseToScreen(points[i]);
                    if (a.x < lowX) {
                        lowX = a.x;
                    }
                    if (a.x > highX) {
                        highX = a.x;
                    }
                    if (a.y < lowY) {
                        lowY = a.y;
                    }
                    if (a.y <= highY) continue;
                    highY = a.y;
                }
                int cX = (lowX + highX) / 2;
                int cY = (lowY + highY) / 2;
                if (Math.abs(cX - c.x) > 4 || Math.abs(cY - c.y) > 4) {
                    g.fillOval(c.x - 4, c.y - 4, 8, 8);
                    g2.setStroke(dottedLine);
                    Highlight.drawLine(g, wnd, c.x, c.y, cX, cY);
                    g2.setStroke(solidLine);
                }
            }
            return;
        }
        if (this.type == Type.POLY) {
            Color oldColor = null;
            if (this.color != null) {
                oldColor = g.getColor();
                g.setColor(this.color);
            }
            boolean opened = this.polygon.getStyle() == Poly.Type.OPENED;
            Highlight.drawOutlineFromPoints(wnd, g, this.polygon.getPoints(), highOffX, highOffY, opened, null);
            if (oldColor != null) {
                g.setColor(oldColor);
            }
            return;
        }
        if (this.type == Type.MESSAGE) {
            Point loc = wnd.databaseToScreen(this.pt1.getX(), this.pt1.getY());
            g.drawString(this.msg, loc.x, loc.y);
        }
        if (this.eobj instanceof ArcInst) {
            ArcInst ai = (ArcInst)this.eobj;
            if (!Job.acquireExamineLock(false)) {
                return;
            }
            try {
                Poly poly = ai.makePoly(ai.getWidth() - ai.getProto().getWidthOffset(), Poly.Type.CLOSED);
                if (poly == null) {
                    return;
                }
                Highlight.drawOutlineFromPoints(wnd, g, poly.getPoints(), highOffX, highOffY, false, null);
                if (onlyHighlight) {
                    String constraints = "X";
                    if (ai.isRigid()) {
                        constraints = "R";
                    } else if (ai.isFixedAngle()) {
                        constraints = ai.isSlidable() ? "FS" : "F";
                    } else if (ai.isSlidable()) {
                        constraints = "S";
                    }
                    Point p = wnd.databaseToScreen(ai.getTrueCenterX(), ai.getTrueCenterY());
                    Font font = wnd.getFont(null);
                    if (font != null) {
                        GlyphVector gv = wnd.getGlyphs(constraints, font);
                        Rectangle2D glyphBounds = gv.getVisualBounds();
                        g.drawString(constraints, (int)((double)p.x - glyphBounds.getWidth() / 2.0 + (double)highOffX), p.y + font.getSize() / 2 + highOffY);
                    }
                }
                Job.releaseExamineLock();
            }
            catch (Error e) {
                Job.releaseExamineLock();
                throw e;
            }
            return;
        }
        PortProto pp = null;
        ElectricObject realEObj = this.eobj;
        if (realEObj instanceof PortInst) {
            pp = ((PortInst)realEObj).getPortProto();
            realEObj = ((PortInst)realEObj).getNodeInst();
        }
        if (realEObj instanceof NodeInst) {
            Poly niPoly;
            boolean niOpened;
            Point2D[] points;
            NodeInst ni = (NodeInst)realEObj;
            NodeProto np = ni.getProto();
            AffineTransform trans = ni.rotateOutAboutTrueCenter();
            int offX = highOffX;
            int offY = highOffY;
            if (this.point >= 0 && (points = ni.getTrace()) != null) {
                int nextPoint;
                double x = ni.getAnchorCenterX() + points[this.point].getX();
                double y = ni.getAnchorCenterY() + points[this.point].getY();
                Point2D.Double thisPt = new Point2D.Double(x, y);
                trans.transform(thisPt, thisPt);
                Point cThis = wnd.databaseToScreen(thisPt);
                int size = 3;
                Highlight.drawLine(g, wnd, cThis.x + size + offX, cThis.y + size + offY, cThis.x - size + offX, cThis.y - size + offY);
                Highlight.drawLine(g, wnd, cThis.x + size + offX, cThis.y - size + offY, cThis.x - size + offX, cThis.y + size + offY);
                boolean showWrap = ni.traceWraps();
                Point2D.Double prevPt = null;
                Point2D.Double nextPt = null;
                int prevPoint = this.point - 1;
                if (prevPoint < 0 && showWrap) {
                    prevPoint = points.length - 1;
                }
                if (prevPoint >= 0) {
                    prevPt = new Point2D.Double(ni.getAnchorCenterX() + points[prevPoint].getX(), ni.getAnchorCenterY() + points[prevPoint].getY());
                    trans.transform(prevPt, prevPt);
                    if (((Point2D)prevPt).getX() == ((Point2D)thisPt).getX() && ((Point2D)prevPt).getY() == ((Point2D)thisPt).getY()) {
                        prevPoint = -1;
                    } else {
                        Point cPrev = wnd.databaseToScreen(prevPt);
                        Highlight.drawLine(g, wnd, cThis.x + offX, cThis.y + offY, cPrev.x, cPrev.y);
                    }
                }
                if ((nextPoint = this.point + 1) >= points.length) {
                    nextPoint = showWrap ? 0 : -1;
                }
                if (nextPoint >= 0) {
                    nextPt = new Point2D.Double(ni.getAnchorCenterX() + points[nextPoint].getX(), ni.getAnchorCenterY() + points[nextPoint].getY());
                    trans.transform(nextPt, nextPt);
                    if (((Point2D)nextPt).getX() == ((Point2D)thisPt).getX() && ((Point2D)nextPt).getY() == ((Point2D)thisPt).getY()) {
                        nextPoint = -1;
                    } else {
                        Point cNext = wnd.databaseToScreen(nextPt);
                        Highlight.drawLine(g, wnd, cThis.x + offX, cThis.y + offY, cNext.x, cNext.y);
                    }
                }
                if (offX == 0 && offY == 0 && points.length > 2) {
                    double arrowLen = Double.MAX_VALUE;
                    if (prevPoint >= 0) {
                        arrowLen = Math.min(thisPt.distance(prevPt), arrowLen);
                    }
                    if (nextPoint >= 0) {
                        arrowLen = Math.min(thisPt.distance(nextPt), arrowLen);
                    }
                    arrowLen /= 10.0;
                    double angleOfArrow = 2.5132741228718345;
                    if (prevPoint >= 0) {
                        Point2D.Double prevCtr = new Point2D.Double((((Point2D)prevPt).getX() + ((Point2D)thisPt).getX()) / 2.0, (((Point2D)prevPt).getY() + ((Point2D)thisPt).getY()) / 2.0);
                        double prevAngle = DBMath.figureAngleRadians(prevPt, thisPt);
                        Point2D.Double prevArrow1 = new Point2D.Double(((Point2D)prevCtr).getX() + Math.cos(prevAngle + angleOfArrow) * arrowLen, ((Point2D)prevCtr).getY() + Math.sin(prevAngle + angleOfArrow) * arrowLen);
                        Point2D.Double prevArrow2 = new Point2D.Double(((Point2D)prevCtr).getX() + Math.cos(prevAngle - angleOfArrow) * arrowLen, ((Point2D)prevCtr).getY() + Math.sin(prevAngle - angleOfArrow) * arrowLen);
                        Point cPrevCtr = wnd.databaseToScreen(prevCtr);
                        Point cPrevArrow1 = wnd.databaseToScreen(prevArrow1);
                        Point cPrevArrow2 = wnd.databaseToScreen(prevArrow2);
                        Highlight.drawLine(g, wnd, cPrevCtr.x, cPrevCtr.y, cPrevArrow1.x, cPrevArrow1.y);
                        Highlight.drawLine(g, wnd, cPrevCtr.x, cPrevCtr.y, cPrevArrow2.x, cPrevArrow2.y);
                    }
                    if (nextPoint >= 0) {
                        Point2D.Double nextCtr = new Point2D.Double((((Point2D)nextPt).getX() + ((Point2D)thisPt).getX()) / 2.0, (((Point2D)nextPt).getY() + ((Point2D)thisPt).getY()) / 2.0);
                        double nextAngle = DBMath.figureAngleRadians(thisPt, nextPt);
                        Point2D.Double nextArrow1 = new Point2D.Double(((Point2D)nextCtr).getX() + Math.cos(nextAngle + angleOfArrow) * arrowLen, ((Point2D)nextCtr).getY() + Math.sin(nextAngle + angleOfArrow) * arrowLen);
                        Point2D.Double nextArrow2 = new Point2D.Double(((Point2D)nextCtr).getX() + Math.cos(nextAngle - angleOfArrow) * arrowLen, ((Point2D)nextCtr).getY() + Math.sin(nextAngle - angleOfArrow) * arrowLen);
                        Point cNextCtr = wnd.databaseToScreen(nextCtr);
                        Point cNextArrow1 = wnd.databaseToScreen(nextArrow1);
                        Point cNextArrow2 = wnd.databaseToScreen(nextArrow2);
                        Highlight.drawLine(g, wnd, cNextCtr.x, cNextCtr.y, cNextArrow1.x, cNextArrow1.y);
                        Highlight.drawLine(g, wnd, cNextCtr.x, cNextCtr.y, cNextArrow2.x, cNextArrow2.y);
                    }
                }
                offY = 0;
                offX = 0;
            }
            boolean bl = niOpened = (niPoly = Highlight.getNodeInstOutline(ni)).getStyle() == Poly.Type.OPENED;
            if (offX == 0 && offY == 0 || this.point < 0) {
                Point2D[] points2 = niPoly.getPoints();
                Highlight.drawOutlineFromPoints(wnd, g, points2, offX, offY, niOpened, null);
            }
            if (pp != null) {
                g.setColor(mainColor);
                Poly poly = ni.getShapeOfPort(pp);
                boolean opened = true;
                Point2D[] points3 = poly.getPoints();
                if (poly.getStyle() == Poly.Type.FILLED || poly.getStyle() == Poly.Type.CLOSED) {
                    opened = false;
                }
                if (poly.getStyle() == Poly.Type.CIRCLE || poly.getStyle() == Poly.Type.THICKCIRCLE || poly.getStyle() == Poly.Type.DISC) {
                    double sX = points3[0].distance(points3[1]) * 2.0;
                    Point2D[] pts = Artwork.fillEllipse(points3[0], sX, sX, 0.0, 360.0);
                    poly = new Poly(pts);
                    poly.transform(ni.rotateOut());
                    points3 = poly.getPoints();
                } else if (poly.getStyle() == Poly.Type.CIRCLEARC) {
                    double[] angles = ni.getArcDegrees();
                    double sX = points3[0].distance(points3[1]) * 2.0;
                    Point2D[] pts = Artwork.fillEllipse(points3[0], sX, sX, angles[0], angles[1]);
                    poly = new Poly(pts);
                    poly.transform(ni.rotateOut());
                    points3 = poly.getPoints();
                }
                Highlight.drawOutlineFromPoints(wnd, g, points3, offX, offY, opened, null);
                g.setColor(mainColor);
                if (ni.isCellInstance() && g instanceof Graphics2D) {
                    boolean wired = false;
                    Iterator<Connection> cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = cIt.next();
                        if (con.getPortInst().getPortProto() != pp) continue;
                        wired = true;
                        break;
                    }
                    if (wired) {
                        Font font = new Font(User.getDefaultFont(), 0, (int)(1.5 * (double)EditWindow.getDefaultFontSize()));
                        GlyphVector v = wnd.getGlyphs(pp.getName(), font);
                        Point point = wnd.databaseToScreen(poly.getCenterX(), poly.getCenterY());
                        ((Graphics2D)g).drawGlyphVector(v, (float)((Point2D)point).getX() + (float)offX, (float)((Point2D)point).getY() + (float)offY);
                    }
                }
                if (this.highlightConnected) {
                    Export equiv;
                    Netlist netlist = this.cell.acquireUserNetlist();
                    if (netlist == null) {
                        return;
                    }
                    NodeInst originalNI = ni;
                    if (ni.isIconOfParent() && (equiv = (Export)this.cell.findPortProto(pp.getName())) != null) {
                        PortInst ePi = equiv.getOriginalPort();
                        ni = ePi.getNodeInst();
                        pp = ePi.getPortProto();
                    }
                    Nodable no = Netlist.getNodableFor(ni, 0);
                    PortProto epp = pp;
                    if (pp instanceof Export && (epp = ((Export)pp).getEquivalent()) == null) {
                        epp = pp;
                    }
                    int busWidth = pp.getNameKey().busWidth();
                    HashSet<Geometric> markObj = new HashSet<Geometric>();
                    Iterator<ArcInst> it = this.cell.getArcs();
                    while (it.hasNext()) {
                        ArcInst ai = it.next();
                        if (!netlist.sameNetwork(no, epp, ai)) continue;
                        markObj.add(ai);
                        markObj.add(ai.getHeadPortInst().getNodeInst());
                        markObj.add(ai.getTailPortInst().getNodeInst());
                    }
                    Stroke origStroke = g2.getStroke();
                    g2.setStroke(dashedLine);
                    Iterator<Geometric> it2 = this.cell.getArcs();
                    while (it2.hasNext()) {
                        ArcInst ai = it2.next();
                        if (!markObj.contains(ai)) continue;
                        Point c1 = wnd.databaseToScreen(ai.getHeadLocation());
                        Point c2 = wnd.databaseToScreen(ai.getTailLocation());
                        Highlight.drawLine(g, wnd, c1.x, c1.y, c2.x, c2.y);
                    }
                    g2.setStroke(solidLine);
                    it2 = this.cell.getNodes();
                    while (it2.hasNext()) {
                        NodeInst oNi = (NodeInst)it2.next();
                        if (oNi == originalNI) continue;
                        if (!markObj.contains(oNi)) {
                            boolean connected = false;
                            if (oNi.hasExports()) {
                                Iterator<PortProto> eIt = oNi.getProto().getPorts();
                                while (eIt.hasNext()) {
                                    PortProto oPp = eIt.next();
                                    if (!netlist.sameNetwork(no, epp, oNi, oPp)) continue;
                                    connected = true;
                                    break;
                                }
                            }
                            if (!connected) continue;
                        }
                        Point c = wnd.databaseToScreen(oNi.getTrueCenter());
                        g.fillOval(c.x - 4, c.y - 4, 8, 8);
                        Point2D nodeCenter = oNi.getTrueCenter();
                        Iterator<Connection> pIt = oNi.getConnections();
                        while (pIt.hasNext()) {
                            EPoint arcEnd;
                            Connection con = pIt.next();
                            ArcInst ai = con.getArc();
                            if (!markObj.contains(ai) || ((Point2D)(arcEnd = con.getLocation())).getX() == nodeCenter.getX() && ((Point2D)arcEnd).getY() == nodeCenter.getY()) continue;
                            Point c1 = wnd.databaseToScreen(arcEnd);
                            Point c2 = wnd.databaseToScreen(nodeCenter);
                            Highlight.drawLine(g, wnd, c1.x, c1.y, c2.x, c2.y);
                        }
                    }
                    g2.setStroke(origStroke);
                }
            }
        }
    }

    public String toString() {
        return "Highlight " + this.type;
    }

    public String describe() {
        StringBuffer desc = new StringBuffer();
        desc.append(this.type);
        if (this.cell != null) {
            desc.append(" in ");
            desc.append(this.cell);
        }
        desc.append(": ");
        if (this.type == Type.MESSAGE) {
            desc.append(", ");
            desc.append(this.msg);
        } else if (this.type == Type.EOBJ) {
            desc.append(", ");
            if (this.eobj instanceof PortInst) {
                desc.append(((PortInst)this.eobj).describe(true));
            }
            if (this.eobj instanceof NodeInst) {
                desc.append(((NodeInst)this.eobj).describe(true));
            }
            if (this.eobj instanceof ArcInst) {
                desc.append(((ArcInst)this.eobj).describe(true));
            }
        } else if (this.type == Type.TEXT) {
            if (this.varKey != null) {
                desc.append(", var: ");
                desc.append(this.eobj.getVar(this.varKey).describe(-1));
            }
            if (this.name != null) {
                desc.append(", name: ");
                desc.append(this.name.toString());
            }
        }
        return desc.toString();
    }

    public static Poly getNodeInstOutline(NodeInst ni) {
        AffineTransform trans = ni.rotateOutAboutTrueCenter();
        Poly poly = null;
        if (!ni.isCellInstance()) {
            double[] angles;
            Point2D[] outline;
            PrimitiveNode pn = (PrimitiveNode)ni.getProto();
            if (pn.isHoldsOutline() && (outline = ni.getTrace()) != null) {
                int numPoints = outline.length;
                Point2D[] pointList = new Point2D.Double[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    pointList[i] = new Point2D.Double(ni.getAnchorCenterX() + outline[i].getX(), ni.getAnchorCenterY() + outline[i].getY());
                }
                trans.transform(pointList, 0, pointList, 0, numPoints);
                poly = new Poly(pointList);
                if (ni.getFunction() == PrimitiveNode.Function.NODE) {
                    poly.setStyle(Poly.Type.FILLED);
                } else {
                    poly.setStyle(Poly.Type.OPENED);
                }
            }
            if (!(pn != Artwork.tech.circleNode && pn != Artwork.tech.thickCircleNode || (angles = ni.getArcDegrees())[0] == 0.0 && angles[1] == 0.0)) {
                Point2D[] pointList = Artwork.fillEllipse(ni.getAnchorCenter(), ni.getXSize(), ni.getYSize(), angles[0], angles[1]);
                poly = new Poly(pointList);
                poly.setStyle(Poly.Type.OPENED);
                poly.transform(ni.rotateOut());
            }
        }
        if (poly == null) {
            SizeOffset so = ni.getSizeOffset();
            double nodeLowX = ni.getTrueCenterX() - ni.getXSize() / 2.0 + so.getLowXOffset();
            double nodeHighX = ni.getTrueCenterX() + ni.getXSize() / 2.0 - so.getHighXOffset();
            double nodeLowY = ni.getTrueCenterY() - ni.getYSize() / 2.0 + so.getLowYOffset();
            double nodeHighY = ni.getTrueCenterY() + ni.getYSize() / 2.0 - so.getHighYOffset();
            if (nodeLowX == nodeHighX && nodeLowY == nodeHighY) {
                float x = (float)nodeLowX;
                float y = (float)nodeLowY;
                Point2D[] outline = new Point2D[]{new Point2D.Double(x, y)};
                poly = new Poly(outline);
            } else {
                double nodeX = (nodeLowX + nodeHighX) / 2.0;
                double nodeY = (nodeLowY + nodeHighY) / 2.0;
                poly = new Poly(nodeX, nodeY, nodeHighX - nodeLowX, nodeHighY - nodeLowY);
                poly.transform(trans);
            }
        }
        return poly;
    }

    private static void drawOutlineFromPoints(EditWindow wnd, Graphics g, Point2D[] points, int offX, int offY, boolean opened, Point2D thickCenter) {
        Dimension screen = wnd.getScreenSize();
        boolean onePoint = true;
        if (points.length <= 0) {
            return;
        }
        Point firstP = wnd.databaseToScreen(points[0].getX(), points[0].getY());
        for (int i = 1; i < points.length; ++i) {
            Point p = wnd.databaseToScreen(points[i].getX(), points[i].getY());
            if (DBMath.doublesEqual(p.getX(), firstP.getX()) && DBMath.doublesEqual(p.getY(), firstP.getY())) continue;
            onePoint = false;
            break;
        }
        if (onePoint) {
            Highlight.drawLine(g, wnd, firstP.x + offX - 3, firstP.y + offY, firstP.x + offX + 3, firstP.y + offY);
            Highlight.drawLine(g, wnd, firstP.x + offX, firstP.y + offY - 3, firstP.x + offX, firstP.y + offY + 3);
            return;
        }
        int cX = 0;
        int cY = 0;
        if (thickCenter != null) {
            Point lp = wnd.databaseToScreen(thickCenter.getX(), thickCenter.getY());
            cX = lp.x;
            cY = lp.y;
        }
        for (int i = 0; i < points.length; ++i) {
            int lastI = i - 1;
            if (lastI < 0) {
                if (opened) continue;
                lastI = points.length - 1;
            }
            Point lp = wnd.databaseToScreen(points[lastI].getX(), points[lastI].getY());
            Point p = wnd.databaseToScreen(points[i].getX(), points[i].getY());
            int fX = lp.x + offX;
            int fY = lp.y + offY;
            int tX = p.x + offX;
            int tY = p.y + offY;
            Highlight.drawLine(g, wnd, fX, fY, tX, tY);
            if (thickCenter == null) continue;
            fX = fX < cX ? --fX : ++fX;
            fY = fY < cY ? --fY : ++fY;
            tX = tX < cX ? --tX : ++tX;
            tY = tY < cY ? --tY : ++tY;
            Highlight.drawLine(g, wnd, fX, fY, tX, tY);
        }
    }

    private static void drawLine(Graphics g, EditWindow wnd, int x1, int y1, int x2, int y2) {
        Dimension size = wnd.getScreenSize();
        Point pt1 = new Point(x1, y1);
        Point pt2 = new Point(x2, y2);
        if (GenMath.clipLine(pt1, pt2, 0, size.width - 1, 0, size.height - 1)) {
            return;
        }
        g.drawLine(pt1.x, pt1.y, pt2.x, pt2.y);
    }

    public boolean sameThing(Highlight other) {
        if (this.type != other.getType()) {
            return false;
        }
        if (this.type == Type.BBOX || this.type == Type.LINE || this.type == Type.THICKLINE || this.type == Type.POLY) {
            return false;
        }
        if (this.type == Type.EOBJ) {
            ElectricObject realOtherEObj;
            ElectricObject realEObj = this.eobj;
            if (realEObj instanceof PortInst) {
                realEObj = ((PortInst)realEObj).getNodeInst();
            }
            if ((realOtherEObj = other.getElectricObject()) instanceof PortInst) {
                realOtherEObj = ((PortInst)realOtherEObj).getNodeInst();
            }
            if (realEObj != realOtherEObj) {
                return false;
            }
        } else if (this.type == Type.TEXT) {
            if (this.eobj != other.getElectricObject()) {
                return false;
            }
            if (this.cell != other.getCell()) {
                return false;
            }
            if (this.varKey != other.getVarKey()) {
                return false;
            }
            if (this.name != other.getName()) {
                return false;
            }
        }
        return true;
    }

    public static class Type {
        private final String name;
        private int order;
        private static int ordering = 1;
        public static final Type EOBJ = new Type("electricObject");
        public static final Type TEXT = new Type("text");
        public static final Type BBOX = new Type("area");
        public static final Type LINE = new Type("line");
        public static final Type THICKLINE = new Type("thick line");
        public static final Type MESSAGE = new Type("message");
        public static final Type POLY = new Type("poly");
        public static final Type SHAPE3D = new Type("shape3d");

        private Type(String name) {
            this.name = name;
            this.order = ordering++;
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return this.name;
        }
    }
}

