/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.lib.LibFile;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class SpiceTab
extends PreferencePanel {
    private JCheckBox epicCheckBox;
    private JPanel epicFrame;
    private JLabel epicLabel;
    private JTextField epicText;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel13;
    private JLabel jLabel17;
    private JLabel jLabel3;
    private JLabel jLabel9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator4;
    private JCheckBox overwriteOutputFile;
    private JPanel spice;
    private JPanel spice1;
    private JPanel spice2;
    private JPanel spice3;
    private JPanel spice5;
    private JButton spiceBrowseHeaderFile;
    private JButton spiceBrowseTrailerFile;
    private JComboBox spiceEnginePopup;
    private JCheckBox spiceForceGlobalPwrGnd;
    private ButtonGroup spiceHeader;
    private JTextField spiceHeaderCardExtension;
    private JTextField spiceHeaderCardFile;
    private JRadioButton spiceHeaderCardsFromFile;
    private JRadioButton spiceHeaderCardsWithExtension;
    private JComboBox spiceLevelPopup;
    private ButtonGroup spiceModel;
    private JRadioButton spiceNoHeaderCards;
    private JRadioButton spiceNoTrailerCards;
    private JComboBox spiceOutputFormatPopup;
    private JComboBox spicePrimitivesetPopup;
    private JButton spiceRunHelp;
    private JComboBox spiceRunPopup;
    private JCheckBox spiceRunProbe;
    private JTextField spiceRunProgram;
    private JTextField spiceRunProgramArgs;
    private ButtonGroup spiceTrailer;
    private JTextField spiceTrailerCardExtension;
    private JTextField spiceTrailerCardFile;
    private JRadioButton spiceTrailerCardsFromFile;
    private JRadioButton spiceTrailerCardsWithExtension;
    private JCheckBox spiceUseCellParameters;
    private JCheckBox spiceUseNodeNames;
    private JCheckBox spiceUseParasitics;
    private JCheckBox spiceWriteSubcktTopCell;
    private JCheckBox spiceWriteTransSizesInLambda;
    private JTextField useDir;
    private JCheckBox useDirCheckBox;

    public SpiceTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.spice;
    }

    public String getName() {
        return "Spice";
    }

    public void init() {
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_2);
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_3);
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_H);
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_P);
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_G);
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_S);
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_H_ASSURA);
        this.spiceEnginePopup.setSelectedItem((Object)Simulation.getSpiceEngine());
        this.spiceLevelPopup.addItem("1");
        this.spiceLevelPopup.addItem("2");
        this.spiceLevelPopup.addItem("3");
        this.spiceLevelPopup.setSelectedItem(Simulation.getSpiceLevel());
        this.spiceOutputFormatPopup.addItem(SpiceOutFormat.Standard);
        this.spiceOutputFormatPopup.addItem(SpiceOutFormat.Raw);
        this.spiceOutputFormatPopup.addItem(SpiceOutFormat.RawSmart);
        this.spiceOutputFormatPopup.addItem(SpiceOutFormat.Epic);
        this.spiceOutputFormatPopup.setSelectedItem((Object)SpiceOutFormat.valueOf(Simulation.getSpiceOutputFormat()));
        this.epicCheckBox.setSelected(Simulation.isSpiceEpicReaderProcess());
        this.epicText.setText(String.valueOf(Simulation.getSpiceEpicMemorySize()));
        this.spiceUseParasitics.setSelected(Simulation.isSpiceUseParasitics());
        this.spiceUseNodeNames.setSelected(Simulation.isSpiceUseNodeNames());
        this.spiceForceGlobalPwrGnd.setSelected(Simulation.isSpiceForceGlobalPwrGnd());
        this.spiceUseCellParameters.setSelected(Simulation.isSpiceUseCellParameters());
        this.spiceWriteTransSizesInLambda.setSelected(Simulation.isSpiceWriteTransSizeInLambda());
        this.spiceWriteSubcktTopCell.setSelected(Simulation.isSpiceWriteSubcktTopCell());
        this.useDir.setText(Simulation.getSpiceRunDir());
        this.useDirCheckBox.setSelected(Simulation.getSpiceUseRunDir());
        this.overwriteOutputFile.setSelected(Simulation.getSpiceOutputOverwrite());
        this.spiceRunProbe.setSelected(Simulation.getSpiceRunProbe());
        this.spiceRunProgram.setText(Simulation.getSpiceRunProgram());
        this.spiceRunProgramArgs.setText(Simulation.getSpiceRunProgramArgs());
        String[] libFiles = LibFile.getSpicePartsLibraries();
        for (int i = 0; i < libFiles.length; ++i) {
            this.spicePrimitivesetPopup.addItem(libFiles[i]);
        }
        this.spicePrimitivesetPopup.setSelectedItem(Simulation.getSpicePartsLibrary());
        String[] runChoices = Simulation.getSpiceRunChoiceValues();
        for (int i = 0; i < runChoices.length; ++i) {
            this.spiceRunPopup.addItem(runChoices[i]);
        }
        this.spiceRunPopup.setSelectedItem(Simulation.getSpiceRunChoice());
        if (this.spiceRunPopup.getSelectedIndex() == 0) {
            this.setSpiceRunOptionsEnabled(false);
        } else {
            this.setSpiceRunOptionsEnabled(true);
        }
        String spiceHeaderCardInitial = Simulation.getSpiceHeaderCardInfo();
        if (spiceHeaderCardInitial.length() == 0) {
            this.spiceNoHeaderCards.setSelected(true);
        } else if (spiceHeaderCardInitial.startsWith("Extension ")) {
            this.spiceHeaderCardsWithExtension.setSelected(true);
            this.spiceHeaderCardExtension.setText(spiceHeaderCardInitial.substring("Extension ".length()));
        } else {
            this.spiceHeaderCardsFromFile.setSelected(true);
            this.spiceHeaderCardFile.setText(spiceHeaderCardInitial);
        }
        String spiceTrailerCardInitial = Simulation.getSpiceTrailerCardInfo();
        if (spiceTrailerCardInitial.length() == 0) {
            this.spiceNoTrailerCards.setSelected(true);
        } else if (spiceTrailerCardInitial.startsWith("Extension ")) {
            this.spiceTrailerCardsWithExtension.setSelected(true);
            this.spiceTrailerCardExtension.setText(spiceTrailerCardInitial.substring("Extension ".length()));
        } else {
            this.spiceTrailerCardsFromFile.setSelected(true);
            this.spiceTrailerCardFile.setText(spiceTrailerCardInitial);
        }
        this.spiceBrowseHeaderFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceBrowseHeaderFileActionPerformed();
            }
        });
        this.spiceBrowseTrailerFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceBrowseTrailerFileActionPerformed();
            }
        });
    }

    private void spiceBrowseTrailerFileActionPerformed() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, null);
        if (fileName == null) {
            return;
        }
        this.spiceTrailerCardFile.setText(fileName);
        this.spiceTrailerCardsFromFile.setSelected(true);
    }

    private void spiceBrowseHeaderFileActionPerformed() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, null);
        if (fileName == null) {
            return;
        }
        this.spiceHeaderCardFile.setText(fileName);
        this.spiceHeaderCardsFromFile.setSelected(true);
    }

    public void term() {
        Simulation.SpiceEngine engine = (Simulation.SpiceEngine)((Object)this.spiceEnginePopup.getSelectedItem());
        if (Simulation.getSpiceEngine() != engine) {
            Simulation.setSpiceEngine(engine);
        }
        String stringNow = (String)this.spiceLevelPopup.getSelectedItem();
        if (!Simulation.getSpiceLevel().equals(stringNow)) {
            Simulation.setSpiceLevel(stringNow);
        }
        SpiceOutFormat formatVal = (SpiceOutFormat)((Object)this.spiceOutputFormatPopup.getSelectedItem());
        if (!Simulation.getSpiceOutputFormat().equals((Object)formatVal)) {
            Simulation.setSpiceOutputFormat(formatVal.name());
        }
        if (formatVal == SpiceOutFormat.Epic) {
            Simulation.setSpiceEpicReaderProcess(this.epicCheckBox.isSelected());
            Simulation.setSpiceEpicMemorySize(TextUtils.atoi(this.epicText.getText()));
        }
        stringNow = (String)this.spicePrimitivesetPopup.getSelectedItem();
        if (!Simulation.getSpicePartsLibrary().equals(stringNow)) {
            Simulation.setSpicePartsLibrary(stringNow);
        }
        boolean booleanNow = this.spiceUseNodeNames.isSelected();
        if (Simulation.isSpiceUseNodeNames() != booleanNow) {
            Simulation.setSpiceUseNodeNames(booleanNow);
        }
        booleanNow = this.spiceForceGlobalPwrGnd.isSelected();
        if (Simulation.isSpiceForceGlobalPwrGnd() != booleanNow) {
            Simulation.setSpiceForceGlobalPwrGnd(booleanNow);
        }
        booleanNow = this.spiceUseCellParameters.isSelected();
        if (Simulation.isSpiceUseCellParameters() != booleanNow) {
            Simulation.setSpiceUseCellParameters(booleanNow);
        }
        booleanNow = this.spiceWriteTransSizesInLambda.isSelected();
        if (Simulation.isSpiceWriteTransSizeInLambda() != booleanNow) {
            Simulation.setSpiceWriteTransSizeInLambda(booleanNow);
        }
        booleanNow = this.spiceWriteSubcktTopCell.isSelected();
        if (Simulation.isSpiceWriteSubcktTopCell() != booleanNow) {
            Simulation.setSpiceWriteSubcktTopCell(booleanNow);
        }
        booleanNow = this.spiceUseParasitics.isSelected();
        if (Simulation.isSpiceUseParasitics() != booleanNow) {
            Simulation.setSpiceUseParasitics(booleanNow);
        }
        stringNow = (String)this.spiceRunPopup.getSelectedItem();
        if (!Simulation.getSpiceRunChoice().equals(stringNow)) {
            Simulation.setSpiceRunChoice(stringNow);
        }
        stringNow = this.useDir.getText();
        if (!Simulation.getSpiceRunDir().equals(stringNow)) {
            Simulation.setSpiceRunDir(stringNow);
        }
        booleanNow = this.useDirCheckBox.isSelected();
        if (Simulation.getSpiceUseRunDir() != booleanNow) {
            Simulation.setSpiceUseRunDir(booleanNow);
        }
        booleanNow = this.overwriteOutputFile.isSelected();
        if (Simulation.getSpiceOutputOverwrite() != booleanNow) {
            Simulation.setSpiceOutputOverwrite(booleanNow);
        }
        booleanNow = this.spiceRunProbe.isSelected();
        if (Simulation.getSpiceRunProbe() != booleanNow) {
            Simulation.setSpiceRunProbe(booleanNow);
        }
        stringNow = this.spiceRunProgram.getText();
        if (!Simulation.getSpiceRunProgram().equals(stringNow)) {
            Simulation.setSpiceRunProgram(stringNow);
        }
        stringNow = this.spiceRunProgramArgs.getText();
        if (!Simulation.getSpiceRunProgramArgs().equals(stringNow)) {
            Simulation.setSpiceRunProgramArgs(stringNow);
        }
        String header = "";
        if (this.spiceHeaderCardsWithExtension.isSelected()) {
            header = "Extension " + this.spiceHeaderCardExtension.getText();
        } else if (this.spiceHeaderCardsFromFile.isSelected()) {
            header = this.spiceHeaderCardFile.getText();
        }
        if (!Simulation.getSpiceHeaderCardInfo().equals(header)) {
            Simulation.setSpiceHeaderCardInfo(header);
        }
        String trailer = "";
        if (this.spiceTrailerCardsWithExtension.isSelected()) {
            trailer = "Extension " + this.spiceTrailerCardExtension.getText();
        } else if (this.spiceTrailerCardsFromFile.isSelected()) {
            trailer = this.spiceTrailerCardFile.getText();
        }
        if (!Simulation.getSpiceTrailerCardInfo().equals(trailer)) {
            Simulation.setSpiceTrailerCardInfo(trailer);
        }
    }

    private void setSpiceRunOptionsEnabled(boolean enabled) {
        this.useDirCheckBox.setEnabled(enabled);
        this.overwriteOutputFile.setEnabled(enabled);
        this.spiceRunProgram.setEnabled(enabled);
        this.spiceRunProgramArgs.setEnabled(enabled);
        this.spiceRunHelp.setEnabled(enabled);
        this.spiceRunProbe.setEnabled(enabled);
        if (enabled) {
            this.spiceRunProgram.setBackground(Color.white);
            if (!this.useDirCheckBox.isSelected()) {
                this.useDir.setEnabled(false);
                this.useDir.setBackground(this.spice2.getBackground());
            } else {
                this.useDir.setEnabled(true);
                this.useDir.setBackground(Color.white);
            }
        } else {
            this.spiceRunProgram.setBackground(this.spice2.getBackground());
            this.useDir.setBackground(this.spice2.getBackground());
            this.useDir.setEnabled(false);
        }
    }

    private void initComponents() {
        this.spiceHeader = new ButtonGroup();
        this.spiceTrailer = new ButtonGroup();
        this.spiceModel = new ButtonGroup();
        this.spice = new JPanel();
        this.spice1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.spiceRunPopup = new JComboBox();
        this.spiceEnginePopup = new JComboBox();
        this.spiceLevelPopup = new JComboBox();
        this.spiceOutputFormatPopup = new JComboBox();
        this.spiceUseParasitics = new JCheckBox();
        this.spiceUseNodeNames = new JCheckBox();
        this.spiceForceGlobalPwrGnd = new JCheckBox();
        this.spiceUseCellParameters = new JCheckBox();
        this.spiceWriteTransSizesInLambda = new JCheckBox();
        this.spiceWriteSubcktTopCell = new JCheckBox();
        this.epicFrame = new JPanel();
        this.epicCheckBox = new JCheckBox();
        this.epicLabel = new JLabel();
        this.epicText = new JTextField();
        this.spice2 = new JPanel();
        this.spiceRunProgram = new JTextField();
        this.jLabel17 = new JLabel();
        this.useDirCheckBox = new JCheckBox();
        this.useDir = new JTextField();
        this.overwriteOutputFile = new JCheckBox();
        this.spiceRunHelp = new JButton();
        this.jLabel3 = new JLabel();
        this.spiceRunProgramArgs = new JTextField();
        this.spiceRunProbe = new JCheckBox();
        this.spice3 = new JPanel();
        this.jLabel13 = new JLabel();
        this.spicePrimitivesetPopup = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.spice5 = new JPanel();
        this.spiceHeaderCardExtension = new JTextField();
        this.spiceNoHeaderCards = new JRadioButton();
        this.spiceHeaderCardsWithExtension = new JRadioButton();
        this.spiceHeaderCardsFromFile = new JRadioButton();
        this.spiceNoTrailerCards = new JRadioButton();
        this.spiceTrailerCardsWithExtension = new JRadioButton();
        this.spiceTrailerCardsFromFile = new JRadioButton();
        this.spiceHeaderCardFile = new JTextField();
        this.spiceBrowseHeaderFile = new JButton();
        this.spiceTrailerCardExtension = new JTextField();
        this.spiceTrailerCardFile = new JTextField();
        this.spiceBrowseTrailerFile = new JButton();
        this.jSeparator4 = new JSeparator();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Spice Preferences");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SpiceTab.this.closeDialog(evt);
            }
        });
        this.spice.setLayout(new GridBagLayout());
        this.spice.setToolTipText("Options for Spice deck generation");
        this.spice1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Spice Engine:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.5;
        this.spice1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel9.setText("Spice Level:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setText("Output format:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.jLabel10, gridBagConstraints);
        this.spiceRunPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceRunPopupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.spice1.add((Component)this.spiceRunPopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.spice1.add((Component)this.spiceEnginePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.spice1.add((Component)this.spiceLevelPopup, gridBagConstraints);
        this.spiceOutputFormatPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceOutputFormatPopupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.spice1.add((Component)this.spiceOutputFormatPopup, gridBagConstraints);
        this.spiceUseParasitics.setText("Use Parasitics");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceUseParasitics, gridBagConstraints);
        this.spiceUseNodeNames.setText("Use Node Names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceUseNodeNames, gridBagConstraints);
        this.spiceForceGlobalPwrGnd.setText("Force Global VDD/GND");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceForceGlobalPwrGnd, gridBagConstraints);
        this.spiceUseCellParameters.setText("Use Cell Parameters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceUseCellParameters, gridBagConstraints);
        this.spiceWriteTransSizesInLambda.setText("Write Trans Sizes in Units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.spice1.add((Component)this.spiceWriteTransSizesInLambda, gridBagConstraints);
        this.spiceWriteSubcktTopCell.setText("Write Subckt For Top Cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.spice1.add((Component)this.spiceWriteSubcktTopCell, gridBagConstraints);
        this.epicFrame.setLayout(new GridBagLayout());
        this.epicFrame.setBorder(BorderFactory.createTitledBorder("Epic Format"));
        this.epicCheckBox.setText("Use External Reader JVM");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.epicFrame.add((Component)this.epicCheckBox, gridBagConstraints);
        this.epicLabel.setHorizontalAlignment(4);
        this.epicLabel.setText("Reader Memory Size: ");
        this.epicLabel.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.epicFrame.add((Component)this.epicLabel, gridBagConstraints);
        this.epicText.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        this.epicFrame.add((Component)this.epicText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        this.spice1.add((Component)this.epicFrame, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.spice1, gridBagConstraints);
        this.spice2.setLayout(new GridBagLayout());
        this.spice2.setBorder(BorderFactory.createEtchedBorder());
        this.spiceRunProgram.setColumns(8);
        this.spiceRunProgram.setMinimumSize(new Dimension(100, 20));
        this.spiceRunProgram.setPreferredSize(new Dimension(92, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.spice2.add((Component)this.spiceRunProgram, gridBagConstraints);
        this.jLabel17.setText("Run Program:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice2.add((Component)this.jLabel17, gridBagConstraints);
        this.useDirCheckBox.setText("Use Dir:");
        this.useDirCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.useDirCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.spice2.add((Component)this.useDirCheckBox, gridBagConstraints);
        this.useDir.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice2.add((Component)this.useDir, gridBagConstraints);
        this.overwriteOutputFile.setText("Overwrite existing output file (no prompts)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.spice2.add((Component)this.overwriteOutputFile, gridBagConstraints);
        this.spiceRunHelp.setText("help");
        this.spiceRunHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceRunHelpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.spice2.add((Component)this.spiceRunHelp, gridBagConstraints);
        this.jLabel3.setText("with args:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.spice2.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.spice2.add((Component)this.spiceRunProgramArgs, gridBagConstraints);
        this.spiceRunProbe.setText("Run probe");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.spice2.add((Component)this.spiceRunProbe, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.spice2, gridBagConstraints);
        this.spice3.setLayout(new GridBagLayout());
        this.jLabel13.setText("Spice primitive set:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.5;
        this.spice3.add((Component)this.jLabel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice3.add((Component)this.spicePrimitivesetPopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.spice3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.spice.add((Component)this.jSeparator1, gridBagConstraints);
        this.spice5.setLayout(new GridBagLayout());
        this.spiceHeaderCardExtension.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.spice5.add((Component)this.spiceHeaderCardExtension, gridBagConstraints);
        this.spiceHeader.add(this.spiceNoHeaderCards);
        this.spiceNoHeaderCards.setText("No Header Cards");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceNoHeaderCards, gridBagConstraints);
        this.spiceHeader.add(this.spiceHeaderCardsWithExtension);
        this.spiceHeaderCardsWithExtension.setText("Use Header Cards with extension:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceHeaderCardsWithExtension, gridBagConstraints);
        this.spiceHeader.add(this.spiceHeaderCardsFromFile);
        this.spiceHeaderCardsFromFile.setText("Use Header Cards from File:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceHeaderCardsFromFile, gridBagConstraints);
        this.spiceTrailer.add(this.spiceNoTrailerCards);
        this.spiceNoTrailerCards.setText("No Trailer Cards");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceNoTrailerCards, gridBagConstraints);
        this.spiceTrailer.add(this.spiceTrailerCardsWithExtension);
        this.spiceTrailerCardsWithExtension.setText("Use Trailer Cards with extension:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceTrailerCardsWithExtension, gridBagConstraints);
        this.spiceTrailer.add(this.spiceTrailerCardsFromFile);
        this.spiceTrailerCardsFromFile.setText("Use Trailer Cards from File:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.spice5.add((Component)this.spiceTrailerCardsFromFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.spice5.add((Component)this.spiceHeaderCardFile, gridBagConstraints);
        this.spiceBrowseHeaderFile.setText("Browse");
        this.spiceBrowseHeaderFile.setMinimumSize(new Dimension(78, 20));
        this.spiceBrowseHeaderFile.setPreferredSize(new Dimension(78, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice5.add((Component)this.spiceBrowseHeaderFile, gridBagConstraints);
        this.spiceTrailerCardExtension.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.spice5.add((Component)this.spiceTrailerCardExtension, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.spice5.add((Component)this.spiceTrailerCardFile, gridBagConstraints);
        this.spiceBrowseTrailerFile.setText("Browse");
        this.spiceBrowseTrailerFile.setMinimumSize(new Dimension(78, 20));
        this.spiceBrowseTrailerFile.setPreferredSize(new Dimension(78, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.spice5.add((Component)this.spiceBrowseTrailerFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.spice5.add((Component)this.jSeparator4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.spice5, gridBagConstraints);
        this.getContentPane().add((Component)this.spice, new GridBagConstraints());
        this.pack();
    }

    private void spiceOutputFormatPopupActionPerformed(ActionEvent evt) {
        this.epicFrame.setVisible(this.spiceOutputFormatPopup.getSelectedItem() == SpiceOutFormat.Epic);
    }

    private void spiceRunPopupActionPerformed(ActionEvent evt) {
        if (this.spiceRunPopup.getSelectedIndex() == 0) {
            this.setSpiceRunOptionsEnabled(false);
        } else {
            this.setSpiceRunOptionsEnabled(true);
        }
    }

    private void spiceRunHelpActionPerformed(ActionEvent evt) {
        String[] message = new String[]{"IMPORTANT: This executes a single program with the given args.  It does NOT run a command-line command.", "For example, 'echo blah > file' will NOT work. Encapsulate it in a script if you want to do such things.", "-----------------", "The following variables are available to use in the program name and arguments:", "   ${WORKING_DIR}:  The current working directory", "   ${USE_DIR}:  The Use Dir field, if specified (otherwise defaults to WORKING_DIR)", "   ${FILENAME}:  The output file name (with extension)", "   ${FILENAME_NO_EXT}:  The output file name (without extension)", "Example: Program: \"hspice\".  Args: \"${FILENAME}\""};
        JOptionPane.showMessageDialog(this, message, "Spice Run Help", 1);
    }

    private void useDirCheckBoxActionPerformed(ActionEvent evt) {
        boolean b = this.useDirCheckBox.isSelected();
        this.useDir.setEnabled(b);
        if (b) {
            this.useDir.setBackground(Color.white);
        } else {
            this.useDir.setBackground(this.spice2.getBackground());
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SpiceOutFormat {
        Standard,
        Raw,
        RawSmart,
        Epic;

    }
}

