/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MeasureListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    public static MeasureListener theOne = new MeasureListener();
    private static double lastMeasuredDistanceX = 0.0;
    private static double lastMeasuredDistanceY = 0.0;
    private static boolean measuring = false;
    private static List lastHighlights = new ArrayList();
    private Point2D dbStart;
    private static final boolean isMac = System.getProperty("os.name").toLowerCase().startsWith("mac");

    private MeasureListener() {
    }

    public static Dimension2D getLastMeasuredDistance() {
        Dimension2D.Double dim = new Dimension2D.Double(lastMeasuredDistanceX, lastMeasuredDistanceY);
        return dim;
    }

    public void reset() {
        if (measuring) {
            measuring = false;
        }
    }

    private void startMeasure(Point2D dbStart) {
        this.dbStart = dbStart;
        measuring = true;
        lastHighlights.clear();
    }

    private void dragOutMeasure(EditWindow wnd, Point2D dbPoint) {
        if (measuring && this.dbStart != null) {
            Point2D start = this.dbStart;
            Point2D end = dbPoint;
            Highlighter highlighter = wnd.getRulerHighlighter();
            Iterator it = lastHighlights.iterator();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                highlighter.remove(h);
            }
            lastHighlights.add(highlighter.addMessage(wnd.getCell(), "(" + TextUtils.formatDouble(start.getX()) + "," + TextUtils.formatDouble(start.getY()) + ")", start));
            lastHighlights.add(highlighter.addMessage(wnd.getCell(), "(" + TextUtils.formatDouble(end.getX()) + "," + TextUtils.formatDouble(end.getY()) + ")", end));
            lastHighlights.add(highlighter.addLine(start, end, wnd.getCell()));
            lastMeasuredDistanceX = Math.abs(start.getX() - end.getX());
            lastMeasuredDistanceY = Math.abs(start.getY() - end.getY());
            Point2D.Double center = new Point2D.Double((start.getX() + end.getX()) / 2.0, (start.getY() + end.getY()) / 2.0);
            double dist = start.distance(end);
            String show = TextUtils.formatDouble(dist) + " (dX=" + TextUtils.formatDouble(lastMeasuredDistanceX) + " dY=" + TextUtils.formatDouble(lastMeasuredDistanceY) + ")";
            lastHighlights.add(highlighter.addMessage(wnd.getCell(), show, center));
            highlighter.finished();
            wnd.clearDoingAreaDrag();
            wnd.repaint();
        }
    }

    private void finishMeasure(EditWindow wnd) {
        if (measuring) {
            Highlighter highlighter = wnd.getRulerHighlighter();
            Iterator it = lastHighlights.iterator();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                highlighter.remove(h);
            }
            highlighter.finished();
            lastHighlights.clear();
            wnd.repaint();
            measuring = false;
        } else {
            Highlighter highlighter = wnd.getRulerHighlighter();
            highlighter.clear();
            highlighter.finished();
            wnd.repaint();
        }
    }

    public void mousePressed(MouseEvent evt) {
        boolean ctrl;
        boolean bl = ctrl = (evt.getModifiersEx() & 0x80) != 0;
        if (evt.getSource() instanceof EditWindow) {
            int newX = evt.getX();
            int newY = evt.getY();
            EditWindow wnd = (EditWindow)evt.getSource();
            Point2D dbMouse = wnd.screenToDatabase(newX, newY);
            EditWindow.gridAlign(dbMouse);
            if (this.isLeftMouse(evt)) {
                if (measuring && ctrl && this.dbStart != null) {
                    dbMouse = MeasureListener.convertToOrthogonal(this.dbStart, dbMouse);
                }
                this.startMeasure(dbMouse);
            }
            if (MeasureListener.isRightMouse(evt)) {
                this.finishMeasure(wnd);
            }
        }
    }

    public void mouseDragged(MouseEvent evt) {
        boolean ctrl;
        boolean bl = ctrl = (evt.getModifiersEx() & 0x80) != 0;
        if (evt.getSource() instanceof EditWindow) {
            int newX = evt.getX();
            int newY = evt.getY();
            EditWindow wnd = (EditWindow)evt.getSource();
            Point2D dbMouse = wnd.screenToDatabase(newX, newY);
            if (ctrl && this.dbStart != null) {
                dbMouse = MeasureListener.convertToOrthogonal(this.dbStart, dbMouse);
            }
            EditWindow.gridAlign(dbMouse);
            this.dragOutMeasure(wnd, dbMouse);
        }
    }

    public void mouseMoved(MouseEvent evt) {
        this.mouseDragged(evt);
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        if (evt.getSource() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)evt.getSource();
            if (chr == 27) {
                this.finishMeasure(wnd);
            }
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    private boolean isLeftMouse(MouseEvent evt) {
        return isMac ? !evt.isMetaDown() && (evt.getModifiers() & 0x10) == 16 : (evt.getModifiers() & 0x10) == 16;
    }

    public static boolean isRightMouse(MouseEvent evt) {
        if (isMac) {
            if (evt.isMetaDown() && (evt.getModifiers() & 0x10) == 16) {
                return true;
            }
            if ((evt.getModifiers() & 4) == 4) {
                return true;
            }
        } else if ((evt.getModifiers() & 4) == 4) {
            return true;
        }
        return false;
    }

    public static Point2D convertToOrthogonal(Point2D startPoint, Point2D mousePoint) {
        double xdist = Math.abs(mousePoint.getX() - startPoint.getX());
        double ydist = Math.abs(mousePoint.getY() - startPoint.getY());
        if (ydist > xdist) {
            return new Point2D.Double(startPoint.getX(), mousePoint.getY());
        }
        return new Point2D.Double(mousePoint.getX(), startPoint.getY());
    }
}

