/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import java.util.List;

public class ArcInfo
extends Info {
    String name;
    String javaName;
    ArcProto.Function func = ArcProto.Function.UNKNOWN;
    boolean fixAng;
    boolean wipes;
    boolean noExtend;
    int angInc;
    double antennaRatio;
    ArcProto generated;
    LayerDetails[] arcDetails;
    double widthOffset;
    double maxWidth;
    private static Info.SpecialTextDescr[] arcTextTable = new Info.SpecialTextDescr[]{new Info.SpecialTextDescr(0.0, 18.0, 9), new Info.SpecialTextDescr(0.0, 15.0, 11), new Info.SpecialTextDescr(0.0, 12.0, 12), new Info.SpecialTextDescr(0.0, 9.0, 13), new Info.SpecialTextDescr(0.0, 6.0, 23), new Info.SpecialTextDescr(0.0, 3.0, 40)};

    ArcInfo() {
    }

    public static Cell[] getArcCells(Library lib) {
        Library[] oneLib = new Library[]{lib};
        return ArcInfo.findCellSequence(oneLib, "arc-", ARCSEQUENCE_KEY);
    }

    void generate(Cell np) {
        ArcInfo.loadTableEntry(arcTextTable, 9, this.func);
        ArcInfo.loadTableEntry(arcTextTable, 11, new Boolean(this.fixAng));
        ArcInfo.loadTableEntry(arcTextTable, 12, new Boolean(this.wipes));
        ArcInfo.loadTableEntry(arcTextTable, 13, new Boolean(this.noExtend));
        ArcInfo.loadTableEntry(arcTextTable, 23, new Integer(this.angInc));
        ArcInfo.loadTableEntry(arcTextTable, 40, new Double(this.antennaRatio));
        ArcInfo.createSpecialText(np, arcTextTable);
    }

    static ArcInfo parseCell(Cell np) {
        ArcInfo aIn = new ArcInfo();
        aIn.name = np.getName().substring(4);
        Iterator it = np.getNodes();
        block8: while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            Variable var = ni.getVar(OPTION_KEY);
            if (var == null) continue;
            String str = ArcInfo.getValueOnNode(ni);
            block0 : switch ((Integer)var.getObject()) {
                case 9: {
                    aIn.func = ArcProto.Function.UNKNOWN;
                    List allFuncs = ArcProto.Function.getFunctions();
                    Iterator fIt = allFuncs.iterator();
                    while (fIt.hasNext()) {
                        ArcProto.Function fun = (ArcProto.Function)fIt.next();
                        if (!fun.toString().equalsIgnoreCase(str)) continue;
                        aIn.func = fun;
                        break block0;
                    }
                    continue block8;
                }
                case 23: {
                    aIn.angInc = TextUtils.atoi(str);
                    break;
                }
                case 11: {
                    aIn.fixAng = str.equalsIgnoreCase("yes");
                    break;
                }
                case 12: {
                    aIn.wipes = str.equalsIgnoreCase("yes");
                    break;
                }
                case 13: {
                    aIn.noExtend = str.equalsIgnoreCase("no");
                    break;
                }
                case 40: {
                    aIn.antennaRatio = TextUtils.atof(str);
                }
            }
        }
        return aIn;
    }

    static void compactCell(Cell cell) {
        RectangularShape nonSpecBounds = null;
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() == Generic.tech.cellCenterNode) continue;
            boolean special = false;
            for (int i = 0; i < arcTextTable.length; ++i) {
                if (ArcInfo.arcTextTable[i].ni != ni) continue;
                special = true;
            }
            if (special) continue;
            Rectangle2D bounds = ni.getBounds();
            if (nonSpecBounds == null) {
                nonSpecBounds = bounds;
                continue;
            }
            Rectangle2D.union((Rectangle2D)nonSpecBounds, bounds, (Rectangle2D)nonSpecBounds);
        }
        if (nonSpecBounds != null) {
            double xOff = -nonSpecBounds.getCenterX();
            double yOff = -nonSpecBounds.getMaxY();
            if (xOff != 0.0 || yOff != 0.0) {
                Iterator it2 = cell.getNodes();
                while (it2.hasNext()) {
                    NodeInst ni = (NodeInst)it2.next();
                    if (ni.getProto() == Generic.tech.cellCenterNode) continue;
                    boolean special = false;
                    for (int i = 0; i < arcTextTable.length; ++i) {
                        if (ArcInfo.arcTextTable[i].ni != ni) continue;
                        special = true;
                    }
                    if (special) continue;
                    ni.move(xOff, yOff);
                }
            }
        }
    }

    static class LayerDetails {
        LayerInfo layer;
        double width;
        Poly.Type style;

        LayerDetails() {
        }
    }
}

