/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewNodesTab
extends PreferencePanel {
    private HashMap initialNewNodesPrimInfo;
    private boolean newNodesDataChanging = false;
    private Technology selectedTech;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel newNode;
    private JCheckBox nodeCheckCellDates;
    private JCheckBox nodeDisallowModificationComplexNodes;
    private JCheckBox nodeDisallowModificationLockedPrims;
    private JCheckBox nodeDupArrayCopyExports;
    private JCheckBox nodeExtractCopyExports;
    private JCheckBox nodeMoveAfterDuplicate;
    private JCheckBox nodePlaceCellCenter;
    private JComboBox nodePrimitive;
    private JTextField nodePrimitiveXSize;
    private JTextField nodePrimitiveYSize;
    private JCheckBox nodeSwitchTechnology;
    private JCheckBox reconstructArcs;
    private JComboBox technologySelection;

    public NewNodesTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.newNode;
    }

    public String getName() {
        return "Nodes";
    }

    public void init() {
        this.initialNewNodesPrimInfo = new HashMap();
        Iterator tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = (Technology)tIt.next();
            this.technologySelection.addItem(tech.getTechName());
            Iterator it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)it.next();
                PrimNodeInfo pni = new PrimNodeInfo();
                SizeOffset so = np.getProtoSizeOffset();
                pni.initialWid = pni.wid = np.getDefWidth() - so.getLowXOffset() - so.getHighXOffset();
                pni.initialHei = pni.hei = np.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
                this.initialNewNodesPrimInfo.put(np, pni);
            }
        }
        this.technologySelection.setSelectedItem(Technology.getCurrent().getTechName());
        this.selectedTech = null;
        this.newNodesPrimPopupChanged();
        this.nodeCheckCellDates.setSelected(User.isCheckCellDates());
        this.nodeSwitchTechnology.setSelected(User.isAutoTechnologySwitch());
        this.nodePlaceCellCenter.setSelected(User.isPlaceCellCenter());
        this.reconstructArcs.setSelected(User.isReconstructArcsToDeletedCells());
        this.nodeDisallowModificationComplexNodes.setSelected(User.isDisallowModificationComplexNodes());
        this.nodeDisallowModificationLockedPrims.setSelected(User.isDisallowModificationLockedPrims());
        this.nodeMoveAfterDuplicate.setSelected(User.isMoveAfterDuplicate());
        this.nodeDupArrayCopyExports.setSelected(User.isDupCopiesExports());
        this.nodeExtractCopyExports.setSelected(User.isExtractCopiesExports());
        this.technologySelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewNodesTab.this.newNodesPrimPopupChanged();
            }
        });
        this.nodePrimitive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewNodesTab.this.newNodesPrimPopupChanged();
            }
        });
        this.nodePrimitiveXSize.getDocument().addDocumentListener(new NewNodeDocumentListener(this));
        this.nodePrimitiveYSize.getDocument().addDocumentListener(new NewNodeDocumentListener(this));
    }

    private void newNodesPrimPopupChanged() {
        String primName;
        PrimNodeInfo pni;
        PrimitiveNode np;
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        if (tech != this.selectedTech) {
            this.selectedTech = tech;
            this.nodePrimitive.removeAllItems();
            Iterator it = tech.getNodes();
            while (it.hasNext()) {
                np = (PrimitiveNode)it.next();
                this.nodePrimitive.addItem(np.getName());
            }
        }
        if ((pni = (PrimNodeInfo)this.initialNewNodesPrimInfo.get(np = tech.findNodeProto(primName = (String)this.nodePrimitive.getSelectedItem()))) == null) {
            return;
        }
        this.newNodesDataChanging = true;
        this.nodePrimitiveXSize.setText(TextUtils.formatDouble(pni.wid));
        this.nodePrimitiveYSize.setText(TextUtils.formatDouble(pni.hei));
        this.newNodesDataChanging = false;
    }

    private void newNodesPrimDataChanged() {
        if (this.newNodesDataChanging) {
            return;
        }
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        String primName = (String)this.nodePrimitive.getSelectedItem();
        PrimitiveNode np = tech.findNodeProto(primName);
        PrimNodeInfo pni = (PrimNodeInfo)this.initialNewNodesPrimInfo.get(np);
        if (pni == null) {
            return;
        }
        pni.wid = TextUtils.atof(this.nodePrimitiveXSize.getText());
        pni.hei = TextUtils.atof(this.nodePrimitiveYSize.getText());
    }

    public void term() {
        Iterator tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = (Technology)tIt.next();
            Iterator it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)it.next();
                PrimNodeInfo pni = (PrimNodeInfo)this.initialNewNodesPrimInfo.get(np);
                if (pni.wid == pni.initialWid && pni.hei == pni.initialHei) continue;
                SizeOffset so = np.getProtoSizeOffset();
                pni.wid += so.getLowXOffset() + so.getHighXOffset();
                pni.hei += so.getLowYOffset() + so.getHighYOffset();
                np.setDefSize(pni.wid, pni.hei);
            }
        }
        boolean currBoolean = this.nodeCheckCellDates.isSelected();
        if (currBoolean != User.isCheckCellDates()) {
            User.setCheckCellDates(currBoolean);
        }
        if ((currBoolean = this.nodeSwitchTechnology.isSelected()) != User.isAutoTechnologySwitch()) {
            User.setAutoTechnologySwitch(currBoolean);
        }
        if ((currBoolean = this.nodePlaceCellCenter.isSelected()) != User.isPlaceCellCenter()) {
            User.setPlaceCellCenter(currBoolean);
        }
        if ((currBoolean = this.reconstructArcs.isSelected()) != User.isReconstructArcsToDeletedCells()) {
            User.setReconstructArcsToDeletedCells(currBoolean);
        }
        if ((currBoolean = this.nodeDisallowModificationComplexNodes.isSelected()) != User.isDisallowModificationComplexNodes()) {
            User.setDisallowModificationComplexNodes(currBoolean);
        }
        if ((currBoolean = this.nodeDisallowModificationLockedPrims.isSelected()) != User.isDisallowModificationLockedPrims()) {
            User.setDisallowModificationLockedPrims(currBoolean);
        }
        if ((currBoolean = this.nodeMoveAfterDuplicate.isSelected()) != User.isMoveAfterDuplicate()) {
            User.setMoveAfterDuplicate(currBoolean);
        }
        if ((currBoolean = this.nodeDupArrayCopyExports.isSelected()) != User.isDupCopiesExports()) {
            User.setDupCopiesExports(currBoolean);
        }
        if ((currBoolean = this.nodeExtractCopyExports.isSelected()) != User.isExtractCopiesExports()) {
            User.setExtractCopiesExports(currBoolean);
        }
    }

    private void initComponents() {
        this.newNode = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.nodePrimitive = new JComboBox();
        this.nodePrimitiveXSize = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.nodePrimitiveYSize = new JTextField();
        this.technologySelection = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jPanel3 = new JPanel();
        this.nodeCheckCellDates = new JCheckBox();
        this.nodeSwitchTechnology = new JCheckBox();
        this.nodePlaceCellCenter = new JCheckBox();
        this.reconstructArcs = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.nodeDisallowModificationLockedPrims = new JCheckBox();
        this.nodeMoveAfterDuplicate = new JCheckBox();
        this.nodeDupArrayCopyExports = new JCheckBox();
        this.nodeExtractCopyExports = new JCheckBox();
        this.nodeDisallowModificationComplexNodes = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NewNodesTab.this.closeDialog(evt);
            }
        });
        this.newNode.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new TitledBorder("For New Primitive Nodes"));
        this.jLabel1.setText("Primitive:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.nodePrimitive, gridBagConstraints);
        this.nodePrimitiveXSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.nodePrimitiveXSize, gridBagConstraints);
        this.jLabel2.setText("Default X size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Default Y size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.nodePrimitiveYSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.nodePrimitiveYSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.technologySelection, gridBagConstraints);
        this.jLabel4.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.newNode.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(new TitledBorder("For Cells"));
        this.nodeCheckCellDates.setText("Check cell dates during editing");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel3.add((Component)this.nodeCheckCellDates, gridBagConstraints);
        this.nodeSwitchTechnology.setText("Switch technology to match current cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel3.add((Component)this.nodeSwitchTechnology, gridBagConstraints);
        this.nodePlaceCellCenter.setText("Place Cell-Center in new cells");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel3.add((Component)this.nodePlaceCellCenter, gridBagConstraints);
        this.reconstructArcs.setText("Reconstruct arcs when deleting instances");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel3.add((Component)this.reconstructArcs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.newNode.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(new TitledBorder("For All Nodes"));
        this.nodeDisallowModificationLockedPrims.setText("Disallow modification of locked primitives");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel4.add((Component)this.nodeDisallowModificationLockedPrims, gridBagConstraints);
        this.nodeMoveAfterDuplicate.setText("Move after Duplicate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel4.add((Component)this.nodeMoveAfterDuplicate, gridBagConstraints);
        this.nodeDupArrayCopyExports.setText("Duplicate/Array/Paste copies exports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel4.add((Component)this.nodeDupArrayCopyExports, gridBagConstraints);
        this.nodeExtractCopyExports.setText("Extract copies exports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel4.add((Component)this.nodeExtractCopyExports, gridBagConstraints);
        this.nodeDisallowModificationComplexNodes.setText("Disallow modification of complex nodes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanel4.add((Component)this.nodeDisallowModificationComplexNodes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.newNode.add((Component)this.jPanel4, gridBagConstraints);
        this.getContentPane().add((Component)this.newNode, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class NewNodeDocumentListener
    implements DocumentListener {
        NewNodesTab dialog;

        NewNodeDocumentListener(NewNodesTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.newNodesPrimDataChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.newNodesPrimDataChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.newNodesPrimDataChanged();
        }
    }

    private static class PrimNodeInfo {
        double initialWid;
        double wid;
        double initialHei;
        double hei;
        Variable var;

        private PrimNodeInfo() {
        }
    }
}

