/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.basic;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.basic.NccUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class NccCellAnnotations {
    private String cellThatOwnsMe;
    private List annotText = new ArrayList();
    private List exportsConnByParent = new ArrayList();
    private String skipReason;
    private String notSubcircuitReason;
    private Cell.CellGroup groupToJoin;
    private List flattenInstances = new ArrayList();
    private List exportsToRename = new ArrayList();
    private String blackBoxReason;
    private String transistorType;
    private String resistorType;

    private void processExportsConnAnnot(NamePatternLexer lex) {
        ArrayList<NamePattern> connected = new ArrayList<NamePattern>();
        NamePattern np = lex.nextPattern();
        while (np != null) {
            connected.add(np);
            np = lex.nextPattern();
        }
        if (connected.size() > 0) {
            this.exportsConnByParent.add(connected);
        }
    }

    private void processSkipAnnotation(NamePatternLexer lex) {
        this.skipReason = lex.restOfLine();
    }

    private void processNotSubcircuitAnnotation(NamePatternLexer lex) {
        this.notSubcircuitReason = lex.restOfLine();
    }

    private void prErr(String s) {
        String currAnnot = (String)this.annotText.get(this.annotText.size() - 1);
        System.out.println("  " + s + "  cell= " + this.cellThatOwnsMe + " annotation= " + currAnnot);
    }

    private void processJoinGroupAnnotation(String note) {
        StringTokenizer lex = new StringTokenizer(note);
        lex.nextToken();
        if (!lex.hasMoreTokens()) {
            this.prErr("joinGroup lacks Library:Cell argument.");
            return;
        }
        String libCell = lex.nextToken();
        int colon = libCell.indexOf(58);
        if (colon == -1) {
            this.prErr("Group specification must be of form Library:Cell{view}.");
            return;
        }
        String libName = libCell.substring(0, colon);
        String cellName = libCell.substring(colon + 1);
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            this.prErr("Can't find library: " + libName + ".");
            return;
        }
        Cell cell = lib.findNodeProto(cellName);
        if (cell == null) {
            this.prErr("Can't find Cell " + cellName + ".");
            return;
        }
        this.groupToJoin = cell.getCellGroup();
        LayoutLib.error(this.groupToJoin == null, "null cell group?");
    }

    private void processFlattenInstancesAnnotation(NamePatternLexer lex) {
        NamePattern np = lex.nextPattern();
        while (np != null) {
            this.flattenInstances.add(np);
            np = lex.nextPattern();
        }
    }

    private void processExportsToRenameAnnotation(NamePatternLexer lex) {
        NamePattern np = lex.nextPattern();
        while (np != null) {
            this.exportsToRename.add(np);
            np = lex.nextPattern();
        }
    }

    private void processBlackBox(NamePatternLexer lex) {
        this.blackBoxReason = lex.restOfLine();
    }

    private void processTransistorType(NamePatternLexer lex) {
        NamePattern type = lex.nextPattern();
        if (type == null) {
            this.prErr("Bad transistorType annotation: missing type");
            return;
        }
        NamePattern type2 = lex.nextPattern();
        if (type2 != null) {
            this.prErr("Bad transistorType annotation: only one type allowed");
            return;
        }
        if (this.transistorType != null) {
            this.prErr("only one transistorType annotation allowed per Cell");
            return;
        }
        this.transistorType = type.getName();
        if (this.transistorType == null) {
            this.prErr("Transistor type may not be a regular expression");
            return;
        }
    }

    private void processResistorType(NamePatternLexer lex) {
        NamePattern type = lex.nextPattern();
        if (type == null) {
            this.prErr("Bad resistorType annotation: missing type");
            return;
        }
        NamePattern type2 = lex.nextPattern();
        if (type2 != null) {
            this.prErr("Bad resistorType annotation: only one type allowed");
            return;
        }
        if (this.resistorType != null) {
            this.prErr("only one resistorType annotation allowed per Cell");
            return;
        }
        this.resistorType = type.getName();
        if (this.resistorType == null) {
            this.prErr("resistor type may not be a regular expression");
            return;
        }
    }

    private void doAnnotation(String note) {
        this.annotText.add(note);
        NamePatternLexer lex = new NamePatternLexer(note);
        NamePattern key = lex.nextPattern();
        if (key != null) {
            if (key.stringEquals("exportsConnectedByParent")) {
                this.processExportsConnAnnot(lex);
            } else if (key.stringEquals("skipNCC")) {
                this.processSkipAnnotation(lex);
            } else if (key.stringEquals("notSubcircuit")) {
                this.processNotSubcircuitAnnotation(lex);
            } else if (key.stringEquals("joinGroup")) {
                this.processJoinGroupAnnotation(note);
            } else if (key.stringEquals("flattenInstances")) {
                this.processFlattenInstancesAnnotation(lex);
            } else if (key.stringEquals("exportsToRename")) {
                this.processExportsToRenameAnnotation(lex);
            } else if (key.stringEquals("blackBox")) {
                this.processBlackBox(lex);
            } else if (key.stringEquals("transistorType")) {
                this.processTransistorType(lex);
            } else if (key.stringEquals("resistorType")) {
                this.processResistorType(lex);
            } else {
                this.prErr("Unrecognized NCC annotation.");
            }
        }
    }

    private NccCellAnnotations(Cell cell, Object annotation) {
        this.cellThatOwnsMe = NccUtils.fullName(cell);
        if (annotation instanceof String) {
            this.doAnnotation((String)annotation);
        } else if (annotation instanceof String[]) {
            String[] ss = (String[])annotation;
            for (int i = 0; i < ss.length; ++i) {
                this.doAnnotation(ss[i]);
            }
        } else {
            this.prErr(" ignoring bad NCC annotation: ");
        }
    }

    public static NccCellAnnotations getAnnotations(Cell cell) {
        Variable nccVar = cell.getVar("ATTR_NCC");
        if (nccVar == null) {
            return null;
        }
        Object annotation = nccVar.getObject();
        return new NccCellAnnotations(cell, annotation);
    }

    public String getSkipReason() {
        return this.skipReason;
    }

    public String getNotSubcircuitReason() {
        return this.notSubcircuitReason;
    }

    public Iterator getExportsConnected() {
        return this.exportsConnByParent.iterator();
    }

    public Iterator getAnnotationText() {
        return this.annotText.iterator();
    }

    public Cell.CellGroup getGroupToJoin() {
        return this.groupToJoin;
    }

    public boolean flattenInstance(String instName) {
        Iterator it = this.flattenInstances.iterator();
        while (it.hasNext()) {
            NamePattern pattern = (NamePattern)it.next();
            if (!pattern.matches(instName)) continue;
            return true;
        }
        return false;
    }

    public boolean renameExport(String exportName) {
        Iterator it = this.exportsToRename.iterator();
        while (it.hasNext()) {
            NamePattern pattern = (NamePattern)it.next();
            if (!pattern.matches(exportName)) continue;
            return true;
        }
        return false;
    }

    public String getBlackBoxReason() {
        return this.blackBoxReason;
    }

    public String getTransistorType() {
        return this.transistorType;
    }

    public String getResistorType() {
        return this.resistorType;
    }

    private class NamePatternLexer {
        private final String s;
        private int pos = 0;

        private int findWhite() {
            while (this.pos < this.s.length()) {
                if (Character.isWhitespace(this.s.charAt(this.pos))) {
                    return this.pos;
                }
                ++this.pos;
            }
            return -1;
        }

        private int findNonWhite() {
            while (this.pos < this.s.length()) {
                if (!Character.isWhitespace(this.s.charAt(this.pos))) {
                    return this.pos;
                }
                ++this.pos;
            }
            return -1;
        }

        private int findSlash() {
            while (this.pos < this.s.length()) {
                if (this.s.charAt(this.pos) == '/') {
                    return this.pos;
                }
                ++this.pos;
            }
            return -1;
        }

        public NamePatternLexer(String annot) {
            this.s = annot;
        }

        public NamePattern nextPattern() {
            int startTok = this.findNonWhite();
            if (startTok == -1) {
                return null;
            }
            if (this.s.charAt(startTok) == '/') {
                ++this.pos;
                startTok = this.pos++;
                int endTok = this.findSlash();
                if (endTok == -1) {
                    NccCellAnnotations.this.prErr("Regular Expression has no trailing '/': " + this.s.substring(startTok - 1) + ".");
                    endTok = this.s.length();
                }
                String pat = this.s.substring(startTok, endTok);
                return new NamePattern(true, pat);
            }
            int endTok = this.findWhite();
            if (endTok == -1) {
                endTok = this.s.length();
            }
            return new NamePattern(false, this.s.substring(startTok, endTok));
        }

        public String restOfLine() {
            return this.s.substring(this.pos);
        }
    }

    public static class NamePattern {
        private final boolean isRegExp;
        private final String pattern;

        NamePattern(boolean isRegEx, String pat) {
            this.isRegExp = isRegEx;
            this.pattern = pat;
        }

        public boolean matches(String name) {
            return this.isRegExp ? name.matches(this.pattern) : name.equals(this.pattern);
        }

        public boolean stringEquals(String name) {
            return name.equals(this.pattern);
        }

        public String getName() {
            return this.isRegExp ? null : this.pattern;
        }
    }
}

