/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Stimuli;
import java.io.IOException;
import java.net.URL;

public class RawSpiceOut
extends Simulate {
    RawSpiceOut() {
    }

    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        if (this.openTextInput(fileURL)) {
            return null;
        }
        RawSpiceOut.startProgressDialog("Raw Spice output", fileURL.getFile());
        Stimuli sd = this.readRawFile(cell);
        RawSpiceOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private Stimuli readRawFile(Cell cell) throws IOException {
        String line;
        boolean first = true;
        int numSignals = -1;
        int eventCount = -1;
        Stimuli sd = new Stimuli();
        sd.setCell(cell);
        AnalogSignal[] signals = null;
        while ((line = this.getLineFromSimulator()) != null) {
            int i;
            int j;
            int i2;
            int colonPos;
            if (first) {
                String hsFormat;
                first = false;
                if (line.length() >= 20 && ((hsFormat = line.substring(16, 20)).equals("9007") || hsFormat.equals("9601"))) {
                    System.out.println("This is an HSPICE file, not a RAWFILE file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return null;
                }
            }
            if ((colonPos = line.indexOf(":")) < 0) continue;
            String preColon = line.substring(0, colonPos);
            String postColon = line.substring(colonPos + 1).trim();
            if (preColon.equals("No. Variables")) {
                numSignals = TextUtils.atoi(postColon) - 1;
                signals = new AnalogSignal[numSignals];
                for (i2 = 0; i2 < numSignals; ++i2) {
                    signals[i2] = new AnalogSignal(sd);
                }
                continue;
            }
            if (preColon.equals("No. Points")) {
                eventCount = TextUtils.atoi(postColon);
                sd.buildCommonTime(eventCount);
                for (i2 = 0; i2 < numSignals; ++i2) {
                    signals[i2].buildValues(eventCount);
                }
                continue;
            }
            if (preColon.equals("Variables")) {
                if (numSignals < 0) {
                    System.out.println("Missing variable count in file");
                    return null;
                }
                for (i2 = 0; i2 <= numSignals; ++i2) {
                    int pos;
                    String name;
                    int tabPos;
                    int spacePos;
                    line = this.getLineFromSimulator();
                    if (line == null) {
                        System.out.println("Error: end of file during signal names");
                        return null;
                    }
                    int numberOnLine = TextUtils.atoi(line = line.trim());
                    if (numberOnLine != i2) {
                        System.out.println("Warning: Variable " + i2 + " has number " + numberOnLine);
                    }
                    if ((spacePos = line.indexOf(" ")) < 0) {
                        spacePos = line.length();
                    }
                    if ((tabPos = line.indexOf("\t")) < 0) {
                        tabPos = line.length();
                    }
                    if ((spacePos = (name = line.substring(pos = Math.min(spacePos, tabPos)).trim()).indexOf(" ")) < 0) {
                        spacePos = line.length();
                    }
                    if ((tabPos = name.indexOf("\t")) < 0) {
                        tabPos = line.length();
                    }
                    pos = Math.min(spacePos, tabPos);
                    name = name.substring(0, pos);
                    if (i2 == 0) {
                        if (name.equals("time")) continue;
                        System.out.println("Warning: the first variable should be time, is '" + name + "'");
                        continue;
                    }
                    signals[i2 - 1].setSignalName(name);
                }
                continue;
            }
            if (preColon.equals("Values")) {
                if (numSignals < 0) {
                    System.out.println("Missing variable count in file");
                    return null;
                }
                if (eventCount < 0) {
                    System.out.println("Missing point count in file");
                    return null;
                }
                for (j = 0; j < eventCount; ++j) {
                    for (i = 0; i <= numSignals; ++i) {
                        do {
                            if ((line = this.getLineFromSimulator()) != null) continue;
                            System.out.println("Error: end of file during data points (read " + j + " out of " + eventCount);
                            return null;
                        } while (line.length() == 0);
                        if (i == 0) {
                            int lineNumber = TextUtils.atoi(line);
                            if (lineNumber != j) {
                                System.out.println("Warning: event " + j + " has wrong event number: " + lineNumber);
                            }
                            while (TextUtils.isDigit(line.charAt(0))) {
                                line = line.substring(1);
                            }
                        }
                        line = line.trim();
                        if (i == 0) {
                            sd.setCommonTime(j, TextUtils.atof(line));
                            continue;
                        }
                        signals[i - 1].setValue(j, TextUtils.atof(line));
                    }
                }
            }
            if (!preColon.equals("Binary")) continue;
            if (numSignals < 0) {
                System.out.println("Missing variable count in file");
                return null;
            }
            if (eventCount < 0) {
                System.out.println("Missing point count in file");
                return null;
            }
            for (j = 0; j < eventCount; ++j) {
                sd.setCommonTime(j, this.dataInputStream.readDouble());
                for (i = 0; i < numSignals; ++i) {
                    signals[i].setValue(j, this.dataInputStream.readDouble());
                }
            }
        }
        return sd;
    }
}

