/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;

public class TieHi {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;

    public static Cell makePart(StdCellParams stdCell) {
        String nm = stdCell.parameterizedName("tieHi") + "{lay}";
        Cell tieHi = stdCell.findPart(nm);
        if (tieHi != null) {
            return tieHi;
        }
        tieHi = stdCell.newPart(nm);
        double pwrX = 3.5;
        double pwrY = stdCell.getVddY();
        String vddName = stdCell.getVddExportName();
        PortCharacteristic vddRole = stdCell.getVddExportRole();
        LayoutLib.newExport(tieHi, vddName, vddRole, Tech.m2, 4.0, pwrX, pwrY);
        LayoutLib.newExport(tieHi, "pwr", PortCharacteristic.OUT, Tech.m1, 4.0, pwrX, pwrY);
        PortInst via = LayoutLib.newNodeInst(Tech.m1m2, pwrX, pwrY, 4.0, stdCell.getVddWidth(), 0.0, tieHi).getOnlyPortInst();
        LayoutLib.newArcInst(Tech.m2, Double.POSITIVE_INFINITY, tieHi.findExport(vddName).getOriginalPort(), via);
        LayoutLib.newArcInst(Tech.m1, Double.POSITIVE_INFINITY, tieHi.findExport("pwr").getOriginalPort(), via);
        double wellMinX = pwrX - 6.0;
        double wellMaxX = pwrX + 6.0;
        stdCell.addNmosWell(wellMinX, wellMaxX, tieHi);
        stdCell.addPmosWell(wellMinX, wellMaxX, tieHi);
        double cellMaxX = pwrX + 2.0 + 1.5;
        stdCell.addEssentialBounds(0.0, cellMaxX, tieHi);
        return tieHi;
    }
}

