/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.Layer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class DRCTemplate {
    public static final int NONE = -1;
    public static final int ALL = 0;
    public static final int M2 = 1;
    public static final int M3 = 2;
    public static final int M4 = 4;
    public static final int M5 = 8;
    public static final int M6 = 16;
    public static final int M23 = 3;
    public static final int M456 = 28;
    public static final int M56 = 24;
    public static final int AC = 32;
    public static final int NAC = 64;
    public static final int SV = 128;
    public static final int NSV = 256;
    public static final int DE = 512;
    public static final int SU = 1024;
    public static final int SC = 2048;
    public static final int TSMC = 4096;
    public static final int ST = 8192;
    public static final int MOSIS = 16384;
    public static final int MINWID = 1;
    public static final int NODSIZ = 2;
    public static final int SURROUND = 3;
    public static final int VIASUR = 4;
    public static final int TRAWELL = 5;
    public static final int TRAPOLY = 6;
    public static final int TRAACTIVE = 7;
    public static final int SPACING = 8;
    public static final int SPACINGM = 9;
    public static final int SPACINGW = 10;
    public static final int SPACINGE = 11;
    public static final int CONSPA = 12;
    public static final int UCONSPA = 13;
    public static final int CUTSPA = 14;
    public static final int CUTSPA2D = 15;
    public static final int CUTSIZE = 16;
    public static final int CUTSUR = 17;
    public static final int CUTSURX = 18;
    public static final int CUTSURY = 19;
    public static final int ASURROUND = 20;
    public static final int AREA = 21;
    public static final int ENCLOSEDAREA = 22;
    public static final int EXTENSION = 23;
    public static final int FORBIDDEN = 24;
    public static final int COMBINATION = 25;
    public static final int EXTENSIONGATE = 26;
    public static final int SLOTSIZE = 26;
    public static final DRCTemplateSort templateSort = new DRCTemplateSort();
    public String ruleName;
    public int when;
    public int ruleType;
    public String name1;
    public String name2;
    public double value1;
    public double value2;
    public double maxWidth;
    public double minLength;
    public String nodeName;
    public int multiCuts;

    public DRCTemplate(String rule, int when, int ruleType, String name1, String name2, double distance, String nodeName) {
        this.ruleName = rule;
        this.when = when;
        this.ruleType = ruleType;
        this.name1 = name1;
        this.name2 = name2;
        this.value1 = distance;
        this.nodeName = nodeName;
        switch (ruleType) {
            case 8: {
                if (name1 != null && name2 != null) break;
                System.out.println("Error: missing one layer in no '" + rule + "' ");
                break;
            }
        }
    }

    public DRCTemplate(String rule, int when, int ruleType, double maxW, double minLen, double distance, int multiCut) {
        this.ruleName = rule;
        this.when = when;
        this.ruleType = ruleType;
        this.value1 = distance;
        this.maxWidth = maxW;
        this.minLength = minLen;
        this.multiCuts = multiCut;
    }

    public DRCTemplate(String rule, int when, int ruleType, double maxW, double minLen, String name1, String name2, double distance, int multiCut) {
        this.ruleName = rule;
        this.when = when;
        this.ruleType = ruleType;
        this.name1 = name1;
        this.name2 = name2;
        this.value1 = distance;
        this.maxWidth = maxW;
        this.minLength = minLen;
        this.multiCuts = multiCut;
        switch (ruleType) {
            case 8: {
                if (name1 != null && name2 != null) break;
                System.out.println("Error: missing one layer in no '" + rule + "' ");
                break;
            }
        }
    }

    public static List makeRuleTemplates(String name, int when, int type, double maxW, double minLen, double value, String[] arrayL) {
        int length = arrayL.length;
        ArrayList<DRCTemplate> list = new ArrayList<DRCTemplate>(length);
        for (int i = 0; i < length; ++i) {
            String layer = arrayL[i];
            DRCTemplate r = new DRCTemplate(name, when, type, maxW, minLen, layer, null, value, -1);
            list.add(r);
        }
        return list;
    }

    public static List makeRuleTemplates(String[] names, int[] when, int type, double value, String[][] matrix) {
        ArrayList<DRCTemplate> list = new ArrayList<DRCTemplate>(names.length * matrix.length);
        for (int i = 0; i < names.length; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                DRCTemplate r = new DRCTemplate(names[i], when[i], type, matrix[j][0], matrix[j][1], value, matrix[j].length > 2 ? matrix[j][2] : null);
                list.add(r);
            }
        }
        return list;
    }

    public static List makeRuleTemplates(String[] names, int[] when, int type, double maxW, double value, String[][] arrayL) {
        ArrayList list = new ArrayList(names.length);
        for (int i = 0; i < names.length; ++i) {
            list.addAll(DRCTemplate.makeRuleTemplates(names[i], when[i], type, maxW, 0.0, value, arrayL, -1));
        }
        return list;
    }

    public static List makeRuleTemplates(String name, int when, int type, double maxW, double minLen, double value, String[][] arrayL, int multiCut) {
        int l = arrayL.length;
        ArrayList<DRCTemplate> list = new ArrayList<DRCTemplate>(l);
        for (int i = 0; i < l; ++i) {
            String[] layers = arrayL[i];
            if (layers.length != 2) {
                System.out.println("Invalid number of layers in DRC::makeRuleTemplates");
            }
            DRCTemplate r = new DRCTemplate(name, when, type, maxW, minLen, layers[0], layers[1], value, multiCut);
            list.add(r);
        }
        return list;
    }

    public static List makeRuleTemplates(String name, int when, int type, double value, String[] arrayL) {
        int length = arrayL.length;
        ArrayList<DRCTemplate> list = new ArrayList<DRCTemplate>(length);
        for (int i = 0; i < length; ++i) {
            String primitiveNode = arrayL[i];
            DRCTemplate r = new DRCTemplate(name, when, type, null, null, value, primitiveNode);
            list.add(r);
        }
        return list;
    }

    public static String getSpacingCombinedName(Layer layer, Geometric geo) {
        String n1 = layer.getName() + "-";
        if (geo != null) {
            n1 = geo instanceof NodeInst ? n1 + ((NodeInst)geo).getProto().getName() : n1 + ((ArcInst)geo).getProto().getName();
        }
        return n1;
    }

    public static class DRCTemplateSort
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double bb1 = ((DRCTemplate)o1).value1;
            double bb2 = ((DRCTemplate)o2).value1;
            if (bb1 < bb2) {
                return -1;
            }
            if (bb1 > bb2) {
                return 1;
            }
            return 0;
        }
    }
}

