/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashMap;

public class Orientation {
    private final short jAngle;
    private final short jOctant;
    private final boolean jMirrorX;
    private final boolean jMirrorY;
    private final String jString;
    private final short cAngle;
    private final boolean cTranspose;
    private final Orientation inverse;
    private final AffineTransform trans;
    private static final HashMap map;
    private static final Orientation[] map45;
    private static final int OCTANT = 7;
    private static final int XMIRROR45 = 8;
    private static final int YMIRROR45 = 16;
    public static final Orientation IDENT;
    public static final Orientation R;
    public static final Orientation RR;
    public static final Orientation RRR;
    public static final Orientation X;
    public static final Orientation XR;
    public static final Orientation XRR;
    public static final Orientation XRRR;
    public static final Orientation Y;
    public static final Orientation YR;
    public static final Orientation YRR;
    public static final Orientation YRRR;
    public static final Orientation XY;
    public static final Orientation XYR;
    public static final Orientation XYRR;
    public static final Orientation XYRRR;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Orientation(int jAngle, boolean jMirrorX, boolean jMirrorY, Orientation inverse) {
        double sin0;
        double cos0;
        if (!($assertionsDisabled || 0 <= jAngle && jAngle < 3600)) {
            throw new AssertionError();
        }
        this.jAngle = (short)jAngle;
        this.jOctant = (short)(jAngle % 450 == 0 ? jAngle / 450 : -1);
        this.jMirrorX = jMirrorX;
        this.jMirrorY = jMirrorY;
        int cAngle = jAngle;
        boolean cTranspose = false;
        if (jMirrorX) {
            if (jMirrorY) {
                cAngle = (cAngle + 1800) % 3600;
            } else {
                cAngle = (cAngle + 900) % 3600;
                cTranspose = true;
            }
        } else if (jMirrorY) {
            cAngle = (cAngle + 2700) % 3600;
            cTranspose = true;
        }
        this.cAngle = (short)cAngle;
        this.cTranspose = cTranspose;
        if (inverse == null) {
            inverse = cTranspose || jAngle == 0 || jAngle == 1800 ? this : new Orientation(3600 - jAngle, jMirrorX, jMirrorY, this);
        }
        this.inverse = inverse;
        double[] matrix = new double[4];
        int sect = jAngle / 450;
        if (!($assertionsDisabled || 0 <= sect && sect < 8)) {
            throw new AssertionError();
        }
        int ang = jAngle % 450;
        if (sect % 2 != 0) {
            ang = 450 - ang;
        }
        if (!($assertionsDisabled || 0 <= ang && ang <= 450)) {
            throw new AssertionError();
        }
        if (ang == 0) {
            cos0 = 1.0;
            sin0 = 0.0;
        } else if (ang == 450) {
            cos0 = sin0 = Math.sqrt(0.5);
        } else {
            double alpha = (double)ang * Math.PI / 1800.0;
            cos0 = Math.cos(alpha);
            sin0 = Math.sin(alpha);
        }
        double cos = 0.0;
        double sin = 0.0;
        switch (sect) {
            case 0: {
                cos = cos0;
                sin = sin0;
                break;
            }
            case 1: {
                cos = sin0;
                sin = cos0;
                break;
            }
            case 2: {
                cos = -sin0;
                sin = cos0;
                break;
            }
            case 3: {
                cos = -cos0;
                sin = sin0;
                break;
            }
            case 4: {
                cos = -cos0;
                sin = -sin0;
                break;
            }
            case 5: {
                cos = -sin0;
                sin = -cos0;
                break;
            }
            case 6: {
                cos = sin0;
                sin = -cos0;
                break;
            }
            case 7: {
                cos = cos0;
                sin = -sin0;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        matrix[0] = cos * (double)(jMirrorX ? -1 : 1);
        matrix[1] = sin * (double)(jMirrorY ? -1 : 1);
        matrix[2] = sin * (double)(jMirrorX ? 1 : -1);
        matrix[3] = cos * (double)(jMirrorY ? -1 : 1);
        if (jAngle % 900 == 0) {
            for (int i = 0; i < matrix.length; ++i) {
                matrix[i] = Math.round(matrix[i]);
            }
        }
        this.trans = new AffineTransform(matrix);
        String s = "";
        if (jMirrorX) {
            s = s + 'X';
        }
        if (jMirrorY) {
            s = s + 'Y';
        }
        while (jAngle >= 900) {
            s = s + 'R';
            jAngle -= 900;
        }
        if (jAngle != 0) {
            s = s + jAngle;
        }
        this.jString = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Orientation fromJava(int jAngle, boolean jMirrorX, boolean jMirrorY) {
        Orientation orient;
        if (jAngle % 450 == 0) {
            int index = jAngle / 450 & 7;
            if (jMirrorX) {
                index |= 8;
            }
            if (jMirrorY) {
                index |= 0x10;
            }
            return map45[index];
        }
        if ((jAngle %= 3600) < 0) {
            jAngle += 3600;
        }
        int index = 0;
        if (jMirrorX) {
            index += 3600;
        }
        if (jMirrorY) {
            index += 7200;
        }
        Integer key = new Integer(index + jAngle);
        HashMap hashMap = map;
        synchronized (hashMap) {
            orient = (Orientation)map.get(key);
            if (orient == null) {
                orient = new Orientation(jAngle, jMirrorX, jMirrorY, null);
                map.put(key, orient);
                if (orient.inverse != orient) {
                    key = new Integer(index + 3600 - jAngle);
                    map.put(key, orient.inverse);
                }
            }
        }
        return orient;
    }

    public static Orientation fromC(int cAngle, boolean cTranspose) {
        return Orientation.fromJava(cTranspose ? cAngle % 3600 + 900 : cAngle, false, cTranspose);
    }

    public static Orientation fromAngle(int angle) {
        return Orientation.fromJava(angle, false, false);
    }

    public Orientation inverse() {
        return this.inverse;
    }

    public Orientation concatenate(Orientation that) {
        boolean mirrorX = this.jMirrorX ^ that.jMirrorX;
        boolean mirrorY = this.jMirrorY ^ that.jMirrorY;
        int angle = that.jMirrorX ^ that.jMirrorY ? that.jAngle - this.jAngle : that.jAngle + this.jAngle;
        return Orientation.fromJava(angle, mirrorX, mirrorY);
    }

    public int getCAngle() {
        return this.cAngle;
    }

    public boolean isCTranspose() {
        return this.cTranspose;
    }

    public int getAngle() {
        return this.jAngle;
    }

    public boolean isXMirrored() {
        return this.jMirrorX;
    }

    public boolean isYMirrored() {
        return this.jMirrorY;
    }

    public AffineTransform pureRotate() {
        return (AffineTransform)this.trans.clone();
    }

    public AffineTransform rotateAbout(Point2D c) {
        return this.rotateAbout(c.getX(), c.getY());
    }

    public AffineTransform rotateAbout(double cX, double cY) {
        return this.rotateAbout(cX, cY, -cX, -cY);
    }

    public AffineTransform rotateAbout(double aX, double aY, double bX, double bY) {
        double m00 = this.trans.getScaleX();
        double m01 = this.trans.getShearX();
        double m10 = this.trans.getShearY();
        double m11 = this.trans.getScaleY();
        if (bX != 0.0 || bY != 0.0) {
            aX = aX + m00 * bX + m01 * bY;
            aY = aY + m11 * bY + m10 * bX;
        }
        return new AffineTransform(m00, m10, m01, m11, aX, aY);
    }

    public int transformAngle(int angle) {
        angle += this.cAngle;
        if (this.cTranspose) {
            angle = 2700 - angle;
        }
        if ((angle %= 3600) < 0) {
            angle += 3600;
        }
        return angle;
    }

    public String toJelibString() {
        return this.jString;
    }

    public String toString() {
        return this.toJelibString();
    }

    static {
        $assertionsDisabled = !Orientation.class.desiredAssertionStatus();
        map = new HashMap();
        Orientation[] m = new Orientation[32];
        for (int i = 0; i < m.length; ++i) {
            Orientation orient;
            int octant = i & 7;
            boolean jMirrorX = (i & 8) != 0;
            boolean jMirrorY = (i & 0x10) != 0;
            m[i] = orient = new Orientation(octant * 450, jMirrorX, jMirrorY, null);
            if (orient.inverse == orient) continue;
            m[i + 8 - octant * 2] = orient.inverse;
        }
        map45 = m;
        IDENT = Orientation.fromJava(0, false, false);
        R = Orientation.fromJava(900, false, false);
        RR = Orientation.fromJava(1800, false, false);
        RRR = Orientation.fromJava(2700, false, false);
        X = Orientation.fromJava(0, true, false);
        XR = Orientation.fromJava(900, true, false);
        XRR = Orientation.fromJava(1800, true, false);
        XRRR = Orientation.fromJava(2700, true, false);
        Y = Orientation.fromJava(0, false, true);
        YR = Orientation.fromJava(900, false, true);
        YRR = Orientation.fromJava(1800, false, true);
        YRRR = Orientation.fromJava(2700, false, true);
        XY = Orientation.fromJava(0, true, true);
        XYR = Orientation.fromJava(900, true, true);
        XYRR = Orientation.fromJava(1800, true, true);
        XYRRR = Orientation.fromJava(2700, true, true);
    }
}

