/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.GenMath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DBMath
extends GenMath {
    private static final double GRID = 100.0;
    private static final double EPSILON = 0.01;
    private static final double TINYDELTA = 0.0101;

    public static double getEpsilon() {
        return 0.01;
    }

    public static boolean pointInRect(Point2D pt, Rectangle2D bounds) {
        if (pt.getX() < bounds.getMinX() - 0.0101) {
            return false;
        }
        if (pt.getX() > bounds.getMaxX() + 0.0101) {
            return false;
        }
        if (pt.getY() < bounds.getMinY() - 0.0101) {
            return false;
        }
        return !(pt.getY() > bounds.getMaxY() + 0.0101);
    }

    public static boolean pointInsideRect(Point2D pt, Rectangle2D bounds) {
        boolean newV = DBMath.isGreaterThan(pt.getX(), bounds.getMinX()) && DBMath.isGreaterThan(bounds.getMaxX(), pt.getX()) && DBMath.isGreaterThan(pt.getY(), bounds.getMinY()) && DBMath.isGreaterThan(bounds.getMaxY(), pt.getY());
        return newV;
    }

    public static boolean areEquals(double a, double b) {
        return Math.abs(a - b) < 0.0101;
    }

    public static boolean isGreaterThan(double a, double b) {
        double actual = DBMath.round(a - b);
        return actual > 0.0;
    }

    public static double round(double x) {
        return Math.rint(x * 100.0) / 100.0;
    }

    public static boolean areEquals(Point2D a, Point2D b) {
        return DBMath.areEquals(a.getX(), b.getX()) && DBMath.areEquals(a.getY(), b.getY());
    }

    public static boolean isOnLine(Point2D end1, Point2D end2, Point2D pt) {
        Point2D closestPointOnSegment = DBMath.closestPointToSegment(end1, end2, pt);
        return DBMath.areEquals(closestPointOnSegment, pt);
    }

    public static boolean hasRemainder(double a, double divisor) {
        double val = DBMath.round(a / divisor);
        return val % 1.0 != 0.0;
    }
}

