/*
 This file is part of pybliographer
 
 Copyright (C) 1998-1999 Frederic GOBRY
 Email : gobry@idiap.ch
 	   
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2 
 of the License, or (at your option) any later version.
   
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details. 
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 
 $Id: recodemodule.c,v 1.1 1999/07/22 07:10:26 gobry Exp $
*/

#include <stdbool.h>
#include "Python.h"
#include "recode.h"

static RECODE_OUTER outer;
char * program_name = "toto";

static void
py_delete_recoder (void * recoder) {
    RECODE_REQUEST request = (RECODE_REQUEST) recoder;

    recode_delete_request (request);
}

static PyObject *
py_new_recoder (PyObject * self, PyObject * args) {
    char * string;
    RECODE_REQUEST request;

    if (! PyArg_ParseTuple(args, "s", & string))
	return NULL;

    request = recode_new_request (outer);
    if (request == NULL) {
	PyErr_SetString (PyExc_IOError, "can't initialize new request");
	return NULL;
    }

    if (! recode_scan_request (request, string)) {
	PyErr_SetString (PyExc_IOError, "can't initialize request");
	return NULL;
    }

    return PyCObject_FromVoidPtr (request, py_delete_recoder);
}

static PyObject *
py_recode (PyObject * self, PyObject * args) {
    char * string;
    RECODE_REQUEST request;
    PyObject * tmp;

    if (! PyArg_ParseTuple(args, "Os", & request, & string))
	return NULL;

    request = (RECODE_REQUEST) PyCObject_AsVoidPtr ((void *) request);

    string = recode_string (request, string);
    if (string == NULL) {
	PyErr_SetString (PyExc_IOError, "can't convert");
	return NULL;
    }

    tmp = PyString_FromString (string);
    free (string);

    return tmp;
}

static PyMethodDef recodeMeth [] = {
    { "request", py_new_recoder, METH_VARARGS },
    { "recode", py_recode, METH_VARARGS },
    {NULL, NULL, 0},
};


void initrecode ()
{
    outer = recode_new_outer (false);
    if (outer == NULL) return;

    (void) Py_InitModule ("recode", recodeMeth);
}

