/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gnomevte.event;

/**
 * Listener for the {@link org.gnu.gnomevte.Terminal} widget
 * that deals exclusively with {@link org.gnu.gnomevte.event.CharacterSizeChangedEvent}.
 */
public interface CharacterSizeChangedListener {

	/**
	 * This method is called whenever a {@link org.gnu.gnomevte.Terminal} 
	 * widget fires a character size change event.
	 * @param event the event that is fired.
	 */
	public void characterSizeChanged(CharacterSizeChangedEvent event);
}
