
#include <pangomm/layout.h>
#include <pangomm/private/layout_p.h>

#include <pango/pango-enum-types.h>
// -*- c++ -*-
/* $Id: layout.ccg,v 1.8 2002/03/26 18:43:34 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Pango
{

void Layout::set_text(const Glib::ustring& text)
{
  pango_layout_set_text(gobj(), text.c_str(), text.size());
}

void Layout::set_markup(const Glib::ustring& markup)
{
  return pango_layout_set_markup(gobj(), markup.c_str(), markup.size());
}

void Layout::set_markup(const Glib::ustring& markup, gunichar accel_marker, gunichar& accel_char)
{
  return pango_layout_set_markup_with_accel(gobj(), markup.c_str(), markup.size(), accel_marker, &accel_char);
}

Glib::ArrayHandle<PangoLogAttr> Layout::get_log_attrs()
{
  //Get array:
  PangoLogAttr* pAttrs = 0;
  int n_attrs = 0;
  pango_layout_get_log_attrs(gobj(), &pAttrs, &n_attrs);

  return Glib::ArrayHandle<PangoLogAttr> (pAttrs, n_attrs, Glib::OWNERSHIP_SHALLOW);
}

void Layout::get_iter(LayoutIter& iter)
{
  iter.assign_gobj(pango_layout_get_iter(gobj()));
}

} /* namespace Pango */


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Pango::Alignment>::value_type()
{
  return pango_alignment_get_type();
}

// static
GType Glib::Value<Pango::WrapMode>::value_type()
{
  return pango_wrap_mode_get_type();
}


namespace Glib
{

Glib::RefPtr<Pango::Layout> wrap(PangoLayout* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Pango::Layout>( dynamic_cast<Pango::Layout*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Pango
{


/* The *_Class implementation: */

GType Layout_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // The actual struct definition is hidden, so we can not derive one.
    gtype_ = pango_layout_get_type();

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}


Glib::ObjectBase* Layout_Class::wrap_new(GObject* o)
{
  return new Layout((PangoLayout*)(o));
}


/* The implementation: */

PangoLayout* Layout::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<Layout> Layout::wrap_specific_type(PangoLayout* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Layout> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    Layout* pCppObject = dynamic_cast<Layout*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<Layout>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<Layout>( new Layout(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

Layout::Layout(PangoLayout* castitem)
: Glib::Object((GObject*)(castitem))
{}

Layout::~Layout()
{
}

Layout::CppClassType Layout::layout_class_; //Initialize static member.

GType Layout::get_type()
{
  return layout_class_.get_type();
}

GType Layout::get_base_type()
{
  return pango_layout_get_type();
}

Glib::RefPtr<Layout> Layout::copy()
{
  return Glib::wrap(pango_layout_copy(gobj()));
}

Glib::RefPtr<Context> Layout::get_context()
{
  return Glib::wrap(pango_layout_get_context(gobj()));
}

void Layout::set_attributes(AttrList& attrs)
{
  pango_layout_set_attributes(gobj(), (attrs).gobj());
}

AttrList Layout::get_attributes()
{
  return AttrList(pango_layout_get_attributes(gobj()));
}

Glib::ustring Layout::get_text()
{
  return Glib::convert_const_gchar_ptr_to_ustring(pango_layout_get_text(gobj()));
}

void Layout::set_font_description(const FontDescription& desc)
{
  pango_layout_set_font_description(gobj(), (desc).gobj());
}

void Layout::set_width(int width)
{
  pango_layout_set_width(gobj(), width);
}

int Layout::get_width()
{
  return pango_layout_get_width(gobj());
}

void Layout::set_wrap(WrapMode wrap)
{
  pango_layout_set_wrap(gobj(), ((PangoWrapMode)(wrap)));
}

WrapMode Layout::get_wrap()
{
  return ((WrapMode)(pango_layout_get_wrap(gobj())));
}

void Layout::set_indent(int indent)
{
  pango_layout_set_indent(gobj(), indent);
}

int Layout::get_indent()
{
  return pango_layout_get_indent(gobj());
}

void Layout::set_spacing(int spacing)
{
  pango_layout_set_spacing(gobj(), spacing);
}

int Layout::get_spacing()
{
  return pango_layout_get_spacing(gobj());
}

void Layout::set_justify(bool justify)
{
  pango_layout_set_justify(gobj(), static_cast<int>(justify));
}

bool Layout::get_justify()
{
  return pango_layout_get_justify(gobj());
}

void Layout::set_alignment(Alignment alignment)
{
  pango_layout_set_alignment(gobj(), ((PangoAlignment)(alignment)));
}

Alignment Layout::get_alignment()
{
  return ((Alignment)(pango_layout_get_alignment(gobj())));
}

void Layout::set_tabs(TabArray& tabs)
{
  pango_layout_set_tabs(gobj(), (tabs).gobj());
}

TabArray Layout::get_tabs()
{
  return Pango::TabArray(pango_layout_get_tabs(gobj()));
}

void Layout::set_single_paragraph_mode(bool setting)
{
  pango_layout_set_single_paragraph_mode(gobj(), static_cast<int>(setting));
}

bool Layout::get_single_paragraph_mode()
{
  return pango_layout_get_single_paragraph_mode(gobj());
}

void Layout::context_changed()
{
  pango_layout_context_changed(gobj());
}

void Layout::index_to_pos(int index, PangoRectangle& pos)
{
  pango_layout_index_to_pos(gobj(), index, &pos);
}

void Layout::get_cursor_pos(int index, PangoRectangle& strong_pos, PangoRectangle& weak_pos)
{
  pango_layout_get_cursor_pos(gobj(), index, &strong_pos, &weak_pos);
}

void Layout::move_cursor_visually(bool strong, int old_index, int old_trailing, int direction, int& new_index, int& new_trailing)
{
  pango_layout_move_cursor_visually(gobj(), static_cast<int>(strong), old_index, old_trailing, direction, &new_index, &new_trailing);
}

bool Layout::xy_to_index(int x, int y, int& index, int& trailing)
{
  return pango_layout_xy_to_index(gobj(), x, y, &index, &trailing);
}

void Layout::get_extents(PangoRectangle& ink_rect, PangoRectangle& logical_rect)
{
  pango_layout_get_extents(gobj(), &ink_rect, &logical_rect);
}

void Layout::get_pixel_extents(PangoRectangle& ink_rect, PangoRectangle& logical_rect)
{
  pango_layout_get_pixel_extents(gobj(), &ink_rect, &logical_rect);
}

void Layout::get_size(int& width, int& height)
{
  pango_layout_get_size(gobj(), &width, &height);
}

void Layout::get_pixel_size(int& width, int& height)
{
  pango_layout_get_pixel_size(gobj(), &width, &height);
}

int Layout::get_line_count()
{
  return pango_layout_get_line_count(gobj());
}

Glib::RefPtr<LayoutLine> Layout::get_line(int line)
{
  return Glib::wrap(pango_layout_get_line(gobj(), line));
}

SListHandle_LayoutLine Layout::get_lines() const
{
  return SListHandle_LayoutLine(pango_layout_get_lines(const_cast<PangoLayout*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}


} // namespace Pango

