
#include <gtkmm/textchildanchor.h>
#include <gtkmm/private/textchildanchor_p.h>

// -*- c++ -*-
/* $Id: textchildanchor.ccg,v 1.2 2002/04/16 13:01:53 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtktextchild.h>

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::TextChildAnchor> wrap(GtkTextChildAnchor* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::TextChildAnchor>( dynamic_cast<Gtk::TextChildAnchor*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType TextChildAnchor_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_text_child_anchor_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void TextChildAnchor_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* TextChildAnchor_Class::wrap_new(GObject* o)
{
  return new TextChildAnchor((GtkTextChildAnchor*)(o));
}


/* The implementation: */

GtkTextChildAnchor* TextChildAnchor::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<TextChildAnchor> TextChildAnchor::wrap_specific_type(GtkTextChildAnchor* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<TextChildAnchor> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    TextChildAnchor* pCppObject = dynamic_cast<TextChildAnchor*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<TextChildAnchor>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<TextChildAnchor>( new TextChildAnchor(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

TextChildAnchor::TextChildAnchor(GtkTextChildAnchor* castitem)
: Glib::Object((GObject*)(castitem))
{}

TextChildAnchor::~TextChildAnchor()
{
}

TextChildAnchor::CppClassType TextChildAnchor::textchildanchor_class_; //Initialize static member.

GType TextChildAnchor::get_type()
{
  return textchildanchor_class_.get_type();
}

GType TextChildAnchor::get_base_type()
{
  return gtk_text_child_anchor_get_type();
}

TextChildAnchor::TextChildAnchor()
: Glib::Object((GObject*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<TextChildAnchor> TextChildAnchor::create()
{
  return Glib::RefPtr<TextChildAnchor>( new TextChildAnchor() );
}
Glib::ListHandle<Widget*> TextChildAnchor::get_widgets()
{
  return Glib::ListHandle<Widget*>(gtk_text_child_anchor_get_widgets(gobj()), Glib::OWNERSHIP_SHALLOW);
}

bool TextChildAnchor::get_deleted() const
{
  return gtk_text_child_anchor_get_deleted(const_cast<GtkTextChildAnchor*>(gobj()));
}


} // namespace Gtk

