
#include <gtkmm/spinbutton.h>
#include <gtkmm/private/spinbutton_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: spinbutton.ccg,v 1.13 2001/12/19 07:31:20 kenelson Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/adjustment.h>
#include <gtk/gtkspinbutton.h>

namespace Gtk
{

SpinButton::SpinButton(double climb_rate, guint digits) :
  Entry((GtkEntry*)(g_object_new(get_type(), "climb_rate", climb_rate, "digits", digits, 0)))
{
}

void SpinButton::remove_adjustment()
{
  gtk_spin_button_set_adjustment(gobj(), 0);
}

} /* namespace Gtk */


namespace
{


gint SpinButton_signal_input_callback(GtkSpinButton*, gdouble* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<int,double*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return ((*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gint RType;
  return RType();
}

gint SpinButton_signal_input_notify_callback(GtkSpinButton*, gdouble* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,double*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gint RType;
  return RType();
}


const Glib::SignalProxyInfo SpinButton_signal_input_info =
{
  "input",
  (GCallback) &SpinButton_signal_input_callback,
  (GCallback) &SpinButton_signal_input_notify_callback
};


gboolean SpinButton_signal_output_callback(GtkSpinButton*, void* data)
{
  using namespace Gtk;
  typedef SigC::Slot0<bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        ( slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean SpinButton_signal_output_notify_callback(GtkSpinButton*, void* data)
{
  using namespace Gtk;
  typedef SigC::Slot0<void> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        ( slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo SpinButton_signal_output_info =
{
  "output",
  (GCallback) &SpinButton_signal_output_callback,
  (GCallback) &SpinButton_signal_output_notify_callback
};


const Glib::SignalProxyInfo SpinButton_signal_value_changed_info =
{
  "value_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace

// static
GType Glib::Value<Gtk::SpinButtonUpdatePolicy>::value_type()
{
  return gtk_spin_button_update_policy_get_type();
}

// static
GType Glib::Value<Gtk::SpinType>::value_type()
{
  return gtk_spin_type_get_type();
}


namespace Glib
{

Gtk::SpinButton* wrap(GtkSpinButton* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::SpinButton *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType SpinButton_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_spin_button_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Editable::add_interface(get_type());
  }

  return gtype_;
}

void SpinButton_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->input = &input_callback;
  klass->output = &output_callback;
  klass->value_changed = &value_changed_callback;
}


gint SpinButton_Class::input_callback(GtkSpinButton* self, gdouble* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->on_input(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->input)
      (*base->input)(self, p0);
  }

  typedef gint RType;
  return RType();
}

gboolean SpinButton_Class::output_callback(GtkSpinButton* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_output());
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->output)
      (*base->output)(self);
  }

  typedef gboolean RType;
  return RType();
}

void SpinButton_Class::value_changed_callback(GtkSpinButton* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_value_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->value_changed)
      (*base->value_changed)(self);
  }
}


Glib::ObjectBase* SpinButton_Class::wrap_new(GObject* o)
{
  return manage(new SpinButton((GtkSpinButton*)(o)));
}


/* The implementation: */

SpinButton::SpinButton(GtkSpinButton* castitem)
: Gtk::Entry((GtkEntry*)(castitem))
{}

SpinButton::~SpinButton()
{
  destroy_();
}

SpinButton::CppClassType SpinButton::spinbutton_class_; //Initialize static member.

GType SpinButton::get_type()
{
  return spinbutton_class_.get_type();
}

GType SpinButton::get_base_type()
{
  return gtk_spin_button_get_type();
}

SpinButton::SpinButton(Adjustment& adjustment, double climb_rate, guint digits)
: Gtk::Entry((GtkEntry*)( g_object_new(get_type(), "adjustment", (adjustment).gobj(), "climb_rate", climb_rate, "digits", digits, (char*)0) ))
{}

void SpinButton::configure(Adjustment& adjustment, double climb_rate, guint digits)
{
  gtk_spin_button_configure(gobj(), (adjustment).gobj(), climb_rate, digits);
}

void SpinButton::set_adjustment(Adjustment& adjustment)
{
  gtk_spin_button_set_adjustment(gobj(), (adjustment).gobj());
}

Gtk::Adjustment* SpinButton::get_adjustment()
{
  return Glib::wrap(gtk_spin_button_get_adjustment(gobj()));
}

void SpinButton::set_digits(guint digits)
{
  gtk_spin_button_set_digits(gobj(), digits);
}

guint SpinButton::get_digits() const
{
  return gtk_spin_button_get_digits(const_cast<GtkSpinButton*>(gobj()));
}

void SpinButton::set_increments(double step, double page)
{
  gtk_spin_button_set_increments(gobj(), step, page);
}

void SpinButton::get_increments(double& step, double& page) const
{
  gtk_spin_button_get_increments(const_cast<GtkSpinButton*>(gobj()), &(step), &(page));
}

void SpinButton::set_range(double min, double max)
{
  gtk_spin_button_set_range(gobj(), min, max);
}

void SpinButton::get_range(double& min, double& max) const
{
  gtk_spin_button_get_range(const_cast<GtkSpinButton*>(gobj()), &(min), &(max));
}

double SpinButton::get_value() const
{
  return gtk_spin_button_get_value(const_cast<GtkSpinButton*>(gobj()));
}

int SpinButton::get_value_as_int() const
{
  return gtk_spin_button_get_value_as_int(const_cast<GtkSpinButton*>(gobj()));
}

void SpinButton::set_value(double value)
{
  gtk_spin_button_set_value(gobj(), value);
}

void SpinButton::set_update_policy(SpinButtonUpdatePolicy policy)
{
  gtk_spin_button_set_update_policy(gobj(), ((GtkSpinButtonUpdatePolicy)(policy)));
}

SpinButtonUpdatePolicy SpinButton::get_update_policy() const
{
  return ((SpinButtonUpdatePolicy)(gtk_spin_button_get_update_policy(const_cast<GtkSpinButton*>(gobj()))));
}

void SpinButton::set_numeric(bool numeric)
{
  gtk_spin_button_set_numeric(gobj(), static_cast<int>(numeric));
}

bool SpinButton::get_numeric() const
{
  return gtk_spin_button_get_numeric(const_cast<GtkSpinButton*>(gobj()));
}

void SpinButton::spin(SpinType direction, double increment)
{
  gtk_spin_button_spin(gobj(), ((GtkSpinType)(direction)), increment);
}

void SpinButton::set_wrap(bool wrap)
{
  gtk_spin_button_set_wrap(gobj(), static_cast<int>(wrap));
}

bool SpinButton::get_wrap() const
{
  return gtk_spin_button_get_wrap(const_cast<GtkSpinButton*>(gobj()));
}

void SpinButton::set_snap_to_ticks(bool snap_to_ticks)
{
  gtk_spin_button_set_snap_to_ticks(gobj(), static_cast<int>(snap_to_ticks));
}

bool SpinButton::get_snap_to_ticks() const
{
  return gtk_spin_button_get_snap_to_ticks(const_cast<GtkSpinButton*>(gobj()));
}

void SpinButton::update()
{
  gtk_spin_button_update(gobj());
}


Glib::SignalProxy1<int,double*> SpinButton::signal_input()
{
  return Glib::SignalProxy1<int,double*>(this, &SpinButton_signal_input_info);
}

Glib::SignalProxy0<bool> SpinButton::signal_output()
{
  return Glib::SignalProxy0<bool>(this, &SpinButton_signal_output_info);
}

Glib::SignalProxy0<void> SpinButton::signal_value_changed()
{
  return Glib::SignalProxy0<void>(this, &SpinButton_signal_value_changed_info);
}


Glib::PropertyProxy<Gtk::Adjustment*> SpinButton::property_adjustment()
{
  return Glib::PropertyProxy<Gtk::Adjustment*>(this, "adjustment");
}

Glib::PropertyProxy<double> SpinButton::property_climb_rate()
{
  return Glib::PropertyProxy<double>(this, "climb_rate");
}

Glib::PropertyProxy<guint> SpinButton::property_digits()
{
  return Glib::PropertyProxy<guint>(this, "digits");
}

Glib::PropertyProxy<bool> SpinButton::property_snap_to_ticks()
{
  return Glib::PropertyProxy<bool>(this, "snap_to_ticks");
}

Glib::PropertyProxy<bool> SpinButton::property_numeric()
{
  return Glib::PropertyProxy<bool>(this, "numeric");
}

Glib::PropertyProxy<bool> SpinButton::property_wrap()
{
  return Glib::PropertyProxy<bool>(this, "wrap");
}

Glib::PropertyProxy<SpinButtonUpdatePolicy> SpinButton::property_update_policy()
{
  return Glib::PropertyProxy<SpinButtonUpdatePolicy>(this, "update_policy");
}

Glib::PropertyProxy<double> SpinButton::property_value()
{
  return Glib::PropertyProxy<double>(this, "value");
}


int Gtk::SpinButton::on_input(double* new_value)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->input)
    return (*base->input)(gobj(),new_value);

  typedef int RType;
  return RType();
}

bool Gtk::SpinButton::on_output()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->output)
    return (*base->output)(gobj());

  typedef bool RType;
  return RType();
}

void Gtk::SpinButton::on_value_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->value_changed)
    (*base->value_changed)(gobj());
}


} // namespace Gtk

