
#include <gtkmm/image.h>
#include <gtkmm/private/image_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: image.ccg,v 1.21 2002/04/23 16:33:35 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkimage.h>
#include <gdkmm/image.h>
#include <gdkmm/bitmap.h>
#include <gdkmm/pixmap.h>

namespace Gtk
{

Image::Image(const Gtk::StockID& stock_id, IconSize size)
:
  Gtk::Misc((GtkMisc*) g_object_new(
      get_type(), "stock", stock_id.get_c_str(), "icon-size", (GtkIconSize) int(size), (char*)0))
{}

Image::Image(IconSet& icon_set, IconSize size)
:
  Gtk::Misc((GtkMisc*) g_object_new(
      get_type(), "icon-set", icon_set.gobj(), "icon-size", (GtkIconSize) int(size), (char*)0))
{}

Image::Image(const Glib::RefPtr<Gdk::PixbufAnimation>& animation)
:
  Gtk::Misc((GtkMisc*) g_object_new(
      get_type(), "pixbuf-animation", animation->gobj(), (char*)0))
{}

void Image::get_pixmap(Glib::RefPtr<Gdk::Pixmap>& pixmap, Glib::RefPtr<Gdk::Bitmap>& mask) const
{
  GdkPixmap* pPixmap = 0;
  GdkBitmap* pBitmap = 0;
  gtk_image_get_pixmap(const_cast<GtkImage*>(gobj()), &pPixmap, &pBitmap);
  pixmap = Gdk::Pixmap::wrap_specific_type(pPixmap);
  mask = Gdk::Bitmap::wrap_specific_type(pBitmap);
}

void Image::get_image(Glib::RefPtr<Gdk::Image>& gdk_image, Glib::RefPtr<Gdk::Bitmap>& mask) const
{
  GdkImage* pImage = 0;
  GdkBitmap* pBitmap = 0;
  gtk_image_get_image(const_cast<GtkImage*>(gobj()), &pImage, &pBitmap);
  gdk_image = Gdk::Image::wrap_specific_type(pImage);
  mask = Gdk::Bitmap::wrap_specific_type(pBitmap);
}

void Image::get_stock(Gtk::StockID& stock_id, IconSize& size) const
{
  char* pStockID = 0; // GTK+ iconsistency: although not const, it should not be freed.
  GtkIconSize icon_size = GTK_ICON_SIZE_INVALID;

  gtk_image_get_stock(const_cast<GtkImage*>(gobj()), &pStockID, &icon_size);

  size = IconSize(static_cast<int>(icon_size));
  stock_id = Gtk::StockID(pStockID); // the StockID ctor checks for 0
}

void Image::get_icon_set(IconSet& icon_set, IconSize& size) const
{
  GtkIconSet* pIconSet = 0;
  GtkIconSize icon_size = GTK_ICON_SIZE_INVALID;

  gtk_image_get_icon_set(const_cast<GtkImage*>(gobj()), &pIconSet, &icon_size);

  size = IconSize(static_cast<int>(icon_size));
  icon_set = Glib::wrap(pIconSet, true); //true = take_copy.
}

void Image::clear()
{
  gtk_image_set_from_pixbuf(gobj(), 0);
}

} // namespace Gtk


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gtk::ImageType>::value_type()
{
  return gtk_image_type_get_type();
}


namespace Glib
{

Gtk::Image* wrap(GtkImage* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Image *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Image_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_image_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Image_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Image_Class::wrap_new(GObject* o)
{
  return manage(new Image((GtkImage*)(o)));
}


/* The implementation: */

Image::Image(GtkImage* castitem)
: Gtk::Misc((GtkMisc*)(castitem))
{}

Image::~Image()
{
  destroy_();
}

Image::CppClassType Image::image_class_; //Initialize static member.

GType Image::get_type()
{
  return image_class_.get_type();
}

GType Image::get_base_type()
{
  return gtk_image_get_type();
}

Image::Image()
: Gtk::Misc((GtkMisc*)(g_object_new(get_type(), (char*)0)))
{}

Image::Image(const Glib::RefPtr<Gdk::Pixmap>& pixmap, const Glib::RefPtr<Gdk::Bitmap>& mask)
: Gtk::Misc((GtkMisc*)( g_object_new(get_type(), "pixmap", Glib::unwrap(pixmap), "mask", Glib::unwrap(mask), (char*)0) ))
{}

Image::Image(const Glib::RefPtr<Gdk::Image>& image, const Glib::RefPtr<Gdk::Bitmap>& mask)
: Gtk::Misc((GtkMisc*)( g_object_new(get_type(), "image", Glib::unwrap(image), "mask", Glib::unwrap(mask), (char*)0) ))
{}

Image::Image(const Glib::ustring& file)
: Gtk::Misc((GtkMisc*)( g_object_new(get_type(), "file", file.c_str(), (char*)0) ))
{}

Image::Image(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)
: Gtk::Misc((GtkMisc*)( g_object_new(get_type(), "pixbuf", Glib::unwrap(pixbuf), (char*)0) ))
{}

void Image::set(const Glib::RefPtr<Gdk::Pixmap>& pixmap, const Glib::RefPtr<Gdk::Bitmap>& mask)
{
  gtk_image_set_from_pixmap(gobj(), Glib::unwrap(pixmap), Glib::unwrap(mask));
}

void Image::set(const Glib::RefPtr<Gdk::Image>& image, const Glib::RefPtr<Gdk::Bitmap>& mask)
{
  gtk_image_set_from_image(gobj(), Glib::unwrap(image), Glib::unwrap(mask));
}

void Image::set(const Glib::ustring& filename)
{
  gtk_image_set_from_file(gobj(), filename.c_str());
}

void Image::set(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)
{
  gtk_image_set_from_pixbuf(gobj(), Glib::unwrap(pixbuf));
}

void Image::set(const Gtk::StockID& stock_id, IconSize size)
{
  gtk_image_set_from_stock(gobj(), (stock_id).get_c_str(), static_cast<GtkIconSize>(int(size)));
}

void Image::set(IconSet& icon_set, IconSize size)
{
  gtk_image_set_from_icon_set(gobj(), (icon_set).gobj(), static_cast<GtkIconSize>(int(size)));
}

void Image::set(const Glib::RefPtr<Gdk::PixbufAnimation>& animation)
{
  gtk_image_set_from_animation(gobj(), Glib::unwrap(animation));
}

ImageType Image::get_storage_type()
{
  return ((ImageType)(gtk_image_get_storage_type(gobj())));
}

Glib::RefPtr<Gdk::Pixbuf> Image::get_pixbuf() const
{
  return Glib::wrap(gtk_image_get_pixbuf(const_cast<GtkImage*>(gobj())));
}

Glib::RefPtr<Gdk::PixbufAnimation> Image::get_animation()
{
  return Glib::wrap(gtk_image_get_animation(gobj()));
}


Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > Image::property_pixbuf()
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> >(this, "pixbuf");
}

Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixmap> > Image::property_pixmap()
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixmap> >(this, "pixmap");
}

Glib::PropertyProxy< Glib::RefPtr<Gdk::Image> > Image::property_image()
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Image> >(this, "image");
}

Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixmap> > Image::property_mask()
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixmap> >(this, "mask");
}

Glib::PropertyProxy_WriteOnly<Glib::ustring> Image::property_file()
{
  return Glib::PropertyProxy_WriteOnly<Glib::ustring>(this, "file");
}

Glib::PropertyProxy<Glib::ustring> Image::property_stock()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "stock");
}

Glib::PropertyProxy<Gtk::IconSet> Image::property_icon_set()
{
  return Glib::PropertyProxy<Gtk::IconSet>(this, "icon_set");
}

Glib::PropertyProxy<int> Image::property_icon_size()
{
  return Glib::PropertyProxy<int>(this, "icon_size");
}

Glib::PropertyProxy< Glib::RefPtr<Gdk::PixbufAnimation> > Image::property_pixbuf_animation()
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::PixbufAnimation> >(this, "pixbuf_animation");
}

Glib::PropertyProxy_ReadOnly<ImageType> Image::property_storage_type()
{
  return Glib::PropertyProxy_ReadOnly<ImageType>(this, "storage_type");
}


} // namespace Gtk

