
#include <gtkmm/iconfactory.h>
#include <gtkmm/private/iconfactory_p.h>

// -*- c++ -*-
/* $Id: iconfactory.ccg,v 1.4 2002/04/16 13:01:52 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkiconfactory.h>

namespace Gtk
{

// static
bool IconSize::lookup(IconSize size, int& width, int& height)
{
  return gtk_icon_size_lookup((GtkIconSize) int(size), &width, &height);
}

// static
IconSize IconSize::register_new(const Glib::ustring& name, int width, int height)
{
  const int size = gtk_icon_size_register(name.c_str(), width, height);
  return IconSize(size);
}

// static
void IconSize::register_alias(const Glib::ustring& alias, IconSize target)
{
  gtk_icon_size_register_alias(alias.c_str(), (GtkIconSize) int(target));
}

// static
IconSize IconSize::from_name(const Glib::ustring& name)
{
  const int size = gtk_icon_size_from_name(name.c_str());
  return IconSize(size);
}

// static
Glib::ustring IconSize::get_name(IconSize size)
{
  return gtk_icon_size_get_name((GtkIconSize) int(size));
}

} // namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::IconFactory> wrap(GtkIconFactory* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::IconFactory>( dynamic_cast<Gtk::IconFactory*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType IconFactory_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_icon_factory_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void IconFactory_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* IconFactory_Class::wrap_new(GObject* o)
{
  return new IconFactory((GtkIconFactory*)(o));
}


/* The implementation: */

GtkIconFactory* IconFactory::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<IconFactory> IconFactory::wrap_specific_type(GtkIconFactory* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<IconFactory> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    IconFactory* pCppObject = dynamic_cast<IconFactory*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<IconFactory>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<IconFactory>( new IconFactory(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

IconFactory::IconFactory(GtkIconFactory* castitem)
: Glib::Object((GObject*)(castitem))
{}

IconFactory::~IconFactory()
{
}

IconFactory::CppClassType IconFactory::iconfactory_class_; //Initialize static member.

GType IconFactory::get_type()
{
  return iconfactory_class_.get_type();
}

GType IconFactory::get_base_type()
{
  return gtk_icon_factory_get_type();
}

IconFactory::IconFactory()
: Glib::Object((GObject*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<IconFactory> IconFactory::create()
{
  return Glib::RefPtr<IconFactory>( new IconFactory() );
}
void IconFactory::add(const Glib::ustring& stock_id, IconSet& icon_set)
{
  gtk_icon_factory_add(gobj(), stock_id.c_str(), (icon_set).gobj());
}

void IconFactory::add_default()
{
  gtk_icon_factory_add_default(gobj());
}

void IconFactory::remove_default()
{
  gtk_icon_factory_remove_default(gobj());
}


} // namespace Gtk

