// -*- c++ -*-
#ifndef _GLIBMM_THREADPOOL_H
#define _GLIBMM_THREADPOOL_H

/* $Id: threadpool.h,v 1.1 2002/03/14 18:09:41 daniel Exp $ */

/* threadpool.h
 *
 * Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/thread.h>

extern "C" { typedef struct _GThreadPool GThreadPool; }


namespace Glib
{

/** @defgroup ThreadPools Thread Pools
 * Pools of threads to execute work concurrently.
 * @{
 */

class ThreadPool
{
public:
  /**
   * @throw Glib::ThreadError
   */
  explicit ThreadPool(int max_threads = -1, bool exclusive = false);
  virtual ~ThreadPool();

  /**
   * @throw Glib::ThreadError
   */
  void push(const SigC::Slot0<void>& slot);

  /**
   * @throw Glib::ThreadError
   */
  void set_max_threads(int max_threads);
  int  get_max_threads() const;

  unsigned int get_num_threads() const;
  unsigned int unprocessed() const;

  void shutdown(bool immediately = false);

  static void set_max_unused_threads(int max_threads);
  static int  get_max_unused_threads();
  static unsigned int get_num_unused_threads();
  static void stop_unused_threads();

  GThreadPool*       gobj()       { return gobject_; }
  const GThreadPool* gobj() const { return gobject_; }

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  class SlotList;
#endif

private:
  GThreadPool* gobject_;
  SlotList*    slot_list_;

  ThreadPool(const ThreadPool&);
  ThreadPool& operator=(const ThreadPool&);
};

/** @} group ThreadPools */


/***************************************************************************/
/*  inline implementation                                                  */
/***************************************************************************/

#ifndef DOXYGEN_SHOULD_SKIP_THIS

/**** Glib::Private ********************************************************/


#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GLIBMM_THREADPOOL_H */

