
extern "C"
{
#include <glib-object.h>
#include <gdk/gdkenumtypes.h>
}

#include <gdkmm/image.h>
#include <gdkmm/private/image_p.h>

#include <gdk/gdkenumtypes.h>
// -*- c++ -*-
/* $Id: image.ccg,v 1.8 2002/04/02 13:23:10 daniel Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Gdk
{

Image::Image(ImageType type, const Glib::RefPtr<Visual>& visual, int width, int height)
:
  Object( G_OBJECT( gdk_image_new((GdkImageType)type, visual->gobj(), width, height) ) )
{}

} /* namespace Gdk */


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gdk::ImageType>::value_type()
{
  return gdk_image_type_get_type();
}


namespace Glib
{

Glib::RefPtr<Gdk::Image> wrap(GdkImage* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gdk::Image>( dynamic_cast<Gdk::Image*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

GType Image_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gdk_image_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Image_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Image_Class::wrap_new(GObject* o)
{
  return new Image((GdkImage*)(o));
}


/* The implementation: */

GdkImage* Image::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<Image> Image::wrap_specific_type(GdkImage* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Image> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    Image* pCppObject = dynamic_cast<Image*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<Image>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<Image>( new Image(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

Image::Image(GdkImage* castitem)
: Glib::Object((GObject*)(castitem))
{}

Image::~Image()
{
}

Image::CppClassType Image::image_class_; //Initialize static member.

GType Image::get_type()
{
  return image_class_.get_type();
}

GType Image::get_base_type()
{
  return gdk_image_get_type();
}

Glib::RefPtr<Image> Image::create(ImageType type, const Glib::RefPtr<Visual>& visual, int width, int height)
{
  return Glib::RefPtr<Image>( new Image(type, visual, width, height) );
}
void Image::put_pixel(int x, int y, guint32 pixel)
{
  gdk_image_put_pixel(gobj(), x, y, pixel);
}

guint32 Image::get_pixel(int x, int y)
{
  return gdk_image_get_pixel(gobj(), x, y);
}

void Image::set_colormap(const Glib::RefPtr<Colormap>& colormap)
{
  gdk_image_set_colormap(gobj(), Glib::unwrap(colormap));
}

Glib::RefPtr<Colormap> Image::get_colormap()
{
  Glib::RefPtr<Colormap> retvalue = Glib::wrap(gdk_image_get_colormap(gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}


} // namespace Gdk

