#include <stdio.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/window.h>
#include <gtkmm/frame.h>
#include <gtkmm/box.h>
#include <gtkmm/main.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/label.h>
#include <gtkmm/adjustment.h>

//TODO: fix runtime warnings.

class ToggleSnap: public Gtk::CheckButton
{
  Gtk::SpinButton* spin_;
public:
  ToggleSnap(Gtk::SpinButton *spin,const Glib::ustring& s) 
      : Gtk::CheckButton(s), spin_(spin)
    {}
  virtual void on_clicked()
    { 
      Gtk::CheckButton::on_clicked();
      spin_->set_snap_to_ticks(get_active()); 
    }
};

class ToggleNumeric: public Gtk::CheckButton
{
  Gtk::SpinButton* spin_;
public:
  ToggleNumeric(Gtk::SpinButton *spin,const Glib::ustring& s) 
      : Gtk::CheckButton(s), spin_(spin)
    {}
  virtual void on_clicked()
    { 
      Gtk::CheckButton::on_clicked();
      spin_->set_numeric(get_active()); 
    }
};

class AppWindow : public Gtk::Window
{
  Gtk::SpinButton *spinner1;
  Gtk::Label  *val_label;
public:
  AppWindow();
  ~AppWindow();

  void change_digits( Gtk::SpinButton *spin );
  void get_value(int display );

};


void AppWindow::change_digits( Gtk::SpinButton *spin )
{
  spinner1->set_digits ( spin->get_value_as_int ());
}

void AppWindow::get_value(int display )
{
  gchar buf[32];

  if (display == 1)
    sprintf (buf, "%d", spinner1->get_value_as_int ());
  else
    sprintf (buf, "%0.*f", spinner1->get_digits(), spinner1->get_value());

  val_label->set_text (buf);
}


AppWindow::AppWindow()
{
  Gtk::Frame      *frame;
  Gtk::Box        *hbox;
  Gtk::Box        *main_vbox;
  Gtk::Box        *vbox;
  Gtk::Box        *vbox2;
  Gtk::SpinButton *spinner2;
  Gtk::SpinButton *spinner;
  Gtk::Button     *button;
  Gtk::CheckButton *checkbutton;
  Gtk::Label      *label;
  Gtk::Adjustment *adj;

  set_title ("Spin Button");

  main_vbox = Gtk::manage( new Gtk::VBox (false, 5) );
  main_vbox->set_border_width (10);
  add (*main_vbox);
  
  frame = Gtk::manage( new Gtk::Frame ("Not accelerated") );
  main_vbox->pack_start (*frame);
  
  vbox = Gtk::manage( new Gtk::VBox (false, 0) );
  vbox->set_border_width (5);
  frame->add (*vbox);
  
  /* Day, month, year spinners */
  
  hbox = Gtk::manage( new Gtk::HBox (false, 0) );
  vbox->pack_start (*hbox, Gtk::EXPAND | Gtk::FILL, 5);
  
  vbox2 = Gtk::manage( new Gtk::VBox (false, 0) );
  hbox->pack_start (*vbox2, Gtk::EXPAND | Gtk::FILL, 5);
  
  label = Gtk::manage( new Gtk::Label ("Day :"));
  label->set_alignment(0, 0.5);
  vbox2->pack_start (*label, Gtk::FILL);
  
  adj = Gtk::manage( new Gtk::Adjustment (1.0, 1.0, 31.0, 1.0, 5.0, 0.0) );
  spinner = Gtk::manage( new Gtk::SpinButton (*adj, 0, 0) );
  spinner->set_wrap (true);
  //spinner->set_shadow_type (Gtk::SHADOW_OUT);
  vbox2->pack_start (*spinner, Gtk::FILL);
  
  vbox2 = Gtk::manage( new Gtk::VBox (false, 0) );
  hbox->pack_start (*vbox2, Gtk::EXPAND | Gtk::FILL, 5);
  
  label = Gtk::manage( new Gtk::Label ("Month :"));
  label->set_alignment(0, 0.5);
  vbox2->pack_start (*label, Gtk::FILL);
  
  adj = Gtk::manage( new Gtk::Adjustment (1.0, 1.0, 12.0, 1.0, 5.0, 0.0) );
  spinner = Gtk::manage( new Gtk::SpinButton (*adj, 0, 0) );
  spinner->set_wrap (true);
  //spinner->set_shadow_type (Gtk::SHADOW_ETCHED_IN);
  vbox2->pack_start (*spinner, Gtk::FILL);
  
  vbox2 = Gtk::manage( new Gtk::VBox (false, 0) );
  hbox->pack_start (*vbox2, Gtk::EXPAND | Gtk::FILL, 5);
  
  label = Gtk::manage( new Gtk::Label ("Year :"));
  label->set_alignment(0, 0.5);
  vbox2->pack_start (*label, Gtk::FILL);
  
  adj = Gtk::manage( new Gtk::Adjustment (1998.0, 0.0, 2100.0, 1.0, 100.0, 0.0) );
  spinner = Gtk::manage( new Gtk::SpinButton (*adj, 0, 0) );
  spinner->set_wrap (false);
  //spinner->set_shadow_type (Gtk::SHADOW_IN);
  spinner->set_size_request (55, 0);
  vbox2->pack_start (*spinner, Gtk::FILL);
  
  frame = Gtk::manage( new Gtk::Frame ("Accelerated") );
  main_vbox->pack_start (*frame);
  
  vbox = Gtk::manage( new Gtk::VBox(false, 0) );
  vbox->set_border_width (5);
  frame->add (*vbox);
  
  hbox = Gtk::manage( new Gtk::HBox (false, 0) );
  vbox->pack_start (*hbox, Gtk::FILL, 5);
  
  vbox2 = Gtk::manage( new Gtk::VBox (false, 0) );
  hbox->pack_start (*vbox2, Gtk::EXPAND | Gtk::FILL, 5);
  
  label = Gtk::manage( new Gtk::Label ("Value :"));
  label->set_alignment(0, 0.5);
  vbox2->pack_start (*label, Gtk::FILL);
  
  adj = Gtk::manage( new Gtk::Adjustment (0.0, -10000.0, 10000.0,
					      0.5, 100.0, 0.0) );
  spinner1 = Gtk::manage( new Gtk::SpinButton (*adj, 1.0, 2) );
  spinner1->set_wrap (true);
  spinner1->set_size_request (100, 0);
  vbox2->pack_start (*spinner1, Gtk::FILL);
  
  vbox2 = Gtk::manage( new Gtk::VBox (false, 0) );
  hbox->pack_start (*vbox2, Gtk::EXPAND | Gtk::FILL, 5);
  
  label = Gtk::manage( new Gtk::Label ("Digits :"));
  label->set_alignment(0, 0.5);
  vbox2->pack_start (*label, Gtk::FILL);
  
  adj = Gtk::manage( new Gtk::Adjustment (2, 1, 5, 1, 1, 0) );

  spinner2 = Gtk::manage( new Gtk::SpinButton (*adj, 0.0, 0) );
  spinner2->set_wrap (true);
  adj->signal_value_changed().connect(
    bind(slot(*this, &AppWindow::change_digits),spinner2));
  vbox2->pack_start (*spinner2, Gtk::FILL);
  
  hbox = Gtk::manage( new Gtk::HBox (false, 0) );
  vbox->pack_start (*hbox, Gtk::FILL, 5);
  
  checkbutton = Gtk::manage( new ToggleSnap (spinner, "Snap to 0.5-ticks"));
  vbox->pack_start (*checkbutton);
  checkbutton->set_active (true);
  
  checkbutton = Gtk::manage( new ToggleNumeric (spinner, "Numeric only input mode") );
  vbox->pack_start ( *checkbutton);
  checkbutton->set_active (true);
  
  val_label = Gtk::manage( new Gtk::Label ("") );
  
  hbox = Gtk::manage( new Gtk::HBox (false, 0) );
  vbox->pack_start (*hbox, Gtk::FILL, 5);

  button = Gtk::manage( new Gtk::Button ("Value as Int") );
  button->signal_clicked().connect(bind(slot(*this,&AppWindow::get_value),1));
  hbox->pack_start (*button, Gtk::EXPAND | Gtk::FILL, 5);
  
  button = Gtk::manage( new Gtk::Button ("Value as Float") );
  button->signal_clicked().connect(bind(slot(*this,&AppWindow::get_value),2));
  hbox->pack_start (*button, Gtk::EXPAND | Gtk::FILL, 5);
  
  vbox->pack_start (*val_label);
  val_label->set_text ("0");
  
  hbox = Gtk::manage( new Gtk::HBox (false, 0));
  main_vbox->pack_start (*hbox, Gtk::FILL);
  
  button = Gtk::manage( new Gtk::Button ("Close") );
  button->signal_clicked().connect(&Gtk::Main::quit);
  hbox->pack_start (*button, Gtk::EXPAND | Gtk::FILL, 5);

  show_all ();
}

AppWindow::~AppWindow() {}

int main( int   argc,
          char *argv[] )
{
  /* Initialise GTK */
  Gtk::Main kit(&argc, &argv);
    
  /* Create a new window */
  AppWindow app;
    
  /* Enter the event loop */
  Gtk::Main::run (app);
    
  return(0);
} 

