
#include <pangomm/fontfamily.h>
#include <pangomm/private/fontfamily_p.h>

// -*- c++ -*-
/* $Id: fontfamily.ccg,v 1.2 2002/02/24 18:10:29 cactus Exp $ */

/* 
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

namespace Pango
{

Glib::ArrayHandle< Glib::RefPtr<FontFace> > FontFamily::list_faces()
{
  //Get the array:
  PangoFontFace** pFontFaces = 0;
  int n_fonts = 0;
  pango_font_family_list_faces (gobj(), &pFontFaces, &n_fonts);

  return Glib::ArrayHandle<Glib::RefPtr <FontFace> > (pFontFaces, n_fonts, Glib::OWNERSHIP_SHALLOW);
}

} /* namespace Pango */


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Pango::FontFamily> wrap(PangoFontFamily* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Pango::FontFamily>( dynamic_cast<Pango::FontFamily*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Pango
{


/* The *_Class implementation: */

GType FontFamily_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // The actual struct definition is hidden, so we can not derive one.
    gtype_ = pango_font_family_get_type();

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}


Glib::ObjectBase* FontFamily_Class::wrap_new(GObject* o)
{
  return new FontFamily((PangoFontFamily*)(o));
}


/* The implementation: */

PangoFontFamily* FontFamily::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<FontFamily> FontFamily::wrap_specific_type(PangoFontFamily* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<FontFamily> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    FontFamily* pCppObject = dynamic_cast<FontFamily*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<FontFamily>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<FontFamily>( new FontFamily(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

FontFamily::FontFamily(PangoFontFamily* castitem)
: Glib::Object((GObject*)(castitem))
{}

FontFamily::~FontFamily()
{
}

FontFamily::CppClassType FontFamily::fontfamily_class_; //Initialize static member.

GType FontFamily::get_type()
{
  return fontfamily_class_.get_type();
}

GType FontFamily::get_base_type()
{
  return pango_font_family_get_type();
}

Glib::ustring FontFamily::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(pango_font_family_get_name(const_cast<PangoFontFamily*>(gobj())));
}


} // namespace Pango

