
#include <gtkmm/treeview.h>
#include <gtkmm/private/treeview_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: treeview.ccg,v 1.12 2002/04/18 05:52:20 murrayc Exp $ */

/* 
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtktreeview.h>
#include <gtkmm/treeviewcolumn.h>
#include <gtkmm/treeview_private.h>
#include <gtkmm/treemodel.h>

namespace Gtk
{

//SignalProxy_Mapping:

//This Signal Proxy allows the C++ coder to specify a SigC::Slot instead of a static function.
class SignalProxy_Mapping
{
public:
  typedef TreeView::SlotMapping SlotType;

  SignalProxy_Mapping(const SlotType& slot);
  ~SignalProxy_Mapping();

  static void gtk_callback(GtkTreeView* tree_view, GtkTreePath* path, gpointer data);

protected:
  SlotType slot_;
};

SignalProxy_Mapping::SignalProxy_Mapping(const SlotType& slot)
{
  slot_ = slot;
}

SignalProxy_Mapping::~SignalProxy_Mapping()
{
}

void SignalProxy_Mapping::gtk_callback(GtkTreeView* tree_view, GtkTreePath* path, gpointer data)
{
  SignalProxy_Mapping* pSignalProxy = static_cast<SignalProxy_Mapping*>(data);
  if(pSignalProxy)
  {
    //Use Slot::operator():
    TreeView* pCppTreeView = Glib::wrap(tree_view);
    TreePath cppTreePath = Glib::wrap(path, true); //true = copy
    (pSignalProxy->slot_)(pCppTreeView, cppTreePath);
  }
}


//SignalProxy_SearchEqual:

//This Signal Proxy allows the C++ coder to specify a SigC::Slot instead of a static function.
class SignalProxy_SearchEqual
{
public:
  typedef TreeView::SlotSearchEqual SlotType;

  SignalProxy_SearchEqual(const SlotType& slot);
  ~SignalProxy_SearchEqual();

  static gboolean gtk_callback(GtkTreeModel* model, gint column, const gchar* key, GtkTreeIter* iter, gpointer data);
  static void gtk_callback_destroy(gpointer data);

protected:
  SlotType slot_;
};

SignalProxy_SearchEqual::SignalProxy_SearchEqual(const SlotType& slot)
{
  slot_ = slot;
}

SignalProxy_SearchEqual::~SignalProxy_SearchEqual()
{
}

gboolean SignalProxy_SearchEqual::gtk_callback(GtkTreeModel* model, gint column, const gchar* key, GtkTreeIter* iter, gpointer data)
{
  SignalProxy_SearchEqual* pSignalProxy = static_cast<SignalProxy_SearchEqual*>(data);
  if(pSignalProxy)
  {
    //Use Slot::operator():
    Glib::RefPtr<TreeModel> refModel = Glib::wrap(model, true); //true = copy.
    TreeIter cppTreeIter = TreeIter(model, iter); //Seems to be the standard conversion, specified in an m4 macro in treeview.hg.
    return (gboolean)(pSignalProxy->slot_)(refModel, column, key, cppTreeIter);
  }

  return false; //arbitrary value.
}

void SignalProxy_SearchEqual::gtk_callback_destroy(gpointer data)
{
  SignalProxy_SearchEqual* pSignalProxy = static_cast<SignalProxy_SearchEqual*>(data);
  if(pSignalProxy)
    delete pSignalProxy;
}


//SignalProxy_ColumnDrop:

//This Signal Proxy allows the C++ coder to specify a SigC::Slot instead of a static function.
class SignalProxy_ColumnDrop
{
public:
  typedef TreeView::SlotColumnDrop SlotType;

  SignalProxy_ColumnDrop(const SlotType& slot);
  ~SignalProxy_ColumnDrop();

  static gboolean gtk_callback(GtkTreeView* tree_view, GtkTreeViewColumn* column, GtkTreeViewColumn* prev_column, GtkTreeViewColumn* next_column, gpointer data);
  static void gtk_callback_destroy(gpointer data);

protected:
  SlotType slot_;
};

SignalProxy_ColumnDrop::SignalProxy_ColumnDrop(const SlotType& slot)
{
  slot_ = slot;
}

SignalProxy_ColumnDrop::~SignalProxy_ColumnDrop()
{
}

gboolean SignalProxy_ColumnDrop::gtk_callback(GtkTreeView* tree_view, GtkTreeViewColumn* column, GtkTreeViewColumn* prev_column, GtkTreeViewColumn* next_column, gpointer data)
{
  SignalProxy_ColumnDrop* pSignalProxy = static_cast<SignalProxy_ColumnDrop*>(data);
  if(pSignalProxy)
  {
    //Use Slot::operator():
    TreeView* pCppTreeView = Glib::wrap(tree_view);
    TreeViewColumn* pCppColumn = Glib::wrap(column);
    TreeViewColumn* pCppColumnPrevious = Glib::wrap(column);
    TreeViewColumn* pCppColumnNext = Glib::wrap(column);

    return (gboolean)(pSignalProxy->slot_)(pCppTreeView, pCppColumn, pCppColumnPrevious, pCppColumnNext);
  }

  return false; //arbitrary value.
}

void SignalProxy_ColumnDrop::gtk_callback_destroy(gpointer data)
{
  SignalProxy_ColumnDrop* pSignalProxy = static_cast<SignalProxy_ColumnDrop*>(data);
  if(pSignalProxy)
    delete pSignalProxy;
}


//TreeView implementation:

int TreeView::insert_column_with_data_func(int position, const Glib::ustring& title, CellRenderer& cell, const SlotCellData& slot)
{
  //Create a signal proxy. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when TreeView_Private::SignalProxy_CellData::gtk_callback_destroy() is called.
  TreeView_Private::SignalProxy_CellData* pSignalProxy = new TreeView_Private::SignalProxy_CellData(slot);

  return gtk_tree_view_insert_column_with_data_func(gobj(), position, const_cast<char*>(title.c_str()), cell.gobj(),
    &TreeView_Private::SignalProxy_CellData::gtk_callback, (gpointer)pSignalProxy,
    &TreeView_Private::SignalProxy_CellData::gtk_callback_destroy);
}


void TreeView::get_cursor(TreePath& path, TreeViewColumn*& focus_column)
{
  GtkTreePath* pTreePath = 0;
  GtkTreeViewColumn* pTreeViewColumn = 0;
  gtk_tree_view_get_cursor(gobj(), &pTreePath, &pTreeViewColumn);

  path = TreePath(pTreePath);
  focus_column = Glib::wrap(pTreeViewColumn);
}

bool TreeView::get_path_at_pos(int x, int y, TreePath& path, TreeViewColumn*& column, int& cell_x, int& cell_y)
{
  GtkTreePath* pTreePath = 0;
  GtkTreeViewColumn* pTreeViewColumn = 0;
  bool result = gtk_tree_view_get_path_at_pos(gobj(), x, y, &pTreePath, &pTreeViewColumn, &cell_x, &cell_y);

  path = TreePath(pTreePath);
  column = Glib::wrap(pTreeViewColumn);
  return result;
}

int TreeView::insert_column(int position, const Glib::ustring& title, CellRenderer& cell)
{
  return gtk_tree_view_insert_column_with_attributes(
      gobj(), position, const_cast<char*>(title.c_str()), cell.gobj(), 0);
}

void TreeView::get_drag_dest_row(TreePath& path, TreeViewDropPosition& pos)
{
  GtkTreePath* pTreePath = 0;
  gtk_tree_view_get_drag_dest_row(gobj(), &pTreePath, (GtkTreeViewDropPosition*) &pos);
  path = Glib::wrap(pTreePath, true); //true = take_copy.
}

bool TreeView::get_dest_row_at_pos(int drag_x, int drag_y, TreePath& path, TreeViewDropPosition& pos)
{
  GtkTreePath* pTreePath = 0;
  gboolean bResult = gtk_tree_view_get_dest_row_at_pos(
      gobj(), drag_x, drag_y, &pTreePath, (GtkTreeViewDropPosition*) &pos);
  path = Glib::wrap(pTreePath, true); //true = take_copy.

  return bResult;
}

void TreeView::map_expanded_rows(const SlotMapping slot)
{
  //Create a signal proxy.
  SignalProxy_Mapping signalProxy(slot); //It only needs to live as long as this method call.

  gtk_tree_view_map_expanded_rows( gobj(), &SignalProxy_Mapping::gtk_callback, (gpointer)(&signalProxy) );
}

void TreeView::set_search_equal_func(const SlotSearchEqual& slot)
{
  //Create a signal proxy. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when SignalProxy_SearchEqual::gtk_callback_destroy() is called.
  SignalProxy_SearchEqual* pSignalProxy = new SignalProxy_SearchEqual(slot);

  gtk_tree_view_set_search_equal_func(gobj(),
    &SignalProxy_SearchEqual::gtk_callback, (gpointer)pSignalProxy,
    &SignalProxy_SearchEqual::gtk_callback_destroy);
}

void TreeView::set_column_drag_function(const SlotColumnDrop& slot)
{
  //Create a signal proxy. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when SignalProxy_ColumnDrop::gtk_callback_destroy() is called.
  SignalProxy_ColumnDrop* pSignalProxy = new SignalProxy_ColumnDrop(slot);

  gtk_tree_view_set_column_drag_function(gobj(),
    &SignalProxy_ColumnDrop::gtk_callback, (gpointer)pSignalProxy,
    &SignalProxy_ColumnDrop::gtk_callback_destroy);

}


} /* namespace Gtk */


namespace
{


void TreeView_signal_set_scroll_adjustments_callback(GtkTreeView*, GtkAdjustment* p0,GtkAdjustment* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,Adjustment*,Adjustment*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0)
,Glib::wrap(p1)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TreeView_signal_set_scroll_adjustments_info =
{
  "set-scroll-adjustments",
  (GCallback) &TreeView_signal_set_scroll_adjustments_callback,
  (GCallback) &TreeView_signal_set_scroll_adjustments_callback
};


void TreeView_signal_row_activated_callback(GtkTreeView*, GtkTreePath* p0,GtkTreeViewColumn* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const TreePath&,TreeViewColumn*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0, true)
,Glib::wrap(p1)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TreeView_signal_row_activated_info =
{
  "row-activated",
  (GCallback) &TreeView_signal_row_activated_callback,
  (GCallback) &TreeView_signal_row_activated_callback
};


gboolean TreeView_signal_test_expand_row_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<bool,const TreeIter&,const TreePath&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (TreeIter(gtk_tree_view_get_model(self), p0)
,Glib::wrap(p1, true)
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean TreeView_signal_test_expand_row_notify_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const TreeIter&,const TreePath&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (TreeIter(gtk_tree_view_get_model(self), p0)
,Glib::wrap(p1, true)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo TreeView_signal_test_expand_row_info =
{
  "test-expand-row",
  (GCallback) &TreeView_signal_test_expand_row_callback,
  (GCallback) &TreeView_signal_test_expand_row_notify_callback
};


gboolean TreeView_signal_test_collapse_row_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<bool,const TreeIter&,const TreePath&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (TreeIter(gtk_tree_view_get_model(self), p0)
,Glib::wrap(p1, true)
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean TreeView_signal_test_collapse_row_notify_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const TreeIter&,const TreePath&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (TreeIter(gtk_tree_view_get_model(self), p0)
,Glib::wrap(p1, true)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo TreeView_signal_test_collapse_row_info =
{
  "test-collapse-row",
  (GCallback) &TreeView_signal_test_collapse_row_callback,
  (GCallback) &TreeView_signal_test_collapse_row_notify_callback
};


void TreeView_signal_row_expanded_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const TreeIter&,const TreePath&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (TreeIter(gtk_tree_view_get_model(self), p0)
,Glib::wrap(p1, true)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TreeView_signal_row_expanded_info =
{
  "row-expanded",
  (GCallback) &TreeView_signal_row_expanded_callback,
  (GCallback) &TreeView_signal_row_expanded_callback
};


void TreeView_signal_row_collapsed_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const TreeIter&,const TreePath&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (TreeIter(gtk_tree_view_get_model(self), p0)
,Glib::wrap(p1, true)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TreeView_signal_row_collapsed_info =
{
  "row-collapsed",
  (GCallback) &TreeView_signal_row_collapsed_callback,
  (GCallback) &TreeView_signal_row_collapsed_callback
};


const Glib::SignalProxyInfo TreeView_signal_cursor_changed_info =
{
  "cursor-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo TreeView_signal_columns_changed_info =
{
  "columns-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


gboolean TreeView_signal_move_cursor_callback(GtkTreeView*, GtkMovementStep p0,gint p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<bool,MovementStep,int> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (((MovementStep)(p0))
,p1
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean TreeView_signal_move_cursor_notify_callback(GtkTreeView*, GtkMovementStep p0,gint p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,MovementStep,int> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (((MovementStep)(p0))
,p1
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo TreeView_signal_move_cursor_info =
{
  "move-cursor",
  (GCallback) &TreeView_signal_move_cursor_callback,
  (GCallback) &TreeView_signal_move_cursor_notify_callback
};


const Glib::SignalProxyInfo TreeView_signal_select_all_info =
{
  "select-all",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo TreeView_signal_unselect_all_info =
{
  "unselect-all",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


void TreeView_signal_select_cursor_row_callback(GtkTreeView*, gboolean p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TreeView_signal_select_cursor_row_info =
{
  "select-cursor-row",
  (GCallback) &TreeView_signal_select_cursor_row_callback,
  (GCallback) &TreeView_signal_select_cursor_row_callback
};


const Glib::SignalProxyInfo TreeView_signal_toggle_cursor_row_info =
{
  "toggle-cursor-row",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


void TreeView_signal_expand_collapse_cursor_row_callback(GtkTreeView*, gboolean p0,gboolean p1,gboolean p2,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot3<void,bool,bool,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
,p1
,p2
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TreeView_signal_expand_collapse_cursor_row_info =
{
  "expand-collapse-cursor-row",
  (GCallback) &TreeView_signal_expand_collapse_cursor_row_callback,
  (GCallback) &TreeView_signal_expand_collapse_cursor_row_callback
};


const Glib::SignalProxyInfo TreeView_signal_select_cursor_parent_info =
{
  "select-cursor-parent",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


const Glib::SignalProxyInfo TreeView_signal_start_interactive_search_info =
{
  "start-interactive-search",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace

// static
GType Glib::Value<Gtk::TreeViewDropPosition>::value_type()
{
  return gtk_tree_view_drop_position_get_type();
}


namespace Glib
{

Gtk::TreeView* wrap(GtkTreeView* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::TreeView *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType TreeView_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_tree_view_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void TreeView_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->set_scroll_adjustments = &set_scroll_adjustments_callback;
  klass->row_activated = &row_activated_callback;
  klass->test_expand_row = &test_expand_row_callback;
  klass->test_collapse_row = &test_collapse_row_callback;
  klass->row_expanded = &row_expanded_callback;
  klass->row_collapsed = &row_collapsed_callback;
  klass->cursor_changed = &cursor_changed_callback;
  klass->columns_changed = &columns_changed_callback;
  klass->move_cursor = &move_cursor_callback;
  klass->select_all = &select_all_callback;
  klass->unselect_all = &unselect_all_callback;
  klass->select_cursor_row = &select_cursor_row_callback;
  klass->toggle_cursor_row = &toggle_cursor_row_callback;
  klass->expand_collapse_cursor_row = &expand_collapse_cursor_row_callback;
  klass->select_cursor_parent = &select_cursor_parent_callback;
  klass->start_interactive_search = &start_interactive_search_callback;
}


void TreeView_Class::set_scroll_adjustments_callback(GtkTreeView* self, GtkAdjustment* p0, GtkAdjustment* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_set_scroll_adjustments(Glib::wrap(p0)
, Glib::wrap(p1)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->set_scroll_adjustments)
      (*base->set_scroll_adjustments)(self, p0, p1);
  }
}

void TreeView_Class::row_activated_callback(GtkTreeView* self, GtkTreePath* p0, GtkTreeViewColumn* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_row_activated(Glib::wrap(p0, true)
, Glib::wrap(p1)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->row_activated)
      (*base->row_activated)(self, p0, p1);
  }
}

gboolean TreeView_Class::test_expand_row_callback(GtkTreeView* self, GtkTreeIter* p0, GtkTreePath* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_test_expand_row(TreeIter(gtk_tree_view_get_model(self), p0)
, Glib::wrap(p1, true)
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->test_expand_row)
      (*base->test_expand_row)(self, p0, p1);
  }

  typedef gboolean RType;
  return RType();
}

gboolean TreeView_Class::test_collapse_row_callback(GtkTreeView* self, GtkTreeIter* p0, GtkTreePath* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_test_collapse_row(TreeIter(gtk_tree_view_get_model(self), p0)
, Glib::wrap(p1, true)
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->test_collapse_row)
      (*base->test_collapse_row)(self, p0, p1);
  }

  typedef gboolean RType;
  return RType();
}

void TreeView_Class::row_expanded_callback(GtkTreeView* self, GtkTreeIter* p0, GtkTreePath* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_row_expanded(TreeIter(gtk_tree_view_get_model(self), p0)
, Glib::wrap(p1, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->row_expanded)
      (*base->row_expanded)(self, p0, p1);
  }
}

void TreeView_Class::row_collapsed_callback(GtkTreeView* self, GtkTreeIter* p0, GtkTreePath* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_row_collapsed(TreeIter(gtk_tree_view_get_model(self), p0)
, Glib::wrap(p1, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->row_collapsed)
      (*base->row_collapsed)(self, p0, p1);
  }
}

void TreeView_Class::cursor_changed_callback(GtkTreeView* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_cursor_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->cursor_changed)
      (*base->cursor_changed)(self);
  }
}

void TreeView_Class::columns_changed_callback(GtkTreeView* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_columns_changed();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->columns_changed)
      (*base->columns_changed)(self);
  }
}

gboolean TreeView_Class::move_cursor_callback(GtkTreeView* self, GtkMovementStep p0, gint p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_move_cursor(((MovementStep)(p0))
, p1
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->move_cursor)
      (*base->move_cursor)(self, p0, p1);
  }

  typedef gboolean RType;
  return RType();
}

void TreeView_Class::select_all_callback(GtkTreeView* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_select_all();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->select_all)
      (*base->select_all)(self);
  }
}

void TreeView_Class::unselect_all_callback(GtkTreeView* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_unselect_all();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->unselect_all)
      (*base->unselect_all)(self);
  }
}

void TreeView_Class::select_cursor_row_callback(GtkTreeView* self, gboolean p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_select_cursor_row(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->select_cursor_row)
      (*base->select_cursor_row)(self, p0);
  }
}

void TreeView_Class::toggle_cursor_row_callback(GtkTreeView* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_toggle_cursor_row();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->toggle_cursor_row)
      (*base->toggle_cursor_row)(self);
  }
}

void TreeView_Class::expand_collapse_cursor_row_callback(GtkTreeView* self, gboolean p0, gboolean p1, gboolean p2)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_expand_collapse_cursor_row(p0
, p1
, p2
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->expand_collapse_cursor_row)
      (*base->expand_collapse_cursor_row)(self, p0, p1, p2);
  }
}

void TreeView_Class::select_cursor_parent_callback(GtkTreeView* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_select_cursor_parent();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->select_cursor_parent)
      (*base->select_cursor_parent)(self);
  }
}

void TreeView_Class::start_interactive_search_callback(GtkTreeView* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_start_interactive_search();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->start_interactive_search)
      (*base->start_interactive_search)(self);
  }
}


Glib::ObjectBase* TreeView_Class::wrap_new(GObject* o)
{
  return manage(new TreeView((GtkTreeView*)(o)));
}


/* The implementation: */

TreeView::TreeView(GtkTreeView* castitem)
: Gtk::Container((GtkContainer*)(castitem))
{}

TreeView::~TreeView()
{
  destroy_();
}

TreeView::CppClassType TreeView::treeview_class_; //Initialize static member.

GType TreeView::get_type()
{
  return treeview_class_.get_type();
}

GType TreeView::get_base_type()
{
  return gtk_tree_view_get_type();
}

TreeView::TreeView()
: Gtk::Container((GtkContainer*)(g_object_new(get_type(), (char*)0)))
{}

TreeView::TreeView(const Glib::RefPtr<TreeModel>& model)
: Gtk::Container((GtkContainer*)( g_object_new(get_type(), "model", Glib::unwrap(model), (char*)0) ))
{}

Glib::RefPtr<TreeModel> TreeView::get_model()
{
  Glib::RefPtr<TreeModel> retvalue = Glib::wrap(gtk_tree_view_get_model(gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void TreeView::set_model(const Glib::RefPtr<TreeModel>& model)
{
  gtk_tree_view_set_model(gobj(), Glib::unwrap(model));
}

Glib::RefPtr<TreeSelection> TreeView::get_selection()
{
  Glib::RefPtr<TreeSelection> retvalue = Glib::wrap(gtk_tree_view_get_selection(gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Adjustment* TreeView::get_hadjustment()
{
  return Glib::wrap(gtk_tree_view_get_hadjustment(gobj()));
}

void TreeView::set_hadjustment(Adjustment& adjustment)
{
  gtk_tree_view_set_hadjustment(gobj(), (adjustment).gobj());
}

Adjustment* TreeView::get_vadjustment()
{
  return Glib::wrap(gtk_tree_view_get_vadjustment(gobj()));
}

void TreeView::set_vadjustment(Adjustment& adjustment)
{
  gtk_tree_view_set_vadjustment(gobj(), (adjustment).gobj());
}

bool TreeView::get_headers_visible()
{
  return gtk_tree_view_get_headers_visible(gobj());
}

void TreeView::set_headers_visible(bool headers_visible)
{
  gtk_tree_view_set_headers_visible(gobj(), static_cast<int>(headers_visible));
}

void TreeView::columns_autosize()
{
  gtk_tree_view_columns_autosize(gobj());
}

void TreeView::set_headers_clickable(bool setting)
{
  gtk_tree_view_set_headers_clickable(gobj(), static_cast<int>(setting));
}

void TreeView::set_rules_hint(bool setting)
{
  gtk_tree_view_set_rules_hint(gobj(), static_cast<int>(setting));
}

bool TreeView::get_rules_hint()
{
  return gtk_tree_view_get_rules_hint(gobj());
}

int TreeView::append_column(TreeViewColumn& column)
{
  return gtk_tree_view_append_column(gobj(), (column).gobj());
}

int TreeView::remove_column(TreeViewColumn& column)
{
  return gtk_tree_view_remove_column(gobj(), (column).gobj());
}

int TreeView::insert_column(TreeViewColumn& column, int position)
{
  return gtk_tree_view_insert_column(gobj(), (column).gobj(), position);
}

TreeViewColumn* TreeView::get_column(int n)
{
  return Glib::wrap(gtk_tree_view_get_column(gobj(), n));
}

Glib::ListHandle<TreeViewColumn*> TreeView::get_columns()
{
  return Glib::ListHandle<TreeViewColumn*>(gtk_tree_view_get_columns(gobj()), Glib::OWNERSHIP_SHALLOW);
}

void TreeView::move_column_after(TreeViewColumn& column, TreeViewColumn& base_column)
{
  gtk_tree_view_move_column_after(gobj(), (column).gobj(), (base_column).gobj());
}

void TreeView::set_expander_column(TreeViewColumn& column)
{
  gtk_tree_view_set_expander_column(gobj(), (column).gobj());
}

TreeViewColumn* TreeView::get_expander_column()
{
  return Glib::wrap(gtk_tree_view_get_expander_column(gobj()));
}

void TreeView::scroll_to_point(int tree_x, int tree_y)
{
  gtk_tree_view_scroll_to_point(gobj(), tree_x, tree_y);
}

void TreeView::scroll_to_cell(const TreePath& path, TreeViewColumn& column, bool use_align, float row_align, float col_align)
{
  gtk_tree_view_scroll_to_cell(gobj(), const_cast<GtkTreePath*>((path).gobj()), (column).gobj(), static_cast<int>(use_align), row_align, col_align);
}

void TreeView::row_activated(const TreePath& path, TreeViewColumn& column)
{
  gtk_tree_view_row_activated(gobj(), const_cast<GtkTreePath*>((path).gobj()), (column).gobj());
}

void TreeView::expand_all()
{
  gtk_tree_view_expand_all(gobj());
}

void TreeView::collapse_all()
{
  gtk_tree_view_collapse_all(gobj());
}

bool TreeView::expand_row(const TreePath& path, bool open_all)
{
  return gtk_tree_view_expand_row(gobj(), const_cast<GtkTreePath*>((path).gobj()), static_cast<int>(open_all));
}

bool TreeView::collapse_row(const TreePath& path)
{
  return gtk_tree_view_collapse_row(gobj(), const_cast<GtkTreePath*>((path).gobj()));
}

bool TreeView::row_expanded(const TreePath& path)
{
  return gtk_tree_view_row_expanded(gobj(), const_cast<GtkTreePath*>((path).gobj()));
}

void TreeView::set_reorderable(bool reorderable)
{
  gtk_tree_view_set_reorderable(gobj(), static_cast<int>(reorderable));
}

bool TreeView::get_reorderable()
{
  return gtk_tree_view_get_reorderable(gobj());
}

void TreeView::set_cursor(const TreePath& path, TreeViewColumn& focus_column, bool start_editing)
{
  gtk_tree_view_set_cursor(gobj(), const_cast<GtkTreePath*>((path).gobj()), (focus_column).gobj(), static_cast<int>(start_editing));
}

Glib::RefPtr<Gdk::Window> TreeView::get_bin_window()
{
  Glib::RefPtr<Gdk::Window> retvalue = Gdk::Window::wrap_specific_type(gtk_tree_view_get_bin_window(gobj()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void TreeView::get_cell_area(const TreePath& path, TreeViewColumn& column, Gdk::Rectangle& rect)
{
  gtk_tree_view_get_cell_area(gobj(), const_cast<GtkTreePath*>((path).gobj()), (column).gobj(), (rect).gobj());
}

void TreeView::get_background_area(const TreePath& path, TreeViewColumn& column, Gdk::Rectangle& rect)
{
  gtk_tree_view_get_background_area(gobj(), const_cast<GtkTreePath*>((path).gobj()), (column).gobj(), (rect).gobj());
}

void TreeView::get_visible_rect(Gdk::Rectangle& visible_rect)
{
  gtk_tree_view_get_visible_rect(gobj(), (visible_rect).gobj());
}

void TreeView::widget_to_tree_coords(int wx, int wy, int& tx, int& ty)
{
  gtk_tree_view_widget_to_tree_coords(gobj(), wx, wy, &tx, &ty);
}

void TreeView::tree_to_widget_coords(int tx, int ty, int& wx, int& wy)
{
  gtk_tree_view_tree_to_widget_coords(gobj(), tx, ty, &wx, &wy);
}

void TreeView::enable_model_drag_source(Gdk::ModifierType start_button_mask, const GtkTargetEntry* targets, int n_targets, Gdk::DragAction actions)
{
  gtk_tree_view_enable_model_drag_source(gobj(), ((GdkModifierType)(start_button_mask)), targets, n_targets, ((GdkDragAction)(actions)));
}

void TreeView::enable_model_drag_dest(const GtkTargetEntry* targets, int n_targets, Gdk::DragAction actions)
{
  gtk_tree_view_enable_model_drag_dest(gobj(), targets, n_targets, ((GdkDragAction)(actions)));
}

void TreeView::unset_rows_drag_source()
{
  gtk_tree_view_unset_rows_drag_source(gobj());
}

void TreeView::unset_rows_drag_dest()
{
  gtk_tree_view_unset_rows_drag_dest(gobj());
}

void TreeView::set_drag_dest_row(const TreePath& path, TreeViewDropPosition pos)
{
  gtk_tree_view_set_drag_dest_row(gobj(), const_cast<GtkTreePath*>((path).gobj()), ((GtkTreeViewDropPosition)(pos)));
}

Glib::RefPtr<Gdk::Pixmap> TreeView::create_row_drag_icon(const TreePath& path)
{
  return Gdk::Pixmap::wrap_specific_type(gtk_tree_view_create_row_drag_icon(gobj(), const_cast<GtkTreePath*>((path).gobj())));
}

void TreeView::set_enable_search(bool enable_search)
{
  gtk_tree_view_set_enable_search(gobj(), static_cast<int>(enable_search));
}

bool TreeView::get_enable_search()
{
  return gtk_tree_view_get_enable_search(gobj());
}

int TreeView::get_search_column()
{
  return gtk_tree_view_get_search_column(gobj());
}

void TreeView::set_search_column(int column)
{
  gtk_tree_view_set_search_column(gobj(), column);
}


Glib::SignalProxy2<void,Adjustment*,Adjustment*> TreeView::signal_set_scroll_adjustments()
{
  return Glib::SignalProxy2<void,Adjustment*,Adjustment*>(this, &TreeView_signal_set_scroll_adjustments_info);
}

Glib::SignalProxy2<void,const TreePath&,TreeViewColumn*> TreeView::signal_row_activated()
{
  return Glib::SignalProxy2<void,const TreePath&,TreeViewColumn*>(this, &TreeView_signal_row_activated_info);
}

Glib::SignalProxy2<bool,const TreeIter&,const TreePath&> TreeView::signal_test_expand_row()
{
  return Glib::SignalProxy2<bool,const TreeIter&,const TreePath&>(this, &TreeView_signal_test_expand_row_info);
}

Glib::SignalProxy2<bool,const TreeIter&,const TreePath&> TreeView::signal_test_collapse_row()
{
  return Glib::SignalProxy2<bool,const TreeIter&,const TreePath&>(this, &TreeView_signal_test_collapse_row_info);
}

Glib::SignalProxy2<void,const TreeIter&,const TreePath&> TreeView::signal_row_expanded()
{
  return Glib::SignalProxy2<void,const TreeIter&,const TreePath&>(this, &TreeView_signal_row_expanded_info);
}

Glib::SignalProxy2<void,const TreeIter&,const TreePath&> TreeView::signal_row_collapsed()
{
  return Glib::SignalProxy2<void,const TreeIter&,const TreePath&>(this, &TreeView_signal_row_collapsed_info);
}

Glib::SignalProxy0<void> TreeView::signal_cursor_changed()
{
  return Glib::SignalProxy0<void>(this, &TreeView_signal_cursor_changed_info);
}

Glib::SignalProxy0<void> TreeView::signal_columns_changed()
{
  return Glib::SignalProxy0<void>(this, &TreeView_signal_columns_changed_info);
}

Glib::SignalProxy2<bool,MovementStep,int> TreeView::signal_move_cursor()
{
  return Glib::SignalProxy2<bool,MovementStep,int>(this, &TreeView_signal_move_cursor_info);
}

Glib::SignalProxy0<void> TreeView::signal_select_all()
{
  return Glib::SignalProxy0<void>(this, &TreeView_signal_select_all_info);
}

Glib::SignalProxy0<void> TreeView::signal_unselect_all()
{
  return Glib::SignalProxy0<void>(this, &TreeView_signal_unselect_all_info);
}

Glib::SignalProxy1<void,bool> TreeView::signal_select_cursor_row()
{
  return Glib::SignalProxy1<void,bool>(this, &TreeView_signal_select_cursor_row_info);
}

Glib::SignalProxy0<void> TreeView::signal_toggle_cursor_row()
{
  return Glib::SignalProxy0<void>(this, &TreeView_signal_toggle_cursor_row_info);
}

Glib::SignalProxy3<void,bool,bool,bool> TreeView::signal_expand_collapse_cursor_row()
{
  return Glib::SignalProxy3<void,bool,bool,bool>(this, &TreeView_signal_expand_collapse_cursor_row_info);
}

Glib::SignalProxy0<void> TreeView::signal_select_cursor_parent()
{
  return Glib::SignalProxy0<void>(this, &TreeView_signal_select_cursor_parent_info);
}

Glib::SignalProxy0<void> TreeView::signal_start_interactive_search()
{
  return Glib::SignalProxy0<void>(this, &TreeView_signal_start_interactive_search_info);
}


Glib::PropertyProxy< Glib::RefPtr<TreeModel> > TreeView::property_model()
{
  return Glib::PropertyProxy< Glib::RefPtr<TreeModel> >(this, "model");
}

Glib::PropertyProxy<Adjustment*> TreeView::property_hadjustment()
{
  return Glib::PropertyProxy<Adjustment*>(this, "hadjustment");
}

Glib::PropertyProxy<Adjustment*> TreeView::property_vadjustment()
{
  return Glib::PropertyProxy<Adjustment*>(this, "vadjustment");
}

Glib::PropertyProxy<bool> TreeView::property_headers_visible()
{
  return Glib::PropertyProxy<bool>(this, "headers_visible");
}

Glib::PropertyProxy_WriteOnly<bool> TreeView::property_headers_clickable()
{
  return Glib::PropertyProxy_WriteOnly<bool>(this, "headers_clickable");
}

Glib::PropertyProxy<TreeViewColumn*> TreeView::property_expander_column()
{
  return Glib::PropertyProxy<TreeViewColumn*>(this, "expander_column");
}

Glib::PropertyProxy<bool> TreeView::property_reorderable()
{
  return Glib::PropertyProxy<bool>(this, "reorderable");
}

Glib::PropertyProxy<bool> TreeView::property_rules_hint()
{
  return Glib::PropertyProxy<bool>(this, "rules_hint");
}

Glib::PropertyProxy<bool> TreeView::property_enable_search()
{
  return Glib::PropertyProxy<bool>(this, "enable_search");
}

Glib::PropertyProxy<int> TreeView::property_search_column()
{
  return Glib::PropertyProxy<int>(this, "search_column");
}


void Gtk::TreeView::on_set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->set_scroll_adjustments)
    (*base->set_scroll_adjustments)(gobj(),(GtkAdjustment*)Glib::unwrap(hadjustment),(GtkAdjustment*)Glib::unwrap(vadjustment));
}

void Gtk::TreeView::on_row_activated(const TreePath& path, TreeViewColumn* column)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->row_activated)
    (*base->row_activated)(gobj(),const_cast<GtkTreePath*>((path).gobj()),(GtkTreeViewColumn*)Glib::unwrap(column));
}

bool Gtk::TreeView::on_test_expand_row(const TreeIter& iter, const TreePath& path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->test_expand_row)
    return (*base->test_expand_row)(gobj(),const_cast<GtkTreeIter*>((iter).gobj()),const_cast<GtkTreePath*>((path).gobj()));

  typedef bool RType;
  return RType();
}

bool Gtk::TreeView::on_test_collapse_row(const TreeIter& iter, const TreePath& path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->test_collapse_row)
    return (*base->test_collapse_row)(gobj(),const_cast<GtkTreeIter*>((iter).gobj()),const_cast<GtkTreePath*>((path).gobj()));

  typedef bool RType;
  return RType();
}

void Gtk::TreeView::on_row_expanded(const TreeIter& iter, const TreePath& path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->row_expanded)
    (*base->row_expanded)(gobj(),const_cast<GtkTreeIter*>((iter).gobj()),const_cast<GtkTreePath*>((path).gobj()));
}

void Gtk::TreeView::on_row_collapsed(const TreeIter& iter, const TreePath& path)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->row_collapsed)
    (*base->row_collapsed)(gobj(),const_cast<GtkTreeIter*>((iter).gobj()),const_cast<GtkTreePath*>((path).gobj()));
}

void Gtk::TreeView::on_cursor_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->cursor_changed)
    (*base->cursor_changed)(gobj());
}

void Gtk::TreeView::on_columns_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->columns_changed)
    (*base->columns_changed)(gobj());
}

bool Gtk::TreeView::on_move_cursor(MovementStep step, int count)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->move_cursor)
    return (*base->move_cursor)(gobj(),((GtkMovementStep)(step)),count);

  typedef bool RType;
  return RType();
}

void Gtk::TreeView::on_select_all()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->select_all)
    (*base->select_all)(gobj());
}

void Gtk::TreeView::on_unselect_all()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->unselect_all)
    (*base->unselect_all)(gobj());
}

void Gtk::TreeView::on_select_cursor_row(bool start_editing)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->select_cursor_row)
    (*base->select_cursor_row)(gobj(),static_cast<int>(start_editing));
}

void Gtk::TreeView::on_toggle_cursor_row()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->toggle_cursor_row)
    (*base->toggle_cursor_row)(gobj());
}

void Gtk::TreeView::on_expand_collapse_cursor_row(bool logical, bool expand, bool open_all)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->expand_collapse_cursor_row)
    (*base->expand_collapse_cursor_row)(gobj(),static_cast<int>(logical),static_cast<int>(expand),static_cast<int>(open_all));
}

void Gtk::TreeView::on_select_cursor_parent()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->select_cursor_parent)
    (*base->select_cursor_parent)(gobj());
}

void Gtk::TreeView::on_start_interactive_search()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->start_interactive_search)
    (*base->start_interactive_search)(gobj());
}


} // namespace Gtk

