
#include <gtkmm/statusbar.h>
#include <gtkmm/private/statusbar_p.h>

// -*- c++ -*-
/* $Id: statusbar.ccg,v 1.5 2002/04/21 23:37:06 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkstatusbar.h>

namespace Gtk
{

guint Statusbar::push(const Glib::ustring& text, guint context_id /* = 0 */)
{
  return gtk_statusbar_push(gobj(), context_id, text.c_str());
}

void Statusbar::remove_message(guint message_id, guint context_id /* = 0 */)
{
  return gtk_statusbar_remove(gobj(), context_id, message_id);
}

} /* namespace Gtk */


namespace
{


void Statusbar_signal_text_pushed_callback(GtkStatusbar*, guint p0,const gchar* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,guint,const Glib::ustring&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0,Glib::convert_const_gchar_ptr_to_ustring(p1)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Statusbar_signal_text_pushed_info =
{
  "text_pushed",
  (GCallback) &Statusbar_signal_text_pushed_callback,
  (GCallback) &Statusbar_signal_text_pushed_callback
};


void Statusbar_signal_text_popped_callback(GtkStatusbar*, guint p0,const gchar* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,guint,const Glib::ustring&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0,Glib::convert_const_gchar_ptr_to_ustring(p1)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Statusbar_signal_text_popped_info =
{
  "text_popped",
  (GCallback) &Statusbar_signal_text_popped_callback,
  (GCallback) &Statusbar_signal_text_popped_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::Statusbar* wrap(GtkStatusbar* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Statusbar *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Statusbar_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_statusbar_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Statusbar_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->text_pushed = &text_pushed_callback;
  klass->text_popped = &text_popped_callback;
}


void Statusbar_Class::text_pushed_callback(GtkStatusbar* self, guint p0, const gchar* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_text_pushed(p0, Glib::convert_const_gchar_ptr_to_ustring(p1)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->text_pushed)
      (*base->text_pushed)(self, p0, p1);
  }
}

void Statusbar_Class::text_popped_callback(GtkStatusbar* self, guint p0, const gchar* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_text_popped(p0, Glib::convert_const_gchar_ptr_to_ustring(p1)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->text_popped)
      (*base->text_popped)(self, p0, p1);
  }
}


Glib::ObjectBase* Statusbar_Class::wrap_new(GObject* o)
{
  return manage(new Statusbar((GtkStatusbar*)(o)));
}


/* The implementation: */

Statusbar::Statusbar(GtkStatusbar* castitem)
: Gtk::HBox((GtkHBox*)(castitem))
{}

Statusbar::~Statusbar()
{
  destroy_();
}

Statusbar::CppClassType Statusbar::statusbar_class_; //Initialize static member.

GType Statusbar::get_type()
{
  return statusbar_class_.get_type();
}

GType Statusbar::get_base_type()
{
  return gtk_statusbar_get_type();
}

Statusbar::Statusbar()
: Gtk::HBox((GtkHBox*)(g_object_new(get_type(), (char*)0)))
{}

guint Statusbar::get_context_id(const Glib::ustring& context_description)
{
  return gtk_statusbar_get_context_id(gobj(), context_description.c_str());
}

void Statusbar::pop(guint context_id)
{
  gtk_statusbar_pop(gobj(), context_id);
}

void Statusbar::set_has_resize_grip(bool setting)
{
  gtk_statusbar_set_has_resize_grip(gobj(), static_cast<int>(setting));
}

bool Statusbar::get_has_resize_grip() const
{
  return gtk_statusbar_get_has_resize_grip(const_cast<GtkStatusbar*>(gobj()));
}


Glib::SignalProxy2<void,guint,const Glib::ustring&> Statusbar::signal_text_pushed()
{
  return Glib::SignalProxy2<void,guint,const Glib::ustring&>(this, &Statusbar_signal_text_pushed_info);
}

Glib::SignalProxy2<void,guint,const Glib::ustring&> Statusbar::signal_text_popped()
{
  return Glib::SignalProxy2<void,guint,const Glib::ustring&>(this, &Statusbar_signal_text_popped_info);
}


void Gtk::Statusbar::on_text_pushed(guint context_id, const Glib::ustring& text)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->text_pushed)
    (*base->text_pushed)(gobj(),context_id,text.c_str());
}

void Gtk::Statusbar::on_text_popped(guint context_id, const Glib::ustring& text)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->text_popped)
    (*base->text_popped)(gobj(),context_id,text.c_str());
}


} // namespace Gtk

