
#include <gtkmm/fixed.h>
#include <gtkmm/private/fixed_p.h>

// -*- c++ -*-
/* $Id: fixed.ccg,v 1.2 2001/05/10 22:47:54 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkfixed.h>

namespace Gtk
{
}


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Fixed* wrap(GtkFixed* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Fixed *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Fixed_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_fixed_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Fixed_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Fixed_Class::wrap_new(GObject* o)
{
  return manage(new Fixed((GtkFixed*)(o)));
}


/* The implementation: */

Fixed::Fixed(GtkFixed* castitem)
: Gtk::Container((GtkContainer*)(castitem))
{}

Fixed::~Fixed()
{
  destroy_();
}

Fixed::CppClassType Fixed::fixed_class_; //Initialize static member.

GType Fixed::get_type()
{
  return fixed_class_.get_type();
}

GType Fixed::get_base_type()
{
  return gtk_fixed_get_type();
}

Fixed::Fixed()
: Gtk::Container((GtkContainer*)(g_object_new(get_type(), (char*)0)))
{}

void Fixed::put(Widget& widget, int x, int y)
{
  gtk_fixed_put(gobj(), (widget).Gtk::Widget::gobj(), x, y);
}

void Fixed::move(Widget& widget, int x, int y)
{
  gtk_fixed_move(gobj(), (widget).Gtk::Widget::gobj(), x, y);
}

void Fixed::set_has_window(bool has_window)
{
  gtk_fixed_set_has_window(gobj(), static_cast<int>(has_window));
}

bool Fixed::get_has_window() const
{
  return gtk_fixed_get_has_window(const_cast<GtkFixed*>(gobj()));
}


} // namespace Gtk

