
#include <gtkmm/accellabel.h>
#include <gtkmm/private/accellabel_p.h>

// -*- c++ -*-
/* $Id: accellabel.ccg,v 1.9 2002/04/02 13:25:13 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkaccellabel.h>
#include <glibmm/wrap.h>

namespace Gtk
{

AccelLabel::AccelLabel(const Glib::ustring& label, bool mnemonic /* = false */)
: Gtk::Label((GtkLabel*)( g_object_new( get_type(), (char*)0 ) ))
{
  if(mnemonic)
    set_text_with_mnemonic(label);
  else
    set_text(label);
}

} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::AccelLabel* wrap(GtkAccelLabel* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::AccelLabel *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType AccelLabel_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_accel_label_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void AccelLabel_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* AccelLabel_Class::wrap_new(GObject* o)
{
  return manage(new AccelLabel((GtkAccelLabel*)(o)));
}


/* The implementation: */

AccelLabel::AccelLabel(GtkAccelLabel* castitem)
: Gtk::Label((GtkLabel*)(castitem))
{}

AccelLabel::~AccelLabel()
{
  destroy_();
}

AccelLabel::CppClassType AccelLabel::accellabel_class_; //Initialize static member.

GType AccelLabel::get_type()
{
  return accellabel_class_.get_type();
}

GType AccelLabel::get_base_type()
{
  return gtk_accel_label_get_type();
}

AccelLabel::AccelLabel()
: Gtk::Label((GtkLabel*)(g_object_new(get_type(), (char*)0)))
{}

void AccelLabel::set_accel_widget(const Widget& widget)
{
  gtk_accel_label_set_accel_widget(gobj(), const_cast<GtkWidget*>((widget).gobj()));
}

Widget* AccelLabel::get_accel_widget()
{
  return Glib::wrap(gtk_accel_label_get_accel_widget(gobj()));
}

guint AccelLabel::get_accel_width() const
{
  return gtk_accel_label_get_accel_width(const_cast<GtkAccelLabel*>(gobj()));
}

bool AccelLabel::refetch()
{
  return gtk_accel_label_refetch(gobj());
}


Glib::PropertyProxy<Gtk::Widget*> AccelLabel::property_accel_widget()
{
  return Glib::PropertyProxy<Gtk::Widget*>(this, "accel_widget");
}


} // namespace Gtk

