// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GLIBMM_THREAD_H
#define _GLIBMM_THREAD_H


/* $Id: thread.hg,v 1.1 2002/04/28 04:08:24 daniel Exp $ */

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glib/gthread.h>
#include <cstddef>

#include <sigc++/sigc++.h>
#include <glibmm/error.h>
#include <glibmm/timeval.h>


/** Initializer macro for Glib::StaticMutex.
 * @relates Glib::StaticMutex
 * @hideinitializer
 */
#define GLIBMM_STATIC_MUTEX_INIT { G_STATIC_MUTEX_INIT }

/** Initializer macro for Glib::StaticRecMutex.
 * @relates Glib::StaticRecMutex
 * @hideinitializer
 */
#define GLIBMM_STATIC_REC_MUTEX_INIT { G_STATIC_REC_MUTEX_INIT }

/** Initializer macro for Glib::StaticRWLock.
 * @relates Glib::StaticRWLock
 * @hideinitializer
 */
#define GLIBMM_STATIC_RW_LOCK_INIT { G_STATIC_RW_LOCK_INIT }

/** Initializer macro for Glib::StaticPrivate.
 * @relates Glib::StaticPrivate
 * @hideinitializer
 */
#define GLIBMM_STATIC_PRIVATE_INIT { G_STATIC_PRIVATE_INIT }


namespace Glib
{

/** @defgroup Threads Threads
 * Thread abstraction; including threads, different mutexes,
 * conditions and thread private data.
 * @{
 */

/** Initializes the GLib thread system.
 * Before you use a thread related function in glibmm, you should initialize
 * the thread system.  This is done by calling Glib::thread_init().
 *
 * @note You should only call thread_init() with a non-<tt>0</tt> parameter
 * if you really know what you are doing.
 *
 * @note thread_init() must not be called directly or indirectly as
 * a callback from glibmm.  Also no mutexes may be currently locked while
 * calling thread_init().
 *
 * thread_init() might only be called once.  On the second call it will
 * abort with an error.  If you want to make sure that the thread system
 * is initialized, you can do that too:
 * @code
 * if(!Glib::thread_supported()) Glib::thread_init();
 * @endcode
 * After that line either the thread system is initialized, or the program
 * will abort if no thread system is available in GLib, i.e. either
 * @c G_THREADS_ENABLED is not defined or @c G_THREADS_IMPL_NONE is defined.
 *
 * If no thread system is available and @a vtable is <tt>0</tt> or if not all
 * elements of @a vtable are non-<tt>0</tt>, then thread_init() will abort.
 *
 * @note To use thread_init() in your program, you have to link with the
 * libraries that the command <tt>pkg-config&nbsp;--libs&nbsp;gthread-2.0</tt>
 * outputs.  This is not the case for all the other thread related functions
 * of glibmm.  Those can be used without having to link with the thread
 * libraries.  (You @em have to link with <tt>gthread-2.0</tt> if you actually
 * want to use threads in your application, though.)
 *
 * @param vtable A function table of type @c GThreadFunctions, that provides
 * the entry points to the thread system to be used.
 */
inline void thread_init(GThreadFunctions* vtable = 0);

/** Returns whether the thread system is initialized.
 * @return @c true, if the thread system is initialized.
 */
inline bool thread_supported();


class Mutex;
class RecMutex;
class RWLock;
class StaticMutex;
class StaticRecMutex;
class StaticRWLock;


/** Exception class for thread-related errors.
 */
class ThreadError : public Glib::Error
{
public:
  enum Code
  {
    AGAIN
  };

  explicit ThreadError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:
  static void throw_func(GError* gobject);
  friend void wrap_init(); // uses throw_func()
#endif
};


/** Represents a running thread.
 * An instance of this class can only be obtained with create(), self(),
 * or wrap(GThread*).  It's not possible to delete a Thread object.  If the
 * thread is @em not joinable, its resources will be freed automatically
 * when it exits.  Otherwise, if the thread @em is joinable, you must call
 * join() to avoid a memory leak.
 *
 * @note g_thread_exit() is not wrapped, because that function exits a thread
 * without any cleanup.  That's especially dangerous in C++ code, since the
 * destructors of automatic object won't be invoked.  Instead, you can throw
 * a Thread::Exit exception, which will be caught by the internal thread
 * entry function.
 *
 * @note You might have noticed that the thread entry slot doesn't have the
 * usual void* return value.  If you want to return any data from your thread
 * you can pass an additional output argument to the thread's entry slot.
 */
class Thread
{
public:
  class Exit;

  /** Creates a new thread with the priority @c G_THREAD_PRIORITY_NORMAL.
   * If @a joinable is @c true, you can wait for this thread's termination by
   * calling join().  Otherwise the thread will just disappear, when ready.
   *
   * The new thread executes the function or method @a slot points to.  You can
   * pass additional arguments using SigC::bind().  If the thread was created
   * successfully, it is returned, otherwise a ThreadError exception is thrown.
   *
   * @param slot A slot to execute in the new thread.
   * @param joinable Should this thread be joinable?
   * @return The new Thread* on success.
   * @throw Glib::ThreadError
   */
  static Thread* create(const SigC::Slot0<void>& slot, bool joinable);

  /** Creates a new thread with the priority @a priority. The stack gets the
   * size @a stack_size or the default value for the current platform, if
   * @a stack_size is <tt>0</tt>.
   *
   * If @a joinable is @c true, you can wait for this thread's termination by
   * calling join().  Otherwise the thread will just disappear, when ready.
   * If @a bound is @c true, this thread will be scheduled in the system scope,
   * otherwise the implementation is free to do scheduling in the process
   * scope.  The first variant is more expensive resource-wise, but generally
   * faster.  On some systems (e.g. Linux) all threads are bound.
   *
   * The new thread executes the function or method @a slot points to.  You can
   * pass additional arguments using SigC::bind().  If the thread was created
   * successfully, it is returned.
   *
   * @note It is not guaranteed, that threads with different priorities really
   * behave accordingly.  On some systems (e.g. Linux) only root can increase
   * priorities.  On other systems (e.g. Solaris) there doesn't seem to be
   * different scheduling for different priorities.  All in all try to avoid
   * being dependent on priorities.  Use @c G_THREAD_PRIORITY_NORMAL here as
   * a default.
   *
   * @note Only use the extended
   * create(const SigC::Slot0<void>&, unsigned long, bool, bool, GThreadPriority)
   * function, when you really can't use the simple
   * create(const SigC::Slot0<void>&, bool)
   * instead.  The latter overload does not take @a stack_size, @a bound and
   * @a priority as arguments, as they should only be used for cases, where
   * it is inevitable.
   *
   * @param slot A slot to execute in the new thread.
   * @param stack_size A stack size for the new thread, or <tt>0</tt>.
   * @param joinable Should this thread be joinable?
   * @param bound Should this thread be bound to a system thread?
   * @param priority A priority for the thread.
   * @return The new Thread* on success.
   * @throw Glib::ThreadError
   */
  static Thread* create(const SigC::Slot0<void>& slot, unsigned long stack_size,
                        bool joinable, bool bound, GThreadPriority priority);

  /** Returns the Thread* corresponding to the calling thread.
   * @return The current thread.
   */
  static Thread* self();

  /** Returns whether the thread is joinable.
   * @return Whether the thread is joinable.
   */
  bool joinable() const;

  /** Waits until the thread finishes.
   * Waits until the thread finishes, i.e. the slot, as given to create(),
   * returns or g_thread_exit() is called by the thread.  (Calling
   * g_thread_exit() in a C++ program should be avoided.)  All resources of
   * the thread including the Glib::Thread object are released.  The thread
   * must have been created with <tt>joinable&nbsp;=&nbsp;true</tt>.
   */
  void join();

  /** Changes the priority of the thread to @a priority.
   * @note It is not guaranteed, that threads with different priorities really
   * behave accordingly.  On some systems (e.g. Linux) only @c root can
   * increase priorities.  On other systems (e.g. Solaris) there doesn't seem
   * to be different scheduling for different priorities.  All in all try to
   * avoid being dependent on priorities.
   * @param priority A new priority for the thread.
   */
  void set_priority(GThreadPriority priority);

  /** Returns the priority of the thread.
   * @return The thread's priority.
   */
  GThreadPriority get_priority() const;

  /** Gives way to other threads waiting to be scheduled.
   * This function is often used as a method to make busy wait less evil.  But
   * in most cases, you will encounter, there are better methods to do that.
   * So in general you shouldn't use this function.
   */
  static void yield();

  GThread*       gobj()       { return &gobject_; }
  const GThread* gobj() const { return &gobject_; }

private:
  GThread gobject_;

  // Glib::Thread can neither be constructed nor deleted.
  Thread();
  void operator delete(void*, size_t);

  // noncopyable
  Thread(const Thread&);
  Thread& operator=(const Thread&);
};

/** %Exception class used to exit from a thread.
 * @code
 * throw Glib::Thread::Exit();
 * @endcode
 * Write this if you want to exit from a thread created by Thread::create().
 * Of course you must make sure not to catch Thread::Exit by accident, i.e.
 * when using <tt>catch(...)</tt> somewhere in your code.
 */
class Thread::Exit
{};

/** @relates Glib::Thread */
Thread* wrap(GThread* gobject);


/** Like Glib::Mutex, but can be defined at compile time.
 * Use @c GLIBMM_STATIC_MUTEX_INIT to initialize a StaticMutex:
 * @code
 * Glib::StaticMutex mutex = GLIBMM_STATIC_MUTEX_INIT;
 * @endcode
 * A StaticMutex can be used without calling Glib::thread_init(), it will
 * silently do nothing then.  That will also work when using the implicit
 * conversion to Mutex&, thus you can safely use Mutex::Lock with a
 * StaticMutex.
 */
struct StaticMutex
{
  void lock();
  bool trylock();
  void unlock();

  operator Mutex&();

  GStaticMutex* gobj() { return &gobject_; }

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  // Must be public to allow initialization at compile time.
  GStaticMutex gobject_;
#endif
};

/** Represents a mutex (mutual exclusion).
 * It can be used to protect data against shared access.  Try to use
 * Mutex::Lock instead of calling lock() and unlock() directly&nbsp;--
 * it will make your life much easier.
 *
 * @note Before creating a Glib::Mutex, Glib::thread_init() has to be called.
 *
 * @note Glib::Mutex is not recursive, i.e. a thread will deadlock, if it
 * already has locked the mutex while calling lock().  Use Glib::RecMutex
 * instead, if you need recursive mutexes.
 */
class Mutex
{
public:
  class Lock;

  Mutex();
  ~Mutex();

  /** Locks the mutex.
   * If mutex is already locked by another thread, the current thread will
   * block until mutex is unlocked by the other thread.
   * @see Mutex::Lock
   */
  void lock();

  /** Tries to lock the mutex.
   * If the mutex is already locked by another thread, it immediately returns
   * @c false.  Otherwise it locks the mutex and returns @c true.
   * @return Whether the mutex could be locked.
   * @see Mutex::Lock
   */
  bool trylock();

  /** Unlocks the mutex.
   * If another thread is blocked in a lock() call for this mutex, it will be
   * woken and can lock the mutex itself.
   * @see Mutex::Lock
   */
  void unlock();

  GMutex* gobj() { return gobject_; }

private:
  GMutex* gobject_;

  // noncopyable
  Mutex(const Mutex&);
  Mutex& operator=(const Mutex&);
};

/** Utility class for exception-safe mutex locking.
 */
class Mutex::Lock
{
public:
  explicit inline Lock(Mutex& mutex, bool acquire_immediately = true);
  inline ~Lock();

  inline void acquire();
  inline bool try_acquire();
  inline void release();

private:
  Mutex&  mutex_;
  bool    locked_;

  // noncopyable
  Lock(const Mutex::Lock&);
  Mutex::Lock& operator=(const Mutex::Lock&);
};


/** Like Glib::RecMutex, but can be defined at compile time.
 * Use @c GLIBMM_STATIC_REC_MUTEX_INIT to initialize a StaticRecMutex:
 * @code
 * Glib::StaticRecMutex mutex = GLIBMM_STATIC_REC_MUTEX_INIT;
 * @endcode
 * A StaticRecMutex can be used without calling Glib::thread_init(), it will
 * silently do nothing then.  That will also work when using the implicit
 * conversion to RecMutex&, thus you can safely use RecMutex::Lock with a
 * StaticRecMutex.
 */
struct StaticRecMutex
{
  void lock();
  bool trylock();
  void unlock();

  void lock_full(unsigned int depth);
  unsigned int unlock_full();

  operator RecMutex&();

  GStaticRecMutex* gobj() { return &gobject_; }

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  // Must be public to allow initialization at compile time.
  GStaticRecMutex gobject_;
#endif
};

class RecMutex : public StaticRecMutex
{
public:
  class Lock;

  RecMutex();
  ~RecMutex();

private:
  // noncopyable
  RecMutex(const RecMutex&);
  RecMutex& operator=(const RecMutex&);
};

/** Utility class for exception-safe locking of recursive mutexes.
 */
class RecMutex::Lock
{
public:
  explicit inline Lock(RecMutex& mutex, bool acquire_immediately = true);
  inline ~Lock();

  inline void acquire();
  inline bool try_acquire();
  inline void release();

private:
  RecMutex& mutex_;
  bool      locked_;

  // noncopyable
  Lock(const RecMutex::Lock&);
  RecMutex::Lock& operator=(const RecMutex::Lock&);
};


/** Like Glib::RWLock, but can be defined at compile time.
 * Use @c GLIBMM_STATIC_RW_LOCK_INIT to initialize a StaticRWLock:
 * @code
 * Glib::StaticRWLock rw_lock = GLIBMM_STATIC_RW_LOCK_INIT;
 * @endcode
 * A StaticRWLock can be used without calling Glib::thread_init(), it will
 * silently do nothing then.  That will also work when using the implicit
 * conversion to RWLock&, thus you can safely use RWLock::ReaderLock and
 * RWLock::WriterLock with a StaticRWLock.
 */
struct StaticRWLock
{
  void reader_lock();
  bool reader_trylock();
  void reader_unlock();

  void writer_lock();
  bool writer_trylock();
  void writer_unlock();

  operator RWLock&();

  GStaticRWLock* gobj() { return &gobject_; }

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  // Must be public to allow initialization at compile time.
  GStaticRWLock gobject_;
#endif
};

class RWLock : public StaticRWLock
{
public:
  class ReaderLock;
  class WriterLock;

  RWLock();
  ~RWLock();

private:
  // noncopyable
  RWLock(const RWLock&);
  RWLock& operator=(const RWLock&);
};

/** Utility class for exception-safe locking of read/write locks.
 */
class RWLock::ReaderLock
{
public:
  explicit inline ReaderLock(RWLock& rwlock, bool acquire_immediately = true);
  inline ~ReaderLock();

  inline void acquire();
  inline bool try_acquire();
  inline void release();

private:
  RWLock& rwlock_;
  bool    locked_;

  // noncopyable
  ReaderLock(const RWLock::ReaderLock&);
  RWLock::ReaderLock& operator=(const RWLock::ReaderLock&);
};

/** Utility class for exception-safe locking of read/write locks.
 */
class RWLock::WriterLock
{
public:
  explicit inline WriterLock(RWLock& rwlock, bool acquire_immediately = true);
  inline ~WriterLock();

  inline void acquire();
  inline bool try_acquire();
  inline void release();

private:
  RWLock& rwlock_;
  bool    locked_;

  // noncopyable
  WriterLock(const RWLock::WriterLock&);
  RWLock::WriterLock& operator=(const RWLock::WriterLock&);
};


class Cond
{
public:
  Cond();
  ~Cond();

  void signal();
  void broadcast();

  void wait(Mutex& mutex);
  bool timed_wait(Mutex& mutex, const Glib::TimeVal& abs_time);

  GCond* gobj() { return gobject_; }

private:
  GCond* gobject_;

  // noncopyable
  Cond(const Cond&);
  Cond& operator=(const Cond&);
};


template <class T>
struct StaticPrivate
{
  typedef void (*DestroyNotifyFunc) (void*);

  static void delete_ptr(void* data);

  inline T* get();
  inline void set(T* data, DestroyNotifyFunc notify_func = &StaticPrivate<T>::delete_ptr);

  GStaticPrivate* gobj() { return &gobject_; }

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  // Must be public to allow initialization at compile time.
  GStaticPrivate gobject_;
#endif
};

template <class T>
class Private
{
public:
  typedef void (*DestructorFunc) (void*);

  static void delete_ptr(void* data);

  explicit inline Private(DestructorFunc destructor_func = &Private<T>::delete_ptr);
  inline T* get();
  inline void set(T* data);

  GPrivate* gobj() { return gobject_; }

private:
  GPrivate* gobject_;

  // noncopyable
  Private(const Private<T>&);
  Private<T>& operator=(const Private<T>&);
};

/** @} group Threads */


/***************************************************************************/
/*  inline implementation                                                  */
/***************************************************************************/

#ifndef DOXYGEN_SHOULD_SKIP_THIS

// internal
void thread_init_impl();

/* This function must be inline, to avoid an unecessary dependency on
 * libgthread even if the thread system is not used.  libgthread might
 * not even be available if GLib was compiled without thread support.
 */
inline
void thread_init(GThreadFunctions* vtable)
{
  g_thread_init(vtable);
  Glib::thread_init_impl();
}

inline
bool thread_supported()
{
  return g_thread_supported();
}


/**** Glib::Mutex::Lock ****************************************************/

inline
Mutex::Lock::Lock(Mutex& mutex, bool acquire_immediately)
:
  mutex_  (mutex),
  locked_ (acquire_immediately)
{
  if(acquire_immediately)
    mutex_.lock();
}

inline
Mutex::Lock::~Lock()
{
  if(locked_)
    mutex_.unlock();
}

inline
void Mutex::Lock::acquire()
{
  mutex_.lock();
  locked_ = true;
}

inline
bool Mutex::Lock::try_acquire()
{
  locked_ = mutex_.trylock();
  return locked_;
}

inline
void Mutex::Lock::release()
{
  mutex_.unlock();
  locked_ = false;
}


/**** Glib::RecMutex::Lock *************************************************/

inline
RecMutex::Lock::Lock(RecMutex& mutex, bool acquire_immediately)
:
  mutex_  (mutex),
  locked_ (acquire_immediately)
{
  if(acquire_immediately)
    mutex_.lock();
}

inline
RecMutex::Lock::~Lock()
{
  if(locked_)
    mutex_.unlock();
}

inline
void RecMutex::Lock::acquire()
{
  mutex_.lock();
  locked_ = true;
}

inline
bool RecMutex::Lock::try_acquire()
{
  locked_ = mutex_.trylock();
  return locked_;
}

inline
void RecMutex::Lock::release()
{
  mutex_.unlock();
  locked_ = false;
}


/**** Glib::RWLock::ReaderLock *********************************************/

inline
RWLock::ReaderLock::ReaderLock(RWLock& rwlock, bool acquire_immediately)
:
  rwlock_ (rwlock),
  locked_ (acquire_immediately)
{
  if(acquire_immediately)
    rwlock_.reader_lock();
}

inline
RWLock::ReaderLock::~ReaderLock()
{
  if(locked_)
    rwlock_.reader_unlock();
}

inline
void RWLock::ReaderLock::acquire()
{
  rwlock_.reader_lock();
  locked_ = true;
}

inline
bool RWLock::ReaderLock::try_acquire()
{
  locked_ = rwlock_.reader_trylock();
  return locked_;
}

inline
void RWLock::ReaderLock::release()
{
  rwlock_.reader_unlock();
  locked_ = false;
}


/**** Glib::RWLock::WriterLock *********************************************/

inline
RWLock::WriterLock::WriterLock(RWLock& rwlock, bool acquire_immediately)
:
  rwlock_ (rwlock),
  locked_ (acquire_immediately)
{
  if(acquire_immediately)
    rwlock_.writer_lock();
}

inline
RWLock::WriterLock::~WriterLock()
{
  if(locked_)
    rwlock_.writer_unlock();
}

inline
void RWLock::WriterLock::acquire()
{
  rwlock_.writer_lock();
  locked_ = true;
}

inline
bool RWLock::WriterLock::try_acquire()
{
  locked_ = rwlock_.writer_trylock();
  return locked_;
}

inline
void RWLock::WriterLock::release()
{
  rwlock_.writer_unlock();
  locked_ = false;
}


/**** Glib::StaticPrivate **************************************************/

// static
template <class T>
void StaticPrivate<T>::delete_ptr(void* data)
{
  delete static_cast<T*>(data);
}

template <class T> inline
T* StaticPrivate<T>::get()
{
  return static_cast<T*>(g_static_private_get(&gobject_));
}

template <class T> inline
void StaticPrivate<T>::set(T* data, typename StaticPrivate<T>::DestroyNotifyFunc notify_func)
{
  g_static_private_set(&gobject_, data, notify_func);
}


/**** Glib::Private ********************************************************/

// static
template <class T>
void Private<T>::delete_ptr(void* data)
{
  delete static_cast<T*>(data);
}

template <class T> inline
Private<T>::Private(typename Private<T>::DestructorFunc destructor_func)
:
  gobject_ (g_private_new(destructor_func))
{}

template <class T> inline
T* Private<T>::get()
{
  return static_cast<T*>(g_private_get(gobject_));
}

template <class T> inline
void Private<T>::set(T* data)
{
  g_private_set(gobject_, data);
}

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GLIBMM_THREAD_H */

