/* example-start stock stock.cc */

#include <gtkmm.h>
#include <iostream>

using namespace Gtk;
using SigC::bind;
using SigC::slot;

struct MyMenu : public Menu
  {
    bool button_press (GdkEvent *);
  };

static void menuitem_response (std::string message);


int main (int argc, char *argv[])
{
    Kit kit(argc,argv);

    /* create a new window */
    Window* window = manage ( new Window() );
    window->set_size_request( 200, 100);
    window->set_title("GTK Menu Test");

    /* Init the menu-widget, and remember -- never
     * show() the menu widget!! 
     * This is the menu that holds the menu items, the one that
     * will pop up when you click on the "Root Menu" in the app */
    Menu* menu = manage (new MyMenu());

    menu->items ().push_back (Menu_Helpers::StockMenuElem (
      Gtk::Stock::OPEN,
      SigC::bind( SigC::slot(menuitem_response), "Open selected")));

    menu->items ().push_back (Menu_Helpers::StockMenuElem (
      Gtk::Stock::SAVE,
      SigC::bind( SigC::slot(menuitem_response), "Save selected")));

    menu->items ().push_back (Menu_Helpers::StockMenuElem (
      Gtk::Stock::SAVE_AS,
      SigC::bind( SigC::slot(menuitem_response), "Save As selected")));

    menu->items ().push_back (Menu_Helpers::StockMenuElem (
      Gtk::Stock::REVERT_TO_SAVED, Menu_Helpers::AccelKey ("<control>r"),
      SigC::bind( SigC::slot(menuitem_response), "Revert")));
    
    /* This is the root menu, and will be the label
     * displayed on the menu bar.  There won't be a signal handler attached,
     * as it only pops up the rest of the menu when pressed. */
    MenuItem* root_menu = manage (new MenuItem("Root Menu"));


    /* Now we specify that we want our newly created "menu" to be the menu
     * for the "root menu" */
    root_menu->set_submenu(*menu);

    /* A vbox to put a menu and a button in: */
    VBox* vbox = manage( new VBox(false, 0) );
    window->add(*vbox);

    /* Create a menu-bar to hold the menus and add it to our main window */
    MenuBar* menu_bar = manage( new MenuBar() );
    vbox->pack_start(*menu_bar, false, false, 2);

    /* Create a button to which to attach menu as a popup */
    Button* button = manage( new Button("press me") );
    button->signal_event().connect( slot(*menu,&MyMenu::button_press) );

//    gtk_signal_connect_object(GTK_OBJECT(button), "event",
//	GTK_SIGNAL_FUNC (button_press), GTK_OBJECT(menu));
    vbox->pack_end(*button, true, true, 2);

    /* And finally we append the menu-item to the menu-bar -- this is the
     * "root" menu-item I have been raving about =) */
    menu_bar->append(*root_menu);

    /* always display the window as the last step so it all splashes on
     * the screen at once. */
    window->show_all ();
    
    kit.run (*window);

    return 0;
}

/* Respond to a button-press by posting a menu passed in as widget.
 *
 * Note that the "widget" argument is the menu being posted, NOT
 * the button that was pressed.
 */

bool MyMenu::button_press (GdkEvent *event)
{

    if (event->type == GDK_BUTTON_PRESS) {
        GdkEventButton *bevent = (GdkEventButton *) event; 
        popup(bevent->button, bevent->time);

        /* Tell calling code that we have handled this event; the buck
         * stops here. */
        return true;
    }

    /* Tell calling code that we have not handled this event; pass it on. */
    return false;
}


/* Print a string when a menu item is selected */

static void menuitem_response (std::string message)
{
  std::cout << message << std::endl;
}
/* example-end */
