
#include <atkmm/relation.h>
#include <atkmm/private/relation_p.h>

#include <atk/atk-enum-types.h>
// -*- c++ -*-
/* $Id: relation.ccg,v 1.1 2002/02/24 15:27:17 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Atk::RelationType>::value_type()
{
  return atk_relation_type_get_type();
}


namespace Glib
{

Glib::RefPtr<Atk::Relation> wrap(AtkRelation* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Atk::Relation>( dynamic_cast<Atk::Relation*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Atk
{


/* The *_Class implementation: */

GType Relation_Class::get_type()
{
  if(!gtype_) // create the GType if necessary
  {
    // TODO: This is currently just optimized away, apparently with no harm.
    // Is it actually needed?
    // Make sure that the parent type has been created.
    CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(atk_relation_get_type(), (GClassInitFunc) &class_init_function);

    // Add derived versions of interfaces, if the C type implements any interfaces:
  }

  return gtype_;
}

void Relation_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Relation_Class::wrap_new(GObject* o)
{
  return new Relation((AtkRelation*)(o));
}


/* The implementation: */

AtkRelation* Relation::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<Relation> Relation::wrap_specific_type(AtkRelation* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Relation> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    Relation* pCppObject = dynamic_cast<Relation*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<Relation>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<Relation>( new Relation(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

Relation::Relation(AtkRelation* castitem)
: Glib::Object((GObject*)(castitem))
{}

Relation::~Relation()
{
}

Relation::CppClassType Relation::relation_class_; //Initialize static member.

GType Relation::get_type()
{
  return relation_class_.get_type();
}

GType Relation::get_base_type()
{
  return atk_relation_get_type();
}

RelationType Relation::get_relation_type() const
{
  return ((RelationType)(atk_relation_get_relation_type(const_cast<AtkRelation*>(gobj()))));
}


} // namespace Atk

