
#include <gtkmm/tearoffmenuitem.h>
#include <gtkmm/private/tearoffmenuitem_p.h>

// -*- c++ -*-
/* $Id: tearoffmenuitem.ccg,v 1.3 2001/05/30 17:53:05 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtktearoffmenuitem.h>

namespace Gtk
{

bool TearoffMenuItem::is_torn_off() const
{
  return gobj()->torn_off;
}

} /* namespace Gtk */

namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::TearoffMenuItem* wrap(GtkTearoffMenuItem* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::TearoffMenuItem *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType TearoffMenuItem_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_tearoff_menu_item_get_type(), "gtkmm__TearoffMenuItem", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void TearoffMenuItem_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* TearoffMenuItem_Class::wrap_new(GObject* o)
{
  return manage(new TearoffMenuItem((GtkTearoffMenuItem*)(o)));
}


/* The implementation: */

TearoffMenuItem::TearoffMenuItem(GtkTearoffMenuItem* castitem)
: Gtk::MenuItem((GtkMenuItem*)(castitem))
{}

TearoffMenuItem::~TearoffMenuItem()
{
  destroy_();
}

TearoffMenuItem::CppClassType TearoffMenuItem::tearoffmenuitem_class_; //Initialize static member.

GType TearoffMenuItem::get_type()
{
  return tearoffmenuitem_class_.get_type();
}

GType TearoffMenuItem::get_base_type()
{
  return gtk_tearoff_menu_item_get_type();
}

TearoffMenuItem::TearoffMenuItem()
: Gtk::MenuItem((GtkMenuItem*)(g_object_new(get_type(), (char*)0)))
{}


} // namespace Gtk

