
#include <gtkmm/bin.h>
#include <gtkmm/private/bin_p.h>

// -*- c++ -*-
/* $Id: bin.ccg,v 1.12 2002/02/15 13:57:22 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkbin.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/label.h>
#include <gtkmm/box.h>
#include <gtkmm/image.h>

namespace Gtk
{


void 
Bin::remove()
{
  if (gobj()->child)
    gtk_container_remove(Container::gobj(),gobj()->child);
}

void 
Bin::add_label(const Glib::ustring& str, bool mnemonic = false,
	             double x_align = 0.5, double y_align = 0.5)
{
  Label* label = manage(new Label(str, mnemonic));
  label->set_alignment(x_align, y_align);
  add(*label);

  //This might not always be appropriate:
  //because maybe the mnemonic widget should be another child widget.
  //if(mnemonic)
    //label->set_mnemonic_widget(*this);

  label->show();
}

void
Bin::add_pixmap(const Glib::RefPtr<Gdk::Pixmap>& pixmap, const Glib::RefPtr<Gdk::Bitmap>& mask)
{
  Image* p = manage(new Image(pixmap, mask));
  add(*p);
  p->show();
}

void
Bin::add_pixlabel (const Glib::RefPtr<Gdk::Pixmap>& pixmap,
		   const Glib::RefPtr<Gdk::Bitmap>& mask,
		   const Glib::ustring& str,
		   double x_align = 0.5, double y_align = 0.5)
{
  //Create Pixmap and Label widgets:
  Image* pmap = manage(new Image(pixmap, mask));
  Label* label = manage(new Label(str));
  label->set_alignment (x_align, y_align);

  //Put them in a VBox:
  Box* box = manage(new HBox(false,5));
  box->pack_start(*pmap, false);
  box->pack_start(*label);
  box->show_all();

  //And put that VBox in this:
  add(*box);
}

void
Bin::add_pixlabel(const Glib::ustring& pixfile,
		  const Glib::ustring& str,
		  double x_align = 0.5, double y_align = 0.5)
{
  //Create Pixmap and Label widgets:
  Image* pmap = manage(new Image(pixfile));
  Label* label = manage(new Label(str));
  label->set_alignment (x_align, y_align);

  //Put them in a VBox:
  Box* vbox = manage(new HBox(false, 5));
  vbox->pack_start(*pmap, false);
  vbox->pack_start(*label);
  vbox->show_all();

  //And put that VBox in this:
  add(*vbox);
}


} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Bin* wrap(GtkBin* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Bin *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Bin_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_bin_get_type(), "gtkmm__Bin", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Bin_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Bin_Class::wrap_new(GObject* o)
{
  return manage(new Bin((GtkBin*)(o)));
}


/* The implementation: */

Bin::Bin(GtkBin* castitem)
: Gtk::Container((GtkContainer*)(castitem))
{}

Bin::~Bin()
{
  destroy_();
}

Bin::CppClassType Bin::bin_class_; //Initialize static member.

GType Bin::get_type()
{
  return bin_class_.get_type();
}

GType Bin::get_base_type()
{
  return gtk_bin_get_type();
}

Bin::Bin()
: Gtk::Container((GtkContainer*)(g_object_new(get_type(), (char*)0)))
{}

Widget* Bin::get_child()
{
  return Glib::wrap(gobj()->child);
}

const Widget* Bin::get_child() const
{
  return Glib::wrap(gobj()->child);
}


} // namespace Gtk

