// -*- c++ -*-
#ifndef _GLIBMM_UTILITY_H
#define _GLIBMM_UTILITY_H
/* $Id: utility.h,v 1.8 2002/04/03 11:17:09 daniel Exp $ */

/* Copyright 2002 Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glib/gmacros.h>
#include <glibmm/ustring.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS

extern "C" void g_free(void*);


/* Occasionally, a struct variable has to be initialized after its definition,
 * i.e. when using structs as class member data.  For convenience, the macro
 * GLIBMM_INITIALIZE_STRUCT(Var, Type) is provided.  It even avoids creating
 * a temporary if the compiler supports compound literals.
 */
#if (__STDC_VERSION__ >= 199901L) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))

#define GLIBMM_INITIALIZE_STRUCT(Var, Type) G_GNUC_EXTENSION Var = ((Type) { 0, })

#else

#define GLIBMM_INITIALIZE_STRUCT(Var, Type) \
    G_STMT_START{ \
        Type const initializer = { 0, }; \
        Var = initializer; \
    }G_STMT_END

#endif /* (__STDC_VERSION__ >= 199901L) || (defined(__GNUC__) && !defined(__STRICT_ANSI__)) */


namespace Glib
{

// These are used by gtkmmproc-generated type conversions:

// Helper to deal with memory allocated
// by GLib functions in an exception-safe manner.
template <typename T>
class ScopedPtr
{
private:
  T* ptr_;
  ScopedPtr(const ScopedPtr<T>&);
  ScopedPtr<T>& operator=(const ScopedPtr<T>&);

public:
  ScopedPtr()                 : ptr_ (0)   {}
  explicit ScopedPtr(T* ptr)  : ptr_ (ptr) {}
  ~ScopedPtr()                { g_free(ptr_); }
  T*  get() const             { return ptr_;  }
  T** addr()                  { return &ptr_; }
};

// Removes the const nature of a ptr
template <class T>
inline T* unconst(const T* t)
  { return const_cast<T*>(t); }

// Convert const gchar* to ustring, while treating NULL as empty string.
inline
Glib::ustring convert_const_gchar_ptr_to_ustring(const char* str)
{
  return (str) ? Glib::ustring(str) : Glib::ustring();
}

// Convert a non-const gchar* return value to ustring, freeing it too.
inline
Glib::ustring convert_return_gchar_ptr_to_ustring(char* str)
{
  return (str) ? Glib::ustring(Glib::ScopedPtr<char>(str).get())
               : Glib::ustring();
}

} // namespace Glib

#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#endif // _GLIBMM_UTILITY_H

