
extern "C"
{
#include <glib-object.h>
#include <gdk/gdkenumtypes.h>
}

#include <gdkmm/visual.h>
#include <gdkmm/private/visual_p.h>

#include <gdk/gdkenumtypes.h>
// -*- c++ -*-
/* $Id: visual.ccg,v 1.1 2001/10/12 01:00:53 murrayc Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdkvisual.h>

namespace Gdk
{


} //namespace


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gdk::VisualType>::value_type()
{
  return gdk_visual_type_get_type();
}


namespace Glib
{

Glib::RefPtr<Gdk::Visual> wrap(GdkVisual* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gdk::Visual>( dynamic_cast<Gdk::Visual*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

GType Visual_Class::get_type()
  {
    gtype_ = gdk_visual_get_type(); //The actual struct definition is hidden, so we can not derive one.
    return gtype_;
  }


Glib::ObjectBase* Visual_Class::wrap_new(GObject* o)
{
  return new Visual((GdkVisual*)(o));
}


/* The implementation: */

GdkVisual* Visual::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<Visual> Visual::wrap_specific_type(GdkVisual* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Visual> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    Visual* pCppObject = dynamic_cast<Visual*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<Visual>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<Visual>( new Visual(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

Visual::Visual(GdkVisual* castitem)
: Glib::Object((GObject*)(castitem))
{}

Visual::~Visual()
{
}

Visual::CppClassType Visual::visual_class_; //Initialize static member.

GType Visual::get_type()
{
  return visual_class_.get_type();
}

GType Visual::get_base_type()
{
  return gdk_visual_get_type();
}

Visual::Visual()
: Glib::Object((GObject*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<Visual> Visual::get_system()
{
  return Gdk::Visual::wrap_specific_type(gdk_visual_get_system());
}

Glib::RefPtr<Visual> Visual::get_best()
{
  return Gdk::Visual::wrap_specific_type(gdk_visual_get_best());
}

Glib::RefPtr<Visual> Visual::get_best(int depth)
{
  return Gdk::Visual::wrap_specific_type(gdk_visual_get_best_with_depth(depth));
}

Glib::RefPtr<Visual> Visual::get_best(VisualType visual_type)
{
  return Gdk::Visual::wrap_specific_type(gdk_visual_get_best_with_type(((GdkVisualType)(visual_type))));
}

Glib::RefPtr<Visual> Visual::get_best(int depth, VisualType visual_type)
{
  return Gdk::Visual::wrap_specific_type(gdk_visual_get_best_with_both(depth, ((GdkVisualType)(visual_type))));
}

int Visual::get_best_depth()
{
  return gdk_visual_get_best_depth();
}

VisualType Visual::get_best_type()
{
  return ((VisualType)(gdk_visual_get_best_type()));
}


} // namespace Gdk

