
#include <pangomm/fontface.h>
#include <pangomm/private/fontface_p.h>

// -*- c++ -*-
/* $Id: fontface.ccg,v 1.1 2001/12/14 13:19:35 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Pango::FontFace> wrap(PangoFontFace* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Pango::FontFace>( dynamic_cast<Pango::FontFace*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Pango
{


/* The *_Class implementation: */

GType FontFace_Class::get_type()
  {
    gtype_ = pango_font_face_get_type(); //The actual struct definition is hidden, so we can not derive one.
    return gtype_;
  }


Glib::ObjectBase* FontFace_Class::wrap_new(GObject* o)
{
  return new FontFace((PangoFontFace*)(o));
}


/* The implementation: */

PangoFontFace* FontFace::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<FontFace> FontFace::wrap_specific_type(PangoFontFace* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<FontFace> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    FontFace* pCppObject = dynamic_cast<FontFace*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<FontFace>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<FontFace>( new FontFace(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

FontFace::FontFace(PangoFontFace* castitem)
: Glib::Object((GObject*)(castitem))
{}

FontFace::~FontFace()
{
}

FontFace::CppClassType FontFace::fontface_class_; //Initialize static member.

GType FontFace::get_type()
{
  return fontface_class_.get_type();
}

GType FontFace::get_base_type()
{
  return pango_font_face_get_type();
}

FontDescription FontFace::describe()
{
  return FontDescription(pango_font_face_describe(gobj()));
}

Glib::ustring FontFace::get_name()
{
  return Glib::convert_const_gchar_ptr_to_ustring(pango_font_face_get_face_name(gobj()));
}


} // namespace Pango

