// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREEVIEW_H
#define _GTKMM_TREEVIEW_H

#include <glibmm.h>

/* $Id: treeview.hg,v 1.36 2002/04/02 13:25:20 daniel Exp $ */


/* treeview.h
 *
 * Copyright(C) 2001 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/listhandle.h>
#include <gtkmm/container.h>
#include <gtkmm/adjustment.h>
#include <gdkmm/pixmap.h>
#include <gtkmm/treeviewcolumn.h>
#include <gtkmm/treeselection.h>
//#include <gtkmm/treemodel.h>
#include <gtkmm/cellrenderer.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreeView GtkTreeView;
typedef struct _GtkTreeViewClass GtkTreeViewClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{ class TreeView_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum TreeViewDropPosition
{
  TREE_VIEW_DROP_BEFORE,
  TREE_VIEW_DROP_AFTER,
  TREE_VIEW_DROP_INTO_OR_BEFORE,
  TREE_VIEW_DROP_INTO_OR_AFTER
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TreeViewDropPosition> : public Glib::Value_Enum<Gtk::TreeViewDropPosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


//class TreeViewColumn;
class TreeModel;

/** @defgroup TreeView TreeView Classes
 * These classes are used with the Gtk::TreeView widget.
 */

/**
 * @ingroup Widgets
 * @ingroup Containers
 * @ingroup TreeView
 */

class TreeView : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TreeView CppObjectType;
  typedef TreeView_Class CppClassType;
  typedef GtkTreeView BaseObjectType;
  typedef GtkTreeViewClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TreeView();

private:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  friend class CppClassType;
  static CppClassType treeview_class_;

  TreeView(const TreeView&);
  TreeView& operator=(const TreeView&); // not implemented

protected:
  explicit TreeView(GtkTreeView* castitem);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */
  GtkTreeView* gobj()             { return (GtkTreeView*)(gobject_); }
  const GtkTreeView* gobj() const { return (GtkTreeView*)(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment);
  virtual void on_row_activated(const TreePath& path, TreeViewColumn* column);
  virtual bool on_test_expand_row(const TreeIter& iter, const TreePath& path);
  virtual bool on_test_collapse_row(const TreeIter& iter, const TreePath& path);
  virtual void on_row_expanded(const TreeIter& iter, const TreePath& path);
  virtual void on_row_collapsed(const TreeIter& iter, const TreePath& path);
  virtual void on_cursor_changed();
  virtual void on_columns_changed();
  virtual bool on_move_cursor(MovementStep step, int count);
  virtual void on_select_all();
  virtual void on_select_cursor_row(bool start_editing);
  virtual void on_toggle_cursor_row();
  virtual void on_expand_collapse_cursor_row(bool logical, bool expand, bool open_all);
  virtual void on_select_cursor_parent();
  virtual void on_start_interactive_search();


private:

  
public:

  TreeView();
  explicit TreeView(const Glib::RefPtr<TreeModel>& model);
  

  /** Returns the model the the Gtk::TreeView is based on.  Returns <tt>0</tt> if the
   * model is unset.
   * @return A Gtk::TreeModel, or <tt>0</tt> if none is currently being used.
   */
  Glib::RefPtr<TreeModel> get_model();
  
  /** Sets the model for a Gtk::TreeView.  If the @a tree_view already has a model
   * set, it will remove it before setting the new model.  If @a model is <tt>0</tt>, then
   * it will unset the old model.
   * @param model The model.
   */
  void set_model(const Glib::RefPtr<TreeModel>& model);
  
  /** Gets the Gtk::TreeSelection associated with @a tree_view.
   * @return A Gtk::TreeSelection object.
   */
  Glib::RefPtr<TreeSelection> get_selection();
  
  /** Gets the Gtk::Adjustment currently being used for the horizontal aspect.
   * @return A Gtk::Adjustment object, or <tt>0</tt> if none is currently being
   * used.
   */
  Adjustment* get_hadjustment();
  
  /** Sets the Gtk::Adjustment for the current horizontal aspect.
   * @param adjustment The Gtk::Adjustment to set, or <tt>0</tt>.
   */
  void set_hadjustment(Adjustment& adjustment);
  
  /** Gets the Gtk::Adjustment currently being used for the vertical aspect.
   * @return A Gtk::Adjustment object, or <tt>0</tt> if none is currently being
   * used.
   */
  Adjustment* get_vadjustment();
  
  /** Sets the Gtk::Adjustment for the current vertical aspect.
   * @param adjustment The Gtk::Adjustment to set, or <tt>0</tt>.
   */
  void set_vadjustment(Adjustment& adjustment);
  
  /** Returns <tt>true</tt> if the headers on the @a tree_view are visible.
   * @return Whether the headers are visible or not.
   */
  bool get_headers_visible();
  
  /** Sets the the visibility state of the headers.
   * @param headers_visible <tt>true</tt> if the headers are visible.
   */
  void set_headers_visible(bool headers_visible);
  
  /** Resizes all columns to their optimal width. Only works after the
   * treeview has been realized.
   */
  void columns_autosize();
  
  /** Allow the column title buttons to be clicked.
   * @param setting <tt>true</tt> if the columns are clickable.
   */
  void set_headers_clickable(bool setting = true);
  
  /** This function tells GTK+ that the user interface for your
   * application requires users to read across tree rows and associate
   * cells with one another. By default, GTK+ will then render the tree
   * with alternating row colors. Do <em>not</em> use it
   * just because you prefer the appearance of the ruled tree; that's a
   * question for the theme. Some themes will draw tree rows in
   * alternating colors even when rules are turned off, and users who
   * prefer that appearance all the time can choose those themes. You
   * should call this function only as a <em>semantic</em>
   * hint to the theme engine that your tree makes alternating colors
   * useful from a functional standpoint (since it has lots of columns,
   * generally).
   * @param setting <tt>true</tt> if the tree requires reading across rows.
   */
  void set_rules_hint(bool setting = true);
  
  /** Gets the setting set by set_rules_hint().
   * @return <tt>true</tt> if rules are useful for the user of this tree.
   */
  bool get_rules_hint();

  
  /** Appends @a column to the list of columns.
   * @param column The Gtk::TreeViewColumn to add.
   * @return The number of columns in @a tree_view after appending.
   */
  int append_column(TreeViewColumn& column);
  
  /** Removes @a column from @a tree_view.
   * @param column The Gtk::TreeViewColumn to remove.
   * @return The number of columns in @a tree_view after removing.
   */
  int remove_column(TreeViewColumn& column);
  
  /** This inserts the @a column into the @a tree_view at @a position.  If @a position is
   * -1, then the column is inserted at the end.
   * @param column The Gtk::TreeViewColumn to be inserted.
   * @param position The position to insert @a column in.
   * @return The number of columns in @a tree_view after insertion.
   */
  int insert_column(TreeViewColumn& column, int position);
  int insert_column(int position, const Glib::ustring& title, CellRenderer& cell);
  //_WRAP_METHOD(int insert_column_with_attributes(int position, const Glib::ustring& title, GtkCellRenderer* cell, ...), )


  typedef TreeViewColumn::SlotCellData SlotCellData;
  int insert_column_with_data_func(int position, const Glib::ustring& title, CellRenderer& cell, const SlotCellData& slot);

  
  /** Gets the Gtk::TreeViewColumn at the given position in the #tree_view.
   * @param n The position of the column, counting from 0.
   * @return The Gtk::TreeViewColumn, or <tt>0</tt> if the position is outside the
   * range of columns.
   */
  TreeViewColumn* get_column(int n);
  
  /** Returns a #GList of all the Gtk::TreeViewColumn s currently in @a tree_view.
   * The returned list must be freed with g_list_free().
   * @return A list of Gtk::TreeViewColumn s.
   */
  Glib::ListHandle<TreeViewColumn*> get_columns();
  
  /** Moves @a column to be after to @a base_column.  If @a base_column is <tt>0</tt>, then
   * @a column is placed in the first position.
   * @param column The Gtk::TreeViewColumn to be moved.
   * @param base_column The Gtk::TreeViewColumn to be moved relative to, or <tt>0</tt>.
   */
  void move_column_after(TreeViewColumn& column, TreeViewColumn& base_column);
  
  /** Sets the column to draw the expander arrow at. It must be in @a tree_view.  If
   * @a column is <tt>0</tt>, then the expander arrow is always at the first visible
   * column.
   * @param column <tt>0</tt>, or the column to draw the expander arrow at.
   */
  void set_expander_column(TreeViewColumn& column);
  
  /** Returns the column that is the current expander column.  This
   * column has the expander arrow drawn next to it.
   * @return The expander column.
   */
  TreeViewColumn* get_expander_column();
  
  /** Sets a user function for determining where a column may be dropped when
   * dragged.  This function is called on every column pair in turn at the
   * beginning of a column drag to determine where a drop can take place.  The
   * arguments passed to @a func are: the @a tree_view, the Gtk::TreeViewColumn being
   * dragged, the two Gtk::TreeViewColumn s determining the drop spot, and
   * @a user_data.  If either of the Gtk::TreeViewColumn arguments for the drop spot
   * are <tt>0</tt>, then they indicate an edge.  If @a func is set to be <tt>0</tt>, then
   * @a tree_view reverts to the default behavior of allowing all columns to be
   * dropped everywhere.
   * @param func A function to determine which columns are reorderable, or <tt>0</tt>.
   * @param user_data User data to be passed to @a func, or <tt>0</tt>.
   * @param destroy Destroy notifier for @a user_data, or <tt>0</tt>.
   */
  void set_column_drag_function(GtkTreeViewColumnDropFunc func, gpointer user_data, GtkDestroyNotify destroy);

  
  /** Scrolls the tree view such that the top-left corner of the visible
   * area is @a tree_x, @a tree_y, where @a tree_x and @a tree_y are specified
   * in tree window coordinates.  The @a tree_view must be realized before
   * this function is called.  If it isn't, you probably want to be
   * using scroll_to_cell().
   * 
   * If either @a tree_x or @a tree_y are -1, then that direction isn't scrolled.
   * @param tree_x X coordinate of new top-left pixel of visible area, or -1.
   * @param tree_y Y coordinate of new top-left pixel of visible area, or -1.
   */
  void scroll_to_point(int tree_x, int tree_y);
  
  /** Moves the alignments of @a tree_view to the position specified by @a column and
   * @a path.  If @a column is <tt>0</tt>, then no horizontal scrolling occurs.  Likewise,
   * if @a path is <tt>0</tt> no vertical scrolling occurs.  At a minimum, one of @a column
   * or @a path need to be non-<tt>0</tt>.  @a row_align determines where the row is
   * placed, and @a col_align determines where @a column is placed.  Both are expected
   * to be between 0.0 and 1.0. 0.0 means left/top alignment, 1.0 means
   * right/bottom alignment, 0.5 means center.
   * 
   * If @a use_align is <tt>false</tt>, then the alignment arguments are ignored, and the
   * tree does the minimum amount of work to scroll the cell onto the screen.
   * This means that the cell will be scrolled to the edge closest to it's current
   * position.  If the cell is currently visible on the screen, nothing is done.
   * 
   * This function only works if the model is set, and @a path is a valid row on the
   * model.  If the model changes before the @a tree_view is realized, the centered
   * path will be modified to reflect this change.
   * @param path The path of the row to move to, or <tt>0</tt>.
   * @param column The Gtk::TreeViewColumn to move horizontally to, or <tt>0</tt>.
   * @param use_align Whether to use alignment arguments, or <tt>false</tt>.
   * @param row_align The vertical alignment of the row specified by @a path.
   * @param col_align The horizontal alignment of the column specified by @a column.
   */
  void scroll_to_cell(const TreePath& path, TreeViewColumn& column, bool use_align, float row_align, float col_align);
  
  /** Activates the cell determined by @a path and @a column.
   * @param path The Gtk::TreePath to be activated.
   * @param column The Gtk::TreeViewColumn to be activated.
   */
  void row_activated(const TreePath& path,TreeViewColumn& column);
  
  /** Recursively expands all nodes in the @a tree_view.
   */
  void expand_all();
  
  /** Recursively collapses all visible, expanded nodes in @a tree_view.
   */
  void collapse_all();
  
  /** Opens the row so its children are visible.
   * @param path Path to a row.
   * @param open_all Whether to recursively expand, or just expand immediate children.
   * @return <tt>true</tt> if the row existed and had children.
   */
  bool expand_row(const TreePath& path, bool open_all);
  
  /** Collapses a row (hides its child rows, if they exist).
   * @param path Path to a row in the @a tree_view.
   * @return <tt>true</tt> if the row was collapsed.
   */
  bool collapse_row(const TreePath& path);
  
  /** Calls @a func on all expanded rows.
   * @param func A function to be called.
   * @param data User data to be passed to the function.
   */
  void map_expanded_rows(GtkTreeViewMappingFunc func, gpointer data);
  
  /** Returns <tt>true</tt> if the node pointed to by @a path is expanded in @a tree_view.
   * @param path A Gtk::TreePath to test expansion state.
   * @return <tt>true</tt> if #path is expanded.
   */
  bool row_expanded(const TreePath& path);
  
  /** This function is a convenience function to allow you to reorder models that
   * support the Gtk::DragSourceIface and the Gtk::DragDestIface.  Both
   * Gtk::TreeStore and Gtk::ListStore support these.  If @a reorderable is <tt>true</tt>, then
   * the user can reorder the model by dragging and dropping rows.  The
   * developer can listen to these changes by connecting to the model's
   * signals.
   * 
   * This function does not give you any degree of control over the order -- any
   * reorderering is allowed.  If more control is needed, you should probably
   * handle drag and drop manually.
   * @param reorderable <tt>true</tt>, if the tree can be reordered.
   */
  void set_reorderable(bool reorderable = true);
  
  /** Retrieves whether the user can reorder the tree via drag-and-drop. See
   * set_reorderable().
   * @return <tt>true</tt> if the tree can be reordered.
   */
  bool get_reorderable();
  
  /** Sets the current keyboard focus to be at @a path, and selects it.  This is
   * useful when you want to focus the user's attention on a particular row.  If
   * @a column is not <tt>0</tt>, then focus is given to the column specified by it.
   * Additionally, if @a column is specified, and @a start_editing is <tt>true</tt>, then
   * editing should be started in the specified cell.  This function is often
   * followed by @a gtk_widget_grab_focus (@a tree_view) in order to give keyboard
   * focus to the widget.  Please note that editing can only happen when the
   * widget is realized.
   * @param path A Gtk::TreePath.
   * @param focus_column A Gtk::TreeViewColumn, or <tt>0</tt>.
   * @param start_editing <tt>true</tt> if the specified cell should start being edited.
   */
  void set_cursor(const TreePath& path, TreeViewColumn& focus_column, bool start_editing);
  void get_cursor(TreePath& path, TreeViewColumn*& focus_column);

/* Layout information */
  
  /** Returns the window that @a tree_view renders to.  This is used primarily to
   * compare to <tt>event->window</tt> to confirm that the event on
   * @a tree_view is on the right window.
   * @return A Gdk::Window, or <tt>0</tt> when @a tree_view hasn't been realized yet.
   */
  Glib::RefPtr<Gdk::Window> get_bin_window();
  bool get_path_at_pos(int x, int y, TreePath& path, TreeViewColumn*& column, int& cell_x, int& cell_y);
  
  /** Fills the bounding rectangle in tree window coordinates for the cell at the
   * row specified by @a path and the column specified by @a column.  If @a path is
   * <tt>0</tt>, or points to a path not currently displayed, the @a y and @a height fields
   * of the rectangle will be filled with 0. If @a column is <tt>0</tt>, the @a x and @a width
   * fields will be filled with 0.  The sum of all cell rects does not cover the
   * entire tree; there are extra pixels in between rows, for example. The
   * returned rectangle is equivalent to the @a cell_area passed to
   * Gtk::CellRenderer::render().  This function is only valid if #tree_view is
   * realized.
   * @param path A Gtk::TreePath for the row, or <tt>0</tt> to get only horizontal coordinates.
   * @param column A Gtk::TreeViewColumn for the column, or <tt>0</tt> to get only vertical coordiantes.
   * @param rect Rectangle to fill with cell rect.
   */
  void get_cell_area(const TreePath& path, TreeViewColumn& column, Gdk::Rectangle&  rect);
  
  /** Fills the bounding rectangle in tree window coordinates for the cell at the
   * row specified by @a path and the column specified by @a column.  If @a path is
   * <tt>0</tt>, or points to a node not found in the tree, the @a y and @a height fields of
   * the rectangle will be filled with 0. If @a column is <tt>0</tt>, the @a x and @a width
   * fields will be filled with 0.  The returned rectangle is equivalent to the
   * @a background_area passed to Gtk::CellRenderer::render().  These background
   * areas tile to cover the entire tree window (except for the area used for
   * header buttons). Contrast with the @a cell_area, returned by
   * get_cell_area(), which returns only the cell itself, excluding
   * surrounding borders and the tree expander area.
   * @param path A Gtk::TreePath for the row, or <tt>0</tt> to get only horizontal coordinates.
   * @param column A Gtk::TreeViewColumn for the column, or <tt>0</tt> to get only vertical coordiantes.
   * @param rect Rectangle to fill with cell background rect.
   */
  void get_background_area(const TreePath& path, TreeViewColumn& column, Gdk::Rectangle&  rect);
  
  /** Fills @a visible_rect with the currently-visible region of the
   * buffer, in tree coordinates. Convert to widget coordinates with
   * tree_to_widget_coords(). Tree coordinates start at
   * 0,0 for row 0 of the tree, and cover the entire scrollable area of
   * the tree.
   * @param visible_rect Rectangle to fill.
   */
  void get_visible_rect(Gdk::Rectangle&  visible_rect);
  
  /** Converts widget coordinates to coordinates for the
   * tree window (the full scrollable area of the tree).
   * @param wx Widget X coordinate.
   * @param wy Widget Y coordinate.
   * @param tx Return location for tree X coordinate.
   * @param ty Return location for tree Y coordinate.
   */
  void widget_to_tree_coords(int wx, int wy, int& tx, int& ty);
  
  /** Converts tree coordinates (coordinates in full scrollable area of the tree)
   * to widget coordinates.
   * @param tx Tree X coordinate.
   * @param ty Tree Y coordinate.
   * @param wx Return location for widget X coordinate.
   * @param wy Return location for widget Y coordinate.
   */
  void tree_to_widget_coords(int tx, int ty, int& wx, int& wy);

/* Drag-and-Drop support */
  
  void enable_model_drag_source(Gdk::ModifierType start_button_mask, const GtkTargetEntry* targets, int n_targets,
                         Gdk::DragAction actions);
  
  void enable_model_drag_dest(const GtkTargetEntry* targets, int n_targets, Gdk::DragAction actions);
  
  void unset_rows_drag_source();
  
  void unset_rows_drag_dest();


/* These are useful to implement your own custom stuff. */
  
  void set_drag_dest_row(const TreePath& path, TreeViewDropPosition pos);
  void get_drag_dest_row(TreePath& path, TreeViewDropPosition& pos);
  bool get_dest_row_at_pos(int drag_x, int drag_y, TreePath& path, TreeViewDropPosition& pos);
  
  /** Creates a Gdk::Pixmap representation of the row at @a path.  This image is used
   * for a drag icon.
   * @param path A Gtk::TreePath in @a tree_view.
   * @return A newly-allocated pixmap of the drag icon.
   */
  Glib::RefPtr<Gdk::Pixmap> create_row_drag_icon(const TreePath& path);

/* Interactive search */
  
  /** If @a enable_search is set, then the user can type in text to search through
   * the tree interactively.
   * @param enable_search <tt>true</tt>, if the user can search interactively.
   */
  void set_enable_search(bool enable_search = true);
  
  /** Returns whether or not the tree allows interactive searching.
   * @return Whether or not to let the user search interactively.
   */
  bool get_enable_search();
  
  /** Gets the column searched on by the interactive search code.
   * @return The column the interactive search code searches in.
   */
  int get_search_column();
  
  /** Sets @a column as the column where the interactive search code should search
   * in.  Additionally, turns on interactive searching.
   * @param column The column to search in.
   */
  void set_search_column(int column);
  
  /** Returns the compare function currently in use.
   * @return The currently used compare function for the search code.
   */
  GtkTreeViewSearchEqualFunc get_search_equal_func();
  
  /** Sets the compare function for the interactive search capabilities.
   * @param search_equal_func The compare function to use during the search.
   * @param search_user_data User data to pass to @a search_equal_func, or <tt>0</tt>.
   * @param search_destroy Destroy notifier for @a search_user_data, or <tt>0</tt>.
   */
  void set_search_equal_func(GtkTreeViewSearchEqualFunc search_equal_func, gpointer search_user_data, GtkDestroyNotify search_destroy);


  /**
   * @par Prototype:
   * <tt>void %set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment)</tt>
   */
  Glib::SignalProxy2<void,Adjustment*,Adjustment*> signal_set_scroll_adjustments();

  
  /**
   * @par Prototype:
   * <tt>void %row_activated(const TreePath& path, TreeViewColumn* column)</tt>
   */
  Glib::SignalProxy2<void,const TreePath&,TreeViewColumn*> signal_row_activated();

  
  /**
   * @par Prototype:
   * <tt>bool %test_expand_row(const TreeIter& iter, const TreePath& path)</tt>
   */
  Glib::SignalProxy2<bool,const TreeIter&,const TreePath&> signal_test_expand_row();

  
  /**
   * @par Prototype:
   * <tt>bool %test_collapse_row(const TreeIter& iter, const TreePath& path)</tt>
   */
  Glib::SignalProxy2<bool,const TreeIter&,const TreePath&> signal_test_collapse_row();

  
  /**
   * @par Prototype:
   * <tt>void %row_expanded(const TreeIter& iter, const TreePath& path)</tt>
   */
  Glib::SignalProxy2<void,const TreeIter&,const TreePath&> signal_row_expanded();

  
  /**
   * @par Prototype:
   * <tt>void %row_collapsed(const TreeIter& iter, const TreePath& path)</tt>
   */
  Glib::SignalProxy2<void,const TreeIter&,const TreePath&> signal_row_collapsed();

  
  /**
   * @par Prototype:
   * <tt>void %cursor_changed()</tt>
   */
  Glib::SignalProxy0<void> signal_cursor_changed();

  
  /**
   * @par Prototype:
   * <tt>void %columns_changed()</tt>
   */
  Glib::SignalProxy0<void> signal_columns_changed();

  
  /**
   * @par Prototype:
   * <tt>bool %move_cursor(MovementStep step, int count)</tt>
   */
  Glib::SignalProxy2<bool,MovementStep,int> signal_move_cursor();

  
  /**
   * @par Prototype:
   * <tt>void %select_all()</tt>
   */
  Glib::SignalProxy0<void> signal_select_all();

  
  /**
   * @par Prototype:
   * <tt>void %select_cursor_row(bool start_editing)</tt>
   */
  Glib::SignalProxy1<void,bool> signal_select_cursor_row();

  
  /**
   * @par Prototype:
   * <tt>void %toggle_cursor_row()</tt>
   */
  Glib::SignalProxy0<void> signal_toggle_cursor_row();

  
  /**
   * @par Prototype:
   * <tt>void %expand_collapse_cursor_row(bool logical, bool expand, bool open_all)</tt>
   */
  Glib::SignalProxy3<void,bool,bool,bool> signal_expand_collapse_cursor_row();

  
  /**
   * @par Prototype:
   * <tt>void %select_cursor_parent()</tt>
   */
  Glib::SignalProxy0<void> signal_select_cursor_parent();

  
  /**
   * @par Prototype:
   * <tt>void %start_interactive_search()</tt>
   */
  Glib::SignalProxy0<void> signal_start_interactive_search();


  Glib::PropertyProxy< Glib::RefPtr<TreeModel> > property_model();

  Glib::PropertyProxy<Adjustment*> property_hadjustment();

  Glib::PropertyProxy<Adjustment*> property_vadjustment();

  Glib::PropertyProxy<bool> property_headers_visible();

  Glib::PropertyProxy_WriteOnly<bool> property_headers_clickable();

  Glib::PropertyProxy<TreeViewColumn*> property_expander_column();

  Glib::PropertyProxy<bool> property_reorderable();

  Glib::PropertyProxy<bool> property_rules_hint();

  Glib::PropertyProxy<bool> property_enable_search();

  Glib::PropertyProxy<int> property_search_column();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::TreeView */
  Gtk::TreeView* wrap(GtkTreeView* object, bool take_copy = false);
}
#endif /* _GTKMM_TREEVIEW_H */

