// -*- c++ -*-
#ifndef _GTKMM_STOCKID_H
#define _GTKMM_STOCKID_H

/* $Id: stockid.h,v 1.2 2002/04/02 13:24:46 daniel Exp $ */

/* stockid.h
 *
 * Copyright (C) 2001 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/utility.h>
#include <glibmm/containers.h>
#include <glibmm/ustring.h>

namespace Gtk
{

namespace Stock { struct BuiltinStockID; }

class StockID
{
public:
  StockID(const Stock::BuiltinStockID& id);
  StockID(const Glib::ustring& id);
  StockID(const StockID& src);
  ~StockID();

  StockID& operator=(const StockID& src);

  bool operator==(const StockID& src) const;

  Glib::ustring get_string() const;

protected:
  Glib::ustring id_;
};

} /* namespace Gtk */


#endif /* _GTKMM_STOCKID_H */

