
#include <gtkmm/plug.h>
#include <gtkmm/private/plug_p.h>

// -*- c++ -*-
/* $Id: plug.ccg,v 1.7 2002/01/12 19:16:22 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkplug.h>

namespace Gtk
{

Plug::Plug(GdkNativeWindow socket_id)
: Gtk::Window((GtkWindow*)( g_object_new( get_type(), 0 ) ))
{
  gtk_plug_construct(gobj(), socket_id);
}

} /* namespace Gtk */


namespace
{

const Glib::SignalProxyInfo Plug_signal_embedded_info =
{
  "embedded",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::Plug* wrap(GtkPlug* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Plug *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Plug_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_plug_get_type(), "gtkmm__Plug", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Plug_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->embedded = &embedded_callback;
}


void Plug_Class::embedded_callback(GtkPlug* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_embedded();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->embedded)
      (*base->embedded)(self);
  }
}


Glib::ObjectBase* Plug_Class::wrap_new(GObject* o)
{
  return manage(new Plug((GtkPlug*)(o)));
}


/* The implementation: */

Plug::Plug(GtkPlug* castitem)
: Gtk::Window((GtkWindow*)(castitem))
{}

Plug::~Plug()
{
  destroy_();
}

Plug::CppClassType Plug::plug_class_; //Initialize static member.

GType Plug::get_type()
{
  return plug_class_.get_type();
}

GType Plug::get_base_type()
{
  return gtk_plug_get_type();
}

GdkNativeWindow Plug::get_id() const
{
  return gtk_plug_get_id(const_cast<GtkPlug*>(gobj()));
}


Glib::SignalProxy0<void> Plug::signal_embedded()
{
  return Glib::SignalProxy0<void>(this, &Plug_signal_embedded_info);
}


void Gtk::Plug::on_embedded()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->embedded)
    (*base->embedded)(gobj());
}


} // namespace Gtk

