
#include <gtkmm/paned.h>
#include <gtkmm/private/paned_p.h>

// -*- c++ -*-
/* $Id: paned.ccg,v 1.2 2001/05/10 22:47:54 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkpaned.h>
#include <gtk/gtkhpaned.h>
#include <gtk/gtkvpaned.h>


namespace
{


gboolean Paned_signal_cycle_child_focus_callback(GtkPaned*, gboolean p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<bool,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean Paned_signal_cycle_child_focus_notify_callback(GtkPaned*, gboolean p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo Paned_signal_cycle_child_focus_info =
{
  "cycle_child_focus",
  (GCallback) &Paned_signal_cycle_child_focus_callback,
  (GCallback) &Paned_signal_cycle_child_focus_notify_callback
};


gboolean Paned_signal_toggle_handle_focus_callback(GtkPaned*, void* data)
{
  using namespace Gtk;
  typedef SigC::Slot0<bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        ( slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean Paned_signal_toggle_handle_focus_notify_callback(GtkPaned*, void* data)
{
  using namespace Gtk;
  typedef SigC::Slot0<void> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        ( slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo Paned_signal_toggle_handle_focus_info =
{
  "toggle_handle_focus",
  (GCallback) &Paned_signal_toggle_handle_focus_callback,
  (GCallback) &Paned_signal_toggle_handle_focus_notify_callback
};


gboolean Paned_signal_move_handle_callback(GtkPaned*, GtkScrollType p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<bool,ScrollType> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (((ScrollType)(p0))
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean Paned_signal_move_handle_notify_callback(GtkPaned*, GtkScrollType p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,ScrollType> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (((ScrollType)(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo Paned_signal_move_handle_info =
{
  "move_handle",
  (GCallback) &Paned_signal_move_handle_callback,
  (GCallback) &Paned_signal_move_handle_notify_callback
};


gboolean Paned_signal_cycle_handle_focus_callback(GtkPaned*, gboolean p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<bool,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean Paned_signal_cycle_handle_focus_notify_callback(GtkPaned*, gboolean p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo Paned_signal_cycle_handle_focus_info =
{
  "cycle_handle_focus",
  (GCallback) &Paned_signal_cycle_handle_focus_callback,
  (GCallback) &Paned_signal_cycle_handle_focus_notify_callback
};


gboolean Paned_signal_accept_position_callback(GtkPaned*, void* data)
{
  using namespace Gtk;
  typedef SigC::Slot0<bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        ( slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean Paned_signal_accept_position_notify_callback(GtkPaned*, void* data)
{
  using namespace Gtk;
  typedef SigC::Slot0<void> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        ( slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo Paned_signal_accept_position_info =
{
  "accept_position",
  (GCallback) &Paned_signal_accept_position_callback,
  (GCallback) &Paned_signal_accept_position_notify_callback
};


gboolean Paned_signal_cancel_position_callback(GtkPaned*, void* data)
{
  using namespace Gtk;
  typedef SigC::Slot0<bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        ( slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean Paned_signal_cancel_position_notify_callback(GtkPaned*, void* data)
{
  using namespace Gtk;
  typedef SigC::Slot0<void> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        ( slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo Paned_signal_cancel_position_info =
{
  "cancel_position",
  (GCallback) &Paned_signal_cancel_position_callback,
  (GCallback) &Paned_signal_cancel_position_notify_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::Paned* wrap(GtkPaned* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Paned *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Paned_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_paned_get_type(), "gtkmm__Paned", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Paned_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->cycle_child_focus = &cycle_child_focus_callback;
  klass->toggle_handle_focus = &toggle_handle_focus_callback;
  klass->move_handle = &move_handle_callback;
  klass->cycle_handle_focus = &cycle_handle_focus_callback;
  klass->accept_position = &accept_position_callback;
  klass->cancel_position = &cancel_position_callback;
}


gboolean Paned_Class::cycle_child_focus_callback(GtkPaned* self, gboolean p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_cycle_child_focus(p0
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->cycle_child_focus)
      (*base->cycle_child_focus)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}

gboolean Paned_Class::toggle_handle_focus_callback(GtkPaned* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_toggle_handle_focus());
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->toggle_handle_focus)
      (*base->toggle_handle_focus)(self);
  }

  typedef gboolean RType;
  return RType();
}

gboolean Paned_Class::move_handle_callback(GtkPaned* self, GtkScrollType p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_move_handle(((ScrollType)(p0))
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->move_handle)
      (*base->move_handle)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}

gboolean Paned_Class::cycle_handle_focus_callback(GtkPaned* self, gboolean p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_cycle_handle_focus(p0
));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->cycle_handle_focus)
      (*base->cycle_handle_focus)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}

gboolean Paned_Class::accept_position_callback(GtkPaned* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_accept_position());
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->accept_position)
      (*base->accept_position)(self);
  }

  typedef gboolean RType;
  return RType();
}

gboolean Paned_Class::cancel_position_callback(GtkPaned* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_cancel_position());
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->cancel_position)
      (*base->cancel_position)(self);
  }

  typedef gboolean RType;
  return RType();
}


Glib::ObjectBase* Paned_Class::wrap_new(GObject* o)
{
  return manage(new Paned((GtkPaned*)(o)));
}


/* The implementation: */

Paned::Paned(GtkPaned* castitem)
: Gtk::Container((GtkContainer*)(castitem))
{}

Paned::~Paned()
{
  destroy_();
}

Paned::CppClassType Paned::paned_class_; //Initialize static member.

GType Paned::get_type()
{
  return paned_class_.get_type();
}

GType Paned::get_base_type()
{
  return gtk_paned_get_type();
}

Paned::Paned()
: Gtk::Container((GtkContainer*)(g_object_new(get_type(), (char*)0)))
{}

void Paned::add1(Widget& child)
{
  gtk_paned_add1(gobj(), (child).Gtk::Widget::gobj());
}

void Paned::add2(Widget& child)
{
  gtk_paned_add2(gobj(), (child).Gtk::Widget::gobj());
}

void Paned::pack1(Widget& child, bool resize, bool shrink)
{
  gtk_paned_pack1(gobj(), (child).Gtk::Widget::gobj(), static_cast<int>(resize), static_cast<int>(shrink));
}

void Paned::pack2(Widget& child, bool resize, bool shrink)
{
  gtk_paned_pack2(gobj(), (child).Gtk::Widget::gobj(), static_cast<int>(resize), static_cast<int>(shrink));
}

int Paned::get_position() const
{
  return gtk_paned_get_position(const_cast<GtkPaned*>(gobj()));
}

void Paned::set_position(int position)
{
  gtk_paned_set_position(gobj(), position);
}

Widget* Paned::get_child1()
{
  return Glib::wrap(gobj()->child1);
}

const Widget* Paned::get_child1() const
{
  return Glib::wrap(gobj()->child1);
}

Widget* Paned::get_child2()
{
  return Glib::wrap(gobj()->child2);
}

const Widget* Paned::get_child2() const
{
  return Glib::wrap(gobj()->child2);
}

guint Paned::get_child1_shrink() const
{
  return gobj()->child1_shrink;
}

guint Paned::get_child2_shrink() const
{
  return gobj()->child2_shrink;
}

guint Paned::get_child1_resize() const
{
  return gobj()->child1_resize;
}

guint Paned::get_child2_resize() const
{
  return gobj()->child2_resize;
}


Glib::SignalProxy1<bool,bool> Paned::signal_cycle_child_focus()
{
  return Glib::SignalProxy1<bool,bool>(this, &Paned_signal_cycle_child_focus_info);
}

Glib::SignalProxy0<bool> Paned::signal_toggle_handle_focus()
{
  return Glib::SignalProxy0<bool>(this, &Paned_signal_toggle_handle_focus_info);
}

Glib::SignalProxy1<bool,ScrollType> Paned::signal_move_handle()
{
  return Glib::SignalProxy1<bool,ScrollType>(this, &Paned_signal_move_handle_info);
}

Glib::SignalProxy1<bool,bool> Paned::signal_cycle_handle_focus()
{
  return Glib::SignalProxy1<bool,bool>(this, &Paned_signal_cycle_handle_focus_info);
}

Glib::SignalProxy0<bool> Paned::signal_accept_position()
{
  return Glib::SignalProxy0<bool>(this, &Paned_signal_accept_position_info);
}

Glib::SignalProxy0<bool> Paned::signal_cancel_position()
{
  return Glib::SignalProxy0<bool>(this, &Paned_signal_cancel_position_info);
}


Glib::PropertyProxy<int> Paned::property_position()
{
  return Glib::PropertyProxy<int>(this, "position");
}

Glib::PropertyProxy<bool> Paned::property_position_set()
{
  return Glib::PropertyProxy<bool>(this, "position_set");
}


bool Gtk::Paned::on_cycle_child_focus(bool reverse)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->cycle_child_focus)
    return (*base->cycle_child_focus)(gobj(),static_cast<int>(reverse));

  typedef bool RType;
  return RType();
}

bool Gtk::Paned::on_toggle_handle_focus()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->toggle_handle_focus)
    return (*base->toggle_handle_focus)(gobj());

  typedef bool RType;
  return RType();
}

bool Gtk::Paned::on_move_handle(ScrollType scroll)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->move_handle)
    return (*base->move_handle)(gobj(),((GtkScrollType)(scroll)));

  typedef bool RType;
  return RType();
}

bool Gtk::Paned::on_cycle_handle_focus(bool reverse)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->cycle_handle_focus)
    return (*base->cycle_handle_focus)(gobj(),static_cast<int>(reverse));

  typedef bool RType;
  return RType();
}

bool Gtk::Paned::on_accept_position()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->accept_position)
    return (*base->accept_position)(gobj());

  typedef bool RType;
  return RType();
}

bool Gtk::Paned::on_cancel_position()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->cancel_position)
    return (*base->cancel_position)(gobj());

  typedef bool RType;
  return RType();
}


} // namespace Gtk


namespace Glib
{

Gtk::HPaned* wrap(GtkHPaned* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::HPaned *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType HPaned_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_hpaned_get_type(), "gtkmm__HPaned", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void HPaned_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* HPaned_Class::wrap_new(GObject* o)
{
  return manage(new HPaned((GtkHPaned*)(o)));
}


/* The implementation: */

HPaned::HPaned(GtkHPaned* castitem)
: Gtk::Paned((GtkPaned*)(castitem))
{}

HPaned::~HPaned()
{
  destroy_();
}

HPaned::CppClassType HPaned::hpaned_class_; //Initialize static member.

GType HPaned::get_type()
{
  return hpaned_class_.get_type();
}

GType HPaned::get_base_type()
{
  return gtk_hpaned_get_type();
}

HPaned::HPaned()
: Gtk::Paned((GtkPaned*)(g_object_new(get_type(), (char*)0)))
{}


} // namespace Gtk


namespace Glib
{

Gtk::VPaned* wrap(GtkVPaned* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::VPaned *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType VPaned_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_vpaned_get_type(), "gtkmm__VPaned", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void VPaned_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* VPaned_Class::wrap_new(GObject* o)
{
  return manage(new VPaned((GtkVPaned*)(o)));
}


/* The implementation: */

VPaned::VPaned(GtkVPaned* castitem)
: Gtk::Paned((GtkPaned*)(castitem))
{}

VPaned::~VPaned()
{
  destroy_();
}

VPaned::CppClassType VPaned::vpaned_class_; //Initialize static member.

GType VPaned::get_type()
{
  return vpaned_class_.get_type();
}

GType VPaned::get_base_type()
{
  return gtk_vpaned_get_type();
}

VPaned::VPaned()
: Gtk::Paned((GtkPaned*)(g_object_new(get_type(), (char*)0)))
{}


} // namespace Gtk

