
#include <gtkmm/cellrenderertext.h>
#include <gtkmm/private/cellrenderertext_p.h>

// -*- c++ -*-
/* $Id: cellrenderertext.ccg,v 1.1 2001/10/31 10:49:51 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <gtk/gtkcellrenderertext.h>


namespace
{


void CellRendererText_signal_edited_callback(GtkCellRendererText*, const gchar* p0,const gchar* p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const Glib::ustring&,const Glib::ustring&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::convert_const_gchar_ptr_to_ustring(p0)
,Glib::convert_const_gchar_ptr_to_ustring(p1)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo CellRendererText_signal_edited_info =
{
  "edited",
  (GCallback) &CellRendererText_signal_edited_callback,
  (GCallback) &CellRendererText_signal_edited_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::CellRendererText* wrap(GtkCellRendererText* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::CellRendererText *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType CellRendererText_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_cell_renderer_text_get_type(), "gtkmm__CellRendererText", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void CellRendererText_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->edited = &edited_callback;
}


void CellRendererText_Class::edited_callback(GtkCellRendererText* self, const gchar* p0, const gchar* p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_edited(Glib::convert_const_gchar_ptr_to_ustring(p0)
, Glib::convert_const_gchar_ptr_to_ustring(p1)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->edited)
      (*base->edited)(self, p0, p1);
  }
}


Glib::ObjectBase* CellRendererText_Class::wrap_new(GObject* o)
{
  return manage(new CellRendererText((GtkCellRendererText*)(o)));
}


/* The implementation: */

CellRendererText::CellRendererText(GtkCellRendererText* castitem)
: Gtk::CellRenderer((GtkCellRenderer*)(castitem))
{}

CellRendererText::~CellRendererText()
{
  destroy_();
}

CellRendererText::CppClassType CellRendererText::cellrenderertext_class_; //Initialize static member.

GType CellRendererText::get_type()
{
  return cellrenderertext_class_.get_type();
}

GType CellRendererText::get_base_type()
{
  return gtk_cell_renderer_text_get_type();
}

CellRendererText::CellRendererText()
: Gtk::CellRenderer((GtkCellRenderer*)(g_object_new(get_type(), (char*)0)))
{}

void CellRendererText::set_fixed_height_from_font(int number_of_rows)
{
  gtk_cell_renderer_text_set_fixed_height_from_font(gobj(), number_of_rows);
}


Glib::SignalProxy2<void,const Glib::ustring&,const Glib::ustring&> CellRendererText::signal_edited()
{
  return Glib::SignalProxy2<void,const Glib::ustring&,const Glib::ustring&>(this, &CellRendererText_signal_edited_info);
}


Glib::PropertyProxy<Glib::ustring> CellRendererText::property_text()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "text");
}

Glib::PropertyProxy_WriteOnly<Glib::ustring> CellRendererText::property_markup()
{
  return Glib::PropertyProxy_WriteOnly<Glib::ustring>(this, "markup");
}

Glib::PropertyProxy<Pango::AttrList> CellRendererText::property_attributes()
{
  return Glib::PropertyProxy<Pango::AttrList>(this, "attributes");
}

Glib::PropertyProxy_WriteOnly<Glib::ustring> CellRendererText::property_background()
{
  return Glib::PropertyProxy_WriteOnly<Glib::ustring>(this, "background");
}

Glib::PropertyProxy_WriteOnly<Glib::ustring> CellRendererText::property_foreground()
{
  return Glib::PropertyProxy_WriteOnly<Glib::ustring>(this, "foreground");
}

Glib::PropertyProxy<Gdk::Color> CellRendererText::property_background_gdk()
{
  return Glib::PropertyProxy<Gdk::Color>(this, "background_gdk");
}

Glib::PropertyProxy<Gdk::Color> CellRendererText::property_foreground_gdk()
{
  return Glib::PropertyProxy<Gdk::Color>(this, "foreground_gdk");
}

Glib::PropertyProxy<Glib::ustring> CellRendererText::property_font()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "font");
}

Glib::PropertyProxy<Pango::FontDescription> CellRendererText::property_font_desc()
{
  return Glib::PropertyProxy<Pango::FontDescription>(this, "font_desc");
}

Glib::PropertyProxy<Glib::ustring> CellRendererText::property_family()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "family");
}

Glib::PropertyProxy<Pango::Style> CellRendererText::property_style()
{
  return Glib::PropertyProxy<Pango::Style>(this, "style");
}

Glib::PropertyProxy<Pango::Variant> CellRendererText::property_variant()
{
  return Glib::PropertyProxy<Pango::Variant>(this, "variant");
}

Glib::PropertyProxy<int> CellRendererText::property_weight()
{
  return Glib::PropertyProxy<int>(this, "weight");
}

Glib::PropertyProxy<Pango::Stretch> CellRendererText::property_stretch()
{
  return Glib::PropertyProxy<Pango::Stretch>(this, "stretch");
}

Glib::PropertyProxy<int> CellRendererText::property_size()
{
  return Glib::PropertyProxy<int>(this, "size");
}

Glib::PropertyProxy<double> CellRendererText::property_size_points()
{
  return Glib::PropertyProxy<double>(this, "size_points");
}

Glib::PropertyProxy<double> CellRendererText::property_scale()
{
  return Glib::PropertyProxy<double>(this, "scale");
}

Glib::PropertyProxy<bool> CellRendererText::property_editable()
{
  return Glib::PropertyProxy<bool>(this, "editable");
}

Glib::PropertyProxy<bool> CellRendererText::property_strikethrough()
{
  return Glib::PropertyProxy<bool>(this, "strikethrough");
}

Glib::PropertyProxy<Pango::Underline> CellRendererText::property_underline()
{
  return Glib::PropertyProxy<Pango::Underline>(this, "underline");
}

Glib::PropertyProxy<int> CellRendererText::property_rise()
{
  return Glib::PropertyProxy<int>(this, "rise");
}

Glib::PropertyProxy<bool> CellRendererText::property_background_set()
{
  return Glib::PropertyProxy<bool>(this, "background_set");
}

Glib::PropertyProxy<bool> CellRendererText::property_foreground_set()
{
  return Glib::PropertyProxy<bool>(this, "foreground_set");
}

Glib::PropertyProxy<bool> CellRendererText::property_family_set()
{
  return Glib::PropertyProxy<bool>(this, "family_set");
}

Glib::PropertyProxy<bool> CellRendererText::property_style_set()
{
  return Glib::PropertyProxy<bool>(this, "style_set");
}

Glib::PropertyProxy<bool> CellRendererText::property_variant_set()
{
  return Glib::PropertyProxy<bool>(this, "variant_set");
}

Glib::PropertyProxy<bool> CellRendererText::property_weight_set()
{
  return Glib::PropertyProxy<bool>(this, "weight_set");
}

Glib::PropertyProxy<bool> CellRendererText::property_stretch_set()
{
  return Glib::PropertyProxy<bool>(this, "stretch_set");
}

Glib::PropertyProxy<bool> CellRendererText::property_size_set()
{
  return Glib::PropertyProxy<bool>(this, "size_set");
}

Glib::PropertyProxy<bool> CellRendererText::property_scale_set()
{
  return Glib::PropertyProxy<bool>(this, "scale_set");
}

Glib::PropertyProxy<bool> CellRendererText::property_editable_set()
{
  return Glib::PropertyProxy<bool>(this, "editable_set");
}

Glib::PropertyProxy<bool> CellRendererText::property_strikethrough_set()
{
  return Glib::PropertyProxy<bool>(this, "strikethrough_set");
}

Glib::PropertyProxy<bool> CellRendererText::property_underline_set()
{
  return Glib::PropertyProxy<bool>(this, "underline_set");
}

Glib::PropertyProxy<bool> CellRendererText::property_rise_set()
{
  return Glib::PropertyProxy<bool>(this, "rise_set");
}


void Gtk::CellRendererText::on_edited(const Glib::ustring& path, const Glib::ustring& new_text)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->edited)
    (*base->edited)(gobj(),path.c_str(),new_text.c_str());
}


} // namespace Gtk

