#include <stdio.h>
#include <gtkmm/window.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/frame.h>
#include <gtkmm/main.h>
#include <gtkmm/notebook.h>
#include <gtkmm/table.h>

class Book : public Gtk::Notebook
  {
  public:
    void rotate_book ();
    void tabsborder_book ();
    void remove_book ();
  };

/* This function rotates the position of the tabs */
void Book::rotate_book ()
  {
    gint pos=(gint)(get_tab_pos());
    ++pos;
    set_tab_pos ((Gtk::PositionType)(pos%4));
  }

/* Add/Remove the page tabs and the borders */
void Book::tabsborder_book ()
  {
    set_show_tabs (!get_show_tabs());
    set_show_border (!get_show_border());
  }

/* Remove a page from the notebook */
void Book::remove_book ()
{
    Gtk::Notebook::Page *page;
    
    page = get_current();
    pages().remove(page);
    /* Need to refresh the widget -- 
     This forces the widget to redraw itself. */
    queue_draw();
}


struct AppWindow: public Gtk::Window
  {
    AppWindow();
    ~AppWindow();
  };


AppWindow::AppWindow()
  {
    set_border_width (10);

    Gtk::Table* table = manage( new Gtk::Table(3,6,false) );
    add (*table);
    
    /* Create a new notebook, place the position of the tabs */
    Book* notebook = manage( new Book() );
    notebook->set_tab_pos (Gtk::POS_TOP);
    table->attach (*notebook, 0,6,0,1);
    
    /* Lets append a bunch of pages to the notebook */
    for (int i = 0; i < 5; i++)
      {
        char bufferf[32];
      	sprintf(bufferf, "Append Frame %d", i+1);

        char bufferl[32];
      	sprintf(bufferl, "Page %d", i+1);
      	
      	Gtk::Frame* frame = manage( new Gtk::Frame (bufferf) );
      	frame->set_border_width (10);
      	frame->set_size_request (100, 75);
      	frame->show ();
      	
      	notebook->pages().push_back(
                Gtk::Notebook_Helpers::TabElem(*frame,bufferl));
      }
      
    /* Now lets add a page to a specific spot */
    Gtk::CheckButton* checkbutton = manage( new Gtk::CheckButton ("Check me please!") );
    checkbutton->set_size_request (100, 75);
    checkbutton->show ();
   
    notebook->pages().insert(++(notebook->pages().begin()),
                   Gtk::Notebook_Helpers::TabElem (*checkbutton,
                                                  "Check me please!")
                  );
    
    /* Now finally lets prepend pages to the notebook */
    for (int i = 0; i < 5; i++)
      {
        Gtk::Frame *frame;

        char bufferf[32];
      	sprintf(bufferf, "Prepend Frame %d", i+1);

        char bufferl[32];
      	sprintf(bufferl, "PPage %d", i+1);

        frame = manage( new Gtk::Frame (bufferf) );
        frame->set_border_width (10);
        frame->set_size_request (100, 75);
        frame->show ();

        notebook->pages().push_front(
          Gtk::Notebook_Helpers::TabElem(*frame,bufferl));
      }
    
    /* Set what page to start at (page 4) */
    notebook->set_current_page (3);

    /* Create a bunch of buttons */
    Gtk::Button* button = manage( new Gtk::Button("close") );
    button->signal_clicked().connect(SigC::slot(&Gtk::Main::quit));
    table->attach(*button, 0,1,1,2);
    
    button = manage( new Gtk::Button("next page") );
    button->signal_clicked().connect(SigC::slot(*notebook, &Gtk::Notebook::next_page));
    table->attach(*button, 1,2,1,2);
    
    button = manage( new Gtk::Button("prev page") );
    button->signal_clicked().connect(SigC::slot(*notebook, &Gtk::Notebook::prev_page));
    table->attach(*button, 2,3,1,2);
    
    button = manage( new Gtk::Button("tab position") );
    button->signal_clicked().connect(SigC::slot(*notebook, &Book::rotate_book));
    table->attach(*button, 3,4,1,2);
    
    button = manage( new Gtk::Button("tabs/border on/off") );
    button->signal_clicked().connect(SigC::slot(*notebook, &Book::tabsborder_book));
    table->attach(*button, 4,5,1,2);
    
    button = manage( new Gtk::Button("remove page") );
    button->signal_clicked().connect(SigC::slot(*notebook, &Book::remove_book));
    table->attach(*button, 5,6,1,2);
    
    show_all();
  }

AppWindow::~AppWindow() {}
    
int main (int argc, char *argv[])
  {
    Gtk::Main m(&argc, &argv);
    AppWindow appwindow;
    m.run(appwindow);
    
    return(0);
  }
