/* bug-buddy bug submitting program
 *
 * Copyright (C) Jacob Berkman
 *
 * Author:  Jacob Berkman  <jacob@bug-buddy.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include "bug-buddy.h"

#include <stdio.h>

#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>
#include <math.h>
#include <string.h>

#include <glib/gi18n.h>
#include <gtk/gtkprogressbar.h>
#include <gtk/gtktextview.h>

#if 0
#include <libart_lgpl/libart.h>
#endif


static void get_trace_from_pair (const gchar *app, int pid, GladeXML *xml);

#define d(x)

void
get_trace_from_gdb (char *app, int pid, GtkTextView *text_view)
{
	kill (pid, SIGCONT);
	get_trace_from_pair (app, pid, text_view);
}

void
stop_gdb (GIOChannel *ioc, int pid)
{
	if (!ioc) {
		d(g_message (_("gdb has already exited")));
		return;
	}
	
	g_io_channel_shutdown (ioc, 1, NULL);
	
	kill (pid, SIGTERM);
	/* i don't think we need to SIGKILL it */
	/*kill (druid_data.gdb_pid, SIGKILL);*/
	waitpid (pid, NULL, 0);
	
	pid = 0;

#if 0
	/* sometimes gdb doesn't restart the old app... */
	if (druid_data.app_pid) {
		kill (druid_data.app_pid, SIGCONT);
		druid_data.app_pid = 0;
	}
#endif
}

static gboolean
handle_gdb_input (GIOChannel *ioc, GIOCondition condition, gpointer data)
{	
	gboolean retval = FALSE;
	gchar buf[1024];
	gsize len;
	GIOStatus io_status;
	GtkTextView *text_view;
	GladeXML *xml = (GladeXML*) data;

	text_view = GTK_TEXT_VIEW (glade_xml_get_widget (xml, "gdb-text"));

	while (gtk_events_pending ())
		gtk_main_iteration ();

 gdb_try_read:
	io_status = g_io_channel_read_chars (ioc, buf, 1024, &len, NULL);

	switch (io_status) {
	case G_IO_STATUS_AGAIN:
		goto gdb_try_read;
	case G_IO_STATUS_ERROR:
		d(g_warning (_("Error on read... aborting")));
		break;
	case G_IO_STATUS_NORMAL:
		retval = TRUE;
		break;
	default:
		break;
	}

	if (len > 0) {
		GtkTextIter end;
		GtkTextBuffer *buffy;
		GtkTextView *tv;
		char *utftext;
		gsize localelen;
		gsize utflen;

		buffy = gtk_text_view_get_buffer (text_view);

		gtk_text_buffer_get_end_iter (buffy, &end);
		/* gdb charset is ISO-8859-1 */
		utftext = g_convert_with_fallback (buf, len, "UTF-8", "ISO-8859-1", NULL, &localelen, &utflen, NULL);
		gtk_text_buffer_insert (buffy, &end, utftext, utflen);
		g_free (utftext);
	}

	
	if (!retval || io_status == G_IO_STATUS_EOF) {
		stop_gdb (ioc, GPOINTER_TO_INT (g_object_get_data (G_OBJECT (xml), "gdb-pid")));
		g_object_set_data (G_OBJECT (xml), "ioc", NULL);
		return FALSE;
	}

	return retval;
}

static void
get_trace_from_pair (const gchar *app, int pid, GladeXML *xml)
{
	char *s;
	const char *short_app;
	char *long_app;
	int gdb_pid;
	int fd;
	GIOChannel *ioc;
	GError *error = NULL;
	char *args[] = { "gdb",
			 "--batch", 
			 "--quiet",
			 "--command=" BUDDY_DATADIR "/gdb-cmd",
			 NULL, NULL, NULL };

	GtkTextView *text_view = GTK_TEXT_VIEW (glade_xml_get_widget (xml, "gdb-text"));

	if (!app || !pid || !*app) {
		/* FIXME: Get parent window */
		buddy_error (NULL, 
			     _("Both a binary file and PID are required to debug."));
		return;
	}

	if (app[0] == G_DIR_SEPARATOR) {
		long_app = g_strdup (app);
		short_app = strrchr (app, G_DIR_SEPARATOR) + 1;
	} else {
		long_app = g_find_program_in_path (app);
		if (!long_app) {
			/* Applets are not in path... */
			long_app = g_strconcat(GNOMELIBEXECDIR,"/", app, NULL);
		}
		short_app = app;
	}	

	if (!long_app) {
		buddy_error (NULL,
			     _("The binary file could not be found. Try using an absolute path."));
		return;
	}

	args[0] = g_find_program_in_path ("gdb");
	args[4] = long_app;
	args[5] = g_strdup_printf ("%d", pid);

	if (!args[0]) {
		buddy_error (NULL,
			     _("GDB could not be found on your system.\n"
			       "Debugging information will not be obtained."));
		d(g_message ("Path: %s", getenv ("PATH")));
	} else {
		d(g_message ("About to debug '%s'", long_app));
	
		if (!g_file_test (BUDDY_DATADIR "/gdb-cmd", G_FILE_TEST_EXISTS)) {
			buddy_error (NULL,
				     _("Could not find the gdb-cmd file.\n"
				       "Please try reinstalling Bug Buddy."));
		} else if (!g_spawn_async_with_pipes (NULL, args, NULL, 0, NULL, NULL,
					       &gdb_pid,
					       NULL, 
					       &fd, 
					       NULL, &error)) {
			buddy_error (GTK_WIDGET ("druid-window"),
				     _("There was an error running gdb:\n\n%s"),
				     error->message);
			g_error_free (error);
			} else {
				GtkTextIter end;
				GtkTextBuffer *buffy;
				GtkTextView *tv;
			
				ioc = g_io_channel_unix_new (fd);
				g_io_channel_set_encoding (ioc, NULL, NULL);
		
				s = g_strdup_printf ("Backtrace was generated from '%s'\n\n", long_app);
				buffy = gtk_text_view_get_buffer (text_view);
				gtk_text_buffer_get_end_iter (buffy, &end);
				gtk_text_buffer_insert (buffy, &end, s, strlen (s));
				g_free (s);

				g_io_add_watch_full (ioc, 100, G_IO_IN | G_IO_HUP,
						handle_gdb_input, xml, gdb_finished);
				g_io_channel_unref (ioc);
				g_object_set_data (G_OBJECT (xml), "ioc", ioc);
				g_object_set_data (G_OBJECT (xml), "gdb-pid", GINT_TO_POINTER (gdb_pid));
			}
		g_free (args[0]);
	}
	g_free (args[5]);
	g_free (long_app);
}
